/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.coreapi.schema.IndexDefinitionImpl;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.rule.RandomRule;

@DbmsExtension
@ExtendWith(value={RandomExtension.class})
class MultipleOpenCursorsTest {
    private static final Label indexLabel = Label.label((String)"IndexLabel");
    private static final String numberProp1 = "numberProp1";
    private static final String numberProp2 = "numberProp2";
    private static final String stringProp1 = "stringProp1";
    private static final String stringProp2 = "stringProp2";
    @Inject
    private GraphDatabaseAPI db;
    @Inject
    private RandomRule rnd;
    public String name;

    MultipleOpenCursorsTest() {
    }

    public static Stream<Arguments> params() {
        return Stream.of(Arguments.of((Object[])new Object[]{new NumberIndexCoordinator(indexLabel, numberProp1, numberProp2, stringProp1, stringProp2)}), Arguments.of((Object[])new Object[]{new StringIndexCoordinator(indexLabel, numberProp1, numberProp2, stringProp1, stringProp2)}), Arguments.of((Object[])new Object[]{new NumberCompositeIndexCoordinator(indexLabel, numberProp1, numberProp2, stringProp1, stringProp2)}), Arguments.of((Object[])new Object[]{new StringCompositeIndexCoordinator(indexLabel, numberProp1, numberProp2, stringProp1, stringProp2)}));
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void multipleCursorsNotNestedExists(IndexCoordinator indexCoordinator) throws Exception {
        indexCoordinator.init(this.db);
        try (Transaction tx = this.db.beginTx();){
            KernelTransaction ktx = ((InternalTransaction)tx).kernelTransaction();
            try (NodeValueIndexCursor cursor1 = indexCoordinator.queryExists(ktx);
                 NodeValueIndexCursor cursor2 = indexCoordinator.queryExists(ktx);){
                List<Long> actual1 = MultipleOpenCursorsTest.asList(cursor1);
                List<Long> actual2 = MultipleOpenCursorsTest.asList(cursor2);
                indexCoordinator.assertExistsResult(actual1);
                indexCoordinator.assertExistsResult(actual2);
            }
            tx.commit();
        }
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void multipleCursorsNotNestedExact(IndexCoordinator indexCoordinator) throws Exception {
        indexCoordinator.init(this.db);
        try (Transaction tx = this.db.beginTx();){
            KernelTransaction ktx = ((InternalTransaction)tx).kernelTransaction();
            try (NodeValueIndexCursor cursor1 = indexCoordinator.queryExact(ktx);
                 NodeValueIndexCursor cursor2 = indexCoordinator.queryExact(ktx);){
                List<Long> actual1 = MultipleOpenCursorsTest.asList(cursor1);
                List<Long> actual2 = MultipleOpenCursorsTest.asList(cursor2);
                indexCoordinator.assertExactResult(actual1);
                indexCoordinator.assertExactResult(actual2);
            }
            tx.commit();
        }
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void multipleIteratorsNotNestedRange(IndexCoordinator indexCoordinator) throws KernelException {
        Assumptions.assumeTrue((boolean)indexCoordinator.supportRangeQuery());
        indexCoordinator.init(this.db);
        try (Transaction tx = this.db.beginTx();){
            KernelTransaction ktx = ((InternalTransaction)tx).kernelTransaction();
            try (NodeValueIndexCursor cursor1 = indexCoordinator.queryRange(ktx);
                 NodeValueIndexCursor cursor2 = indexCoordinator.queryRange(ktx);){
                List<Long> actual1 = MultipleOpenCursorsTest.asList(cursor1);
                List<Long> actual2 = MultipleOpenCursorsTest.asList(cursor2);
                indexCoordinator.assertRangeResult(actual1);
                indexCoordinator.assertRangeResult(actual2);
            }
            tx.commit();
        }
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void multipleIteratorsNestedInnerNewExists(IndexCoordinator indexCoordinator) throws Exception {
        indexCoordinator.init(this.db);
        try (Transaction tx = this.db.beginTx();){
            KernelTransaction ktx = ((InternalTransaction)tx).kernelTransaction();
            try (NodeValueIndexCursor cursor1 = indexCoordinator.queryExists(ktx);){
                ArrayList<Long> actual1 = new ArrayList<Long>();
                while (cursor1.next()) {
                    actual1.add(cursor1.nodeReference());
                    NodeValueIndexCursor cursor2 = indexCoordinator.queryExists(ktx);
                    try {
                        List<Long> actual2 = MultipleOpenCursorsTest.asList(cursor2);
                        indexCoordinator.assertExistsResult(actual2);
                    }
                    finally {
                        if (cursor2 == null) continue;
                        cursor2.close();
                    }
                }
                indexCoordinator.assertExistsResult(actual1);
            }
            tx.commit();
        }
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void multipleIteratorsNestedInnerNewExact(IndexCoordinator indexCoordinator) throws Exception {
        indexCoordinator.init(this.db);
        try (Transaction tx = this.db.beginTx();){
            KernelTransaction ktx = ((InternalTransaction)tx).kernelTransaction();
            try (NodeValueIndexCursor cursor1 = indexCoordinator.queryExact(ktx);){
                ArrayList<Long> actual1 = new ArrayList<Long>();
                while (cursor1.next()) {
                    actual1.add(cursor1.nodeReference());
                    NodeValueIndexCursor cursor2 = indexCoordinator.queryExact(ktx);
                    try {
                        List<Long> actual2 = MultipleOpenCursorsTest.asList(cursor2);
                        indexCoordinator.assertExactResult(actual2);
                    }
                    finally {
                        if (cursor2 == null) continue;
                        cursor2.close();
                    }
                }
                indexCoordinator.assertExactResult(actual1);
            }
            tx.commit();
        }
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void multipleIteratorsNestedInnerNewRange(IndexCoordinator indexCoordinator) throws Exception {
        Assumptions.assumeTrue((boolean)indexCoordinator.supportRangeQuery());
        indexCoordinator.init(this.db);
        try (Transaction tx = this.db.beginTx();){
            KernelTransaction ktx = ((InternalTransaction)tx).kernelTransaction();
            try (NodeValueIndexCursor cursor1 = indexCoordinator.queryRange(ktx);){
                ArrayList<Long> actual1 = new ArrayList<Long>();
                while (cursor1.next()) {
                    actual1.add(cursor1.nodeReference());
                    NodeValueIndexCursor cursor2 = indexCoordinator.queryRange(ktx);
                    try {
                        List<Long> actual2 = MultipleOpenCursorsTest.asList(cursor2);
                        indexCoordinator.assertRangeResult(actual2);
                    }
                    finally {
                        if (cursor2 == null) continue;
                        cursor2.close();
                    }
                }
                indexCoordinator.assertRangeResult(actual1);
            }
            tx.commit();
        }
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void multipleIteratorsNestedInterleavedExists(IndexCoordinator indexCoordinator) throws Exception {
        indexCoordinator.init(this.db);
        try (Transaction tx = this.db.beginTx();){
            KernelTransaction ktx = ((InternalTransaction)tx).kernelTransaction();
            try (NodeValueIndexCursor cursor1 = indexCoordinator.queryExists(ktx);){
                ArrayList<Long> actual1 = new ArrayList<Long>();
                try (NodeValueIndexCursor cursor2 = indexCoordinator.queryExists(ktx);){
                    ArrayList<Long> actual2 = new ArrayList<Long>();
                    this.exhaustInterleaved(cursor1, actual1, cursor2, actual2);
                    indexCoordinator.assertExistsResult(actual1);
                    indexCoordinator.assertExistsResult(actual2);
                }
            }
            tx.commit();
        }
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void multipleIteratorsNestedInterleavedExact(IndexCoordinator indexCoordinator) throws Exception {
        indexCoordinator.init(this.db);
        try (Transaction tx = this.db.beginTx();){
            KernelTransaction ktx = ((InternalTransaction)tx).kernelTransaction();
            try (NodeValueIndexCursor cursor1 = indexCoordinator.queryExact(ktx);){
                ArrayList<Long> actual1 = new ArrayList<Long>();
                try (NodeValueIndexCursor cursor2 = indexCoordinator.queryExact(ktx);){
                    ArrayList<Long> actual2 = new ArrayList<Long>();
                    this.exhaustInterleaved(cursor1, actual1, cursor2, actual2);
                    indexCoordinator.assertExactResult(actual1);
                    indexCoordinator.assertExactResult(actual2);
                }
            }
            tx.commit();
        }
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    void multipleIteratorsNestedInterleavedRange(IndexCoordinator indexCoordinator) throws Exception {
        Assumptions.assumeTrue((boolean)indexCoordinator.supportRangeQuery());
        indexCoordinator.init(this.db);
        try (Transaction tx = this.db.beginTx();){
            KernelTransaction ktx = ((InternalTransaction)tx).kernelTransaction();
            try (NodeValueIndexCursor cursor1 = indexCoordinator.queryRange(ktx);
                 NodeValueIndexCursor cursor2 = indexCoordinator.queryRange(ktx);){
                ArrayList<Long> actual1 = new ArrayList<Long>();
                ArrayList<Long> actual2 = new ArrayList<Long>();
                this.exhaustInterleaved(cursor1, actual1, cursor2, actual2);
                indexCoordinator.assertRangeResult(actual1);
                indexCoordinator.assertRangeResult(actual2);
            }
            tx.commit();
        }
    }

    private static List<Long> asList(NodeValueIndexCursor cursor) {
        ArrayList<Long> list = new ArrayList<Long>();
        while (cursor.next()) {
            list.add(cursor.nodeReference());
        }
        return list;
    }

    private void exhaustInterleaved(NodeValueIndexCursor source1, List<Long> target1, NodeValueIndexCursor source2, List<Long> target2) {
        boolean source1HasNext = true;
        boolean source2HasNext = true;
        while (source1HasNext && source2HasNext) {
            if (this.rnd.nextBoolean()) {
                source1HasNext = source1.next();
                if (!source1HasNext) continue;
                target1.add(source1.nodeReference());
                continue;
            }
            source2HasNext = source2.next();
            if (!source2HasNext) continue;
            target2.add(source2.nodeReference());
        }
        while (source1.next()) {
            target1.add(source1.nodeReference());
        }
        while (source2.next()) {
            target2.add(source2.nodeReference());
        }
    }

    private static abstract class IndexCoordinator {
        final int numberOfNodes = 100;
        final Label indexLabel;
        final String numberProp1;
        final String numberProp2;
        final String stringProp1;
        final String stringProp2;
        Number[] numberProp1Values;
        Number[] numberProp2Values;
        String[] stringProp1Values;
        String[] stringProp2Values;
        int indexedLabelId;
        int numberPropId1;
        int numberPropId2;
        int stringPropId1;
        int stringPropId2;
        IndexDescriptor indexDescriptor;

        IndexCoordinator(Label indexLabel, String numberProp1, String numberProp2, String stringProp1, String stringProp2) {
            this.indexLabel = indexLabel;
            this.numberProp1 = numberProp1;
            this.numberProp2 = numberProp2;
            this.stringProp1 = stringProp1;
            this.stringProp2 = stringProp2;
            this.numberProp1Values = new Number[100];
            this.numberProp2Values = new Number[100];
            this.stringProp1Values = new String[100];
            this.stringProp2Values = new String[100];
            for (int i = 0; i < 100; ++i) {
                this.numberProp1Values[i] = i;
                this.numberProp2Values[i] = i;
                this.stringProp1Values[i] = "string-" + String.format("%02d", i);
                this.stringProp2Values[i] = "string-" + String.format("%02d", i);
            }
        }

        void init(GraphDatabaseAPI db) {
            try (Transaction tx = db.beginTx();){
                for (int i = 0; i < 100; ++i) {
                    Node node = tx.createNode(new Label[]{this.indexLabel});
                    node.setProperty(this.numberProp1, (Object)this.numberProp1Values[i]);
                    node.setProperty(this.numberProp2, (Object)this.numberProp2Values[i]);
                    node.setProperty(this.stringProp1, (Object)this.stringProp1Values[i]);
                    node.setProperty(this.stringProp2, (Object)this.stringProp2Values[i]);
                }
                tx.commit();
            }
            tx = db.beginTx();
            try {
                TokenRead tokenRead = ((InternalTransaction)tx).kernelTransaction().tokenRead();
                this.indexedLabelId = tokenRead.nodeLabel(this.indexLabel.name());
                this.numberPropId1 = tokenRead.propertyKey(this.numberProp1);
                this.numberPropId2 = tokenRead.propertyKey(this.numberProp2);
                this.stringPropId1 = tokenRead.propertyKey(this.stringProp1);
                this.stringPropId2 = tokenRead.propertyKey(this.stringProp2);
                tx.commit();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
            this.createIndex(db);
        }

        private void createIndex(GraphDatabaseAPI db) {
            try (Transaction tx = db.beginTx();){
                IndexDefinitionImpl indexDefinition = (IndexDefinitionImpl)this.doCreateIndex(tx);
                this.indexDescriptor = indexDefinition.getIndexReference();
                tx.commit();
            }
            tx = db.beginTx();
            try {
                tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
                tx.commit();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }

        abstract boolean supportRangeQuery();

        abstract NodeValueIndexCursor queryRange(KernelTransaction var1) throws KernelException;

        abstract NodeValueIndexCursor queryExists(KernelTransaction var1) throws KernelException;

        abstract NodeValueIndexCursor queryExact(KernelTransaction var1) throws KernelException;

        abstract void assertRangeResult(List<Long> var1);

        void assertExistsResult(List<Long> actual) {
            ArrayList<Long> expected = new ArrayList<Long>();
            for (long i = 0L; i < 100L; ++i) {
                expected.add(i);
            }
            this.assertSameContent(actual, expected);
        }

        void assertSameContent(List<Long> actual, List<Long> expected) {
            Assertions.assertThat(actual).containsAll(expected);
        }

        abstract void assertExactResult(List<Long> var1);

        abstract IndexDefinition doCreateIndex(Transaction var1);

        NodeValueIndexCursor indexQuery(KernelTransaction ktx, IndexDescriptor indexDescriptor, PropertyIndexQuery ... indexQueries) throws KernelException {
            NodeValueIndexCursor cursor = ktx.cursors().allocateNodeValueIndexCursor(ktx.cursorContext(), ktx.memoryTracker());
            IndexReadSession index = ktx.dataRead().indexReadSession(indexDescriptor);
            ktx.dataRead().nodeIndexSeek(index, cursor, IndexQueryConstraints.unconstrained(), indexQueries);
            return cursor;
        }
    }

    private static class NumberIndexCoordinator
    extends IndexCoordinator {
        NumberIndexCoordinator(Label indexLabel, String numberProp1, String numberProp2, String stringProp1, String stringProp2) {
            super(indexLabel, numberProp1, numberProp2, stringProp1, stringProp2);
        }

        @Override
        boolean supportRangeQuery() {
            return true;
        }

        @Override
        NodeValueIndexCursor queryRange(KernelTransaction ktx) throws KernelException {
            return this.indexQuery(ktx, this.indexDescriptor, new PropertyIndexQuery[]{PropertyIndexQuery.range((int)this.numberPropId1, (Number)this.numberProp1Values[0], (boolean)true, (Number)this.numberProp1Values[50], (boolean)false)});
        }

        @Override
        NodeValueIndexCursor queryExists(KernelTransaction ktx) throws KernelException {
            return this.indexQuery(ktx, this.indexDescriptor, new PropertyIndexQuery[]{PropertyIndexQuery.exists((int)this.numberPropId1)});
        }

        @Override
        NodeValueIndexCursor queryExact(KernelTransaction ktx) throws KernelException {
            return this.indexQuery(ktx, this.indexDescriptor, new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)this.numberPropId1, (Object)this.numberProp1Values[0])});
        }

        @Override
        void assertRangeResult(List<Long> actual) {
            ArrayList<Long> expected = new ArrayList<Long>();
            for (long i = 0L; i < 50L; ++i) {
                expected.add(i);
            }
            this.assertSameContent(actual, expected);
        }

        @Override
        void assertExactResult(List<Long> actual) {
            ArrayList<Long> expected = new ArrayList<Long>();
            expected.add(0L);
            this.assertSameContent(actual, expected);
        }

        @Override
        IndexDefinition doCreateIndex(Transaction tx) {
            return tx.schema().indexFor(this.indexLabel).on(this.numberProp1).create();
        }

        public String toString() {
            return "Single number non unique";
        }
    }

    private static class StringIndexCoordinator
    extends IndexCoordinator {
        StringIndexCoordinator(Label indexLabel, String numberProp1, String numberProp2, String stringProp1, String stringProp2) {
            super(indexLabel, numberProp1, numberProp2, stringProp1, stringProp2);
        }

        @Override
        boolean supportRangeQuery() {
            return true;
        }

        @Override
        NodeValueIndexCursor queryRange(KernelTransaction ktx) throws KernelException {
            return this.indexQuery(ktx, this.indexDescriptor, new PropertyIndexQuery[]{PropertyIndexQuery.range((int)this.numberPropId1, (String)this.stringProp1Values[0], (boolean)true, (String)this.stringProp1Values[50], (boolean)false)});
        }

        @Override
        NodeValueIndexCursor queryExists(KernelTransaction ktx) throws KernelException {
            return this.indexQuery(ktx, this.indexDescriptor, new PropertyIndexQuery[]{PropertyIndexQuery.exists((int)this.stringPropId1)});
        }

        @Override
        NodeValueIndexCursor queryExact(KernelTransaction ktx) throws KernelException {
            return this.indexQuery(ktx, this.indexDescriptor, new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)this.stringPropId1, (Object)this.stringProp1Values[0])});
        }

        @Override
        void assertRangeResult(List<Long> actual) {
            ArrayList<Long> expected = new ArrayList<Long>();
            for (long i = 0L; i < 50L; ++i) {
                expected.add(i);
            }
            this.assertSameContent(actual, expected);
        }

        @Override
        void assertExactResult(List<Long> actual) {
            ArrayList<Long> expected = new ArrayList<Long>();
            expected.add(0L);
            this.assertSameContent(actual, expected);
        }

        @Override
        IndexDefinition doCreateIndex(Transaction tx) {
            return tx.schema().indexFor(this.indexLabel).on(this.stringProp1).create();
        }

        public String toString() {
            return "Single string non unique";
        }
    }

    private static class NumberCompositeIndexCoordinator
    extends IndexCoordinator {
        NumberCompositeIndexCoordinator(Label indexLabel, String numberProp1, String numberProp2, String stringProp1, String stringProp2) {
            super(indexLabel, numberProp1, numberProp2, stringProp1, stringProp2);
        }

        @Override
        boolean supportRangeQuery() {
            return false;
        }

        @Override
        NodeValueIndexCursor queryRange(KernelTransaction ktx) {
            throw new UnsupportedOperationException();
        }

        @Override
        NodeValueIndexCursor queryExists(KernelTransaction ktx) throws KernelException {
            return this.indexQuery(ktx, this.indexDescriptor, new PropertyIndexQuery[]{PropertyIndexQuery.exists((int)this.numberPropId1), PropertyIndexQuery.exists((int)this.numberPropId2)});
        }

        @Override
        NodeValueIndexCursor queryExact(KernelTransaction ktx) throws KernelException {
            return this.indexQuery(ktx, this.indexDescriptor, new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)this.numberPropId1, (Object)this.numberProp1Values[0]), PropertyIndexQuery.exact((int)this.numberPropId2, (Object)this.numberProp2Values[0])});
        }

        @Override
        void assertRangeResult(List<Long> actual) {
            throw new UnsupportedOperationException();
        }

        @Override
        void assertExactResult(List<Long> actual) {
            ArrayList<Long> expected = new ArrayList<Long>();
            expected.add(0L);
            this.assertSameContent(actual, expected);
        }

        @Override
        IndexDefinition doCreateIndex(Transaction tx) {
            return tx.schema().indexFor(this.indexLabel).on(this.numberProp1).on(this.numberProp2).create();
        }

        public String toString() {
            return "Composite number non unique";
        }
    }

    private static class StringCompositeIndexCoordinator
    extends IndexCoordinator {
        StringCompositeIndexCoordinator(Label indexLabel, String numberProp1, String numberProp2, String stringProp1, String stringProp2) {
            super(indexLabel, numberProp1, numberProp2, stringProp1, stringProp2);
        }

        @Override
        boolean supportRangeQuery() {
            return false;
        }

        @Override
        NodeValueIndexCursor queryRange(KernelTransaction ktx) {
            throw new UnsupportedOperationException();
        }

        @Override
        NodeValueIndexCursor queryExists(KernelTransaction ktx) throws KernelException {
            return this.indexQuery(ktx, this.indexDescriptor, new PropertyIndexQuery[]{PropertyIndexQuery.exists((int)this.stringPropId1), PropertyIndexQuery.exists((int)this.stringPropId2)});
        }

        @Override
        NodeValueIndexCursor queryExact(KernelTransaction ktx) throws KernelException {
            return this.indexQuery(ktx, this.indexDescriptor, new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)this.stringPropId1, (Object)this.stringProp1Values[0]), PropertyIndexQuery.exact((int)this.stringPropId2, (Object)this.stringProp2Values[0])});
        }

        @Override
        void assertRangeResult(List<Long> result) {
            throw new UnsupportedOperationException();
        }

        @Override
        void assertExactResult(List<Long> actual) {
            ArrayList<Long> expected = new ArrayList<Long>();
            expected.add(0L);
            this.assertSameContent(actual, expected);
        }

        @Override
        IndexDefinition doCreateIndex(Transaction tx) {
            return tx.schema().indexFor(this.indexLabel).on(this.stringProp1).on(this.stringProp2).create();
        }

        public String toString() {
            return "Composite string non unique";
        }
    }
}

