/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractFloatAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.ResourceLock;
import org.neo4j.common.EntityType;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.FulltextSettings;
import org.neo4j.configuration.helpers.DatabaseReadOnlyChecker;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexCreator;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.IndexSetting;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.id.DefaultIdGeneratorFactory;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipValueIndexCursor;
import org.neo4j.internal.kernel.api.SchemaWrite;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotApplicableKernelException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.recordstorage.SchemaStorage;
import org.neo4j.internal.recordstorage.StoreTokens;
import org.neo4j.internal.schema.FulltextSchemaDescriptor;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.impl.muninn.StandalonePageCacheFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.impl.fulltext.BrokenAnalyzerProvider;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexProceduresUtil;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexSettingsKeys;
import org.neo4j.kernel.api.impl.fulltext.FulltextProceduresTest;
import org.neo4j.kernel.api.impl.fulltext.LuceneFulltextTestSupport;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.impl.api.KernelImpl;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.index.schema.FulltextIndexProviderFactory;
import org.neo4j.kernel.impl.newapi.ExtendedNodeValueIndexCursorAdapter;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.extension.DbmsController;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.token.TokenHolders;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueCategory;
import org.neo4j.values.storable.Values;

@DbmsExtension
class FulltextIndexProviderTest {
    private static final String NAME = "fulltext";
    @Inject
    DbmsController controller;
    @Inject
    GraphDatabaseAPI db;
    @Inject
    KernelImpl kernel;
    private Node node1;
    private Node node2;
    private int labelIdHej;
    private int labelIdHa;
    private int labelIdHe;
    private int relTypeIdHej;
    private int propIdHej;
    private int propIdHa;
    private int propIdHe;
    private int propIdHo;

    FulltextIndexProviderTest() {
    }

    @BeforeEach
    void prepDB() {
        Label hej = Label.label((String)"hej");
        Label ha = Label.label((String)"ha");
        Label he = Label.label((String)"he");
        RelationshipType hejType = RelationshipType.withName((String)"hej");
        try (Transaction transaction = this.db.beginTx();){
            this.node1 = transaction.createNode(new Label[]{hej, ha, he});
            this.node1.setProperty("hej", (Object)"value");
            this.node1.setProperty("ha", (Object)"value1");
            this.node1.setProperty("he", (Object)"value2");
            this.node1.setProperty("ho", (Object)"value3");
            this.node2 = transaction.createNode();
            Relationship rel = this.node1.createRelationshipTo(this.node2, hejType);
            rel.setProperty("hej", (Object)"valuuu");
            rel.setProperty("ha", (Object)"value1");
            rel.setProperty("he", (Object)"value2");
            rel.setProperty("ho", (Object)"value3");
            transaction.commit();
        }
        try (Transaction tx = this.db.beginTx();){
            TokenRead tokenRead = this.tokenRead(tx);
            this.labelIdHej = tokenRead.nodeLabel(hej.name());
            this.labelIdHa = tokenRead.nodeLabel(ha.name());
            this.labelIdHe = tokenRead.nodeLabel(he.name());
            this.relTypeIdHej = tokenRead.relationshipType(hejType.name());
            this.propIdHej = tokenRead.propertyKey("hej");
            this.propIdHa = tokenRead.propertyKey("ha");
            this.propIdHe = tokenRead.propertyKey("he");
            this.propIdHo = tokenRead.propertyKey("ho");
            tx.commit();
        }
    }

    @Test
    void createFulltextIndex() throws Exception {
        IndexDescriptor fulltextIndex = this.createIndex(new int[]{this.labelIdHej, this.labelIdHa, this.labelIdHe}, new int[]{this.propIdHej, this.propIdHa, this.propIdHe});
        try (KernelTransactionImplementation transaction = this.getKernelTransaction();){
            IndexDescriptor descriptor = transaction.schemaRead().indexGetForName(NAME);
            org.junit.jupiter.api.Assertions.assertEquals((Object)descriptor.schema(), (Object)fulltextIndex.schema());
            transaction.success();
        }
    }

    @Test
    void shouldHaveAReasonableDirectoryStructure() throws Exception {
        this.createIndex(new int[]{this.labelIdHej, this.labelIdHa, this.labelIdHe}, new int[]{this.propIdHej, this.propIdHa, this.propIdHe});
        try (Transaction tx = this.db.beginTx();){
            tx.schema().awaitIndexesOnline(1L, TimeUnit.HOURS);
            tx.commit();
        }
        try (KernelTransactionImplementation transaction = this.getKernelTransaction();){
            IndexDescriptor descriptor = transaction.schemaRead().indexGetForName(NAME);
            Path indexDir = Path.of(this.db.databaseLayout().databaseDirectory().toAbsolutePath().toString(), "schema", "index", descriptor.getIndexProvider().name(), "" + descriptor.getId());
            List<Path> listFiles = List.of(Objects.requireNonNull(FileUtils.listPaths((Path)indexDir)));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)listFiles.contains(indexDir.resolve("failure-message")));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)listFiles.contains(indexDir.resolve("1")));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)listFiles.contains(indexDir.resolve(indexDir.getFileName() + ".tx")));
        }
    }

    @Test
    void createAndRetainFulltextIndex() throws Exception {
        IndexDescriptor fulltextIndex = this.createIndex(new int[]{this.labelIdHej, this.labelIdHa, this.labelIdHe}, new int[]{this.propIdHej, this.propIdHa, this.propIdHe});
        this.controller.restartDbms();
        this.verifyThatFulltextIndexIsPresent(fulltextIndex);
    }

    @Test
    void createAndRetainRelationshipFulltextIndex() throws Exception {
        IndexDescriptor indexReference;
        try (KernelTransactionImplementation transaction = this.getKernelTransaction();){
            FulltextSchemaDescriptor schema = SchemaDescriptor.fulltext((EntityType)EntityType.RELATIONSHIP, (int[])new int[]{this.labelIdHej, this.labelIdHa, this.labelIdHe}, (int[])new int[]{this.propIdHej, this.propIdHa, this.propIdHe, this.propIdHo});
            IndexPrototype prototype = IndexPrototype.forSchema((SchemaDescriptor)schema, (IndexProviderDescriptor)FulltextIndexProviderFactory.DESCRIPTOR).withIndexType(IndexType.FULLTEXT).withName(NAME);
            indexReference = transaction.schemaWrite().indexCreate(prototype);
            transaction.success();
        }
        this.await(indexReference);
        this.controller.restartDbms();
        this.verifyThatFulltextIndexIsPresent(indexReference);
    }

    @Test
    void createAndQueryFulltextIndex() throws Exception {
        IndexDescriptor indexReference = this.createIndex(new int[]{this.labelIdHej, this.labelIdHa, this.labelIdHe}, new int[]{this.propIdHej, this.propIdHa, this.propIdHe, this.propIdHo});
        this.await(indexReference);
        long thirdNodeId = this.createTheThirdNode();
        this.verifyNodeData(thirdNodeId);
        this.controller.restartDbms();
        this.verifyNodeData(thirdNodeId);
    }

    @Test
    void createAndQueryFulltextRelationshipIndex() throws Exception {
        long secondRelId;
        IndexDescriptor indexReference;
        try (KernelTransactionImplementation transaction = this.getKernelTransaction();){
            FulltextSchemaDescriptor schema = SchemaDescriptor.fulltext((EntityType)EntityType.RELATIONSHIP, (int[])new int[]{this.labelIdHej, this.labelIdHa, this.labelIdHe}, (int[])new int[]{this.propIdHej, this.propIdHa, this.propIdHe, this.propIdHo});
            IndexPrototype prototype = IndexPrototype.forSchema((SchemaDescriptor)schema, (IndexProviderDescriptor)FulltextIndexProviderFactory.DESCRIPTOR).withIndexType(IndexType.FULLTEXT).withName(NAME);
            indexReference = transaction.schemaWrite().indexCreate(prototype);
            transaction.success();
        }
        this.await(indexReference);
        try (Transaction transaction = this.db.beginTx();){
            Relationship ho = transaction.getNodeById(this.node1.getId()).createRelationshipTo(transaction.getNodeById(this.node2.getId()), RelationshipType.withName((String)"ho"));
            secondRelId = ho.getId();
            ho.setProperty("hej", (Object)"villa");
            ho.setProperty("ho", (Object)"value3");
            transaction.commit();
        }
        this.verifyRelationshipData(secondRelId);
        this.controller.restartDbms();
        this.verifyRelationshipData(secondRelId);
    }

    @Test
    void multiTokenFulltextIndexesMustShowUpInSchemaGetIndexes() {
        try (Transaction tx = this.db.beginTx();){
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "nodeIndex", FulltextIndexProceduresUtil.asStrList((String[])new String[]{"Label1", "Label2"}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"prop1", "prop2"}))).close();
            tx.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", "relIndex", FulltextIndexProceduresUtil.asStrList((String[])new String[]{"RelType1", "RelType2"}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"prop1", "prop2"}))).close();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            for (IndexDefinition index : tx.schema().getIndexes()) {
                if (index.getIndexType() == org.neo4j.graphdb.schema.IndexType.LOOKUP) continue;
                org.junit.jupiter.api.Assertions.assertFalse((boolean)index.isConstraintIndex());
                org.junit.jupiter.api.Assertions.assertTrue((boolean)index.isMultiTokenIndex());
                org.junit.jupiter.api.Assertions.assertTrue((boolean)index.isCompositeIndex());
                if (index.isNodeIndex()) {
                    org.junit.jupiter.api.Assertions.assertFalse((boolean)index.isRelationshipIndex());
                    Assertions.assertThat((Iterable)index.getLabels()).contains((Object[])new Label[]{Label.label((String)"Label1"), Label.label((String)"Label2")});
                    try {
                        index.getRelationshipTypes();
                        org.junit.jupiter.api.Assertions.fail((String)"index.getRelationshipTypes() on node IndexDefinition should have thrown.");
                    }
                    catch (IllegalStateException illegalStateException) {}
                    continue;
                }
                org.junit.jupiter.api.Assertions.assertTrue((boolean)index.isRelationshipIndex());
                Assertions.assertThat((Iterable)index.getRelationshipTypes()).contains((Object[])new RelationshipType[]{RelationshipType.withName((String)"RelType1"), RelationshipType.withName((String)"RelType2")});
                try {
                    index.getLabels();
                    org.junit.jupiter.api.Assertions.fail((String)"index.getLabels() on node IndexDefinition should have thrown.");
                }
                catch (IllegalStateException illegalStateException) {}
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void awaitIndexesOnlineMustWorkOnFulltextIndexes() {
        String prop1 = "prop1";
        String prop2 = "prop2";
        String prop3 = "prop3";
        String val1 = "foo foo";
        String val2 = "bar bar";
        String val3 = "baz baz";
        Label label1 = Label.label((String)"FirstLabel");
        Label label2 = Label.label((String)"SecondLabel");
        Label label3 = Label.label((String)"ThirdLabel");
        RelationshipType relType1 = RelationshipType.withName((String)"FirstRelType");
        RelationshipType relType2 = RelationshipType.withName((String)"SecondRelType");
        RelationshipType relType3 = RelationshipType.withName((String)"ThirdRelType");
        LongHashSet nodes1 = new LongHashSet();
        LongHashSet nodes2 = new LongHashSet();
        LongHashSet nodes3 = new LongHashSet();
        LongHashSet rels1 = new LongHashSet();
        LongHashSet rels2 = new LongHashSet();
        LongHashSet rels3 = new LongHashSet();
        try (Transaction tx = this.db.beginTx();){
            for (int i = 0; i < 100; ++i) {
                Node node1 = tx.createNode(new Label[]{label1});
                node1.setProperty(prop1, (Object)val1);
                nodes1.add(node1.getId());
                Relationship rel1 = node1.createRelationshipTo(node1, relType1);
                rel1.setProperty(prop1, (Object)val1);
                rels1.add(rel1.getId());
                Node node2 = tx.createNode(new Label[]{label2});
                node2.setProperty(prop2, (Object)val2);
                nodes2.add(node2.getId());
                Relationship rel2 = node1.createRelationshipTo(node2, relType2);
                rel2.setProperty(prop2, (Object)val2);
                rels2.add(rel2.getId());
                Node node3 = tx.createNode(new Label[]{label3});
                node3.setProperty(prop3, (Object)val3);
                nodes3.add(node3.getId());
                Relationship rel3 = node1.createRelationshipTo(node3, relType3);
                rel3.setProperty(prop3, (Object)val3);
                rels3.add(rel3.getId());
            }
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "nodeIndex", FulltextIndexProceduresUtil.asStrList((String[])new String[]{label1.name(), label2.name(), label3.name()}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{prop1, prop2, prop3}))).close();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(30L, TimeUnit.SECONDS);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodeIndex", "foo", nodes1);
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodeIndex", "bar", nodes2);
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodeIndex", "baz", nodes3);
        tx = this.db.beginTx();
        try {
            tx.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", "relIndex", FulltextIndexProceduresUtil.asStrList((String[])new String[]{relType1.name(), relType2.name(), relType3.name()}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{prop1, prop2, prop3}))).close();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(30L, TimeUnit.SECONDS);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "relIndex", "foo", rels1);
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "relIndex", "bar", rels2);
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "relIndex", "baz", rels3);
    }

    @Test
    void queryingWithIndexProgressorMustProvideScore() throws Exception {
        long nodeId = this.createTheThirdNode();
        IndexDescriptor index = this.createIndex(new int[]{this.labelIdHej, this.labelIdHa, this.labelIdHe}, new int[]{this.propIdHej, this.propIdHa, this.propIdHe, this.propIdHo});
        this.await(index);
        final ArrayList acceptedEntities = new ArrayList();
        try (KernelTransactionImplementation ktx = this.getKernelTransaction();){
            ExtendedNodeValueIndexCursorAdapter cursor = new ExtendedNodeValueIndexCursorAdapter(){
                private long nodeReference;
                private IndexProgressor progressor;

                public long nodeReference() {
                    return this.nodeReference;
                }

                public boolean next() {
                    return this.progressor.next();
                }

                public void initialize(IndexDescriptor descriptor, IndexProgressor progressor, PropertyIndexQuery[] query, IndexQueryConstraints constraints, boolean indexIncludesTransactionState) {
                    this.progressor = progressor;
                }

                public boolean acceptEntity(long reference, float score, Value ... values) {
                    this.nodeReference = reference;
                    org.junit.jupiter.api.Assertions.assertFalse((boolean)Float.isNaN(score), (String)"score should not be NaN");
                    ((AbstractFloatAssert)Assertions.assertThat((float)score).as("score must be positive", new Object[0])).isGreaterThan(0.0f);
                    acceptedEntities.add("reference = " + reference + ", score = " + score + ", " + Arrays.toString(values));
                    return true;
                }
            };
            Read read = ktx.dataRead();
            IndexReadSession indexSession = ktx.dataRead().indexReadSession(index);
            read.nodeIndexSeek(indexSession, (NodeValueIndexCursor)cursor, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{PropertyIndexQuery.fulltextSearch((String)"hej:\"villa\"")});
            int counter = 0;
            while (cursor.next()) {
                Assertions.assertThat((long)cursor.nodeReference()).isEqualTo(nodeId);
                ++counter;
            }
            Assertions.assertThat((int)counter).isEqualTo(1);
            Assertions.assertThat((int)acceptedEntities.size()).isEqualTo(1);
            acceptedEntities.clear();
        }
    }

    @Test
    void validateMustThrowIfSchemaIsNotFulltext() throws Exception {
        try (KernelTransactionImplementation transaction = this.getKernelTransaction();){
            int[] propertyIds = new int[]{this.propIdHa};
            LabelSchemaDescriptor schema = SchemaDescriptor.forLabel((int)this.labelIdHa, (int[])propertyIds);
            IndexPrototype prototype = IndexPrototype.forSchema((SchemaDescriptor)schema).withIndexType(IndexType.FULLTEXT).withName(NAME);
            SchemaWrite schemaWrite = transaction.schemaWrite();
            IllegalArgumentException e = (IllegalArgumentException)org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> schemaWrite.indexCreate(prototype));
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"schema is not a full-text index schema"});
            transaction.success();
        }
    }

    @Test
    void indexWithUnknownAnalyzerWillBeMarkedAsFailedOnStartup() throws Exception {
        long indexId;
        try (KernelTransactionImplementation transaction = this.getKernelTransaction();){
            int[] propertyIds = new int[]{this.propIdHa};
            FulltextSchemaDescriptor schema = SchemaDescriptor.fulltext((EntityType)EntityType.NODE, (int[])new int[]{this.labelIdHa}, (int[])propertyIds);
            IndexPrototype prototype = IndexPrototype.forSchema((SchemaDescriptor)schema).withIndexType(IndexType.FULLTEXT).withName(NAME);
            SchemaWrite schemaWrite = transaction.schemaWrite();
            IndexDescriptor index = schemaWrite.indexCreate(prototype);
            indexId = index.getId();
            transaction.success();
        }
        this.controller.restartDbms(builder -> {
            PageCacheTracer cacheTracer = PageCacheTracer.NULL;
            FileSystemAbstraction fs = builder.getFileSystem();
            DatabaseLayout databaseLayout = Neo4jLayout.of((Path)builder.getHomeDirectory()).databaseLayout("neo4j");
            DefaultIdGeneratorFactory idGenFactory = new DefaultIdGeneratorFactory(fs, RecoveryCleanupWorkCollector.ignore(), databaseLayout.getDatabaseName());
            try (JobScheduler scheduler = JobSchedulerFactory.createInitialisedScheduler();
                 PageCache pageCache = StandalonePageCacheFactory.createPageCache((FileSystemAbstraction)fs, (JobScheduler)scheduler, (PageCacheTracer)cacheTracer);){
                StoreFactory factory = new StoreFactory(databaseLayout, Config.defaults(), (IdGeneratorFactory)idGenFactory, pageCache, fs, (LogProvider)NullLogProvider.getInstance(), cacheTracer, DatabaseReadOnlyChecker.writable());
                CursorContext cursorContext = CursorContext.NULL;
                try (NeoStores neoStores = factory.openAllNeoStores(false);){
                    TokenHolders tokens = StoreTokens.readOnlyTokenHolders((NeoStores)neoStores, (CursorContext)CursorContext.NULL);
                    SchemaStore schemaStore = neoStores.getSchemaStore();
                    SchemaStorage storage = new SchemaStorage(schemaStore, tokens, () -> KernelVersion.LATEST);
                    IndexDescriptor index = (IndexDescriptor)storage.loadSingleSchemaRule(indexId, CursorContext.NULL);
                    HashMap indexConfigMap = new HashMap(index.getIndexConfig().asMap());
                    for (Map.Entry entry : indexConfigMap.entrySet()) {
                        if (!((String)entry.getKey()).contains("analyzer")) continue;
                        entry.setValue(Values.stringValue((String)"bla-bla-lyzer"));
                    }
                    index = index.withIndexConfig(IndexConfig.with(indexConfigMap));
                    storage.writeSchemaRule((SchemaRule)index, cursorContext, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
                    schemaStore.flush(cursorContext);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return builder;
        });
        try (Transaction tx = this.db.beginTx();){
            IndexDefinition index = tx.schema().getIndexByName(NAME);
            Schema.IndexState indexState = tx.schema().getIndexState(index);
            Assertions.assertThat((Comparable)indexState).isEqualTo((Object)Schema.IndexState.FAILED);
            String indexFailure = tx.schema().getIndexFailure(index);
            Assertions.assertThat((String)indexFailure).contains(new CharSequence[]{"bla-bla-lyzer"});
        }
        tx = this.db.beginTx();
        try {
            tx.schema().getIndexByName(NAME).drop();
            org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> tx.schema().getIndexByName(NAME));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> tx.schema().getIndexByName(NAME));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.controller.restartDbms();
        tx = this.db.beginTx();
        try {
            org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> tx.schema().getIndexByName(NAME));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ResourceLock(value="BrokenAnalyzerProvider")
    @Test
    void indexWithAnalyzerThatThrowsWillNotBeCreated() {
        Schema.IndexState indexState;
        IndexDefinition index;
        IndexCreator creator;
        BrokenAnalyzerProvider.shouldThrow = true;
        BrokenAnalyzerProvider.shouldReturnNull = false;
        try (Transaction tx = this.db.beginTx();){
            creator = tx.schema().indexFor(Label.label((String)"Label")).withIndexType(org.neo4j.graphdb.schema.IndexType.FULLTEXT).withIndexConfiguration(Map.of(IndexSetting.fulltext_Analyzer(), "broken-analyzer")).on("prop").withName(NAME);
            RuntimeException e = (RuntimeException)org.junit.jupiter.api.Assertions.assertThrows(RuntimeException.class, () -> ((IndexCreator)creator).create());
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"boom"});
            BrokenAnalyzerProvider.shouldThrow = false;
            creator.create();
            BrokenAnalyzerProvider.shouldThrow = true;
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            IllegalStateException e = (IllegalStateException)org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> tx.schema().awaitIndexOnline(NAME, 10L, TimeUnit.SECONDS));
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"FAILED"});
            IndexDefinition index2 = tx.schema().getIndexByName(NAME);
            Assertions.assertThat((Comparable)tx.schema().getIndexState(index2)).isEqualTo((Object)Schema.IndexState.FAILED);
            index2.drop();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        BrokenAnalyzerProvider.shouldThrow = false;
        tx = this.db.beginTx();
        try {
            creator = tx.schema().indexFor(Label.label((String)"Label")).withIndexType(org.neo4j.graphdb.schema.IndexType.FULLTEXT).withIndexConfiguration(Map.of(IndexSetting.fulltext_Analyzer(), "broken-analyzer")).on("prop").withName(NAME);
            creator.create();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexOnline(NAME, 1L, TimeUnit.MINUTES);
            index = tx.schema().getIndexByName(NAME);
            indexState = tx.schema().getIndexState(index);
            Assertions.assertThat((Comparable)indexState).isEqualTo((Object)Schema.IndexState.ONLINE);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.controller.restartDbms();
        tx = this.db.beginTx();
        try {
            index = tx.schema().getIndexByName(NAME);
            indexState = tx.schema().getIndexState(index);
            Assertions.assertThat((Comparable)indexState).isEqualTo((Object)Schema.IndexState.ONLINE);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ResourceLock(value="BrokenAnalyzerProvider")
    @Test
    void indexWithAnalyzerThatReturnsNullWillNotBeCreated() {
        Schema.IndexState indexState;
        IndexDefinition index;
        IndexCreator creator;
        BrokenAnalyzerProvider.shouldThrow = false;
        BrokenAnalyzerProvider.shouldReturnNull = true;
        try (Transaction tx = this.db.beginTx();){
            creator = tx.schema().indexFor(Label.label((String)"Label")).withIndexType(org.neo4j.graphdb.schema.IndexType.FULLTEXT).withIndexConfiguration(Map.of(IndexSetting.fulltext_Analyzer(), "broken-analyzer")).on("prop").withName(NAME);
            RuntimeException e = (RuntimeException)org.junit.jupiter.api.Assertions.assertThrows(RuntimeException.class, () -> ((IndexCreator)creator).create());
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"null"});
            BrokenAnalyzerProvider.shouldReturnNull = false;
            creator.create();
            BrokenAnalyzerProvider.shouldReturnNull = true;
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            IllegalStateException e = (IllegalStateException)org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> tx.schema().awaitIndexOnline(NAME, 1L, TimeUnit.MINUTES));
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"FAILED"});
            IndexDefinition index2 = tx.schema().getIndexByName(NAME);
            Assertions.assertThat((Comparable)tx.schema().getIndexState(index2)).isEqualTo((Object)Schema.IndexState.FAILED);
            index2.drop();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        BrokenAnalyzerProvider.shouldReturnNull = false;
        tx = this.db.beginTx();
        try {
            creator = tx.schema().indexFor(Label.label((String)"Label")).withIndexType(org.neo4j.graphdb.schema.IndexType.FULLTEXT).withIndexConfiguration(Map.of(IndexSetting.fulltext_Analyzer(), "broken-analyzer")).on("prop").withName(NAME);
            creator.create();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexOnline(NAME, 1L, TimeUnit.MINUTES);
            index = tx.schema().getIndexByName(NAME);
            indexState = tx.schema().getIndexState(index);
            Assertions.assertThat((Comparable)indexState).isEqualTo((Object)Schema.IndexState.ONLINE);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.controller.restartDbms();
        tx = this.db.beginTx();
        try {
            index = tx.schema().getIndexByName(NAME);
            indexState = tx.schema().getIndexState(index);
            Assertions.assertThat((Comparable)indexState).isEqualTo((Object)Schema.IndexState.ONLINE);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ResourceLock(value="BrokenAnalyzerProvider")
    @Test
    void indexWithAnalyzerProviderThatThrowsAnExceptionOnStartupWillBeMarkedAsFailedOnStartup() {
        Schema.IndexState indexState;
        IndexDefinition index;
        BrokenAnalyzerProvider.shouldThrow = false;
        BrokenAnalyzerProvider.shouldReturnNull = false;
        try (Transaction tx = this.db.beginTx();){
            IndexCreator creator = tx.schema().indexFor(Label.label((String)"Label")).withIndexType(org.neo4j.graphdb.schema.IndexType.FULLTEXT).withIndexConfiguration(Map.of(IndexSetting.fulltext_Analyzer(), "broken-analyzer")).on("prop").withName(NAME);
            creator.create();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexOnline(NAME, 1L, TimeUnit.MINUTES);
            index = tx.schema().getIndexByName(NAME);
            indexState = tx.schema().getIndexState(index);
            Assertions.assertThat((Comparable)indexState).isEqualTo((Object)Schema.IndexState.ONLINE);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        BrokenAnalyzerProvider.shouldThrow = true;
        this.controller.restartDbms();
        tx = this.db.beginTx();
        try {
            index = tx.schema().getIndexByName(NAME);
            indexState = tx.schema().getIndexState(index);
            Assertions.assertThat((Comparable)indexState).isEqualTo((Object)Schema.IndexState.FAILED);
            String indexFailure = tx.schema().getIndexFailure(index);
            Assertions.assertThat((String)indexFailure).contains(new CharSequence[]{"boom"});
            index.drop();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> tx.schema().getIndexByName(NAME));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ResourceLock(value="BrokenAnalyzerProvider")
    @Test
    void indexWithAnalyzerProviderThatReturnsNullWillBeMarkedAsFailedOnStartup() {
        Schema.IndexState indexState;
        IndexDefinition index;
        BrokenAnalyzerProvider.shouldThrow = false;
        BrokenAnalyzerProvider.shouldReturnNull = false;
        try (Transaction tx = this.db.beginTx();){
            IndexCreator creator = tx.schema().indexFor(Label.label((String)"Label")).withIndexType(org.neo4j.graphdb.schema.IndexType.FULLTEXT).withIndexConfiguration(Map.of(IndexSetting.fulltext_Analyzer(), "broken-analyzer")).on("prop").withName(NAME);
            creator.create();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexOnline(NAME, 1L, TimeUnit.MINUTES);
            index = tx.schema().getIndexByName(NAME);
            indexState = tx.schema().getIndexState(index);
            Assertions.assertThat((Comparable)indexState).isEqualTo((Object)Schema.IndexState.ONLINE);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        BrokenAnalyzerProvider.shouldReturnNull = true;
        this.controller.restartDbms();
        tx = this.db.beginTx();
        try {
            index = tx.schema().getIndexByName(NAME);
            indexState = tx.schema().getIndexState(index);
            Assertions.assertThat((Comparable)indexState).isEqualTo((Object)Schema.IndexState.FAILED);
            String indexFailure = tx.schema().getIndexFailure(index);
            Assertions.assertThat((String)indexFailure).contains(new CharSequence[]{"null"});
            index.drop();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> tx.schema().getIndexByName(NAME));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldAnswerContainsIfCypherCompatible() throws KernelException {
        KernelTransaction ktx;
        int containsPropertyId;
        int containsLabelId;
        long nodeapaapa;
        long nodeapalong;
        long nodeapa2;
        long nodeapa1;
        long nodea;
        Label containsLabel = Label.label((String)"containsLabel");
        String containsProp = "containsProp";
        try (Transaction tx = this.db.beginTx();){
            nodea = this.createNode(tx, containsLabel, containsProp, "a");
            this.createNode(tx, containsLabel, containsProp, "A");
            nodeapa1 = this.createNode(tx, containsLabel, containsProp, "apa");
            nodeapa2 = this.createNode(tx, containsLabel, containsProp, "apa");
            nodeapalong = this.createNode(tx, containsLabel, containsProp, "apalong");
            nodeapaapa = this.createNode(tx, containsLabel, containsProp, "apa apa");
            tx.commit();
        }
        try (Transaction tx = this.db.beginTx();){
            TokenRead tokenRead = this.tokenRead(tx);
            containsLabelId = tokenRead.nodeLabel(containsLabel.name());
            containsPropertyId = tokenRead.propertyKey(containsProp);
        }
        IndexDescriptor indexReference = this.createIndex(new int[]{containsLabelId}, new int[]{containsPropertyId}, "cypher");
        this.await(indexReference);
        tx = this.db.beginTx();
        try {
            ktx = LuceneFulltextTestSupport.kernelTransaction(tx);
            this.assertQueryResult(ktx, (PropertyIndexQuery)this.containsQuery(containsPropertyId, "a"), nodea, nodeapa1, nodeapa2, nodeapalong, nodeapaapa);
            this.assertQueryResult(ktx, (PropertyIndexQuery)this.containsQuery(containsPropertyId, "apa"), nodeapa1, nodeapa2, nodeapalong, nodeapaapa);
            this.assertQueryResult(ktx, (PropertyIndexQuery)this.containsQuery(containsPropertyId, "apa*"), new Long[0]);
            this.assertQueryResult(ktx, (PropertyIndexQuery)this.containsQuery(containsPropertyId, "pa ap"), nodeapaapa);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.controller.restartDbms();
        tx = this.db.beginTx();
        try {
            ktx = LuceneFulltextTestSupport.kernelTransaction(tx);
            this.assertQueryResult(ktx, (PropertyIndexQuery)this.containsQuery(containsPropertyId, "a"), nodea, nodeapa1, nodeapa2, nodeapalong, nodeapaapa);
            this.assertQueryResult(ktx, (PropertyIndexQuery)this.containsQuery(containsPropertyId, "apa"), nodeapa1, nodeapa2, nodeapalong, nodeapaapa);
            this.assertQueryResult(ktx, (PropertyIndexQuery)this.containsQuery(containsPropertyId, "apa*"), new Long[0]);
            this.assertQueryResult(ktx, (PropertyIndexQuery)this.containsQuery(containsPropertyId, "pa ap"), nodeapaapa);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldAnswerEndsWithIfCypherCompatible() throws KernelException {
        KernelTransaction ktx;
        int containsPropertyId;
        int containsLabelId;
        long nodeapaapa;
        long nodelongapa;
        long nodeapa2;
        long nodeapa1;
        long nodea;
        Label containsLabel = Label.label((String)"containsLabel");
        String containsProp = "containsProp";
        try (Transaction tx = this.db.beginTx();){
            nodea = this.createNode(tx, containsLabel, containsProp, "a");
            this.createNode(tx, containsLabel, containsProp, "A");
            nodeapa1 = this.createNode(tx, containsLabel, containsProp, "apa");
            nodeapa2 = this.createNode(tx, containsLabel, containsProp, "apa");
            nodelongapa = this.createNode(tx, containsLabel, containsProp, "longapa");
            nodeapaapa = this.createNode(tx, containsLabel, containsProp, "apa apa");
            this.createNode(tx, containsLabel, containsProp, "apalong");
            tx.commit();
        }
        try (Transaction tx = this.db.beginTx();){
            TokenRead tokenRead = this.tokenRead(tx);
            containsLabelId = tokenRead.nodeLabel(containsLabel.name());
            containsPropertyId = tokenRead.propertyKey(containsProp);
        }
        IndexDescriptor indexReference = this.createIndex(new int[]{containsLabelId}, new int[]{containsPropertyId}, "cypher");
        this.await(indexReference);
        tx = this.db.beginTx();
        try {
            ktx = LuceneFulltextTestSupport.kernelTransaction(tx);
            this.assertQueryResult(ktx, (PropertyIndexQuery)this.endsWithQuery(containsPropertyId, "a"), nodea, nodeapa1, nodeapa2, nodelongapa, nodeapaapa);
            this.assertQueryResult(ktx, (PropertyIndexQuery)this.endsWithQuery(containsPropertyId, "apa"), nodeapa1, nodeapa2, nodelongapa, nodeapaapa);
            this.assertQueryResult(ktx, (PropertyIndexQuery)this.endsWithQuery(containsPropertyId, "apa*"), new Long[0]);
            this.assertQueryResult(ktx, (PropertyIndexQuery)this.endsWithQuery(containsPropertyId, "a apa"), nodeapaapa);
            this.assertQueryResult(ktx, (PropertyIndexQuery)this.endsWithQuery(containsPropertyId, "*apa"), new Long[0]);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.controller.restartDbms();
        tx = this.db.beginTx();
        try {
            ktx = LuceneFulltextTestSupport.kernelTransaction(tx);
            this.assertQueryResult(ktx, (PropertyIndexQuery)this.endsWithQuery(containsPropertyId, "a"), nodea, nodeapa1, nodeapa2, nodelongapa, nodeapaapa);
            this.assertQueryResult(ktx, (PropertyIndexQuery)this.endsWithQuery(containsPropertyId, "apa"), nodeapa1, nodeapa2, nodelongapa, nodeapaapa);
            this.assertQueryResult(ktx, (PropertyIndexQuery)this.endsWithQuery(containsPropertyId, "apa*"), new Long[0]);
            this.assertQueryResult(ktx, (PropertyIndexQuery)this.endsWithQuery(containsPropertyId, "a apa"), nodeapaapa);
            this.assertQueryResult(ktx, (PropertyIndexQuery)this.endsWithQuery(containsPropertyId, "*apa"), new Long[0]);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldAnswerStartsWithIfCypherCompatible() throws KernelException {
        KernelTransaction ktx;
        int containsPropertyId;
        int containsLabelId;
        long nodeapalong;
        long nodeapaapa;
        long nodeapa2;
        long nodeapa1;
        long nodea;
        Label containsLabel = Label.label((String)"containsLabel");
        String containsProp = "containsProp";
        try (Transaction tx = this.db.beginTx();){
            nodea = this.createNode(tx, containsLabel, containsProp, "a");
            this.createNode(tx, containsLabel, containsProp, "A");
            nodeapa1 = this.createNode(tx, containsLabel, containsProp, "apa");
            nodeapa2 = this.createNode(tx, containsLabel, containsProp, "apa");
            this.createNode(tx, containsLabel, containsProp, "longapa");
            nodeapaapa = this.createNode(tx, containsLabel, containsProp, "apa apa");
            nodeapalong = this.createNode(tx, containsLabel, containsProp, "apalong");
            tx.commit();
        }
        try (Transaction tx = this.db.beginTx();){
            TokenRead tokenRead = this.tokenRead(tx);
            containsLabelId = tokenRead.nodeLabel(containsLabel.name());
            containsPropertyId = tokenRead.propertyKey(containsProp);
        }
        IndexDescriptor indexReference = this.createIndex(new int[]{containsLabelId}, new int[]{containsPropertyId}, "cypher");
        this.await(indexReference);
        tx = this.db.beginTx();
        try {
            ktx = LuceneFulltextTestSupport.kernelTransaction(tx);
            this.assertQueryResult(ktx, (PropertyIndexQuery)this.startsWithQuery(containsPropertyId, "a"), nodea, nodeapa1, nodeapa2, nodeapaapa, nodeapalong);
            this.assertQueryResult(ktx, (PropertyIndexQuery)this.startsWithQuery(containsPropertyId, "apa"), nodeapa1, nodeapa2, nodeapalong, nodeapaapa);
            this.assertQueryResult(ktx, (PropertyIndexQuery)this.startsWithQuery(containsPropertyId, "apa*"), new Long[0]);
            this.assertQueryResult(ktx, (PropertyIndexQuery)this.startsWithQuery(containsPropertyId, "apa a"), nodeapaapa);
            this.assertQueryResult(ktx, (PropertyIndexQuery)this.startsWithQuery(containsPropertyId, "*apa"), new Long[0]);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.controller.restartDbms();
        tx = this.db.beginTx();
        try {
            ktx = LuceneFulltextTestSupport.kernelTransaction(tx);
            this.assertQueryResult(ktx, (PropertyIndexQuery)this.startsWithQuery(containsPropertyId, "a"), nodea, nodeapa1, nodeapa2, nodeapaapa, nodeapalong);
            this.assertQueryResult(ktx, (PropertyIndexQuery)this.startsWithQuery(containsPropertyId, "apa"), nodeapa1, nodeapa2, nodeapalong, nodeapaapa);
            this.assertQueryResult(ktx, (PropertyIndexQuery)this.startsWithQuery(containsPropertyId, "apa*"), new Long[0]);
            this.assertQueryResult(ktx, (PropertyIndexQuery)this.startsWithQuery(containsPropertyId, "apa a"), nodeapaapa);
            this.assertQueryResult(ktx, (PropertyIndexQuery)this.startsWithQuery(containsPropertyId, "*apa"), new Long[0]);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldAnswerExactIfCypherCompatible() throws KernelException {
        IndexNotApplicableKernelException e;
        KernelTransaction ktx;
        int containsPropertyId;
        int containsLabelId;
        long nodeapaapa;
        long nodeapa2;
        long nodeapa1;
        long nodea;
        Label containsLabel = Label.label((String)"containsLabel");
        String containsProp = "containsProp";
        try (Transaction tx = this.db.beginTx();){
            nodea = this.createNode(tx, containsLabel, containsProp, "a");
            this.createNode(tx, containsLabel, containsProp, "A");
            nodeapa1 = this.createNode(tx, containsLabel, containsProp, "apa");
            nodeapa2 = this.createNode(tx, containsLabel, containsProp, "apa");
            this.createNode(tx, containsLabel, containsProp, "longapa");
            nodeapaapa = this.createNode(tx, containsLabel, containsProp, "apa apa");
            this.createNode(tx, containsLabel, containsProp, "apalong");
            tx.commit();
        }
        try (Transaction tx = this.db.beginTx();){
            TokenRead tokenRead = this.tokenRead(tx);
            containsLabelId = tokenRead.nodeLabel(containsLabel.name());
            containsPropertyId = tokenRead.propertyKey(containsProp);
        }
        IndexDescriptor indexReference = this.createIndex(new int[]{containsLabelId}, new int[]{containsPropertyId}, "cypher");
        this.await(indexReference);
        tx = this.db.beginTx();
        try {
            ktx = LuceneFulltextTestSupport.kernelTransaction(tx);
            this.assertQueryResult(ktx, (PropertyIndexQuery)this.exactQuery(containsPropertyId, "a"), nodea);
            this.assertQueryResult(ktx, (PropertyIndexQuery)this.exactQuery(containsPropertyId, "apa"), nodeapa1, nodeapa2);
            this.assertQueryResult(ktx, (PropertyIndexQuery)this.exactQuery(containsPropertyId, "apa*"), new Long[0]);
            this.assertQueryResult(ktx, (PropertyIndexQuery)this.exactQuery(containsPropertyId, "apa a"), new Long[0]);
            this.assertQueryResult(ktx, (PropertyIndexQuery)this.exactQuery(containsPropertyId, "apa apa"), nodeapaapa);
            this.assertQueryResult(ktx, (PropertyIndexQuery)this.exactQuery(containsPropertyId, "*apa"), new Long[0]);
            this.assertQueryResult(ktx, (PropertyIndexQuery)this.exactQuery(containsPropertyId, "apa*"), new Long[0]);
            e = (IndexNotApplicableKernelException)org.junit.jupiter.api.Assertions.assertThrows(IndexNotApplicableKernelException.class, () -> this.assertQueryResult(ktx, (PropertyIndexQuery)this.exactQuery(containsPropertyId, 1), new Long[0]));
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"A fulltext schema index cannot answer " + PropertyIndexQuery.IndexQueryType.exact + " queries on " + ValueCategory.NUMBER + " values."});
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.controller.restartDbms();
        tx = this.db.beginTx();
        try {
            ktx = LuceneFulltextTestSupport.kernelTransaction(tx);
            this.assertQueryResult(ktx, (PropertyIndexQuery)this.exactQuery(containsPropertyId, "a"), nodea);
            this.assertQueryResult(ktx, (PropertyIndexQuery)this.exactQuery(containsPropertyId, "apa"), nodeapa1, nodeapa2);
            this.assertQueryResult(ktx, (PropertyIndexQuery)this.exactQuery(containsPropertyId, "apa*"), new Long[0]);
            this.assertQueryResult(ktx, (PropertyIndexQuery)this.exactQuery(containsPropertyId, "apa a"), new Long[0]);
            this.assertQueryResult(ktx, (PropertyIndexQuery)this.exactQuery(containsPropertyId, "apa apa"), nodeapaapa);
            this.assertQueryResult(ktx, (PropertyIndexQuery)this.exactQuery(containsPropertyId, "*apa"), new Long[0]);
            this.assertQueryResult(ktx, (PropertyIndexQuery)this.exactQuery(containsPropertyId, "apa*"), new Long[0]);
            e = (IndexNotApplicableKernelException)org.junit.jupiter.api.Assertions.assertThrows(IndexNotApplicableKernelException.class, () -> this.assertQueryResult(ktx, (PropertyIndexQuery)this.exactQuery(containsPropertyId, 1), new Long[0]));
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"A fulltext schema index cannot answer " + PropertyIndexQuery.IndexQueryType.exact + " queries on " + ValueCategory.NUMBER + " values."});
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldAnswerRangeIfCypherCompatible() throws KernelException {
        KernelTransaction ktx;
        int containsPropertyId;
        int containsLabelId;
        long nodeapa2;
        long nodeapa1;
        long nodeaapa;
        long nodeaa;
        long nodea;
        Label containsLabel = Label.label((String)"containsLabel");
        String containsProp = "containsProp";
        try (Transaction tx = this.db.beginTx();){
            this.createNode(tx, containsLabel, containsProp, "1");
            nodea = this.createNode(tx, containsLabel, containsProp, "a");
            nodeaa = this.createNode(tx, containsLabel, containsProp, "aa");
            nodeaapa = this.createNode(tx, containsLabel, containsProp, "aapa");
            nodeapa1 = this.createNode(tx, containsLabel, containsProp, "apa");
            nodeapa2 = this.createNode(tx, containsLabel, containsProp, "apa");
            this.createNode(tx, containsLabel, containsProp, "bpa");
            this.createNode(tx, containsLabel, containsProp, "A");
            tx.commit();
        }
        try (Transaction tx = this.db.beginTx();){
            TokenRead tokenRead = this.tokenRead(tx);
            containsLabelId = tokenRead.nodeLabel(containsLabel.name());
            containsPropertyId = tokenRead.propertyKey(containsProp);
        }
        IndexDescriptor indexReference = this.createIndex(new int[]{containsLabelId}, new int[]{containsPropertyId}, "cypher");
        this.await(indexReference);
        tx = this.db.beginTx();
        try {
            ktx = LuceneFulltextTestSupport.kernelTransaction(tx);
            this.assertQueryResult(ktx, (PropertyIndexQuery)this.rangeQuery(containsPropertyId, "a", true, "apa", true), nodea, nodeaa, nodeaapa, nodeapa1, nodeapa2);
            this.assertQueryResult(ktx, (PropertyIndexQuery)this.rangeQuery(containsPropertyId, "a", false, "apa", true), nodeaa, nodeaapa, nodeapa1, nodeapa2);
            this.assertQueryResult(ktx, (PropertyIndexQuery)this.rangeQuery(containsPropertyId, "a", true, "apa", false), nodea, nodeaa, nodeaapa);
            this.assertQueryResult(ktx, (PropertyIndexQuery)this.rangeQuery(containsPropertyId, "a", false, "apa", false), nodeaa, nodeaapa);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.controller.restartDbms();
        tx = this.db.beginTx();
        try {
            ktx = LuceneFulltextTestSupport.kernelTransaction(tx);
            this.assertQueryResult(ktx, (PropertyIndexQuery)this.rangeQuery(containsPropertyId, "a", true, "apa", true), nodea, nodeaa, nodeaapa, nodeapa1, nodeapa2);
            this.assertQueryResult(ktx, (PropertyIndexQuery)this.rangeQuery(containsPropertyId, "a", false, "apa", true), nodeaa, nodeaapa, nodeapa1, nodeapa2);
            this.assertQueryResult(ktx, (PropertyIndexQuery)this.rangeQuery(containsPropertyId, "a", true, "apa", false), nodea, nodeaa, nodeaapa);
            this.assertQueryResult(ktx, (PropertyIndexQuery)this.rangeQuery(containsPropertyId, "a", false, "apa", false), nodeaa, nodeaapa);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldThrowOnCypherFulltextQueryIfNotCypherCompatibleAnalyzer() throws KernelException {
        IndexDescriptor indexReference = this.createIndex(new int[]{this.labelIdHa}, new int[]{this.propIdHa}, "english");
        this.await(indexReference);
        try (Transaction tx = this.db.beginTx();){
            KernelTransaction ktx = LuceneFulltextTestSupport.kernelTransaction(tx);
            IllegalStateException e = (IllegalStateException)org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> this.assertQueryResult(ktx, (PropertyIndexQuery)this.endsWithQuery(1, "a"), new Long[0]));
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"This fulltext index does not have support for Cypher semantics because configured analyzer 'english' is not Cypher compatible."});
        }
    }

    @Test
    void shouldThrowOnCypherFulltextQueryIfNotCypherCompatibleComposite() throws KernelException {
        IndexDescriptor indexReference = this.createIndex(new int[]{this.labelIdHa}, new int[]{this.propIdHa, this.propIdHe}, "cypher");
        this.await(indexReference);
        try (Transaction tx = this.db.beginTx();){
            KernelTransaction ktx = LuceneFulltextTestSupport.kernelTransaction(tx);
            IllegalStateException e = (IllegalStateException)org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> this.assertQueryResult(ktx, (PropertyIndexQuery)this.endsWithQuery(1, "a"), new Long[0]));
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"This fulltext index does not have support for Cypher semantics because index is composite."});
        }
    }

    @Test
    void shouldThrowOnCypherFulltextQueryIfNotCypherCompatibleMultipleEntities() throws KernelException {
        IndexDescriptor indexReference = this.createIndex(new int[]{this.labelIdHa, this.labelIdHe}, new int[]{this.propIdHa}, "cypher");
        this.await(indexReference);
        try (Transaction tx = this.db.beginTx();){
            KernelTransaction ktx = LuceneFulltextTestSupport.kernelTransaction(tx);
            IllegalStateException e = (IllegalStateException)org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> this.assertQueryResult(ktx, (PropertyIndexQuery)this.endsWithQuery(1, "a"), new Long[0]));
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"This fulltext index does not have support for Cypher semantics because index target more than one label."});
        }
    }

    @Test
    void shouldThrowOnCypherFulltextQueryIfNotCypherCompatibleNotNodeIndex() throws KernelException {
        IndexDescriptor indexReference = this.createIndex(new int[]{this.relTypeIdHej}, new int[]{this.propIdHej}, "cypher", EntityType.RELATIONSHIP);
        this.await(indexReference);
        try (Transaction tx = this.db.beginTx();){
            KernelTransaction ktx = LuceneFulltextTestSupport.kernelTransaction(tx);
            IndexNotApplicableKernelException e = (IndexNotApplicableKernelException)org.junit.jupiter.api.Assertions.assertThrows(IndexNotApplicableKernelException.class, () -> this.assertQueryResult(ktx, (PropertyIndexQuery)this.endsWithQuery(1, "a"), new Long[0]));
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Node index seek can only be performed on node indexes"});
        }
    }

    @Test
    void shouldThrowOnCypherFulltextQueryIfNotCypherCompatibleEventuallyConsistent() throws KernelException {
        IndexDescriptor indexReference = this.createIndex(new int[]{this.labelIdHa}, new int[]{this.propIdHa}, "cypher", EntityType.NODE, true);
        this.await(indexReference);
        try (Transaction tx = this.db.beginTx();){
            KernelTransaction ktx = LuceneFulltextTestSupport.kernelTransaction(tx);
            IllegalStateException e = (IllegalStateException)org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> this.assertQueryResult(ktx, (PropertyIndexQuery)this.endsWithQuery(1, "a"), new Long[0]));
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"This fulltext index does not have support for Cypher semantics because index is eventually consistent."});
        }
    }

    private void assertQueryResult(KernelTransaction ktx, PropertyIndexQuery query, Long ... expectedResultArray) throws KernelException {
        List<Long> expectedResult = Arrays.asList(expectedResultArray);
        IndexReadSession index = ktx.dataRead().indexReadSession(ktx.schemaRead().indexGetForName(NAME));
        try (NodeValueIndexCursor cursor = ktx.cursors().allocateNodeValueIndexCursor(ktx.cursorContext(), ktx.memoryTracker());){
            ArrayList<Long> actualResult = new ArrayList<Long>();
            ktx.dataRead().nodeIndexSeek(index, cursor, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{query});
            while (cursor.next()) {
                actualResult.add(cursor.nodeReference());
            }
            actualResult.sort(Long::compareTo);
            expectedResult.sort(Long::compareTo);
            Assertions.assertThat(actualResult).isEqualTo(expectedResult);
        }
    }

    private PropertyIndexQuery.StringContainsPredicate containsQuery(int containsPropertyId, String string) {
        return PropertyIndexQuery.stringContains((int)containsPropertyId, (TextValue)Values.stringValue((String)string));
    }

    private PropertyIndexQuery.StringSuffixPredicate endsWithQuery(int containsPropertyId, String string) {
        return PropertyIndexQuery.stringSuffix((int)containsPropertyId, (TextValue)Values.stringValue((String)string));
    }

    private PropertyIndexQuery.StringPrefixPredicate startsWithQuery(int containsPropertyId, String string) {
        return PropertyIndexQuery.stringPrefix((int)containsPropertyId, (TextValue)Values.stringValue((String)string));
    }

    private PropertyIndexQuery.ExactPredicate exactQuery(int containsPropertyId, Object object) {
        return PropertyIndexQuery.exact((int)containsPropertyId, (Object)Values.of((Object)object));
    }

    private PropertyIndexQuery.RangePredicate<?> rangeQuery(int containsPropertyId, Object from, boolean fromInclusive, Object to, boolean toInclusive) {
        return PropertyIndexQuery.range((int)containsPropertyId, (Value)Values.of((Object)from), (boolean)fromInclusive, (Value)Values.of((Object)to), (boolean)toInclusive);
    }

    private long createNode(Transaction tx, Label containsLabel, String containsProp, String propertyValue) {
        Node node = tx.createNode(new Label[]{containsLabel});
        node.setProperty(containsProp, (Object)propertyValue);
        return node.getId();
    }

    private TokenRead tokenRead(Transaction tx) {
        return ((InternalTransaction)tx).kernelTransaction().tokenRead();
    }

    private KernelTransactionImplementation getKernelTransaction() {
        try {
            return (KernelTransactionImplementation)this.kernel.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED);
        }
        catch (TransactionFailureException e) {
            throw new RuntimeException("oops");
        }
    }

    private IndexDescriptor createIndex(int[] entityTokens, int[] propertyIds) throws KernelException {
        return this.createIndex(entityTokens, propertyIds, (String)FulltextSettings.fulltext_default_analyzer.defaultValue());
    }

    private IndexDescriptor createIndex(int[] entityTokens, int[] propertyIds, String analyzer) throws KernelException {
        return this.createIndex(entityTokens, propertyIds, analyzer, EntityType.NODE);
    }

    private IndexDescriptor createIndex(int[] entityTokens, int[] propertyIds, String analyzer, EntityType entityType) throws KernelException {
        return this.createIndex(entityTokens, propertyIds, analyzer, entityType, false);
    }

    private IndexDescriptor createIndex(int[] entityTokens, int[] propertyIds, String analyzer, EntityType entityType, boolean eventuallyConsistent) throws KernelException {
        IndexDescriptor fulltext;
        try (KernelTransactionImplementation transaction = this.getKernelTransaction();){
            FulltextSchemaDescriptor schema = SchemaDescriptor.fulltext((EntityType)entityType, (int[])entityTokens, (int[])propertyIds);
            IndexConfig config = IndexConfig.with((String)FulltextIndexSettingsKeys.ANALYZER, (Value)Values.stringValue((String)analyzer)).withIfAbsent(FulltextIndexSettingsKeys.EVENTUALLY_CONSISTENT, Values.of((Object)eventuallyConsistent));
            IndexPrototype prototype = IndexPrototype.forSchema((SchemaDescriptor)schema, (IndexProviderDescriptor)FulltextIndexProviderFactory.DESCRIPTOR).withIndexType(IndexType.FULLTEXT).withName(NAME).withIndexConfig(config);
            fulltext = transaction.schemaWrite().indexCreate(prototype);
            transaction.success();
        }
        return fulltext;
    }

    private void verifyThatFulltextIndexIsPresent(IndexDescriptor fulltextIndexDescriptor) throws TransactionFailureException {
        try (KernelTransactionImplementation transaction = this.getKernelTransaction();){
            IndexDescriptor descriptor = transaction.schemaRead().indexGetForName(NAME);
            org.junit.jupiter.api.Assertions.assertEquals((Object)fulltextIndexDescriptor.schema(), (Object)descriptor.schema());
            org.junit.jupiter.api.Assertions.assertEquals((Object)fulltextIndexDescriptor.isUnique(), (Object)descriptor.isUnique());
            transaction.success();
        }
    }

    private long createTheThirdNode() {
        long nodeId;
        try (Transaction transaction = this.db.beginTx();){
            Node hej = transaction.createNode(new Label[]{Label.label((String)"hej")});
            nodeId = hej.getId();
            hej.setProperty("hej", (Object)"villa");
            hej.setProperty("ho", (Object)"value3");
            transaction.commit();
        }
        return nodeId;
    }

    private void verifyNodeData(long thirdNodeId) throws Exception {
        try (Transaction tx = this.db.beginTx();){
            KernelTransaction ktx = LuceneFulltextTestSupport.kernelTransaction(tx);
            IndexReadSession index = ktx.dataRead().indexReadSession(ktx.schemaRead().indexGetForName(NAME));
            try (NodeValueIndexCursor cursor = ktx.cursors().allocateNodeValueIndexCursor(ktx.cursorContext(), ktx.memoryTracker());){
                ktx.dataRead().nodeIndexSeek(index, cursor, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{PropertyIndexQuery.fulltextSearch((String)"value")});
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)cursor.nodeReference());
                org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
                ktx.dataRead().nodeIndexSeek(index, cursor, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{PropertyIndexQuery.fulltextSearch((String)"villa")});
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                org.junit.jupiter.api.Assertions.assertEquals((long)thirdNodeId, (long)cursor.nodeReference());
                org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
                ktx.dataRead().nodeIndexSeek(index, cursor, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{PropertyIndexQuery.fulltextSearch((String)"value3")});
                MutableLongSet ids = LongSets.mutable.empty();
                ids.add(0L);
                ids.add(thirdNodeId);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                org.junit.jupiter.api.Assertions.assertTrue((boolean)ids.remove(cursor.nodeReference()));
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                org.junit.jupiter.api.Assertions.assertTrue((boolean)ids.remove(cursor.nodeReference()));
                org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
            }
            tx.commit();
        }
    }

    private void verifyRelationshipData(long secondRelId) throws Exception {
        try (Transaction tx = this.db.beginTx();){
            KernelTransaction ktx = LuceneFulltextTestSupport.kernelTransaction(tx);
            IndexDescriptor index = ktx.schemaRead().indexGetForName(NAME);
            IndexReadSession indexReadSession = ktx.dataRead().indexReadSession(index);
            try (RelationshipValueIndexCursor cursor = ktx.cursors().allocateRelationshipValueIndexCursor(ktx.cursorContext(), ktx.memoryTracker());){
                ktx.dataRead().relationshipIndexSeek(indexReadSession, cursor, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{PropertyIndexQuery.fulltextSearch((String)"valuuu")});
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)cursor.relationshipReference());
                org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
                ktx.dataRead().relationshipIndexSeek(indexReadSession, cursor, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{PropertyIndexQuery.fulltextSearch((String)"villa")});
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                org.junit.jupiter.api.Assertions.assertEquals((long)secondRelId, (long)cursor.relationshipReference());
                org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
                ktx.dataRead().relationshipIndexSeek(indexReadSession, cursor, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{PropertyIndexQuery.fulltextSearch((String)"value3")});
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)cursor.relationshipReference());
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                org.junit.jupiter.api.Assertions.assertEquals((long)secondRelId, (long)cursor.relationshipReference());
                org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
            }
            tx.commit();
        }
    }

    private void await(IndexDescriptor index) {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().awaitIndexOnline(index.getName(), 1L, TimeUnit.MINUTES);
        }
    }
}

