/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexCreator;
import org.neo4j.index.internal.gbptree.TreeNodeDynamicSize;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.impl.muninn.StandalonePageCacheFactory;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.TestLabels;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.test.rule.TestDirectory;

@Neo4jLayoutExtension
@ExtendWith(value={RandomExtension.class})
public class BTreeIndexKeySizeValidationIT {
    private static final String[] PROP_KEYS = new String[]{"prop0", "prop1", "prop2", "prop3", "prop4"};
    private static final int PAGE_SIZE_8K = (int)ByteUnit.kibiBytes((long)8L);
    private static final int PAGE_SIZE_16K = (int)ByteUnit.kibiBytes((long)16L);
    private static final int ESTIMATED_OVERHEAD_PER_SLOT = 2;
    private static final int WIGGLE_ROOM = 50;
    @Inject
    private DefaultFileSystemAbstraction fs;
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private Neo4jLayout neo4jLayout;
    @Inject
    private RandomRule random;
    private DatabaseManagementService dbms;
    private GraphDatabaseAPI db;
    private JobScheduler scheduler;

    @AfterEach
    private void cleanup() throws Exception {
        if (this.dbms != null) {
            this.dbms.shutdown();
            this.dbms = null;
            this.db = null;
        }
        if (this.scheduler != null) {
            this.scheduler.shutdown();
            this.scheduler = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @MethodSource(value={"pageSizes"})
    void shouldEnforceSizeCapSingleValueSingleType(int pageSize) {
        void var6_8;
        NamedDynamicValueGenerator[] dynamicValueGenerators;
        this.startDb(pageSize);
        ArrayList<CallSite> failureMessages = new ArrayList<CallSite>();
        NamedDynamicValueGenerator[] namedDynamicValueGeneratorArray = dynamicValueGenerators = NamedDynamicValueGenerator.values();
        int n = namedDynamicValueGeneratorArray.length;
        boolean bl = false;
        while (var6_8 < n) {
            NamedDynamicValueGenerator generator = namedDynamicValueGeneratorArray[var6_8];
            int expectedMax = pageSize == PAGE_SIZE_16K ? generator.expectedMax16k : generator.expectedMax;
            String propKey = PROP_KEYS[0] + generator.name();
            this.createIndex(propKey);
            BinarySearch binarySearch = new BinarySearch();
            while (!binarySearch.finished()) {
                Object propValue = generator.dynamicValue(this.random, binarySearch.arrayLength);
                long expectedNodeId = -1L;
                boolean wasAbleToWrite = true;
                try (Transaction tx = this.db.beginTx();){
                    Node node = tx.createNode(new Label[]{TestLabels.LABEL_ONE});
                    node.setProperty(propKey, propValue);
                    expectedNodeId = node.getId();
                    tx.commit();
                }
                catch (Exception e) {
                    wasAbleToWrite = false;
                }
                this.verifyReadExpected(propKey, propValue, expectedNodeId, wasAbleToWrite);
                binarySearch.progress(wasAbleToWrite);
            }
            if (expectedMax != binarySearch.longestSuccessful) {
                failureMessages.add((CallSite)((Object)(generator.name() + ": expected=" + expectedMax + ", actual=" + binarySearch.longestSuccessful)));
            }
            ++var6_8;
        }
        if (failureMessages.size() > 0) {
            StringJoiner joiner = new StringJoiner(System.lineSeparator(), "Some value types did not have expected longest successful array. This is a strong indicator that documentation of max limit needs to be updated." + System.lineSeparator(), "");
            for (String string : failureMessages) {
                joiner.add(string);
            }
            Assertions.fail((String)joiner.toString());
        }
    }

    @ParameterizedTest
    @MethodSource(value={"pageSizes"})
    void shouldEnforceSizeCapMixedTypes(int pageSize) {
        this.startDb(pageSize);
        for (int numberOfSlots = 1; numberOfSlots < 5; ++numberOfSlots) {
            String[] propKeys = this.generatePropertyKeys(numberOfSlots);
            this.createIndex(propKeys);
            int keySizeLimit = TreeNodeDynamicSize.keyValueSizeCapFromPageSize((int)pageSize);
            int keySizeLimitPerSlot = keySizeLimit / propKeys.length - 2;
            int wiggleRoomPerSlot = 50 / propKeys.length;
            SuccessAndFail successAndFail = new SuccessAndFail();
            for (int i = 0; i < 1000; ++i) {
                Object[] propValues = this.generatePropertyValues(propKeys, keySizeLimitPerSlot, wiggleRoomPerSlot);
                long expectedNodeId = -1L;
                boolean ableToWrite = true;
                try (Transaction tx = this.db.beginTx();){
                    Node node = tx.createNode(new Label[]{TestLabels.LABEL_ONE});
                    this.setProperties(propKeys, propValues, node);
                    expectedNodeId = node.getId();
                    tx.commit();
                }
                catch (Exception e) {
                    ableToWrite = false;
                }
                successAndFail.ableToWrite(ableToWrite);
                this.verifyReadExpected(propKeys, propValues, expectedNodeId, ableToWrite);
            }
            successAndFail.verifyBothSuccessAndFail();
        }
    }

    private static Stream<Integer> pageSizes() {
        return Stream.of(PAGE_SIZE_8K, PAGE_SIZE_16K);
    }

    private void setProperties(String[] propKeys, Object[] propValues, Node node) {
        for (int propKey = 0; propKey < propKeys.length; ++propKey) {
            node.setProperty(propKeys[propKey], propValues[propKey]);
        }
    }

    private String[] generatePropertyKeys(int numberOfSlots) {
        String[] propKeys = new String[numberOfSlots];
        for (int i = 0; i < numberOfSlots; ++i) {
            propKeys[i] = PROP_KEYS[i] + "numberOfSlots" + numberOfSlots;
        }
        return propKeys;
    }

    private Object[] generatePropertyValues(String[] propKeys, int keySizeLimitPerSlot, int wiggleRoomPerSlot) {
        Object[] propValues = new Object[propKeys.length];
        for (int propKey = 0; propKey < propKeys.length; ++propKey) {
            NamedDynamicValueGenerator among = (NamedDynamicValueGenerator)((Object)this.random.among((Object[])NamedDynamicValueGenerator.values()));
            propValues[propKey] = among.dynamicValue(this.random, keySizeLimitPerSlot, wiggleRoomPerSlot);
        }
        return propValues;
    }

    private void verifyReadExpected(String propKey, Object propValue, long expectedNodeId, boolean ableToWrite) {
        this.verifyReadExpected(new String[]{propKey}, new Object[]{propValue}, expectedNodeId, ableToWrite);
    }

    private void verifyReadExpected(String[] propKeys, Object[] propValues, long expectedNodeId, boolean ableToWrite) {
        try (Transaction tx = this.db.beginTx();){
            HashMap<String, Object> values = new HashMap<String, Object>();
            for (int propKey = 0; propKey < propKeys.length; ++propKey) {
                values.put(propKeys[propKey], propValues[propKey]);
            }
            try (ResourceIterator nodes = tx.findNodes(TestLabels.LABEL_ONE, values);){
                if (ableToWrite) {
                    Assertions.assertTrue((boolean)nodes.hasNext());
                    Node node = (Node)nodes.next();
                    Assertions.assertNotNull((Object)node);
                    Assertions.assertEquals((long)expectedNodeId, (long)node.getId(), (String)"node id");
                } else {
                    Assertions.assertFalse((boolean)nodes.hasNext());
                }
            }
            tx.commit();
        }
    }

    private void createIndex(String ... propKeys) {
        try (Transaction tx = this.db.beginTx();){
            IndexCreator indexCreator = tx.schema().indexFor(TestLabels.LABEL_ONE);
            for (String propKey : propKeys) {
                indexCreator = indexCreator.on(propKey);
            }
            indexCreator.create();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private void startDb(int pageSize) {
        TestDatabaseManagementServiceBuilder builder = new TestDatabaseManagementServiceBuilder(this.neo4jLayout);
        builder.setConfig(GraphDatabaseSettings.default_schema_provider, (Object)GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10.providerName());
        this.scheduler = JobSchedulerFactory.createInitialisedScheduler();
        PageCache pageCache = StandalonePageCacheFactory.createPageCache((FileSystemAbstraction)this.fs, (JobScheduler)this.scheduler, (int)pageSize);
        Dependencies dependencies = new Dependencies();
        dependencies.satisfyDependency((Object)pageCache);
        builder.setExternalDependencies((DependencyResolver)dependencies);
        this.dbms = builder.build();
        this.db = (GraphDatabaseAPI)this.dbms.database("neo4j");
    }

    private static enum NamedDynamicValueGenerator {
        string(1, 8164, 8132, (random, i) -> random.randomValues().nextAlphaNumericTextValue(i, i).stringValue()),
        byteArray(1, 8163, 8131, (random, i) -> random.randomValues().nextByteArrayRaw(i, i)),
        shortArray(2, 4081, 4065, (random, i) -> random.randomValues().nextShortArrayRaw(i, i)),
        intArray(4, 2040, 2032, (random, i) -> random.randomValues().nextIntArrayRaw(i, i)),
        longArray(8, 1020, 1016, (random, i) -> random.randomValues().nextLongArrayRaw(i, i)),
        floatArray(4, 2040, 2032, (random, i) -> random.randomValues().nextFloatArrayRaw(i, i)),
        doubleArray(8, 1020, 1016, (random, i) -> random.randomValues().nextDoubleArrayRaw(i, i)),
        booleanArray(1, 8164, 8132, (random, i) -> random.randomValues().nextBooleanArrayRaw(i, i)),
        charArray(1, 2721, 2710, (random, i) -> random.randomValues().nextAlphaNumericTextValue(i, i).stringValue().toCharArray()),
        stringArray1(3, 2721, 2710, (random, i) -> random.randomValues().nextAlphaNumericStringArrayRaw(i, i, 1, 1)),
        stringArray10(12, 680, 677, (random, i) -> random.randomValues().nextAlphaNumericStringArrayRaw(i, i, 10, 10)),
        stringArray100(102, 80, 79, (random, i) -> random.randomValues().nextAlphaNumericStringArrayRaw(i, i, 100, 100)),
        stringArray1000(1002, 8, 8, (random, i) -> random.randomValues().nextAlphaNumericStringArrayRaw(i, i, 1000, 1000)),
        dateArray(8, 1020, 1016, (random, i) -> random.randomValues().nextDateArrayRaw(i, i)),
        timeArray(12, 680, 677, (random, i) -> random.randomValues().nextTimeArrayRaw(i, i)),
        localTimeArray(8, 1020, 1016, (random, i) -> random.randomValues().nextLocalTimeArrayRaw(i, i)),
        dateTimeArray(16, 510, 508, (random, i) -> random.randomValues().nextDateTimeArrayRaw(i, i)),
        localDateTimeArray(12, 680, 677, (random, i) -> random.randomValues().nextLocalDateTimeArrayRaw(i, i)),
        durationArray(28, 291, 290, (random, i) -> random.randomValues().nextDurationArrayRaw(i, i)),
        periodArray(28, 291, 290, (random, i) -> random.randomValues().nextPeriodArrayRaw(i, i)),
        cartesianPointArray(8, 340, 338, (random, i) -> random.randomValues().nextCartesianPointArray(i, i).asObjectCopy()),
        cartesian3DPointArray(8, 255, 254, (random, i) -> random.randomValues().nextCartesian3DPointArray(i, i).asObjectCopy()),
        geographicPointArray(8, 340, 338, (random, i) -> random.randomValues().nextGeographicPointArray(i, i).asObjectCopy()),
        geographic3DPointArray(8, 255, 254, (random, i) -> random.randomValues().nextGeographic3DPointArray(i, i).asObjectCopy());

        private final int singleArrayEntrySize;
        private final DynamicValueGenerator generator;
        private final int expectedMax;
        private final int expectedMax16k;

        private NamedDynamicValueGenerator(int singleArrayEntrySize, int expectedLongestArrayLength, int expectedLongestArrayLength_16k, DynamicValueGenerator generator) {
            this.singleArrayEntrySize = singleArrayEntrySize;
            this.expectedMax = expectedLongestArrayLength;
            this.expectedMax16k = expectedLongestArrayLength_16k;
            this.generator = generator;
        }

        Object dynamicValue(RandomRule random, int length) {
            return this.generator.dynamicValue(random, length);
        }

        Object dynamicValue(RandomRule random, int keySizeLimit, int wiggleRoom) {
            int lowLimit = this.lowLimit(keySizeLimit, wiggleRoom, this.singleArrayEntrySize);
            int highLimit = this.highLimit(keySizeLimit, wiggleRoom, this.singleArrayEntrySize);
            return this.dynamicValue(random, random.intBetween(lowLimit, highLimit));
        }

        private int lowLimit(int keySizeLimit, int wiggleRoom, int singleEntrySize) {
            return (keySizeLimit - wiggleRoom) / singleEntrySize;
        }

        private int highLimit(int keySizeLimit, int wiggleRoom, int singleEntrySize) {
            return (keySizeLimit + wiggleRoom) / singleEntrySize;
        }

        @FunctionalInterface
        private static interface DynamicValueGenerator {
            public Object dynamicValue(RandomRule var1, int var2);
        }
    }

    private static class SuccessAndFail {
        boolean atLeastOneSuccess;
        boolean atLeastOneFail;

        private SuccessAndFail() {
        }

        void ableToWrite(boolean ableToWrite) {
            if (ableToWrite) {
                this.atLeastOneSuccess = true;
            } else {
                this.atLeastOneFail = true;
            }
        }

        void verifyBothSuccessAndFail() {
            Assertions.assertTrue((boolean)this.atLeastOneSuccess, (String)"not a single successful write, need to adjust parameters");
            Assertions.assertTrue((boolean)this.atLeastOneFail, (String)"not a single failed write, need to adjust parameters");
        }
    }

    private static class BinarySearch {
        private int longestSuccessful;
        private int minArrayLength;
        private int maxArrayLength = 1;
        private int arrayLength = 1;
        private boolean foundMaxLimit;

        private BinarySearch() {
        }

        boolean finished() {
            return this.arrayLength == this.minArrayLength;
        }

        void progress(boolean wasAbleToWrite) {
            if (wasAbleToWrite) {
                this.longestSuccessful = Math.max(this.arrayLength, this.longestSuccessful);
                if (!this.foundMaxLimit) {
                    this.minArrayLength = this.arrayLength;
                    this.maxArrayLength *= 2;
                    this.arrayLength = this.maxArrayLength;
                } else {
                    this.minArrayLength = this.arrayLength;
                    this.arrayLength = (this.minArrayLength + this.maxArrayLength) / 2;
                }
            } else {
                this.foundMaxLimit = true;
                this.maxArrayLength = this.arrayLength;
                this.arrayLength = (this.minArrayLength + this.maxArrayLength) / 2;
            }
        }
    }
}

