/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class IndexTxStateLookupTest {
    private static final String TRIGGER_LAZY = "this is supposed to be a really long property to trigger lazy loading";
    private static final Random random = new Random();
    @Inject
    private GraphDatabaseAPI db;
    private Object store;
    private Object lookup;

    protected static Stream<Arguments> argumentsProvider() {
        Class[] numberTypes;
        ArrayList<Arguments> parameters = new ArrayList<Arguments>();
        parameters.addAll(Arrays.asList(Arguments.of((Object[])new Object[]{new String("name"), new String("name")}), Arguments.of((Object[])new Object[]{7, 7L}), Arguments.of((Object[])new Object[]{9L, 9}), Arguments.of((Object[])new Object[]{2, 2.0}), Arguments.of((Object[])new Object[]{3L, 3.0}), Arguments.of((Object[])new Object[]{4, Float.valueOf(4.0f)}), Arguments.of((Object[])new Object[]{5L, Float.valueOf(5.0f)}), Arguments.of((Object[])new Object[]{12.0, 12}), Arguments.of((Object[])new Object[]{13.0, 13L}), Arguments.of((Object[])new Object[]{Float.valueOf(14.0f), 14}), Arguments.of((Object[])new Object[]{Float.valueOf(15.0f), 15L}), Arguments.of((Object[])new Object[]{Float.valueOf(2.5f), 2.5}), Arguments.of((Object[])new Object[]{16.25, Float.valueOf(16.25f)}), Arguments.of((Object[])new Object[]{IndexTxStateLookupTest.stringArray("a", "b", "c"), IndexTxStateLookupTest.charArray('a', 'b', 'c')}), Arguments.of((Object[])new Object[]{IndexTxStateLookupTest.charArray('d', 'e', 'f'), IndexTxStateLookupTest.stringArray("d", "e", "f")}), Arguments.of((Object[])new Object[]{IndexTxStateLookupTest.splitStrings(TRIGGER_LAZY), IndexTxStateLookupTest.splitChars(TRIGGER_LAZY)}), Arguments.of((Object[])new Object[]{IndexTxStateLookupTest.splitChars(TRIGGER_LAZY), IndexTxStateLookupTest.splitStrings(TRIGGER_LAZY)}), Arguments.of((Object[])new Object[]{IndexTxStateLookupTest.stringArray("foo", "bar"), IndexTxStateLookupTest.stringArray("foo", "bar")})));
        for (Class lhs : numberTypes = new Class[]{Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE}) {
            for (Class rhs : numberTypes) {
                parameters.add(IndexTxStateLookupTest.randomNumbers(3, lhs, rhs));
                parameters.add(IndexTxStateLookupTest.randomNumbers(200, lhs, rhs));
            }
        }
        return parameters.stream();
    }

    private static NamedObject stringArray(String ... items) {
        return new NamedObject(items, IndexTxStateLookupTest.arrayToString(items));
    }

    private static NamedObject charArray(char ... items) {
        return new NamedObject(items, IndexTxStateLookupTest.arrayToString(items));
    }

    private static Arguments randomNumbers(int length, Class<?> lhsType, Class<?> rhsType) {
        Object lhs = Array.newInstance(lhsType, length);
        Object rhs = Array.newInstance(rhsType, length);
        for (int i = 0; i < length; ++i) {
            int value = random.nextInt(128);
            Array.set(lhs, i, IndexTxStateLookupTest.convert(value, lhsType));
            Array.set(rhs, i, IndexTxStateLookupTest.convert(value, rhsType));
        }
        return Arguments.of((Object[])new Object[]{new NamedObject(lhs, IndexTxStateLookupTest.arrayToString(lhs)), new NamedObject(rhs, IndexTxStateLookupTest.arrayToString(rhs))});
    }

    private static String arrayToString(Object arrayObject) {
        int length = Array.getLength(arrayObject);
        String type = arrayObject.getClass().getComponentType().getSimpleName();
        StringBuilder builder = new StringBuilder().append('(').append(type).append(") {");
        for (int i = 0; i < length; ++i) {
            builder.append(i > 0 ? "," : "").append(Array.get(arrayObject, i));
        }
        return builder.append('}').toString();
    }

    private static Object convert(int value, Class<?> type) {
        switch (type.getName()) {
            case "byte": {
                return (byte)value;
            }
            case "short": {
                return (short)value;
            }
            case "int": {
                return value;
            }
            case "long": {
                return (long)value;
            }
            case "float": {
                return Float.valueOf(value);
            }
            case "double": {
                return (double)value;
            }
        }
        return value;
    }

    private static NamedObject splitStrings(String string) {
        char[] chars = IndexTxStateLookupTest.internalSplitChars(string);
        String[] result = new String[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            result[i] = Character.toString(chars[i]);
        }
        return IndexTxStateLookupTest.stringArray(result);
    }

    private static char[] internalSplitChars(String string) {
        char[] result = new char[string.length()];
        string.getChars(0, result.length, result, 0);
        return result;
    }

    private static NamedObject splitChars(String string) {
        char[] result = IndexTxStateLookupTest.internalSplitChars(string);
        return IndexTxStateLookupTest.charArray(result);
    }

    public void init(Object store, Object lookup) {
        this.store = this.realValue(store);
        this.lookup = this.realValue(lookup);
    }

    private Object realValue(Object object) {
        return object instanceof NamedObject ? ((NamedObject)object).object : object;
    }

    @BeforeAll
    public void given() {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().indexFor(Label.label((String)"Node")).on("prop").create();
            tx.schema().indexFor(RelationshipType.withName((String)"Rel")).on("prop").create();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(30L, TimeUnit.SECONDS);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest(name="store=<{0}> lookup=<{1}>")
    @MethodSource(value={"argumentsProvider"})
    public void lookupWithinTransaction(Object store, Object lookup) {
        this.init(store, lookup);
        try (Transaction tx = this.db.beginTx();){
            tx.createNode(new Label[]{Label.label((String)"Node")}).setProperty("prop", this.store);
            Assertions.assertEquals((long)1L, (long)Iterators.count((Iterator)tx.findNodes(Label.label((String)"Node"), "prop", this.lookup)));
        }
    }

    @ParameterizedTest(name="store=<{0}> lookup=<{1}>")
    @MethodSource(value={"argumentsProvider"})
    public void lookupWithinTransactionWithCacheEviction(Object store, Object lookup) {
        this.init(store, lookup);
        try (Transaction tx = this.db.beginTx();){
            tx.createNode(new Label[]{Label.label((String)"Node")}).setProperty("prop", this.store);
            Assertions.assertEquals((long)1L, (long)Iterators.count((Iterator)tx.findNodes(Label.label((String)"Node"), "prop", this.lookup)));
        }
    }

    @ParameterizedTest(name="store=<{0}> lookup=<{1}>")
    @MethodSource(value={"argumentsProvider"})
    public void lookupWithoutTransaction(Object store, Object lookup) {
        Node node;
        this.init(store, lookup);
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode(new Label[]{Label.label((String)"Node")});
            node.setProperty("prop", this.store);
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            Assertions.assertEquals((long)1L, (long)Iterators.count((Iterator)tx.findNodes(Label.label((String)"Node"), "prop", this.lookup)));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.deleteNode(node);
    }

    private void deleteNode(Node node) {
        try (Transaction tx = this.db.beginTx();){
            tx.getNodeById(node.getId()).delete();
            tx.commit();
        }
    }

    @ParameterizedTest(name="store=<{0}> lookup=<{1}>")
    @MethodSource(value={"argumentsProvider"})
    public void lookupWithoutTransactionWithCacheEviction(Object store, Object lookup) {
        Node node;
        this.init(store, lookup);
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode(new Label[]{Label.label((String)"Node")});
            node.setProperty("prop", this.store);
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            Assertions.assertEquals((long)1L, (long)Iterators.count((Iterator)tx.findNodes(Label.label((String)"Node"), "prop", this.lookup)));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.deleteNode(node);
    }

    @ParameterizedTest(name="store=<{0}> lookup=<{1}>")
    @MethodSource(value={"argumentsProvider"})
    void shouldRemoveDeletedNodeCreatedInSameTransactionFromIndexTxState(Object store, Object lookup) {
        this.init(store, lookup);
        try (Transaction tx = this.db.beginTx();){
            Label label = Label.label((String)"Node");
            String key = "prop";
            Node node = tx.createNode(new Label[]{label});
            node.setProperty(key, this.store);
            Assertions.assertTrue((boolean)tx.findNodes(label, key, this.lookup).hasNext());
            node.delete();
            Assertions.assertFalse((boolean)tx.findNodes(label, key, this.lookup).hasNext());
        }
    }

    @ParameterizedTest(name="store=<{0}> lookup=<{1}>")
    @MethodSource(value={"argumentsProvider"})
    void shouldRemoveDeletedRelationshipCreatedInSameTransactionFromIndexTxState(Object store, Object lookup) {
        this.init(store, lookup);
        try (Transaction tx = this.db.beginTx();){
            RelationshipType type = RelationshipType.withName((String)"Rel");
            String key = "prop";
            Relationship relationship = tx.createNode().createRelationshipTo(tx.createNode(), type);
            relationship.setProperty(key, this.store);
            Assertions.assertTrue((boolean)tx.findRelationships(type, key, this.lookup).hasNext());
            relationship.delete();
            Assertions.assertFalse((boolean)tx.findRelationships(type, key, this.lookup).hasNext());
        }
    }

    @ParameterizedTest(name="store=<{0}> lookup=<{1}>")
    @MethodSource(value={"argumentsProvider"})
    void shouldRemoveDeletedNodeCreatedInSameTransactionFromIndexTxStateEvenWithMultipleProperties(Object store, Object lookup) {
        this.init(store, lookup);
        try (Transaction tx = this.db.beginTx();){
            Label label = Label.label((String)"Node");
            String key = "prop";
            String key2 = "prop2";
            Node node = tx.createNode(new Label[]{label});
            node.setProperty(key, this.store);
            node.setProperty(key2, this.store);
            Assertions.assertTrue((boolean)tx.findNodes(label, key, this.lookup).hasNext());
            node.delete();
            Assertions.assertFalse((boolean)tx.findNodes(label, key, this.lookup).hasNext());
        }
    }

    @ParameterizedTest(name="store=<{0}> lookup=<{1}>")
    @MethodSource(value={"argumentsProvider"})
    void shouldRemoveDeletedRelationshipCreatedInSameTransactionFromIndexTxStateEvenWithMultipleProperties(Object store, Object lookup) {
        this.init(store, lookup);
        try (Transaction tx = this.db.beginTx();){
            RelationshipType type = RelationshipType.withName((String)"Rel");
            String key = "prop";
            String key2 = "prop2";
            Relationship relationship = tx.createNode().createRelationshipTo(tx.createNode(), type);
            relationship.setProperty(key, this.store);
            relationship.setProperty(key2, this.store);
            Assertions.assertTrue((boolean)tx.findRelationships(type, key, this.lookup).hasNext());
            relationship.delete();
            Assertions.assertFalse((boolean)tx.findRelationships(type, key, this.lookup).hasNext());
        }
    }

    private static class NamedObject {
        private final Object object;
        private final String name;

        NamedObject(Object object, String name) {
            this.object = object;
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

