/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.schema;

import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.ResourceLock;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.log4j.Log4jLogProvider;
import org.neo4j.test.DoubleLatch;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.extension.SuppressOutput;
import org.neo4j.test.extension.SuppressOutputExtension;
import org.neo4j.values.storable.RandomValues;

@Neo4jLayoutExtension
@ExtendWith(value={SuppressOutputExtension.class})
@ResourceLock(value="java.lang.System.out")
class ConcurrentUpdateIT {
    @Inject
    private SuppressOutput suppressOutput;
    @Inject
    private DatabaseLayout databaseLayout;

    ConcurrentUpdateIT() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void populateDbWithConcurrentUpdates() throws Exception {
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(this.databaseLayout).build();
        GraphDatabaseService database = managementService.database("neo4j");
        try {
            RandomValues randomValues = RandomValues.create();
            int counter = 1;
            for (int j = 0; j < 100; ++j) {
                try (Transaction transaction = database.beginTx();){
                    for (int i = 0; i < 5; ++i) {
                        Node node = transaction.createNode(new Label[]{Label.label((String)("label" + counter))});
                        node.setProperty("property", randomValues.nextValue().asObject());
                    }
                    transaction.commit();
                }
                ++counter;
            }
            int populatorCount = 5;
            ExecutorService executor = Executors.newFixedThreadPool(populatorCount);
            CountDownLatch startSignal = new CountDownLatch(1);
            AtomicBoolean endSignal = new AtomicBoolean();
            for (int i = 0; i < populatorCount; ++i) {
                executor.submit(new Populator(database, counter, startSignal, endSignal));
            }
            try {
                try (Transaction transaction = database.beginTx();){
                    transaction.schema().indexFor(Label.label((String)"label10")).on("property").create();
                    transaction.commit();
                }
                startSignal.countDown();
                transaction = database.beginTx();
                try {
                    transaction.schema().awaitIndexesOnline((long)populatorCount, TimeUnit.MINUTES);
                    transaction.commit();
                }
                finally {
                    if (transaction != null) {
                        transaction.close();
                    }
                }
            }
            finally {
                endSignal.set(true);
                executor.shutdown();
            }
        }
        finally {
            managementService.shutdown();
            ConsistencyCheckService consistencyCheckService = new ConsistencyCheckService();
            Config config = Config.defaults((Setting)GraphDatabaseSettings.pagecache_memory, (Object)"8m");
            consistencyCheckService.runFullConsistencyCheck(this.databaseLayout, config, ProgressMonitorFactory.NONE, (LogProvider)new Log4jLogProvider((OutputStream)System.out), false);
        }
    }

    private static class Populator
    implements Runnable {
        private final GraphDatabaseService databaseService;
        private final long totalNodes;
        private final CountDownLatch startSignal;
        private final AtomicBoolean endSignal;

        Populator(GraphDatabaseService databaseService, long totalNodes, CountDownLatch startSignal, AtomicBoolean endSignal) {
            this.databaseService = databaseService;
            this.totalNodes = totalNodes;
            this.startSignal = startSignal;
            this.endSignal = endSignal;
        }

        @Override
        public void run() {
            RandomValues randomValues = RandomValues.create();
            DoubleLatch.awaitLatch((CountDownLatch)this.startSignal);
            while (!this.endSignal.get()) {
                Transaction transaction = this.databaseService.beginTx();
                try {
                    try {
                        int operationType = randomValues.nextIntValue(3).value();
                        switch (operationType) {
                            case 0: {
                                long targetNodeId = randomValues.nextLongValue(this.totalNodes).value();
                                transaction.getNodeById(targetNodeId).delete();
                                break;
                            }
                            case 1: {
                                long nodeId = randomValues.nextLongValue(this.totalNodes).value();
                                Node node = transaction.getNodeById(nodeId);
                                Map allProperties = node.getAllProperties();
                                for (String key : allProperties.keySet()) {
                                    node.setProperty(key, randomValues.nextValue().asObject());
                                }
                                break;
                            }
                            case 2: {
                                Node nodeToUpdate = transaction.createNode(new Label[]{Label.label((String)"label10")});
                                nodeToUpdate.setProperty("property", randomValues.nextValue().asObject());
                                break;
                            }
                            default: {
                                throw new UnsupportedOperationException("Unknown type of index operation");
                            }
                        }
                        transaction.commit();
                    }
                    catch (Exception e) {
                        transaction.rollback();
                    }
                }
                finally {
                    if (transaction == null) continue;
                    transaction.close();
                }
            }
        }
    }
}

