/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.api.impl.fulltext.FulltextProceduresTestSupport;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;

@ExtendWith(value={RandomExtension.class})
public class FulltextIndexMoreDataTest
extends FulltextProceduresTestSupport {
    public static final int ZEBRAS = 100000;
    @Inject
    private RandomSupport random;
    private long topEntity;

    private void setUp(FulltextProceduresTestSupport.EntityUtil entityUtil, boolean before, boolean after) {
        this.createIndexAndWait(entityUtil);
        if (before) {
            this.createSomeZebras(entityUtil);
        }
        try (Transaction tx = this.db.beginTx();){
            this.topEntity = entityUtil.createEntityWithProperty(tx, "zebra zebra zebra zebra donkey");
            tx.commit();
        }
        if (after) {
            this.createSomeZebras(entityUtil);
        }
    }

    private void createSomeZebras(FulltextProceduresTestSupport.EntityUtil entityUtil) {
        try (Transaction tx = this.db.beginTx();){
            for (int i = 0; i < 100000; ++i) {
                entityUtil.createEntityWithProperty(tx, "zebra donkey");
            }
            tx.commit();
        }
    }

    @MethodSource(value={"entityTypeProvider"})
    @ParameterizedTest
    void canCollectAllHitsWithTopZebraInTheMiddle(FulltextProceduresTestSupport.EntityUtil entityUtil) {
        this.setUp(entityUtil, true, true);
        try (Transaction tx = this.db.beginTx();){
            try (ResourceIterator<Entity> iterator = entityUtil.queryIndexWithOptions(tx, "zebra", "{}");){
                List<Entity> list = iterator.stream().collect(Collectors.toList());
                this.assertSearchResults(list, 200000);
            }
            tx.commit();
        }
    }

    @MethodSource(value={"entityTypeProvider"})
    @ParameterizedTest
    void canCollectAllHitsWithTopZebraInTheBeginning(FulltextProceduresTestSupport.EntityUtil entityUtil) {
        this.setUp(entityUtil, false, true);
        try (Transaction tx = this.db.beginTx();){
            try (ResourceIterator<Entity> iterator = entityUtil.queryIndexWithOptions(tx, "zebra", "{}");){
                List<Entity> list = iterator.stream().collect(Collectors.toList());
                this.assertSearchResults(list, 100000);
            }
            tx.commit();
        }
    }

    @MethodSource(value={"entityTypeProvider"})
    @ParameterizedTest
    void canCollectAllHitsWithTopZebraAtTheEnd(FulltextProceduresTestSupport.EntityUtil entityUtil) {
        this.setUp(entityUtil, true, false);
        try (Transaction tx = this.db.beginTx();){
            try (ResourceIterator<Entity> iterator = entityUtil.queryIndexWithOptions(tx, "zebra", "{}");){
                List<Entity> list = iterator.stream().collect(Collectors.toList());
                this.assertSearchResults(list, 100000);
            }
            tx.commit();
        }
    }

    @MethodSource(value={"entityTypeProvider"})
    @ParameterizedTest
    void canCollectTopHitWithTopZebraInTheMiddle(FulltextProceduresTestSupport.EntityUtil entityUtil) {
        this.setUp(entityUtil, true, true);
        try (Transaction tx = this.db.beginTx();){
            try (ResourceIterator<Entity> iterator = entityUtil.queryIndexWithOptions(tx, "zebra", "{limit:1}");){
                List<Entity> list = iterator.stream().collect(Collectors.toList());
                this.assertSearchResults(list, 0);
            }
            tx.commit();
        }
    }

    @MethodSource(value={"entityTypeProvider"})
    @ParameterizedTest
    void canCollectTopHitWithTopZebraInTheBeginning(FulltextProceduresTestSupport.EntityUtil entityUtil) {
        this.setUp(entityUtil, false, true);
        try (Transaction tx = this.db.beginTx();){
            try (ResourceIterator<Entity> iterator = entityUtil.queryIndexWithOptions(tx, "zebra", "{limit:1}");){
                List<Entity> list = iterator.stream().collect(Collectors.toList());
                this.assertSearchResults(list, 0);
            }
            tx.commit();
        }
    }

    @MethodSource(value={"entityTypeProvider"})
    @ParameterizedTest
    void canCollectTopHitWithTopZebraAtTheEnd(FulltextProceduresTestSupport.EntityUtil entityUtil) {
        this.setUp(entityUtil, true, false);
        try (Transaction tx = this.db.beginTx();){
            try (ResourceIterator<Entity> iterator = entityUtil.queryIndexWithOptions(tx, "zebra", "{limit:1}");){
                List<Entity> list = iterator.stream().collect(Collectors.toList());
                this.assertSearchResults(list, 0);
            }
            tx.commit();
        }
    }

    @MethodSource(value={"entityTypeProvider"})
    @ParameterizedTest
    void canCollectTopHitsWithTopZebraInTheMiddle(FulltextProceduresTestSupport.EntityUtil entityUtil) {
        this.setUp(entityUtil, true, true);
        try (Transaction tx = this.db.beginTx();){
            int limit = this.random.nextInt(1, 100000);
            try (ResourceIterator<Entity> iterator = entityUtil.queryIndexWithOptions(tx, "zebra", "{limit: " + limit + "}");){
                List<Entity> list = iterator.stream().collect(Collectors.toList());
                this.assertSearchResults(list, limit - 1);
            }
            tx.commit();
        }
    }

    @MethodSource(value={"entityTypeProvider"})
    @ParameterizedTest
    void canCollectTopHitsWithTopZebraInTheBeginning(FulltextProceduresTestSupport.EntityUtil entityUtil) {
        this.setUp(entityUtil, false, true);
        try (Transaction tx = this.db.beginTx();){
            int limit = this.random.nextInt(1, 100000);
            try (ResourceIterator<Entity> iterator = entityUtil.queryIndexWithOptions(tx, "zebra", "{limit: " + limit + "}");){
                List<Entity> list = iterator.stream().collect(Collectors.toList());
                this.assertSearchResults(list, limit - 1);
            }
            tx.commit();
        }
    }

    @MethodSource(value={"entityTypeProvider"})
    @ParameterizedTest
    void canCollectTopHitsWithTopZebraAtTheEnd(FulltextProceduresTestSupport.EntityUtil entityUtil) {
        this.setUp(entityUtil, true, false);
        try (Transaction tx = this.db.beginTx();){
            int limit = this.random.nextInt(1, 100000);
            try (ResourceIterator<Entity> iterator = entityUtil.queryIndexWithOptions(tx, "zebra", "{limit: " + limit + "}");){
                List<Entity> list = iterator.stream().collect(Collectors.toList());
                this.assertSearchResults(list, limit - 1);
            }
            tx.commit();
        }
    }

    private void assertSearchResults(List<Entity> list, int extraZebras) {
        Assertions.assertThat(list).hasSize(1 + extraZebras);
        Assertions.assertThat((long)list.get(0).getId()).isEqualTo(this.topEntity);
        Assertions.assertThat((Iterable)list.stream().map(Entity::getId).collect(Collectors.toSet())).hasSize(list.size());
    }
}

