/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.MultipleFoundException;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.graphdb.spatial.CRS;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.mockito.mock.SpatialMocks;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Values;

@ImpermanentDbmsExtension
abstract class IndexingAcceptanceTestBase<TOKEN, ENTITY extends Entity> {
    protected static final String LONG_STRING = "a long string that has to be stored in dynamic records";
    @Inject
    protected GraphDatabaseAPI db;
    protected TOKEN TOKEN1;
    protected TOKEN TOKEN2;
    protected TOKEN TOKEN3;

    IndexingAcceptanceTestBase() {
    }

    @BeforeEach
    void setupLabels(TestInfo testInfo) {
        this.TOKEN1 = this.createToken("TOKEN1-" + testInfo.getDisplayName());
        this.TOKEN2 = this.createToken("TOKEN2-" + testInfo.getDisplayName());
        this.TOKEN3 = this.createToken("TOKEN3-" + testInfo.getDisplayName());
    }

    @Test
    void shouldInterpretPropertyAsChangedEvenIfPropertyMovesFromOneRecordToAnother() {
        ENTITY entity;
        long smallValue = 10L;
        long bigValue = 0x4000000000000000L;
        try (Transaction tx = this.db.beginTx();){
            entity = this.createEntity(tx, this.TOKEN1);
            entity.setProperty("pad0", (Object)true);
            entity.setProperty("pad1", (Object)true);
            entity.setProperty("pad2", (Object)true);
            entity.setProperty("key", (Object)smallValue);
            tx.commit();
        }
        this.createIndex((GraphDatabaseService)this.db, this.indexType(), this.TOKEN1, "key");
        tx = this.db.beginTx();
        try {
            this.getEntity(tx, entity.getId()).setProperty("key", (Object)bigValue);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        try (Transaction transaction = this.db.beginTx();){
            Assertions.assertThat(this.findEntitiesByTokenAndProperty(transaction, this.TOKEN1, "key", bigValue)).containsOnly((Object[])new Entity[]{entity});
            Assertions.assertThat(this.findEntitiesByTokenAndProperty(transaction, this.TOKEN1, "key", smallValue)).isEmpty();
        }
    }

    @Test
    void searchingForEntityByPropertyShouldWorkWithoutIndex() {
        ENTITY entity = this.createEntity((GraphDatabaseService)this.db, MapUtil.map((Object[])new Object[]{"name", "Hawking"}), this.TOKEN1);
        try (Transaction transaction = this.db.beginTx();){
            Assertions.assertThat(this.findEntitiesByTokenAndProperty(transaction, this.TOKEN1, "name", "Hawking")).containsOnly((Object[])new Entity[]{entity});
        }
    }

    @Test
    void searchingUsesIndexWhenItExists() {
        ENTITY entity = this.createEntity((GraphDatabaseService)this.db, MapUtil.map((Object[])new Object[]{"name", "Hawking"}), this.TOKEN1);
        this.createIndex((GraphDatabaseService)this.db, this.indexType(), this.TOKEN1, "name");
        try (Transaction transaction = this.db.beginTx();){
            Assertions.assertThat(this.findEntitiesByTokenAndProperty(transaction, this.TOKEN1, "name", "Hawking")).containsOnly((Object[])new Entity[]{entity});
        }
    }

    @Test
    void searchingByLabelAndPropertyReturnsEmptyWhenMissingLabelOrProperty() {
        try (Transaction transaction = this.db.beginTx();){
            Assertions.assertThat(this.findEntitiesByTokenAndProperty(transaction, this.TOKEN1, "name", "Hawking")).isEmpty();
        }
    }

    @Test
    void shouldSeeIndexUpdatesWhenQueryingOutsideTransaction() {
        this.createIndex((GraphDatabaseService)this.db, this.indexType(), this.TOKEN1, "name");
        ENTITY firstEntity = this.createEntity((GraphDatabaseService)this.db, MapUtil.map((Object[])new Object[]{"name", "Mattias"}), this.TOKEN1);
        try (Transaction transaction = this.db.beginTx();){
            Assertions.assertThat(this.findEntitiesByTokenAndProperty(transaction, this.TOKEN1, "name", "Mattias")).containsOnly((Object[])new Entity[]{firstEntity});
        }
        ENTITY secondEntity = this.createEntity((GraphDatabaseService)this.db, MapUtil.map((Object[])new Object[]{"name", "Taylor"}), this.TOKEN1);
        try (Transaction transaction = this.db.beginTx();){
            Assertions.assertThat(this.findEntitiesByTokenAndProperty(transaction, this.TOKEN1, "name", "Taylor")).containsOnly((Object[])new Entity[]{secondEntity});
        }
    }

    @Test
    void createdEntityShouldShowUpWithinTransaction() {
        long sizeAfterDelete;
        long sizeBeforeDelete;
        this.createIndex((GraphDatabaseService)this.db, this.indexType(), this.TOKEN1, "name");
        try (Transaction tx = this.db.beginTx();){
            ENTITY entity = this.createEntity((GraphDatabaseService)this.db, MapUtil.map((Object[])new Object[]{"name", "Mattias"}), this.TOKEN1);
            sizeBeforeDelete = Iterators.count(this.findEntities(tx, this.TOKEN1, "name", "Mattias"));
            this.deleteEntity(tx, entity.getId());
            sizeAfterDelete = Iterators.count(this.findEntities(tx, this.TOKEN1, "name", "Mattias"));
            tx.commit();
        }
        Assertions.assertThat((long)sizeBeforeDelete).isOne();
        Assertions.assertThat((long)sizeAfterDelete).isZero();
    }

    @Test
    void deletedEntityShouldShowUpWithinTransaction() {
        long sizeAfterDelete;
        long sizeBeforeDelete;
        this.createIndex((GraphDatabaseService)this.db, this.indexType(), this.TOKEN1, "name");
        ENTITY entity = this.createEntity((GraphDatabaseService)this.db, MapUtil.map((Object[])new Object[]{"name", "Mattias"}), this.TOKEN1);
        try (Transaction tx = this.db.beginTx();){
            sizeBeforeDelete = Iterators.count(this.findEntities(tx, this.TOKEN1, "name", "Mattias"));
            this.deleteEntity(tx, entity.getId());
            sizeAfterDelete = Iterators.count(this.findEntities(tx, this.TOKEN1, "name", "Mattias"));
            tx.commit();
        }
        Assertions.assertThat((long)sizeBeforeDelete).isOne();
        Assertions.assertThat((long)sizeAfterDelete).isZero();
    }

    @Test
    void createdEntityShouldShowUpInIndexQuery() {
        long sizeAfterCreate;
        long sizeBeforeCreate;
        this.createIndex((GraphDatabaseService)this.db, this.indexType(), this.TOKEN1, "name");
        this.createEntity((GraphDatabaseService)this.db, MapUtil.map((Object[])new Object[]{"name", "Mattias"}), this.TOKEN1);
        try (Transaction transaction = this.db.beginTx();){
            sizeBeforeCreate = Iterators.count(this.findEntities(transaction, this.TOKEN1, "name", "Mattias"));
        }
        this.createEntity((GraphDatabaseService)this.db, MapUtil.map((Object[])new Object[]{"name", "Mattias"}), this.TOKEN1);
        transaction = this.db.beginTx();
        try {
            sizeAfterCreate = Iterators.count(this.findEntities(transaction, this.TOKEN1, "name", "Mattias"));
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        Assertions.assertThat((long)sizeBeforeCreate).isOne();
        Assertions.assertThat((long)sizeAfterCreate).isEqualTo(2L);
    }

    @Test
    void shouldBeAbleToQuerySupportedPropertyTypes() {
        String property = "name";
        this.createIndex((GraphDatabaseService)this.db, this.indexType(), this.TOKEN1, property);
        this.assertCanCreateAndFind((GraphDatabaseService)this.db, this.TOKEN1, property, "A String");
        this.assertCanCreateAndFind((GraphDatabaseService)this.db, this.TOKEN1, property, true);
        this.assertCanCreateAndFind((GraphDatabaseService)this.db, this.TOKEN1, property, false);
        this.assertCanCreateAndFind((GraphDatabaseService)this.db, this.TOKEN1, property, (byte)56);
        this.assertCanCreateAndFind((GraphDatabaseService)this.db, this.TOKEN1, property, Character.valueOf('z'));
        this.assertCanCreateAndFind((GraphDatabaseService)this.db, this.TOKEN1, property, (short)12);
        this.assertCanCreateAndFind((GraphDatabaseService)this.db, this.TOKEN1, property, 12);
        this.assertCanCreateAndFind((GraphDatabaseService)this.db, this.TOKEN1, property, 12L);
        this.assertCanCreateAndFind((GraphDatabaseService)this.db, this.TOKEN1, property, Float.valueOf(12.0f));
        this.assertCanCreateAndFind((GraphDatabaseService)this.db, this.TOKEN1, property, 12.0);
        this.assertCanCreateAndFind((GraphDatabaseService)this.db, this.TOKEN1, property, SpatialMocks.mockPoint((double)12.3, (double)45.6, (CRS)SpatialMocks.mockWGS84()));
        this.assertCanCreateAndFind((GraphDatabaseService)this.db, this.TOKEN1, property, SpatialMocks.mockPoint((double)123.0, (double)456.0, (CRS)SpatialMocks.mockCartesian()));
        this.assertCanCreateAndFind((GraphDatabaseService)this.db, this.TOKEN1, property, SpatialMocks.mockPoint((double)12.3, (double)45.6, (double)100.0, (CRS)SpatialMocks.mockWGS84_3D()));
        this.assertCanCreateAndFind((GraphDatabaseService)this.db, this.TOKEN1, property, SpatialMocks.mockPoint((double)123.0, (double)456.0, (double)789.0, (CRS)SpatialMocks.mockCartesian_3D()));
        this.assertCanCreateAndFind((GraphDatabaseService)this.db, this.TOKEN1, property, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{12.3, 45.6}));
        this.assertCanCreateAndFind((GraphDatabaseService)this.db, this.TOKEN1, property, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{123.0, 456.0}));
        this.assertCanCreateAndFind((GraphDatabaseService)this.db, this.TOKEN1, property, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84_3D, (double[])new double[]{12.3, 45.6, 100.0}));
        this.assertCanCreateAndFind((GraphDatabaseService)this.db, this.TOKEN1, property, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian_3D, (double[])new double[]{123.0, 456.0, 789.0}));
        this.assertCanCreateAndFind((GraphDatabaseService)this.db, this.TOKEN1, property, new String[]{"A String"});
        this.assertCanCreateAndFind((GraphDatabaseService)this.db, this.TOKEN1, property, new boolean[]{true});
        this.assertCanCreateAndFind((GraphDatabaseService)this.db, this.TOKEN1, property, new Boolean[]{false});
        this.assertCanCreateAndFind((GraphDatabaseService)this.db, this.TOKEN1, property, new byte[]{56});
        this.assertCanCreateAndFind((GraphDatabaseService)this.db, this.TOKEN1, property, new Byte[]{(byte)57});
        this.assertCanCreateAndFind((GraphDatabaseService)this.db, this.TOKEN1, property, new char[]{'a'});
        this.assertCanCreateAndFind((GraphDatabaseService)this.db, this.TOKEN1, property, new Character[]{Character.valueOf('b')});
        this.assertCanCreateAndFind((GraphDatabaseService)this.db, this.TOKEN1, property, new short[]{12});
        this.assertCanCreateAndFind((GraphDatabaseService)this.db, this.TOKEN1, property, new Short[]{(short)13});
        this.assertCanCreateAndFind((GraphDatabaseService)this.db, this.TOKEN1, property, new int[]{14});
        this.assertCanCreateAndFind((GraphDatabaseService)this.db, this.TOKEN1, property, new Integer[]{15});
        this.assertCanCreateAndFind((GraphDatabaseService)this.db, this.TOKEN1, property, new long[]{16L});
        this.assertCanCreateAndFind((GraphDatabaseService)this.db, this.TOKEN1, property, new Long[]{17L});
        this.assertCanCreateAndFind((GraphDatabaseService)this.db, this.TOKEN1, property, new float[]{18.0f});
        this.assertCanCreateAndFind((GraphDatabaseService)this.db, this.TOKEN1, property, new Float[]{Float.valueOf(19.0f)});
        this.assertCanCreateAndFind((GraphDatabaseService)this.db, this.TOKEN1, property, new double[]{20.0});
        this.assertCanCreateAndFind((GraphDatabaseService)this.db, this.TOKEN1, property, new Double[]{21.0});
        this.assertCanCreateAndFind((GraphDatabaseService)this.db, this.TOKEN1, property, new Point[]{SpatialMocks.mockPoint((double)12.3, (double)45.6, (CRS)SpatialMocks.mockWGS84())});
        this.assertCanCreateAndFind((GraphDatabaseService)this.db, this.TOKEN1, property, new Point[]{SpatialMocks.mockPoint((double)123.0, (double)456.0, (CRS)SpatialMocks.mockCartesian())});
        this.assertCanCreateAndFind((GraphDatabaseService)this.db, this.TOKEN1, property, new Point[]{SpatialMocks.mockPoint((double)12.3, (double)45.6, (double)100.0, (CRS)SpatialMocks.mockWGS84_3D())});
        this.assertCanCreateAndFind((GraphDatabaseService)this.db, this.TOKEN1, property, new Point[]{SpatialMocks.mockPoint((double)123.0, (double)456.0, (double)789.0, (CRS)SpatialMocks.mockCartesian_3D())});
        this.assertCanCreateAndFind((GraphDatabaseService)this.db, this.TOKEN1, property, new PointValue[]{Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{12.3, 45.6})});
        this.assertCanCreateAndFind((GraphDatabaseService)this.db, this.TOKEN1, property, new PointValue[]{Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{123.0, 456.0})});
        this.assertCanCreateAndFind((GraphDatabaseService)this.db, this.TOKEN1, property, new PointValue[]{Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84_3D, (double[])new double[]{12.3, 45.6, 100.0})});
        this.assertCanCreateAndFind((GraphDatabaseService)this.db, this.TOKEN1, property, new PointValue[]{Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian_3D, (double[])new double[]{123.0, 456.0, 789.0})});
    }

    @Test
    void shouldRetrieveMultipleEntitiesWithSameValueFromIndex() {
        ENTITY entity2;
        ENTITY entity1;
        this.createIndex((GraphDatabaseService)this.db, this.indexType(), this.TOKEN1, "name");
        try (Transaction tx = this.db.beginTx();){
            entity1 = this.createEntity(tx, this.TOKEN1);
            entity1.setProperty("name", (Object)"Stefan");
            entity2 = this.createEntity(tx, this.TOKEN1);
            entity2.setProperty("name", (Object)"Stefan");
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            ResourceIterator<ENTITY> result = this.findEntities(tx, this.TOKEN1, "name", "Stefan");
            org.junit.jupiter.api.Assertions.assertEquals((Object)Iterators.asSet((Object[])new Entity[]{entity1, entity2}), (Object)Iterators.asSet(result));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldThrowWhenMultipleResultsForSingleEntities() {
        this.createIndex((GraphDatabaseService)this.db, this.indexType(), this.TOKEN1, "name");
        try (Transaction tx = this.db.beginTx();){
            ENTITY entity1 = this.createEntity(tx, this.TOKEN1);
            entity1.setProperty("name", (Object)"Stefan");
            ENTITY entity2 = this.createEntity(tx, this.TOKEN1);
            entity2.setProperty("name", (Object)"Stefan");
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            MultipleFoundException e = (MultipleFoundException)org.junit.jupiter.api.Assertions.assertThrows(MultipleFoundException.class, () -> this.findEntity(tx, this.TOKEN1, "name", "Stefan"));
            Assertions.assertThat((Throwable)e).hasMessage(String.format(this.getMultipleEntitiesMessageTemplate(), this.TOKEN1));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    protected void assertCanCreateAndFind(GraphDatabaseService db, TOKEN label, String propertyKey, Object value) {
        ENTITY created = this.createEntity(db, MapUtil.map((Object[])new Object[]{propertyKey, value}), label);
        try (Transaction tx = db.beginTx();){
            ENTITY found = this.findEntity(tx, label, propertyKey, value);
            Assertions.assertThat(found).isEqualTo(created);
            this.deleteEntity(tx, found.getId());
            tx.commit();
        }
    }

    protected abstract TOKEN createToken(String var1);

    protected abstract List<ENTITY> findEntitiesByTokenAndProperty(Transaction var1, TOKEN var2, String var3, Object var4);

    protected abstract ENTITY createEntity(GraphDatabaseService var1, Map<String, Object> var2, TOKEN var3);

    protected abstract ENTITY createEntity(Transaction var1, TOKEN var2);

    protected abstract void deleteEntity(Transaction var1, long var2);

    protected abstract ENTITY getEntity(Transaction var1, long var2);

    protected abstract IndexDefinition createIndex(GraphDatabaseService var1, IndexType var2, TOKEN var3, String ... var4);

    protected abstract ResourceIterator<ENTITY> findEntities(Transaction var1, TOKEN var2, String var3, Object var4);

    protected abstract ENTITY findEntity(Transaction var1, TOKEN var2, String var3, Object var4);

    protected abstract String getMultipleEntitiesMessageTemplate();

    protected abstract IndexType indexType();
}

