/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Nested;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.IndexingAcceptanceTestBase;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.SchemaAcceptanceTest;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.internal.helpers.collection.Iterators;

public class RelationshipIndexingAcceptanceTest {

    @Nested
    class RangeIndexTest
    extends RelationshipIndexingAcceptanceTestBase {
        RangeIndexTest() {
        }

        @Override
        protected IndexType indexType() {
            return IndexType.RANGE;
        }
    }

    @Nested
    class BTreeIndexTest
    extends RelationshipIndexingAcceptanceTestBase {
        BTreeIndexTest() {
        }

        @Override
        protected IndexType indexType() {
            return IndexType.BTREE;
        }
    }

    static abstract class RelationshipIndexingAcceptanceTestBase
    extends IndexingAcceptanceTestBase<RelationshipType, Relationship> {
        RelationshipIndexingAcceptanceTestBase() {
        }

        @Override
        protected RelationshipType createToken(String name) {
            return RelationshipType.withName((String)name);
        }

        @Override
        protected List<Relationship> findEntitiesByTokenAndProperty(Transaction tx, RelationshipType type, String propertyName, Object value) {
            return Iterators.asList((Iterator)tx.findRelationships(type, propertyName, value));
        }

        @Override
        protected Relationship createEntity(GraphDatabaseService db, Map<String, Object> properties, RelationshipType type) {
            try (Transaction tx = db.beginTx();){
                Node from = tx.createNode(new Label[]{Label.label((String)"test")});
                Node to = tx.createNode(new Label[]{Label.label((String)"test")});
                Relationship rel = from.createRelationshipTo(to, type);
                properties.forEach((arg_0, arg_1) -> ((Relationship)rel).setProperty(arg_0, arg_1));
                tx.commit();
                Relationship relationship = rel;
                return relationship;
            }
        }

        @Override
        protected Relationship createEntity(Transaction tx, RelationshipType type) {
            Node from = tx.createNode(new Label[]{Label.label((String)"test")});
            Node to = tx.createNode(new Label[]{Label.label((String)"test")});
            return from.createRelationshipTo(to, type);
        }

        @Override
        protected void deleteEntity(Transaction tx, long id) {
            tx.getRelationshipById(id).delete();
        }

        @Override
        protected Relationship getEntity(Transaction tx, long id) {
            return tx.getRelationshipById(id);
        }

        @Override
        protected IndexDefinition createIndex(GraphDatabaseService db, IndexType indexType, RelationshipType type, String ... properties) {
            return SchemaAcceptanceTest.createIndex((GraphDatabaseService)db, (IndexType)indexType, (RelationshipType)type, (String[])properties);
        }

        @Override
        protected ResourceIterator<Relationship> findEntities(Transaction tx, RelationshipType type, String key, Object value) {
            return tx.findRelationships(type, key, value);
        }

        @Override
        protected Relationship findEntity(Transaction tx, RelationshipType type, String key, Object value) {
            return tx.findRelationship(type, key, value);
        }

        @Override
        protected String getMultipleEntitiesMessageTemplate() {
            return "Found multiple relationships with type: '%s', property name: 'name' and property value: 'Stefan' while only one was expected.";
        }
    }
}

