/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index;

import java.io.IOException;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.neo4j.batchinsert.BatchInserter;
import org.neo4j.batchinsert.BatchInserters;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.id.ReservedIdException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.recordstorage.RecordDatabaseLayout;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;

@Neo4jLayoutExtension
public class BatchInsertionIT {
    @Inject
    private FileSystemAbstraction fileSystem;
    @Inject
    private RecordDatabaseLayout databaseLayout;
    private DatabaseManagementService managementService;

    @AfterEach
    void tearDown() {
        if (this.managementService != null) {
            this.managementService.shutdown();
        }
    }

    @Test
    void shouldBeAbleToMakeRepeatedCallsToSetNodeProperty() throws Exception {
        Integer finalValue = 87;
        BatchInserter inserter = BatchInserters.inserter((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem);
        long nodeId = inserter.createNode(Collections.emptyMap(), new Label[0]);
        inserter.setNodeProperty(nodeId, "a", (Object)"some property value");
        inserter.setNodeProperty(nodeId, "a", (Object)42);
        inserter.setNodeProperty(nodeId, "a", (Object)3.14);
        inserter.setNodeProperty(nodeId, "a", (Object)true);
        inserter.setNodeProperty(nodeId, "a", (Object)finalValue);
        inserter.shutdown();
        GraphDatabaseService db = this.getDatabase();
        try (Transaction tx = db.beginTx();){
            Assertions.assertThat((Object)tx.getNodeById(nodeId).getProperty("a")).isEqualTo((Object)finalValue);
        }
    }

    @Test
    void shouldBeAbleToMakeRepeatedCallsToSetNodePropertyWithMultiplePropertiesPerBlock() throws Exception {
        BatchInserter inserter = BatchInserters.inserter((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem);
        long nodeId = inserter.createNode(Collections.emptyMap(), new Label[0]);
        Integer finalValue1 = 87;
        Double finalValue2 = 3.14;
        inserter.setNodeProperty(nodeId, "a", (Object)"some property value");
        inserter.setNodeProperty(nodeId, "a", (Object)42);
        inserter.setNodeProperty(nodeId, "b", (Object)finalValue2);
        inserter.setNodeProperty(nodeId, "a", (Object)finalValue2);
        inserter.setNodeProperty(nodeId, "a", (Object)true);
        inserter.setNodeProperty(nodeId, "a", (Object)finalValue1);
        inserter.shutdown();
        GraphDatabaseService db = this.getDatabase();
        try (Transaction tx = db.beginTx();){
            Assertions.assertThat((Object)tx.getNodeById(nodeId).getProperty("a")).isEqualTo((Object)finalValue1);
            Assertions.assertThat((Object)tx.getNodeById(nodeId).getProperty("b")).isEqualTo((Object)finalValue2);
        }
    }

    @Test
    void makeSureCantCreateNodeWithMagicNumber() throws IOException {
        try (BatchInserter inserter = BatchInserters.inserter((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem);){
            org.junit.jupiter.api.Assertions.assertThrows(ReservedIdException.class, () -> inserter.createNode(0xFFFFFFFFL, null, new Label[0]));
        }
    }

    private GraphDatabaseService getDatabase() {
        if (this.managementService == null) {
            this.managementService = new TestDatabaseManagementServiceBuilder((DatabaseLayout)this.databaseLayout).setFileSystem(this.fileSystem).build();
        }
        return this.managementService.database("neo4j");
    }
}

