/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index;

import java.io.IOException;
import java.nio.file.Path;
import java.util.function.Consumer;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.neo4j.index.NativeIndexRestartAction;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.impl.muninn.StandalonePageCacheFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.impl.index.schema.NativeIndexHeaderWriter;
import org.neo4j.kernel.impl.index.schema.NativeIndexes;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.scheduler.JobScheduler;

public class SetInitialStateInNativeIndex
extends NativeIndexRestartAction {
    private final byte targetInitialState;

    public SetInitialStateInNativeIndex(byte targetInitialState, IndexProviderDescriptor providerDescriptor) {
        super(providerDescriptor);
        this.targetInitialState = targetInitialState;
    }

    @Override
    protected void runOnDirectoryStructure(FileSystemAbstraction fs, IndexDirectoryStructure indexDirectoryStructure) throws IOException {
        PageCache pageCache = StandalonePageCacheFactory.createPageCache((FileSystemAbstraction)fs, (JobScheduler)JobSchedulerFactory.createInitialisedScheduler(), (PageCacheTracer)PageCacheTracer.NULL);
        int filesChanged = this.setInitialState(fs, indexDirectoryStructure.rootDirectory(), pageCache);
        ((AbstractIntegerAssert)Assertions.assertThat((int)filesChanged).as("couldn't find any index to set state on", new Object[0])).isGreaterThanOrEqualTo(1);
    }

    private int setInitialState(FileSystemAbstraction fs, Path fileOrDir, PageCache pageCache) throws IOException {
        if (fs.isDirectory(fileOrDir)) {
            Path[] children;
            int count = 0;
            for (Path child : children = fs.listFiles(fileOrDir)) {
                count += this.setInitialState(fs, child, pageCache);
            }
            return count;
        }
        if (SetInitialStateInNativeIndex.isNativeIndexFile(fileOrDir, pageCache)) {
            SetInitialStateInNativeIndex.overwriteState(pageCache, fileOrDir, this.targetInitialState);
        }
        return 1;
    }

    private static boolean isNativeIndexFile(Path fileOrDir, PageCache pageCache) {
        try {
            NativeIndexes.readState((PageCache)pageCache, (Path)fileOrDir, (String)"neo4j", (CursorContext)CursorContext.NULL);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static void overwriteState(PageCache pageCache, Path indexFile, byte state) throws IOException {
        NativeIndexHeaderWriter stateWriter = new NativeIndexHeaderWriter(state);
        GBPTree.overwriteHeader((PageCache)pageCache, (Path)indexFile, (Consumer)stateWriter, (String)"neo4j", (CursorContext)CursorContext.NULL);
    }
}

