/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.exceptions.KernelException;
import org.neo4j.function.ThrowingAction;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.RelationshipValueIndexCursor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.impl.fulltext.LuceneFulltextTestSupport;
import org.neo4j.test.Race;

class ConcurrentLuceneFulltextUpdaterTest
extends LuceneFulltextTestSupport {
    private static final String NODES_INDEX_NAME = "nodes";
    private static final String RELS_INDEX_NAME = "rels";
    private static final int ENTITIES_PER_THREAD = 500;
    private static final int ALICE_THREADS = 1;
    private static final int BOB_THREADS = 1;
    private Race race;
    private final CountDownLatch aliceLatch = new CountDownLatch(2);
    private final CountDownLatch bobLatch = new CountDownLatch(2);

    ConcurrentLuceneFulltextUpdaterTest() {
    }

    @BeforeEach
    public void createRace() {
        this.race = new Race();
    }

    private void createInitialNodeIndex() {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().indexFor(LABEL).on("prop").withIndexType(IndexType.FULLTEXT).withName(NODES_INDEX_NAME).create();
            tx.commit();
        }
    }

    private void createInitialRelationshipIndex() {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().indexFor(RELTYPE).on("prop").withIndexType(IndexType.FULLTEXT).withName(RELS_INDEX_NAME).create();
            tx.commit();
        }
    }

    private void raceContestants(Runnable aliceWork, Runnable changeConfig, Runnable bobWork) throws Throwable {
        this.race.addContestants(1, aliceWork);
        this.race.addContestant(changeConfig);
        this.race.addContestants(1, bobWork);
        this.race.go();
        try (Transaction tx = this.db.beginTx();){
            tx.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
        }
    }

    private void verifyForNodes() throws KernelException {
        try (Transaction tx = this.db.beginTx();){
            KernelTransaction ktx = ConcurrentLuceneFulltextUpdaterTest.kernelTransaction(tx);
            IndexReadSession index = ktx.dataRead().indexReadSession(ktx.schemaRead().indexGetForName(NODES_INDEX_NAME));
            try (NodeValueIndexCursor bobCursor = ktx.cursors().allocateNodeValueIndexCursor(ktx.cursorContext(), ktx.memoryTracker());){
                ktx.dataRead().nodeIndexSeek(ktx.queryContext(), index, bobCursor, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{PropertyIndexQuery.fulltextSearch((String)"bob")});
                int bobCount = 0;
                while (bobCursor.next()) {
                    ++bobCount;
                }
                Assertions.assertEquals((int)500, (int)bobCount);
            }
            try (NodeValueIndexCursor aliceCursor = ktx.cursors().allocateNodeValueIndexCursor(ktx.cursorContext(), ktx.memoryTracker());){
                ktx.dataRead().nodeIndexSeek(ktx.queryContext(), index, aliceCursor, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{PropertyIndexQuery.fulltextSearch((String)"alice")});
                int aliceCount = 0;
                while (aliceCursor.next()) {
                    ++aliceCount;
                }
                Assertions.assertEquals((int)0, (int)aliceCount);
            }
        }
    }

    private void verifyForRels() throws KernelException {
        try (Transaction tx = this.db.beginTx();){
            KernelTransaction ktx = ConcurrentLuceneFulltextUpdaterTest.kernelTransaction(tx);
            IndexReadSession index = ktx.dataRead().indexReadSession(ktx.schemaRead().indexGetForName(RELS_INDEX_NAME));
            try (RelationshipValueIndexCursor bobCursor = ktx.cursors().allocateRelationshipValueIndexCursor(ktx.cursorContext(), ktx.memoryTracker());){
                ktx.dataRead().relationshipIndexSeek(ktx.queryContext(), index, bobCursor, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{PropertyIndexQuery.fulltextSearch((String)"bob")});
                int bobCount = 0;
                while (bobCursor.next()) {
                    ++bobCount;
                }
                Assertions.assertEquals((int)500, (int)bobCount);
            }
            try (RelationshipValueIndexCursor aliceCursor = ktx.cursors().allocateRelationshipValueIndexCursor(ktx.cursorContext(), ktx.memoryTracker());){
                ktx.dataRead().relationshipIndexSeek(ktx.queryContext(), index, aliceCursor, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{PropertyIndexQuery.fulltextSearch((String)"alice")});
                int aliceCount = 0;
                while (aliceCursor.next()) {
                    ++aliceCount;
                }
                Assertions.assertEquals((int)0, (int)aliceCount);
            }
        }
    }

    private Runnable work(int iterations, ThrowingConsumer<Transaction, Exception> work) {
        return () -> {
            try {
                for (int i = 0; i < iterations; ++i) {
                    Thread.yield();
                    try (Transaction tx = this.db.beginTx();){
                        Thread.yield();
                        work.accept((Object)tx);
                        Thread.yield();
                        tx.commit();
                        continue;
                    }
                }
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        };
    }

    private ThrowingAction<Exception> dropAndReCreateNodeIndex() {
        return () -> {
            this.aliceLatch.await();
            this.bobLatch.await();
            try (Transaction tx = this.db.beginTx();){
                tx.schema().getIndexByName(NODES_INDEX_NAME).drop();
                tx.schema().indexFor(LABEL).on("otherProp").withIndexType(IndexType.FULLTEXT).withName(NODES_INDEX_NAME).create();
                tx.commit();
            }
        };
    }

    private ThrowingAction<Exception> dropAndReCreateRelationshipIndex() {
        return () -> {
            this.aliceLatch.await();
            this.bobLatch.await();
            try (Transaction tx = this.db.beginTx();){
                tx.schema().getIndexByName(RELS_INDEX_NAME).drop();
                tx.schema().indexFor(RELTYPE).on("otherProp").withIndexType(IndexType.FULLTEXT).withName(RELS_INDEX_NAME).create();
                tx.commit();
            }
        };
    }

    @Test
    void labelledNodesCoreAPI() throws Throwable {
        this.createInitialNodeIndex();
        Runnable aliceWork = this.work(500, (ThrowingConsumer<Transaction, Exception>)((ThrowingConsumer)tx -> {
            tx.getNodeById(ConcurrentLuceneFulltextUpdaterTest.createNodeIndexableByPropertyValue(tx, LABEL, "alice"));
            this.aliceLatch.countDown();
        }));
        Runnable bobWork = this.work(500, (ThrowingConsumer<Transaction, Exception>)((ThrowingConsumer)tx -> {
            tx.getNodeById(ConcurrentLuceneFulltextUpdaterTest.createNodeWithProperty(tx, LABEL, "otherProp", "bob"));
            this.bobLatch.countDown();
        }));
        Runnable changeConfig = this.work(1, (ThrowingConsumer<Transaction, Exception>)((ThrowingConsumer)tx -> this.dropAndReCreateNodeIndex().apply()));
        this.raceContestants(aliceWork, changeConfig, bobWork);
        this.verifyForNodes();
    }

    @Test
    void labelledNodesCypherCurrent() throws Throwable {
        this.createInitialNodeIndex();
        Runnable aliceWork = this.work(500, (ThrowingConsumer<Transaction, Exception>)((ThrowingConsumer)tx -> {
            tx.execute("create (:LABEL {prop: \"alice\"})").close();
            this.aliceLatch.countDown();
        }));
        Runnable bobWork = this.work(500, (ThrowingConsumer<Transaction, Exception>)((ThrowingConsumer)tx -> {
            tx.execute("create (:LABEL {otherProp: \"bob\"})").close();
            this.bobLatch.countDown();
        }));
        Runnable changeConfig = this.work(1, (ThrowingConsumer<Transaction, Exception>)((ThrowingConsumer)tx -> this.dropAndReCreateNodeIndex().apply()));
        this.raceContestants(aliceWork, changeConfig, bobWork);
        this.verifyForNodes();
    }

    @Test
    void relationshipsCoreAPI() throws Throwable {
        this.createInitialRelationshipIndex();
        Runnable aliceWork = this.work(500, (ThrowingConsumer<Transaction, Exception>)((ThrowingConsumer)tx -> {
            tx.getRelationshipById(ConcurrentLuceneFulltextUpdaterTest.createRelationshipIndexableByPropertyValue(tx, tx.createNode().getId(), tx.createNode().getId(), "alice"));
            this.aliceLatch.countDown();
        }));
        Runnable bobWork = this.work(500, (ThrowingConsumer<Transaction, Exception>)((ThrowingConsumer)tx -> {
            tx.getRelationshipById(ConcurrentLuceneFulltextUpdaterTest.createRelationshipWithProperty(tx, tx.createNode().getId(), tx.createNode().getId(), "otherProp", "bob"));
            this.bobLatch.countDown();
        }));
        Runnable changeConfig = this.work(1, (ThrowingConsumer<Transaction, Exception>)((ThrowingConsumer)tx -> this.dropAndReCreateRelationshipIndex().apply()));
        this.raceContestants(aliceWork, changeConfig, bobWork);
        this.verifyForRels();
    }

    @Test
    void relationshipsCypherCurrent() throws Throwable {
        this.createInitialRelationshipIndex();
        Runnable aliceWork = this.work(500, (ThrowingConsumer<Transaction, Exception>)((ThrowingConsumer)tx -> {
            tx.execute("create ()-[:type {prop: \"alice\"}]->()").close();
            this.aliceLatch.countDown();
        }));
        Runnable bobWork = this.work(500, (ThrowingConsumer<Transaction, Exception>)((ThrowingConsumer)tx -> {
            tx.execute("create ()-[:type {otherProp: \"bob\"}]->()").close();
            this.bobLatch.countDown();
        }));
        Runnable changeConfig = this.work(1, (ThrowingConsumer<Transaction, Exception>)((ThrowingConsumer)tx -> this.dropAndReCreateRelationshipIndex().apply()));
        this.raceContestants(aliceWork, changeConfig, bobWork);
        this.verifyForRels();
    }
}

