/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.FulltextSettings;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.impl.fulltext.LuceneFulltextTestSupport;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;

class FulltextAnalyzerTest
extends LuceneFulltextTestSupport {
    private static final String ENGLISH = "english";
    static final String SWEDISH = "swedish";
    private static final String FOLDING = "standard-folding";
    public static final String NODE_INDEX_NAME = "nodes";
    public static final String REL_INDEX_NAME = "rels";

    FulltextAnalyzerTest() {
    }

    @Test
    void shouldBeAbleToSpecifyEnglishAnalyzer() throws Exception {
        long relId;
        long nodeId;
        this.applySetting((Setting<String>)FulltextSettings.fulltext_default_analyzer, ENGLISH);
        this.createIndexes();
        try (Transaction tx = this.db.beginTx();){
            FulltextAnalyzerTest.createNodeIndexableByPropertyValue(tx, LABEL, "Hello and hello again, in the end.");
            nodeId = FulltextAnalyzerTest.createNodeIndexableByPropertyValue(tx, LABEL, "En apa och en tomte bodde i ett hus.");
            FulltextAnalyzerTest.createRelationshipIndexableByPropertyValue(tx, tx.createNode().getId(), tx.createNode().getId(), "Hello and hello again, in the end.");
            relId = FulltextAnalyzerTest.createRelationshipIndexableByPropertyValue(tx, tx.createNode().getId(), tx.createNode().getId(), "En apa och en tomte bodde i ett hus.");
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            KernelTransaction ktx = FulltextAnalyzerTest.kernelTransaction(tx);
            FulltextAnalyzerTest.assertQueryFindsNothing(ktx, true, NODE_INDEX_NAME, "and");
            FulltextAnalyzerTest.assertQueryFindsNothing(ktx, true, NODE_INDEX_NAME, "in");
            FulltextAnalyzerTest.assertQueryFindsNothing(ktx, true, NODE_INDEX_NAME, "the");
            FulltextAnalyzerTest.assertQueryFindsNothing(ktx, false, REL_INDEX_NAME, "and");
            FulltextAnalyzerTest.assertQueryFindsNothing(ktx, false, REL_INDEX_NAME, "in");
            FulltextAnalyzerTest.assertQueryFindsNothing(ktx, false, REL_INDEX_NAME, "the");
            FulltextAnalyzerTest.assertQueryFindsIds(ktx, true, NODE_INDEX_NAME, "en", nodeId);
            FulltextAnalyzerTest.assertQueryFindsIds(ktx, true, NODE_INDEX_NAME, "och", nodeId);
            FulltextAnalyzerTest.assertQueryFindsIds(ktx, true, NODE_INDEX_NAME, "ett", nodeId);
            FulltextAnalyzerTest.assertQueryFindsIds(ktx, false, REL_INDEX_NAME, "en", relId);
            FulltextAnalyzerTest.assertQueryFindsIds(ktx, false, REL_INDEX_NAME, "och", relId);
            FulltextAnalyzerTest.assertQueryFindsIds(ktx, false, REL_INDEX_NAME, "ett", relId);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldBeAbleToSpecifySwedishAnalyzer() throws Exception {
        long relId;
        long nodeId;
        this.applySetting((Setting<String>)FulltextSettings.fulltext_default_analyzer, SWEDISH);
        this.createIndexes();
        try (Transaction tx = this.db.beginTx();){
            nodeId = FulltextAnalyzerTest.createNodeIndexableByPropertyValue(tx, LABEL, "Hello and hello again, in the end.");
            FulltextAnalyzerTest.createNodeIndexableByPropertyValue(tx, LABEL, "En apa och en tomte bodde i ett hus.");
            relId = FulltextAnalyzerTest.createRelationshipIndexableByPropertyValue(tx, tx.createNode().getId(), tx.createNode().getId(), "Hello and hello again, in the end.");
            FulltextAnalyzerTest.createRelationshipIndexableByPropertyValue(tx, tx.createNode().getId(), tx.createNode().getId(), "En apa och en tomte bodde i ett hus.");
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            KernelTransaction ktx = FulltextAnalyzerTest.kernelTransaction(tx);
            FulltextAnalyzerTest.assertQueryFindsIds(ktx, true, NODE_INDEX_NAME, "and", nodeId);
            FulltextAnalyzerTest.assertQueryFindsIds(ktx, true, NODE_INDEX_NAME, "in", nodeId);
            FulltextAnalyzerTest.assertQueryFindsIds(ktx, true, NODE_INDEX_NAME, "the", nodeId);
            FulltextAnalyzerTest.assertQueryFindsIds(ktx, false, REL_INDEX_NAME, "and", relId);
            FulltextAnalyzerTest.assertQueryFindsIds(ktx, false, REL_INDEX_NAME, "in", relId);
            FulltextAnalyzerTest.assertQueryFindsIds(ktx, false, REL_INDEX_NAME, "the", relId);
            FulltextAnalyzerTest.assertQueryFindsNothing(ktx, true, NODE_INDEX_NAME, "en");
            FulltextAnalyzerTest.assertQueryFindsNothing(ktx, true, NODE_INDEX_NAME, "och");
            FulltextAnalyzerTest.assertQueryFindsNothing(ktx, true, NODE_INDEX_NAME, "ett");
            FulltextAnalyzerTest.assertQueryFindsNothing(ktx, false, REL_INDEX_NAME, "en");
            FulltextAnalyzerTest.assertQueryFindsNothing(ktx, false, REL_INDEX_NAME, "och");
            FulltextAnalyzerTest.assertQueryFindsNothing(ktx, false, REL_INDEX_NAME, "ett");
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldBeAbleToSpecifyFoldingAnalyzer() throws Exception {
        long relId3;
        long relId2;
        long relId;
        long nodeId3;
        long nodeId2;
        long nodeId;
        this.applySetting((Setting<String>)FulltextSettings.fulltext_default_analyzer, FOLDING);
        this.createIndexes();
        try (Transaction tx = this.db.beginTx();){
            nodeId = FulltextAnalyzerTest.createNodeIndexableByPropertyValue(tx, LABEL, "P\u0159\u00edli\u0161 \u017elu\u0165ou\u010dk\u00fd k\u016f\u0148 \u00fap\u011bl \u010f\u00e1belsk\u00e9 \u00f3dy.");
            nodeId2 = FulltextAnalyzerTest.createNodeIndexableByPropertyValue(tx, LABEL, "1SOMEDATA1");
            nodeId3 = FulltextAnalyzerTest.createNodeIndexableByPropertyValue(tx, LABEL, "\u24b6pa \u2c6fmma \u01e2ta \ua736ajaj \ua73averka dett\u249c");
            relId = FulltextAnalyzerTest.createRelationshipIndexableByPropertyValue(tx, tx.createNode().getId(), tx.createNode().getId(), "P\u0159\u00edli\u0161 \u017elu\u0165ou\u010dk\u00fd k\u016f\u0148 \u00fap\u011bl \u010f\u00e1belsk\u00e9 \u00f3dy.");
            relId2 = FulltextAnalyzerTest.createRelationshipIndexableByPropertyValue(tx, tx.createNode().getId(), tx.createNode().getId(), "1SOMEDATA1");
            relId3 = FulltextAnalyzerTest.createRelationshipIndexableByPropertyValue(tx, tx.createNode().getId(), tx.createNode().getId(), "\u24b6pa \u2c6fmma \u01e2ta \ua736ajaj \ua73averka dett\u249c");
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            KernelTransaction ktx = FulltextAnalyzerTest.kernelTransaction(tx);
            FulltextAnalyzerTest.assertQueryFindsIds(ktx, true, NODE_INDEX_NAME, "prilis", nodeId);
            FulltextAnalyzerTest.assertQueryFindsIds(ktx, true, NODE_INDEX_NAME, "zlutoucky", nodeId);
            FulltextAnalyzerTest.assertQueryFindsIds(ktx, true, NODE_INDEX_NAME, "kun", nodeId);
            FulltextAnalyzerTest.assertQueryFindsIds(ktx, true, NODE_INDEX_NAME, "upel", nodeId);
            FulltextAnalyzerTest.assertQueryFindsIds(ktx, true, NODE_INDEX_NAME, "dabelske", nodeId);
            FulltextAnalyzerTest.assertQueryFindsIds(ktx, true, NODE_INDEX_NAME, "ody", nodeId);
            FulltextAnalyzerTest.assertQueryFindsIds(ktx, true, NODE_INDEX_NAME, "1SOMEDATA1", nodeId2);
            FulltextAnalyzerTest.assertQueryFindsIds(ktx, true, NODE_INDEX_NAME, "1somedata1", nodeId2);
            FulltextAnalyzerTest.assertQueryFindsIds(ktx, true, NODE_INDEX_NAME, "*SOMEDATA*", nodeId2);
            FulltextAnalyzerTest.assertQueryFindsIds(ktx, true, NODE_INDEX_NAME, "*somedata*", nodeId2);
            FulltextAnalyzerTest.assertQueryFindsIds(ktx, true, NODE_INDEX_NAME, "Apa", nodeId3);
            FulltextAnalyzerTest.assertQueryFindsIds(ktx, true, NODE_INDEX_NAME, "amma", nodeId3);
            FulltextAnalyzerTest.assertQueryFindsIds(ktx, true, NODE_INDEX_NAME, "AEta", nodeId3);
            FulltextAnalyzerTest.assertQueryFindsIds(ktx, true, NODE_INDEX_NAME, "Auajaj", nodeId3);
            FulltextAnalyzerTest.assertQueryFindsIds(ktx, true, NODE_INDEX_NAME, "Avverka", nodeId3);
            FulltextAnalyzerTest.assertQueryFindsIds(ktx, true, NODE_INDEX_NAME, "dett(a)", nodeId3);
            FulltextAnalyzerTest.assertQueryFindsIds(ktx, false, REL_INDEX_NAME, "prilis", relId);
            FulltextAnalyzerTest.assertQueryFindsIds(ktx, false, REL_INDEX_NAME, "zlutoucky", relId);
            FulltextAnalyzerTest.assertQueryFindsIds(ktx, false, REL_INDEX_NAME, "kun", relId);
            FulltextAnalyzerTest.assertQueryFindsIds(ktx, false, REL_INDEX_NAME, "upel", relId);
            FulltextAnalyzerTest.assertQueryFindsIds(ktx, false, REL_INDEX_NAME, "dabelske", relId);
            FulltextAnalyzerTest.assertQueryFindsIds(ktx, false, REL_INDEX_NAME, "ody", relId);
            FulltextAnalyzerTest.assertQueryFindsIds(ktx, false, REL_INDEX_NAME, "1SOMEDATA1", relId2);
            FulltextAnalyzerTest.assertQueryFindsIds(ktx, false, REL_INDEX_NAME, "1somedata1", relId2);
            FulltextAnalyzerTest.assertQueryFindsIds(ktx, false, REL_INDEX_NAME, "*SOMEDATA*", relId2);
            FulltextAnalyzerTest.assertQueryFindsIds(ktx, false, REL_INDEX_NAME, "*somedata*", relId2);
            FulltextAnalyzerTest.assertQueryFindsIds(ktx, false, REL_INDEX_NAME, "Apa", relId3);
            FulltextAnalyzerTest.assertQueryFindsIds(ktx, false, REL_INDEX_NAME, "amma", relId3);
            FulltextAnalyzerTest.assertQueryFindsIds(ktx, false, REL_INDEX_NAME, "AEta", relId3);
            FulltextAnalyzerTest.assertQueryFindsIds(ktx, false, REL_INDEX_NAME, "Auajaj", relId3);
            FulltextAnalyzerTest.assertQueryFindsIds(ktx, false, REL_INDEX_NAME, "Avverka", relId3);
            FulltextAnalyzerTest.assertQueryFindsIds(ktx, false, REL_INDEX_NAME, "dett(a)", relId3);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldNotReindexNodesWhenDefaultAnalyzerIsChanged() throws Exception {
        long relId;
        long nodeId;
        this.applySetting((Setting<String>)FulltextSettings.fulltext_default_analyzer, ENGLISH);
        this.createIndexes();
        try (Transaction tx = this.db.beginTx();){
            FulltextAnalyzerTest.createNodeIndexableByPropertyValue(tx, LABEL, "Hello and hello again, in the end.");
            nodeId = FulltextAnalyzerTest.createNodeIndexableByPropertyValue(tx, LABEL, "En apa och en tomte bodde i ett hus.");
            FulltextAnalyzerTest.createRelationshipIndexableByPropertyValue(tx, tx.createNode().getId(), tx.createNode().getId(), "Hello and hello again, in the end.");
            relId = FulltextAnalyzerTest.createRelationshipIndexableByPropertyValue(tx, tx.createNode().getId(), tx.createNode().getId(), "En apa och en tomte bodde i ett hus.");
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            KernelTransaction ktx = FulltextAnalyzerTest.kernelTransaction(tx);
            FulltextAnalyzerTest.assertQueryFindsNothing(ktx, true, NODE_INDEX_NAME, "and");
            FulltextAnalyzerTest.assertQueryFindsNothing(ktx, true, NODE_INDEX_NAME, "in");
            FulltextAnalyzerTest.assertQueryFindsNothing(ktx, true, NODE_INDEX_NAME, "the");
            FulltextAnalyzerTest.assertQueryFindsIds(ktx, true, NODE_INDEX_NAME, "en", nodeId);
            FulltextAnalyzerTest.assertQueryFindsIds(ktx, true, NODE_INDEX_NAME, "och", nodeId);
            FulltextAnalyzerTest.assertQueryFindsIds(ktx, true, NODE_INDEX_NAME, "ett", nodeId);
            FulltextAnalyzerTest.assertQueryFindsNothing(ktx, false, REL_INDEX_NAME, "and");
            FulltextAnalyzerTest.assertQueryFindsNothing(ktx, false, REL_INDEX_NAME, "in");
            FulltextAnalyzerTest.assertQueryFindsNothing(ktx, false, REL_INDEX_NAME, "the");
            FulltextAnalyzerTest.assertQueryFindsIds(ktx, false, REL_INDEX_NAME, "en", relId);
            FulltextAnalyzerTest.assertQueryFindsIds(ktx, false, REL_INDEX_NAME, "och", relId);
            FulltextAnalyzerTest.assertQueryFindsIds(ktx, false, REL_INDEX_NAME, "ett", relId);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.applySetting((Setting<String>)FulltextSettings.fulltext_default_analyzer, SWEDISH);
        try (KernelTransactionImplementation ktx = this.getKernelTransaction();){
            SchemaRead schemaRead = ktx.schemaRead();
            this.await(schemaRead.indexGetForName(NODE_INDEX_NAME));
            FulltextAnalyzerTest.assertQueryFindsNothing((KernelTransaction)ktx, true, NODE_INDEX_NAME, "and");
            FulltextAnalyzerTest.assertQueryFindsNothing((KernelTransaction)ktx, true, NODE_INDEX_NAME, "in");
            FulltextAnalyzerTest.assertQueryFindsNothing((KernelTransaction)ktx, true, NODE_INDEX_NAME, "the");
            FulltextAnalyzerTest.assertQueryFindsIds((KernelTransaction)ktx, true, NODE_INDEX_NAME, "en", nodeId);
            FulltextAnalyzerTest.assertQueryFindsIds((KernelTransaction)ktx, true, NODE_INDEX_NAME, "och", nodeId);
            FulltextAnalyzerTest.assertQueryFindsIds((KernelTransaction)ktx, true, NODE_INDEX_NAME, "ett", nodeId);
            FulltextAnalyzerTest.assertQueryFindsNothing((KernelTransaction)ktx, false, REL_INDEX_NAME, "and");
            FulltextAnalyzerTest.assertQueryFindsNothing((KernelTransaction)ktx, false, REL_INDEX_NAME, "in");
            FulltextAnalyzerTest.assertQueryFindsNothing((KernelTransaction)ktx, false, REL_INDEX_NAME, "the");
            FulltextAnalyzerTest.assertQueryFindsIds((KernelTransaction)ktx, false, REL_INDEX_NAME, "en", relId);
            FulltextAnalyzerTest.assertQueryFindsIds((KernelTransaction)ktx, false, REL_INDEX_NAME, "och", relId);
            FulltextAnalyzerTest.assertQueryFindsIds((KernelTransaction)ktx, false, REL_INDEX_NAME, "ett", relId);
        }
    }

    private void createIndexes() {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().indexFor(LABEL).on("prop").withIndexType(IndexType.FULLTEXT).withName(NODE_INDEX_NAME).create();
            tx.schema().indexFor(RELTYPE).on("prop").withIndexType(IndexType.FULLTEXT).withName(REL_INDEX_NAME).create();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexOnline(NODE_INDEX_NAME, 1L, TimeUnit.MINUTES);
            tx.schema().awaitIndexOnline(REL_INDEX_NAME, 1L, TimeUnit.MINUTES);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }
}

