/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.kernel.api.impl.schema.DatabaseFunctions;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension
public class UniqueIndexApplicationIT {
    @Inject
    private GraphDatabaseAPI db;

    private static Stream<Function<Transaction, Void>> indexTypes() {
        return Stream.of(DatabaseFunctions.index(Label.label((String)"Label1"), "key1"), DatabaseFunctions.uniquenessConstraint(Label.label((String)"Label1"), "key1"));
    }

    @AfterEach
    void then() {
        try (Transaction transaction = this.db.beginTx();){
            ((ListAssert)Assertions.assertThat(UniqueIndexApplicationIT.listNodeIdsFromIndexLookup(transaction, Label.label((String)"Label1"), "key1", "value1").apply((GraphDatabaseService)this.db)).as("Matching nodes from index lookup", new Object[0])).hasSize(1);
        }
    }

    private void createIndex(Function<Transaction, Void> createIndexFunc) {
        try (Transaction tx = this.db.beginTx();){
            createIndexFunc.apply(tx);
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            DatabaseFunctions.awaitIndexesOnline(5L, TimeUnit.SECONDS).apply(tx);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"indexTypes"})
    void tx_createNode_addLabel_setProperty(Function<Transaction, Void> createIndexFunc) {
        this.createIndex(createIndexFunc);
        try (Transaction transaction = this.db.beginTx();){
            Node node = transaction.createNode();
            node.addLabel(Label.label((String)"Label1"));
            node.setProperty("key1", (Object)"value1");
            transaction.commit();
        }
    }

    @ParameterizedTest
    @MethodSource(value={"indexTypes"})
    void tx_createNode_tx_addLabel_setProperty(Function<Transaction, Void> createIndexFunc) {
        this.createIndex(createIndexFunc);
        try (Transaction transaction = this.db.beginTx();){
            Node node = transaction.createNode();
            node.addLabel(Label.label((String)"Label1"));
            node.setProperty("key1", (Object)"value1");
            transaction.commit();
        }
    }

    @ParameterizedTest
    @MethodSource(value={"indexTypes"})
    void tx_createNode_addLabel_tx_setProperty(Function<Transaction, Void> createIndexFunc) {
        Node node;
        this.createIndex(createIndexFunc);
        try (Transaction transaction = this.db.beginTx();){
            node = transaction.createNode();
            node.addLabel(Label.label((String)"Label1"));
            transaction.commit();
        }
        transaction = this.db.beginTx();
        try {
            transaction.getNodeById(node.getId()).setProperty("key1", (Object)"value1");
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"indexTypes"})
    void tx_createNode_setProperty_tx_addLabel(Function<Transaction, Void> createIndexFunc) {
        Node node;
        this.createIndex(createIndexFunc);
        try (Transaction transaction = this.db.beginTx();){
            node = transaction.createNode();
            node.addLabel(Label.label((String)"Label1"));
            node.setProperty("key1", (Object)"value1");
            transaction.commit();
        }
        transaction = this.db.beginTx();
        try {
            transaction.getNodeById(node.getId()).addLabel(Label.label((String)"Label1"));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"indexTypes"})
    void tx_createNode_tx_addLabel_tx_setProperty(Function<Transaction, Void> createIndexFunc) {
        Node node;
        this.createIndex(createIndexFunc);
        try (Transaction transaction = this.db.beginTx();){
            node = transaction.createNode();
            transaction.commit();
        }
        transaction = this.db.beginTx();
        try {
            transaction.getNodeById(node.getId()).addLabel(Label.label((String)"Label1"));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.db.beginTx();
        try {
            transaction.getNodeById(node.getId()).setProperty("key1", (Object)"value1");
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"indexTypes"})
    void tx_createNode_tx_setProperty_tx_addLabel(Function<Transaction, Void> createIndexFunc) {
        this.createIndex(createIndexFunc);
        try (Transaction transaction = this.db.beginTx();){
            Node node = transaction.createNode();
            node.setProperty("key1", (Object)"value1");
            node.addLabel(Label.label((String)"Label1"));
            transaction.commit();
        }
    }

    private static Function<GraphDatabaseService, List<Long>> listNodeIdsFromIndexLookup(Transaction tx, Label label, String propertyKey, Object value) {
        return graphDb -> {
            ArrayList<Long> ids = new ArrayList<Long>();
            for (Node node : Iterators.loop((Iterator)tx.findNodes(label, propertyKey, value))) {
                ids.add(node.getId());
            }
            return ids;
        };
    }
}

