/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.constraints;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.Inject;

@DbmsExtension
class ConstraintCreationIT {
    @Inject
    private GraphDatabaseAPI db;
    @Inject
    private IndexProviderMap indexProviderMap;
    private static final Label LABEL = Label.label((String)"label1");
    private long indexId;
    private long nbrIndexesOnStart;

    ConstraintCreationIT() {
    }

    @BeforeEach
    void setUp() {
        try (Transaction tx = this.db.beginTx();){
            this.nbrIndexesOnStart = Iterables.count((Iterable)tx.schema().getIndexes());
            this.indexId = this.nbrIndexesOnStart + 1L;
        }
    }

    @ExtensionCallback
    void configureLuceneSubProvider(TestDatabaseManagementServiceBuilder builder) {
        builder.setConfig(GraphDatabaseSettings.default_schema_provider, (Object)GraphDatabaseSettings.SchemaIndex.NATIVE30.providerName());
    }

    @Test
    @DbmsExtension(configurationCallback="configureLuceneSubProvider")
    void shouldNotLeaveLuceneIndexFilesHangingAroundIfConstraintCreationFails() {
        this.attemptAndFailConstraintCreation();
        IndexProvider indexProvider = this.indexProviderMap.getDefaultProvider();
        Path indexDir = indexProvider.directoryStructure().directoryForIndex(this.indexId);
        Assertions.assertFalse((boolean)Files.exists(indexDir, new LinkOption[0]));
    }

    @ParameterizedTest
    @EnumSource(value=IndexType.class, names={"RANGE", "BTREE"})
    void shouldNotLeaveNativeIndexFilesHangingAroundIfConstraintCreationFails(IndexType indexType) {
        this.attemptAndFailConstraintCreation(indexType);
        IndexProvider indexProvider = this.indexProviderMap.getDefaultProvider();
        Path indexDir = indexProvider.directoryStructure().directoryForIndex(this.indexId);
        Assertions.assertFalse((boolean)Files.exists(indexDir, new LinkOption[0]));
    }

    private void attemptAndFailConstraintCreation() {
        this.attemptAndFailConstraintCreation(IndexType.BTREE);
    }

    private void attemptAndFailConstraintCreation(IndexType indexType) {
        try (Transaction tx = this.db.beginTx();){
            for (int i = 0; i < 2; ++i) {
                Node node1 = tx.createNode(new Label[]{LABEL});
                node1.setProperty("prop", (Object)true);
            }
            tx.commit();
        }
        Assertions.assertThrows(ConstraintViolationException.class, () -> {
            try (Transaction tx = this.db.beginTx();){
                tx.schema().constraintFor(LABEL).assertPropertyIsUnique("prop").withIndexType(indexType).create();
                tx.commit();
            }
        });
        tx = this.db.beginTx();
        try {
            Assertions.assertEquals((long)this.nbrIndexesOnStart, (long)Iterables.count((Iterable)tx.schema().getIndexes()));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }
}

