/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.index.SetInitialStateInNativeIndex;
import org.neo4j.internal.kernel.api.IndexMonitor;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.monitoring.Monitors;
import org.neo4j.test.Barrier;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.TestLabels;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;

@Neo4jLayoutExtension
public class IndexCleanupIT {
    private static final String propertyKey = "key";
    @Inject
    private FileSystemAbstraction fs;
    @Inject
    private DatabaseLayout databaseLayout;
    private DatabaseManagementService managementService;
    private GraphDatabaseAPI db;

    @AfterEach
    void tearDown() {
        if (this.managementService != null) {
            this.managementService.shutdown();
        }
    }

    @ParameterizedTest
    @EnumSource(value=GraphDatabaseSettings.SchemaIndex.class)
    void mustClearIndexDirectoryOnDropWhileOnline(GraphDatabaseSettings.SchemaIndex schemaIndex) throws IOException {
        Path[] providerDirectories;
        this.configureDb(schemaIndex);
        IndexCleanupIT.createIndex((GraphDatabaseService)this.db, true);
        for (Path providerDirectory : providerDirectories = IndexCleanupIT.providerDirectories(this.fs, this.db)) {
            Assertions.assertTrue((this.fs.listFiles(providerDirectory).length > 0 ? 1 : 0) != 0, (String)"expected there to be at least one index per existing provider map");
        }
        this.dropAllIndexes();
        this.assertNoIndexFilesExisting(providerDirectories);
    }

    @ParameterizedTest
    @EnumSource(value=GraphDatabaseSettings.SchemaIndex.class)
    void mustClearIndexDirectoryOnDropWhileFailed(GraphDatabaseSettings.SchemaIndex schemaIndex) throws IOException {
        this.configureDb(schemaIndex);
        IndexCleanupIT.createIndex((GraphDatabaseService)this.db, true);
        IndexProviderDescriptor providerDescriptor = new IndexProviderDescriptor(schemaIndex.providerKey(), schemaIndex.providerVersion());
        SetInitialStateInNativeIndex setInitialStateInNativeIndex = new SetInitialStateInNativeIndex(0, providerDescriptor);
        this.restartDatabase(schemaIndex, setInitialStateInNativeIndex);
        try (Transaction tx = this.db.beginTx();){
            for (IndexDefinition index : tx.schema().getIndexes()) {
                if (index.getIndexType() == IndexType.LOOKUP) continue;
                Schema.IndexState indexState = tx.schema().getIndexState(index);
                Assertions.assertEquals((Object)Schema.IndexState.FAILED, (Object)indexState, (String)("expected index state to be " + Schema.IndexState.FAILED));
            }
            tx.commit();
        }
        this.dropAllIndexes();
        this.assertNoIndexFilesExisting(IndexCleanupIT.providerDirectories(this.fs, this.db));
    }

    @ParameterizedTest
    @EnumSource(value=GraphDatabaseSettings.SchemaIndex.class)
    void mustClearIndexDirectoryOnDropWhilePopulating(GraphDatabaseSettings.SchemaIndex schemaIndex) throws InterruptedException, IOException {
        Path[] providerDirectories;
        final Barrier.Control midPopulation = new Barrier.Control();
        IndexMonitor.MonitorAdapter trappingMonitor = new IndexMonitor.MonitorAdapter(){

            public void indexPopulationScanStarting() {
                midPopulation.reached();
            }
        };
        this.configureDb(schemaIndex);
        this.createSomeData();
        Monitors monitors = (Monitors)this.db.getDependencyResolver().resolveDependency(Monitors.class);
        monitors.addMonitorListener((Object)trappingMonitor, new String[0]);
        IndexCleanupIT.createIndex((GraphDatabaseService)this.db, false);
        midPopulation.await();
        for (Path providerDirectory : providerDirectories = IndexCleanupIT.providerDirectories(this.fs, this.db)) {
            Assertions.assertTrue((this.fs.listFiles(providerDirectory).length > 0 ? 1 : 0) != 0, (String)"expected there to be at least one index per existing provider map");
        }
        this.dropAllIndexes();
        midPopulation.release();
        this.assertNoIndexFilesExisting(providerDirectories);
    }

    private void assertNoIndexFilesExisting(Path[] providerDirectories) throws IOException {
        for (Path providerDirectory : providerDirectories) {
            Assertions.assertEquals((int)0, (int)this.fs.listFiles(providerDirectory).length, (String)"expected there to be no index files");
        }
    }

    private void dropAllIndexes() {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().getIndexes().forEach(IndexDefinition::drop);
            tx.commit();
        }
    }

    private void restartDatabase(GraphDatabaseSettings.SchemaIndex index, SetInitialStateInNativeIndex action) throws IOException {
        this.managementService.shutdown();
        action.run(this.fs, this.databaseLayout);
        this.configureDb(index);
    }

    private void configureDb(GraphDatabaseSettings.SchemaIndex schemaIndex) {
        this.managementService = new TestDatabaseManagementServiceBuilder(this.databaseLayout).setConfig(GraphDatabaseSettings.default_schema_provider, (Object)schemaIndex.providerName()).build();
        this.db = (GraphDatabaseAPI)this.managementService.database("neo4j");
    }

    private static void createIndex(GraphDatabaseService db, boolean awaitOnline) {
        try (Transaction tx = db.beginTx();){
            IndexDefinition indexDefinition = tx.schema().indexFor(TestLabels.LABEL_ONE).on(propertyKey).create();
            tx.commit();
        }
        if (awaitOnline) {
            tx = db.beginTx();
            try {
                tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
                tx.commit();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
    }

    private static Path[] providerDirectories(FileSystemAbstraction fs, GraphDatabaseAPI db) throws IOException {
        DatabaseLayout databaseLayout = db.databaseLayout();
        Path dbDir = databaseLayout.databaseDirectory();
        Path schemaDir = dbDir.resolve("schema");
        Path indexDir = schemaDir.resolve("index");
        return fs.listFiles(indexDir);
    }

    private void createSomeData() {
        try (Transaction tx = this.db.beginTx();){
            tx.createNode().setProperty(propertyKey, (Object)"abc");
            tx.commit();
        }
    }
}

