/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.common.EntityType;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.SchemaWrite;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.schema.FulltextSchemaDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.kernel.api.exceptions.schema.RepeatedLabelInSchemaException;
import org.neo4j.kernel.api.exceptions.schema.RepeatedPropertyInSchemaException;
import org.neo4j.kernel.api.exceptions.schema.RepeatedRelationshipTypeInSchemaException;
import org.neo4j.kernel.impl.api.index.IndexProviderNotFoundException;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;

public class IndexCreateIT
extends KernelIntegrationTest {
    private static final IndexCreator INDEX_CREATOR = (schemaWrite, schema, provider, name) -> schemaWrite.indexCreate(IndexPrototype.forSchema((SchemaDescriptor)schema).withIndexProvider(schemaWrite.indexProviderByName(provider)).withName(name));
    private static final IndexCreator UNIQUE_CONSTRAINT_CREATOR = (schemaWrite, schema, provider, name) -> schemaWrite.uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)schema, (IndexProviderDescriptor)schemaWrite.indexProviderByName(provider)).withName(name));

    @Test
    void shouldCreateIndexWithSpecificExistingProviderName() throws KernelException {
        this.shouldCreateWithSpecificExistingProviderName(INDEX_CREATOR);
    }

    @Test
    void shouldCreateUniquePropertyConstraintWithSpecificExistingProviderName() throws KernelException {
        this.shouldCreateWithSpecificExistingProviderName(UNIQUE_CONSTRAINT_CREATOR);
    }

    @Test
    void shouldFailCreateIndexWithNonExistentProviderName() throws KernelException {
        this.shouldFailWithNonExistentProviderName(INDEX_CREATOR);
    }

    @Test
    void shouldFailCreateUniquePropertyConstraintWithNonExistentProviderName() throws KernelException {
        this.shouldFailWithNonExistentProviderName(UNIQUE_CONSTRAINT_CREATOR);
    }

    @Test
    void shouldFailCreateIndexWithDuplicateLabels() throws KernelException {
        TokenWrite tokenWrite = this.tokenWriteInNewTransaction();
        int labelId = tokenWrite.labelGetOrCreateForName("Label");
        int propId = tokenWrite.propertyKeyGetOrCreateForName("property");
        this.commit();
        SchemaWrite schemaWrite = this.schemaWriteInNewTransaction();
        FulltextSchemaDescriptor descriptor = SchemaDescriptors.fulltext((EntityType)EntityType.NODE, (int[])new int[]{labelId, labelId}, (int[])new int[]{propId});
        Assertions.assertThrows(RepeatedLabelInSchemaException.class, () -> schemaWrite.indexCreate(IndexPrototype.forSchema((SchemaDescriptor)descriptor)));
    }

    @Test
    void shouldFailCreateIndexWithDuplicateRelationshipTypes() throws KernelException {
        TokenWrite tokenWrite = this.tokenWriteInNewTransaction();
        int relTypeId = tokenWrite.relationshipTypeGetOrCreateForName("RELATIONSHIP");
        int propId = tokenWrite.propertyKeyGetOrCreateForName("property");
        this.commit();
        SchemaWrite schemaWrite = this.schemaWriteInNewTransaction();
        FulltextSchemaDescriptor descriptor = SchemaDescriptors.fulltext((EntityType)EntityType.RELATIONSHIP, (int[])new int[]{relTypeId, relTypeId}, (int[])new int[]{propId});
        Assertions.assertThrows(RepeatedRelationshipTypeInSchemaException.class, () -> schemaWrite.indexCreate(IndexPrototype.forSchema((SchemaDescriptor)descriptor)));
    }

    @Test
    void shouldFailCreateIndexWithDuplicateProperties() throws KernelException {
        TokenWrite tokenWrite = this.tokenWriteInNewTransaction();
        int labelId = tokenWrite.labelGetOrCreateForName("Label");
        int propId = tokenWrite.propertyKeyGetOrCreateForName("property");
        this.commit();
        SchemaWrite schemaWrite = this.schemaWriteInNewTransaction();
        FulltextSchemaDescriptor descriptor = SchemaDescriptors.fulltext((EntityType)EntityType.NODE, (int[])new int[]{labelId}, (int[])new int[]{propId, propId});
        Assertions.assertThrows(RepeatedPropertyInSchemaException.class, () -> schemaWrite.indexCreate(IndexPrototype.forSchema((SchemaDescriptor)descriptor)));
    }

    protected void shouldFailWithNonExistentProviderName(IndexCreator creator) throws KernelException {
        TokenWrite tokenWrite = this.tokenWriteInNewTransaction();
        int labelId = tokenWrite.labelGetOrCreateForName("Label");
        int propId = tokenWrite.propertyKeyGetOrCreateForName("property");
        this.commit();
        SchemaWrite schemaWrite = this.schemaWriteInNewTransaction();
        Assertions.assertThrows(IndexProviderNotFoundException.class, () -> creator.create(schemaWrite, SchemaDescriptors.forLabel((int)labelId, (int[])new int[]{propId}), "something-completely-different", "index name"));
    }

    protected void shouldCreateWithSpecificExistingProviderName(IndexCreator creator) throws KernelException {
        int counter = 0;
        for (GraphDatabaseSettings.SchemaIndex indexSetting : GraphDatabaseSettings.SchemaIndex.values()) {
            TokenWrite tokenWrite = this.tokenWriteInNewTransaction();
            int labelId = tokenWrite.labelGetOrCreateForName("Label" + counter);
            int propId = tokenWrite.propertyKeyGetOrCreateForName("property");
            this.commit();
            SchemaWrite schemaWrite = this.schemaWriteInNewTransaction();
            LabelSchemaDescriptor descriptor = SchemaDescriptors.forLabel((int)labelId, (int[])new int[]{propId});
            String provider = indexSetting.providerName();
            String indexName = "index-" + counter;
            creator.create(schemaWrite, descriptor, provider, indexName);
            IndexDescriptor index = this.transaction.kernelTransaction().schemaRead().indexGetForName(indexName);
            this.commit();
            Assertions.assertEquals((Object)provider, (Object)this.indexingService.getIndexProxy(index).getDescriptor().getIndexProvider().name());
            ++counter;
        }
    }

    protected static interface IndexCreator {
        public void create(SchemaWrite var1, LabelSchemaDescriptor var2, String var3, String var4) throws KernelException;
    }
}

