/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.common.EntityType;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Label;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.TokenPredicate;
import org.neo4j.internal.kernel.api.TokenReadSession;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.Kernel;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
class NodeScanIT {
    @Inject
    private Kernel kernel;

    NodeScanIT() {
    }

    @Test
    void trackPageCacheAccessOnNodeLabelScan() throws KernelException {
        Label testLabel = Label.label((String)"testLabel");
        try (KernelTransaction tx = this.kernel.beginTransaction(KernelTransaction.Type.IMPLICIT, (LoginContext)AnonymousContext.read());){
            CursorContext cursorContext = tx.cursorContext();
            Assertions.assertThat((long)cursorContext.getCursorTracer().pins()).isZero();
            int label = tx.tokenRead().nodeLabel(testLabel.name());
            IndexDescriptor index = (IndexDescriptor)tx.schemaRead().index((SchemaDescriptor)SchemaDescriptors.forAnyEntityTokens((EntityType)EntityType.NODE)).next();
            TokenReadSession tokenReadSession = tx.dataRead().tokenReadSession(index);
            try (NodeLabelIndexCursor cursor = tx.cursors().allocateNodeLabelIndexCursor(cursorContext);){
                tx.dataRead().nodeLabelScan(tokenReadSession, cursor, IndexQueryConstraints.unconstrained(), new TokenPredicate(label), cursorContext);
                Assertions.assertThat((long)cursorContext.getCursorTracer().pins()).isNotZero();
            }
        }
    }
}

