/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.schema;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.kernel.impl.index.schema.config.SpatialIndexValueTestUtil;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.TestLabels;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;
import org.neo4j.values.storable.PointValue;

@TestDirectoryExtension
class UniqueSpatialIndexIT {
    private static final String KEY = "prop";
    @Inject
    private TestDirectory directory;
    private GraphDatabaseService db;
    private PointValue point1;
    private PointValue point2;
    private DatabaseManagementService managementService;

    UniqueSpatialIndexIT() {
    }

    @BeforeEach
    void setup() {
        Pair collidingPoints = SpatialIndexValueTestUtil.pointsWithSameValueOnSpaceFillingCurve((Config)Config.defaults());
        this.point1 = (PointValue)collidingPoints.first();
        this.point2 = (PointValue)collidingPoints.other();
    }

    @AfterEach
    void tearDown() {
        if (this.db != null) {
            this.managementService.shutdown();
        }
    }

    @ParameterizedTest
    @MethodSource(value={"providerSettings"})
    void shouldPopulateIndexWithUniquePointsThatCollideOnSpaceFillingCurve(GraphDatabaseSettings.SchemaIndex schemaIndex) {
        this.setupDb(schemaIndex);
        Pair<Long, Long> nodeIds = this.createUniqueNodes();
        this.createUniquenessConstraint();
        this.assertBothNodesArePresent(nodeIds);
    }

    @ParameterizedTest
    @MethodSource(value={"providerSettings"})
    void shouldAddPointsThatCollideOnSpaceFillingCurveToUniqueIndexInSameTx(GraphDatabaseSettings.SchemaIndex schemaIndex) {
        this.setupDb(schemaIndex);
        this.createUniquenessConstraint();
        Pair<Long, Long> nodeIds = this.createUniqueNodes();
        this.assertBothNodesArePresent(nodeIds);
    }

    @ParameterizedTest
    @MethodSource(value={"providerSettings"})
    void shouldThrowWhenPopulatingWithNonUniquePoints(GraphDatabaseSettings.SchemaIndex schemaIndex) {
        this.setupDb(schemaIndex);
        this.createNonUniqueNodes();
        Assertions.assertThrows(ConstraintViolationException.class, this::createUniquenessConstraint);
    }

    @ParameterizedTest
    @MethodSource(value={"providerSettings"})
    void shouldThrowWhenAddingNonUniquePoints(GraphDatabaseSettings.SchemaIndex schemaIndex) {
        this.setupDb(schemaIndex);
        this.createUniquenessConstraint();
        Assertions.assertThrows(ConstraintViolationException.class, this::createNonUniqueNodes);
    }

    private static Stream<GraphDatabaseSettings.SchemaIndex> providerSettings() {
        return Arrays.stream(GraphDatabaseSettings.SchemaIndex.values());
    }

    private void createNonUniqueNodes() {
        try (Transaction tx = this.db.beginTx();){
            Node originNode = tx.createNode(new Label[]{TestLabels.LABEL_ONE});
            originNode.setProperty(KEY, (Object)this.point1);
            Node centerNode = tx.createNode(new Label[]{TestLabels.LABEL_ONE});
            centerNode.setProperty(KEY, (Object)this.point1);
            tx.commit();
        }
    }

    private Pair<Long, Long> createUniqueNodes() {
        Pair nodeIds;
        try (Transaction tx = this.db.beginTx();){
            Node originNode = tx.createNode(new Label[]{TestLabels.LABEL_ONE});
            originNode.setProperty(KEY, (Object)this.point1);
            Node centerNode = tx.createNode(new Label[]{TestLabels.LABEL_ONE});
            centerNode.setProperty(KEY, (Object)this.point2);
            nodeIds = Pair.of((Object)originNode.getId(), (Object)centerNode.getId());
            tx.commit();
        }
        return nodeIds;
    }

    private void assertBothNodesArePresent(Pair<Long, Long> nodeIds) {
        try (Transaction tx = this.db.beginTx();){
            ResourceIterator origin = tx.findNodes(TestLabels.LABEL_ONE, KEY, (Object)this.point1);
            Assertions.assertTrue((boolean)origin.hasNext());
            Assertions.assertEquals((long)((Long)nodeIds.first()), (long)((Node)origin.next()).getId());
            Assertions.assertFalse((boolean)origin.hasNext());
            ResourceIterator center = tx.findNodes(TestLabels.LABEL_ONE, KEY, (Object)this.point2);
            Assertions.assertTrue((boolean)center.hasNext());
            Assertions.assertEquals((long)((Long)nodeIds.other()), (long)((Node)center.next()).getId());
            Assertions.assertFalse((boolean)center.hasNext());
            tx.commit();
        }
    }

    private void createUniquenessConstraint() {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().constraintFor(TestLabels.LABEL_ONE).assertPropertyIsUnique(KEY).create();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private void setupDb(GraphDatabaseSettings.SchemaIndex schemaIndex) {
        this.managementService = new TestDatabaseManagementServiceBuilder(this.directory.homePath()).setConfig(GraphDatabaseSettings.default_schema_provider, (Object)schemaIndex.providerName()).build();
        this.db = this.managementService.database("neo4j");
    }
}

