/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.api.impl.fulltext.FulltextProceduresTestSupport;

class FulltextIndexSkipAndLimitTest
extends FulltextProceduresTestSupport {
    private long topEntity;
    private long middleEntity;
    private long bottomEntity;

    FulltextIndexSkipAndLimitTest() {
    }

    private void setUp(FulltextProceduresTestSupport.EntityUtil entityUtil) {
        this.createIndexAndWait(entityUtil);
        try (Transaction tx = this.db.beginTx();){
            this.topEntity = entityUtil.createEntityWithProperty(tx, "zebra zebra zebra zebra donkey");
            this.middleEntity = entityUtil.createEntityWithProperty(tx, "zebra zebra zebra donkey");
            this.bottomEntity = entityUtil.createEntityWithProperty(tx, "zebra donkey");
            tx.commit();
        }
    }

    @MethodSource(value={"entityTypeProvider"})
    @ParameterizedTest
    void queryEntitiesMustApplySkip(FulltextProceduresTestSupport.EntityUtil entityUtil) {
        this.setUp(entityUtil);
        try (Transaction tx = this.db.beginTx();
             ResourceIterator<Entity> iterator = entityUtil.queryIndexWithOptions(tx, "zebra", "{skip:1}");){
            Assertions.assertThat((long)((Entity)iterator.next()).getId()).isEqualTo(this.middleEntity);
            Assertions.assertThat((long)((Entity)iterator.next()).getId()).isEqualTo(this.bottomEntity);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)iterator.hasNext());
            tx.commit();
        }
    }

    @MethodSource(value={"entityTypeProvider"})
    @ParameterizedTest
    void queryEntitiesMustApplyLimit(FulltextProceduresTestSupport.EntityUtil entityUtil) {
        this.setUp(entityUtil);
        try (Transaction tx = this.db.beginTx();
             ResourceIterator<Entity> iterator = entityUtil.queryIndexWithOptions(tx, "zebra", "{limit:1}");){
            Assertions.assertThat((long)((Entity)iterator.next()).getId()).isEqualTo(this.topEntity);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)iterator.hasNext());
            tx.commit();
        }
    }

    @MethodSource(value={"entityTypeProvider"})
    @ParameterizedTest
    void queryEntitiesMustApplySkipAndLimit(FulltextProceduresTestSupport.EntityUtil entityUtil) {
        this.setUp(entityUtil);
        try (Transaction tx = this.db.beginTx();
             ResourceIterator<Entity> iterator = entityUtil.queryIndexWithOptions(tx, "zebra", "{skip:1, limit:1}");){
            Assertions.assertThat((long)((Entity)iterator.next()).getId()).isEqualTo(this.middleEntity);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)iterator.hasNext());
            tx.commit();
        }
    }

    @MethodSource(value={"entityTypeProvider"})
    @ParameterizedTest
    void queryEntitiesWithSkipAndLimitMustIgnoreEntitiesDeletedInTransaction(FulltextProceduresTestSupport.EntityUtil entityUtil) {
        this.setUp(entityUtil);
        try (Transaction tx = this.db.beginTx();){
            entityUtil.deleteEntity(tx, this.topEntity);
            try (ResourceIterator<Entity> iterator = entityUtil.queryIndexWithOptions(tx, "zebra", "{skip:1}");){
                Assertions.assertThat((long)((Entity)iterator.next()).getId()).isEqualTo(this.bottomEntity);
                org.junit.jupiter.api.Assertions.assertFalse((boolean)iterator.hasNext());
            }
            iterator = entityUtil.queryIndexWithOptions(tx, "zebra", "{limit:1}");
            try {
                Assertions.assertThat((long)((Entity)iterator.next()).getId()).isEqualTo(this.middleEntity);
                org.junit.jupiter.api.Assertions.assertFalse((boolean)iterator.hasNext());
            }
            finally {
                if (iterator != null) {
                    iterator.close();
                }
            }
            tx.commit();
        }
    }

    @MethodSource(value={"entityTypeProvider"})
    @ParameterizedTest
    void queryEntitiesWithSkipAndLimitMustIncludeEntitiesAddedInTransaction(FulltextProceduresTestSupport.EntityUtil entityUtil) {
        this.setUp(entityUtil);
        try (Transaction tx = this.db.beginTx();){
            long entityId = entityUtil.createEntityWithProperty(tx, "zebra zebra donkey");
            try (ResourceIterator<Entity> iterator = entityUtil.queryIndexWithOptions(tx, "zebra", "{skip:1, limit:2}");){
                Assertions.assertThat((long)((Entity)iterator.next()).getId()).isEqualTo(this.middleEntity);
                Assertions.assertThat((long)((Entity)iterator.next()).getId()).isEqualTo(entityId);
                org.junit.jupiter.api.Assertions.assertFalse((boolean)iterator.hasNext());
            }
            tx.commit();
        }
    }
}

