/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.index.internal.gbptree.TreeNodeDynamicSize;
import org.neo4j.kernel.api.impl.schema.StringLengthIndexValidationIT;
import org.neo4j.kernel.impl.index.schema.IndexEntryTestUtil;
import org.neo4j.test.RandomSupport;

public class GenericStringLengthIndexValidationIT
extends StringLengthIndexValidationIT {
    @Override
    protected int getSingleKeySizeLimit() {
        return TreeNodeDynamicSize.keyValueSizeCapFromPageSize((int)8192);
    }

    @Override
    protected String getString(RandomSupport random, int keySize) {
        return IndexEntryTestUtil.generateStringResultingInIndexEntrySize((int)keySize);
    }

    @Override
    protected GraphDatabaseSettings.SchemaIndex getSchemaIndex() {
        return GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10;
    }

    @Override
    protected String expectedPopulationFailureCauseMessage(long indexId, long entityId) {
        return String.format("Property value is too large to index, please see index documentation for limitations. Index: Index( id=%d, name='index_71616483', type='GENERAL BTREE', schema=(:LABEL_ONE {largeString}), indexProvider='native-btree-1.0' ), entity id: %d", indexId, entityId);
    }
}

