/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.constraints;

import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.IndexMonitor;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.io.fs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.coreapi.schema.IndexDefinitionImpl;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.monitoring.Monitors;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@EphemeralTestDirectoryExtension
class ConstraintRecoveryIT {
    private static final String KEY = "prop";
    private static final Label LABEL = Label.label((String)"label1");
    @Inject
    private EphemeralFileSystemAbstraction fs;
    @Inject
    private TestDirectory testDirectory;
    private GraphDatabaseAPI db;

    ConstraintRecoveryIT() {
    }

    @Test
    void shouldHaveAvailableOrphanedConstraintIndexIfUniqueConstraintCreationFails() {
        Path pathToDb = this.testDirectory.homePath();
        TestDatabaseManagementServiceBuilder dbFactory = new TestDatabaseManagementServiceBuilder(pathToDb);
        dbFactory.setFileSystem((FileSystemAbstraction)this.fs);
        final EphemeralFileSystemAbstraction[] storeInNeedOfRecovery = new EphemeralFileSystemAbstraction[1];
        final AtomicBoolean monitorCalled = new AtomicBoolean(false);
        Monitors monitors = new Monitors();
        monitors.addMonitorListener((Object)new IndexMonitor.MonitorAdapter(){

            public void indexPopulationScanComplete() {
                monitorCalled.set(true);
                ((RecordStorageEngine)ConstraintRecoveryIT.this.db.getDependencyResolver().resolveDependency(RecordStorageEngine.class)).testAccessNeoStores().getSchemaStore().flush(CursorContext.NULL);
                storeInNeedOfRecovery[0] = ConstraintRecoveryIT.this.fs.snapshot();
            }
        }, new String[0]);
        dbFactory.setMonitors(monitors);
        DatabaseManagementService managementService = this.configure(dbFactory.impermanent().setConfig(GraphDatabaseSettings.default_schema_provider, (Object)GraphDatabaseSettings.SchemaIndex.NATIVE30.providerName())).build();
        this.db = (GraphDatabaseAPI)managementService.database("neo4j");
        try (Transaction tx = this.db.beginTx();){
            for (int i = 0; i < 2; ++i) {
                tx.createNode(new Label[]{LABEL}).setProperty(KEY, (Object)"true");
            }
            tx.commit();
        }
        Assertions.assertThrows(ConstraintViolationException.class, () -> {
            try (Transaction tx = this.db.beginTx();){
                tx.schema().constraintFor(LABEL).assertPropertyIsUnique(KEY).create();
            }
        });
        managementService.shutdown();
        Assertions.assertTrue((boolean)monitorCalled.get());
        dbFactory = new TestDatabaseManagementServiceBuilder(pathToDb);
        dbFactory.setFileSystem((FileSystemAbstraction)storeInNeedOfRecovery[0]);
        DatabaseManagementService secondManagementService = this.configure(dbFactory.impermanent()).build();
        this.db = (GraphDatabaseAPI)secondManagementService.database("neo4j");
        IndexingService indexingService = (IndexingService)this.db.getDependencyResolver().resolveDependency(IndexingService.class);
        try (Transaction tx = this.db.beginTx();){
            tx.schema().getIndexes().forEach(index -> {
                try {
                    IndexProxy proxy = indexingService.getIndexProxy(((IndexDefinitionImpl)index).getIndexReference());
                    proxy.awaitStoreScanCompleted(10L, TimeUnit.MINUTES);
                }
                catch (InterruptedException | IndexNotFoundKernelException | IndexPopulationFailedKernelException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        try (Transaction transaction = this.db.beginTx();){
            Assertions.assertEquals((long)2L, (long)Iterables.count((Iterable)transaction.getAllNodes()));
        }
        tx = this.db.beginTx();
        try {
            Assertions.assertEquals((long)0L, (long)Iterables.count((Iterable)Iterables.asList((Iterable)tx.schema().getConstraints())));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            IndexDefinition orphanedConstraintIndex = (IndexDefinition)Iterables.single((Iterable)tx.schema().getIndexes(LABEL));
            Assertions.assertEquals((Object)LABEL.name(), (Object)((Label)Iterables.single((Iterable)orphanedConstraintIndex.getLabels())).name());
            Assertions.assertEquals((Object)KEY, (Object)Iterables.single((Iterable)orphanedConstraintIndex.getPropertyKeys()));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        secondManagementService.shutdown();
    }

    protected TestDatabaseManagementServiceBuilder configure(TestDatabaseManagementServiceBuilder builder) {
        return builder;
    }
}

