/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.checking.full.ConsistencyFlags;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.api.DatabaseManagementServiceBuilder;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.internal.recordstorage.RecordCursorTypes;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexProceduresUtil;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.coreapi.schema.IndexDefinitionImpl;
import org.neo4j.kernel.impl.index.schema.FailingGenericNativeIndexProviderFactory;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.cursor.CachedStoreCursors;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.cursor.CursorType;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.values.storable.RandomValues;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@Neo4jLayoutExtension
@ExtendWith(value={RandomExtension.class})
class FulltextIndexConsistencyCheckIT {
    @Inject
    private FileSystemAbstraction fs;
    @Inject
    private DatabaseLayout databaseLayout;
    @Inject
    private RandomSupport random;
    private DatabaseManagementServiceBuilder builder;
    private GraphDatabaseService database;
    private DatabaseManagementService managementService;

    FulltextIndexConsistencyCheckIT() {
    }

    @BeforeEach
    void before() {
        this.builder = new TestDatabaseManagementServiceBuilder(this.databaseLayout);
    }

    @AfterEach
    void tearDown() {
        if (this.database != null) {
            this.managementService.shutdown();
        }
    }

    @Test
    void mustBeAbleToConsistencyCheckEmptyDatabaseWithWithEmptyFulltextIndexes() throws Exception {
        GraphDatabaseService db = this.createDatabase();
        try (Transaction tx = db.beginTx();){
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "nodes", FulltextIndexProceduresUtil.asStrList((String[])new String[]{"Label"}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"prop"}))).close();
            tx.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", "rels", FulltextIndexProceduresUtil.asStrList((String[])new String[]{"R1"}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"p1"}))).close();
            tx.commit();
        }
        tx = db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.managementService.shutdown();
        FulltextIndexConsistencyCheckIT.assertIsConsistent(this.checkConsistency());
    }

    @Test
    void mustBeAbleToConsistencyCheckNodeIndexWithOneLabelAndOneProperty() throws Exception {
        GraphDatabaseService db = this.createDatabase();
        try (Transaction tx = db.beginTx();){
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "nodes", FulltextIndexProceduresUtil.asStrList((String[])new String[]{"Label"}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"prop"}))).close();
            tx.commit();
        }
        tx = db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
            tx.createNode(new Label[]{Label.label((String)"Label")}).setProperty("prop", (Object)"value");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.managementService.shutdown();
        FulltextIndexConsistencyCheckIT.assertIsConsistent(this.checkConsistency());
    }

    @Test
    void mustBeAbleToConsistencyCheckNodeIndexWithOneLabelAndMultipleProperties() throws Exception {
        GraphDatabaseService db = this.createDatabase();
        try (Transaction tx = db.beginTx();){
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "nodes", FulltextIndexProceduresUtil.asStrList((String[])new String[]{"Label"}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"p1", "p2"}))).close();
            tx.commit();
        }
        tx = db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
            Node node = tx.createNode(new Label[]{Label.label((String)"Label")});
            node.setProperty("p1", (Object)"value");
            node.setProperty("p2", (Object)"value");
            tx.createNode(new Label[]{Label.label((String)"Label")}).setProperty("p1", (Object)"value");
            tx.createNode(new Label[]{Label.label((String)"Label")}).setProperty("p2", (Object)"value");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.managementService.shutdown();
        FulltextIndexConsistencyCheckIT.assertIsConsistent(this.checkConsistency());
    }

    @Test
    void mustBeAbleToConsistencyCheckNodeIndexWithMultipleLabelsAndOneProperty() throws Exception {
        GraphDatabaseService db = this.createDatabase();
        try (Transaction tx = db.beginTx();){
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "nodes", FulltextIndexProceduresUtil.asStrList((String[])new String[]{"L1", "L2"}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"prop"}))).close();
            tx.commit();
        }
        tx = db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
            tx.createNode(new Label[]{Label.label((String)"L1"), Label.label((String)"L2")}).setProperty("prop", (Object)"value");
            tx.createNode(new Label[]{Label.label((String)"L2")}).setProperty("prop", (Object)"value");
            tx.createNode(new Label[]{Label.label((String)"L1")}).setProperty("prop", (Object)"value");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.managementService.shutdown();
        FulltextIndexConsistencyCheckIT.assertIsConsistent(this.checkConsistency());
    }

    @Test
    void mustBeAbleToConsistencyCheckNodeIndexWithManyLabelsAndOneProperty() throws Exception {
        GraphDatabaseService db = this.createDatabase();
        String[] labels = new String[]{"L1", "L2", "L3", "L4", "L5", "L6", "L7", "L8", "L9", "L10", "L11", "L12", "L13", "L14", "L15", "L16"};
        try (Transaction tx = db.beginTx();){
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "nodes", FulltextIndexProceduresUtil.asStrList((String[])labels), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"prop"}))).close();
            tx.commit();
        }
        tx = db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
            tx.createNode((Label[])Stream.of(labels).map(Label::label).toArray(Label[]::new)).setProperty("prop", (Object)"value");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.managementService.shutdown();
        FulltextIndexConsistencyCheckIT.assertIsConsistent(this.checkConsistency());
    }

    @Test
    void mustBeAbleToConsistencyCheckNodeIndexWithMultipleLabelsAndMultipleProperties() throws Exception {
        GraphDatabaseService db = this.createDatabase();
        try (Transaction tx = db.beginTx();){
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "nodes", FulltextIndexProceduresUtil.asStrList((String[])new String[]{"L1", "L2"}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"p1", "p2"}))).close();
            tx.commit();
        }
        tx = db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
            Node n1 = tx.createNode(new Label[]{Label.label((String)"L1"), Label.label((String)"L2")});
            n1.setProperty("p1", (Object)"value");
            n1.setProperty("p2", (Object)"value");
            Node n2 = tx.createNode(new Label[]{Label.label((String)"L1"), Label.label((String)"L2")});
            n2.setProperty("p1", (Object)"value");
            Node n3 = tx.createNode(new Label[]{Label.label((String)"L1"), Label.label((String)"L2")});
            n3.setProperty("p2", (Object)"value");
            Node n4 = tx.createNode(new Label[]{Label.label((String)"L1")});
            n4.setProperty("p1", (Object)"value");
            n4.setProperty("p2", (Object)"value");
            Node n5 = tx.createNode(new Label[]{Label.label((String)"L1")});
            n5.setProperty("p1", (Object)"value");
            Node n6 = tx.createNode(new Label[]{Label.label((String)"L1")});
            n6.setProperty("p2", (Object)"value");
            Node n7 = tx.createNode(new Label[]{Label.label((String)"L2")});
            n7.setProperty("p1", (Object)"value");
            n7.setProperty("p2", (Object)"value");
            Node n8 = tx.createNode(new Label[]{Label.label((String)"L2")});
            n8.setProperty("p1", (Object)"value");
            Node n9 = tx.createNode(new Label[]{Label.label((String)"L2")});
            n9.setProperty("p2", (Object)"value");
            tx.createNode(new Label[]{Label.label((String)"L2")}).setProperty("p1", (Object)"value");
            tx.createNode(new Label[]{Label.label((String)"L2")}).setProperty("p2", (Object)"value");
            tx.createNode(new Label[]{Label.label((String)"L1")}).setProperty("p1", (Object)"value");
            tx.createNode(new Label[]{Label.label((String)"L1")}).setProperty("p2", (Object)"value");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.managementService.shutdown();
        FulltextIndexConsistencyCheckIT.assertIsConsistent(this.checkConsistency());
    }

    @Test
    void mustBeAbleToConsistencyCheckRelationshipIndexWithOneRelationshipTypeAndOneProperty() throws Exception {
        GraphDatabaseService db = this.createDatabase();
        RelationshipType relationshipType = RelationshipType.withName((String)"R1");
        try (Transaction tx = db.beginTx();){
            tx.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", "rels", FulltextIndexProceduresUtil.asStrList((String[])new String[]{"R1"}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"p1"}))).close();
            tx.commit();
        }
        tx = db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
            Node node = tx.createNode();
            node.createRelationshipTo(node, relationshipType).setProperty("p1", (Object)"value");
            node.createRelationshipTo(node, relationshipType).setProperty("p1", (Object)"value");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.managementService.shutdown();
        FulltextIndexConsistencyCheckIT.assertIsConsistent(this.checkConsistency());
    }

    @Test
    void mustBeAbleToConsistencyCheckRelationshipIndexWithOneRelationshipTypeAndMultipleProperties() throws Exception {
        GraphDatabaseService db = this.createDatabase();
        RelationshipType relationshipType = RelationshipType.withName((String)"R1");
        try (Transaction tx = db.beginTx();){
            tx.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", "rels", FulltextIndexProceduresUtil.asStrList((String[])new String[]{"R1"}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"p1", "p2"}))).close();
            tx.commit();
        }
        tx = db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
            Node node = tx.createNode();
            Relationship r1 = node.createRelationshipTo(node, relationshipType);
            r1.setProperty("p1", (Object)"value");
            r1.setProperty("p2", (Object)"value");
            Relationship r2 = node.createRelationshipTo(node, relationshipType);
            r2.setProperty("p1", (Object)"value");
            r2.setProperty("p2", (Object)"value");
            node.createRelationshipTo(node, relationshipType).setProperty("p1", (Object)"value");
            node.createRelationshipTo(node, relationshipType).setProperty("p2", (Object)"value");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.managementService.shutdown();
        FulltextIndexConsistencyCheckIT.assertIsConsistent(this.checkConsistency());
    }

    @Test
    void mustBeAbleToConsistencyCheckRelationshipIndexWithMultipleRelationshipTypesAndOneProperty() throws Exception {
        GraphDatabaseService db = this.createDatabase();
        RelationshipType relType1 = RelationshipType.withName((String)"R1");
        RelationshipType relType2 = RelationshipType.withName((String)"R2");
        try (Transaction tx = db.beginTx();){
            tx.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", "rels", FulltextIndexProceduresUtil.asStrList((String[])new String[]{"R1", "R2"}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"p1"}))).close();
            tx.commit();
        }
        tx = db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
            Node n1 = tx.createNode();
            Node n2 = tx.createNode();
            n1.createRelationshipTo(n1, relType1).setProperty("p1", (Object)"value");
            n1.createRelationshipTo(n1, relType2).setProperty("p1", (Object)"value");
            n2.createRelationshipTo(n2, relType1).setProperty("p1", (Object)"value");
            n2.createRelationshipTo(n2, relType2).setProperty("p1", (Object)"value");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.managementService.shutdown();
        FulltextIndexConsistencyCheckIT.assertIsConsistent(this.checkConsistency());
    }

    @Test
    void mustBeAbleToConsistencyCheckRelationshipIndexWithMultipleRelationshipTypesAndMultipleProperties() throws Exception {
        GraphDatabaseService db = this.createDatabase();
        RelationshipType relType1 = RelationshipType.withName((String)"R1");
        RelationshipType relType2 = RelationshipType.withName((String)"R2");
        try (Transaction tx = db.beginTx();){
            tx.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", "rels", FulltextIndexProceduresUtil.asStrList((String[])new String[]{"R1", "R2"}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"p1", "p2"}))).close();
            tx.commit();
        }
        tx = db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
            Node n1 = tx.createNode();
            Node n2 = tx.createNode();
            Relationship r1 = n1.createRelationshipTo(n1, relType1);
            r1.setProperty("p1", (Object)"value");
            r1.setProperty("p2", (Object)"value");
            Relationship r2 = n1.createRelationshipTo(n1, relType2);
            r2.setProperty("p1", (Object)"value");
            r2.setProperty("p2", (Object)"value");
            Relationship r3 = n2.createRelationshipTo(n2, relType1);
            r3.setProperty("p1", (Object)"value");
            r3.setProperty("p2", (Object)"value");
            Relationship r4 = n2.createRelationshipTo(n2, relType2);
            r4.setProperty("p1", (Object)"value");
            r4.setProperty("p2", (Object)"value");
            n1.createRelationshipTo(n2, relType1).setProperty("p1", (Object)"value");
            n1.createRelationshipTo(n2, relType2).setProperty("p1", (Object)"value");
            n1.createRelationshipTo(n2, relType1).setProperty("p2", (Object)"value");
            n1.createRelationshipTo(n2, relType2).setProperty("p2", (Object)"value");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.managementService.shutdown();
        FulltextIndexConsistencyCheckIT.assertIsConsistent(this.checkConsistency());
    }

    @Test
    void mustBeAbleToConsistencyCheckNodeAndRelationshipIndexesAtTheSameTime() throws Exception {
        GraphDatabaseService db = this.createDatabase();
        try (Transaction tx = db.beginTx();){
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "nodes", FulltextIndexProceduresUtil.asStrList((String[])new String[]{"L1", "L2", "L3"}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"p1", "p2"}))).close();
            tx.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", "rels", FulltextIndexProceduresUtil.asStrList((String[])new String[]{"R1", "R2"}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"p1", "p2"}))).close();
            tx.commit();
        }
        tx = db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
            Node n1 = tx.createNode(new Label[]{Label.label((String)"L1"), Label.label((String)"L3")});
            n1.setProperty("p1", (Object)"value");
            n1.setProperty("p2", (Object)"value");
            n1.createRelationshipTo(n1, RelationshipType.withName((String)"R2")).setProperty("p1", (Object)"value");
            Node n2 = tx.createNode(new Label[]{Label.label((String)"L2")});
            n2.setProperty("p2", (Object)"value");
            Relationship r1 = n2.createRelationshipTo(n2, RelationshipType.withName((String)"R1"));
            r1.setProperty("p1", (Object)"value");
            r1.setProperty("p2", (Object)"value");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.managementService.shutdown();
        FulltextIndexConsistencyCheckIT.assertIsConsistent(this.checkConsistency());
    }

    @Test
    void mustBeAbleToConsistencyCheckNodeIndexThatIsMissingNodesBecauseTheirPropertyValuesAreNotStrings() throws Exception {
        GraphDatabaseService db = this.createDatabase();
        try (Transaction tx = db.beginTx();){
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "nodes", FulltextIndexProceduresUtil.asStrList((String[])new String[]{"L1"}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"p1"}))).close();
            tx.commit();
        }
        tx = db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
            tx.createNode(new Label[]{Label.label((String)"L1")}).setProperty("p1", (Object)1);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.managementService.shutdown();
        FulltextIndexConsistencyCheckIT.assertIsConsistent(this.checkConsistency());
    }

    @Test
    void mustBeAbleToConsistencyCheckRelationshipIndexThatIsMissingRelationshipsBecauseTheirPropertyValuesAreNotStrings() throws Exception {
        GraphDatabaseService db = this.createDatabase();
        try (Transaction tx = db.beginTx();){
            tx.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", "rels", FulltextIndexProceduresUtil.asStrList((String[])new String[]{"R1"}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"p1"}))).close();
            tx.commit();
        }
        tx = db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
            Node node = tx.createNode();
            node.createRelationshipTo(node, RelationshipType.withName((String)"R1")).setProperty("p1", (Object)1);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.managementService.shutdown();
        FulltextIndexConsistencyCheckIT.assertIsConsistent(this.checkConsistency());
    }

    @Test
    void consistencyCheckerMustBeAbleToRunOnStoreWithFulltextIndexes() throws Exception {
        GraphDatabaseService db = this.createDatabase();
        Label[] labels = (Label[])IntStream.range(1, 7).mapToObj(i -> Label.label((String)("LABEL" + i))).toArray(Label[]::new);
        RelationshipType[] relTypes = (RelationshipType[])IntStream.range(1, 5).mapToObj(i -> RelationshipType.withName((String)("REL" + i))).toArray(RelationshipType[]::new);
        String[] propertyKeys = (String[])IntStream.range(1, 7).mapToObj(i -> "PROP" + i).toArray(String[]::new);
        RandomValues randomValues = this.random.randomValues();
        try (Transaction tx = db.beginTx();){
            int nodeCount = 1000;
            ArrayList<Node> nodes = new ArrayList<Node>(nodeCount);
            for (int i2 = 0; i2 < nodeCount; ++i2) {
                Label[] nodeLabels = (Label[])this.random.ints((long)this.random.nextInt(labels.length), 0, labels.length).distinct().mapToObj(x -> labels[x]).toArray(Label[]::new);
                Node node = tx.createNode(nodeLabels);
                Stream.of(propertyKeys).forEach(p -> node.setProperty(p, this.random.nextBoolean() ? p : randomValues.nextValue().asObject()));
                nodes.add(node);
                int localRelCount = Math.min(nodes.size(), 5);
                this.random.ints((long)localRelCount, 0, localRelCount).distinct().mapToObj(x -> node.createRelationshipTo((Node)nodes.get(x), relTypes[this.random.nextInt(relTypes.length)])).forEach(r -> Stream.of(propertyKeys).forEach(p -> r.setProperty(p, this.random.nextBoolean() ? p : randomValues.nextValue().asObject())));
            }
            tx.commit();
        }
        tx = db.beginTx();
        try {
            int i3;
            for (i3 = 1; i3 < labels.length; ++i3) {
                tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "nodes" + i3, FulltextIndexProceduresUtil.asStrList((String[])((String[])Arrays.stream(labels).limit(i3).map(Label::name).toArray(String[]::new))), FulltextIndexProceduresUtil.asStrList((String[])Arrays.copyOf(propertyKeys, i3)))).close();
            }
            for (i3 = 1; i3 < relTypes.length; ++i3) {
                tx.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", "rels" + i3, FulltextIndexProceduresUtil.asStrList((String[])((String[])Arrays.stream(relTypes).limit(i3).map(RelationshipType::name).toArray(String[]::new))), FulltextIndexProceduresUtil.asStrList((String[])Arrays.copyOf(propertyKeys, i3)))).close();
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.managementService.shutdown();
        FulltextIndexConsistencyCheckIT.assertIsConsistent(this.checkConsistency());
    }

    @Test
    void mustDiscoverNodeInStoreMissingFromIndex() throws Exception {
        long nodeId;
        IndexDescriptor indexDescriptor;
        GraphDatabaseService db = this.createDatabase();
        try (Transaction tx = db.beginTx();){
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "nodes", FulltextIndexProceduresUtil.asStrList((String[])new String[]{"Label"}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"prop"}))).close();
            tx.commit();
        }
        try (Transaction tx = db.beginTx();){
            tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
            indexDescriptor = FulltextIndexConsistencyCheckIT.getFulltextIndexDescriptor(tx.schema().getIndexes());
            Node node = tx.createNode(new Label[]{Label.label((String)"Label")});
            node.setProperty("prop", (Object)"value");
            nodeId = node.getId();
            tx.commit();
        }
        IndexingService indexes = FulltextIndexConsistencyCheckIT.getIndexingService(db);
        IndexProxy indexProxy = indexes.getIndexProxy(indexDescriptor);
        try (IndexUpdater updater = indexProxy.newUpdater(IndexUpdateMode.ONLINE, CursorContext.NULL);){
            updater.process((IndexEntryUpdate)IndexEntryUpdate.remove((long)nodeId, (SchemaDescriptorSupplier)indexDescriptor, (Value[])new Value[]{Values.stringValue((String)"value")}));
        }
        this.managementService.shutdown();
        ConsistencyCheckService.Result result = this.checkConsistency();
        Assertions.assertFalse((boolean)result.isSuccessful());
    }

    @Disabled(value="Turns out that this is not something that the consistency checker actually looks for, currently. The test is disabled until the consistency checker is extended with checks that will discover this sort of inconsistency.")
    @Test
    void mustDiscoverNodeInIndexMissingFromStore() throws Exception {
        long nodeId;
        GraphDatabaseService db = this.createDatabase();
        try (Transaction tx = db.beginTx();){
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "nodes", FulltextIndexProceduresUtil.asStrList((String[])new String[]{"Label"}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"prop"}))).close();
            tx.commit();
        }
        try (Transaction tx = db.beginTx();){
            tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
            Node node = tx.createNode(new Label[]{Label.label((String)"Label")});
            nodeId = node.getId();
            node.setProperty("prop", (Object)"value");
            tx.commit();
        }
        this.managementService.shutdown();
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(this.databaseLayout).setFileSystem(this.fs).addExtension((ExtensionFactory)new FailingGenericNativeIndexProviderFactory(new FailingGenericNativeIndexProviderFactory.FailureType[]{FailingGenericNativeIndexProviderFactory.FailureType.SKIP_ONLINE_UPDATES})).setConfig(GraphDatabaseSettings.default_schema_provider, (Object)FailingGenericNativeIndexProviderFactory.DESCRIPTOR.name()).build();
        db = managementService.database("neo4j");
        try (Transaction tx = db.beginTx();){
            tx.getNodeById(nodeId).removeProperty("prop");
            tx.commit();
        }
        managementService.shutdown();
        ConsistencyCheckService.Result result = this.checkConsistency();
        Assertions.assertFalse((boolean)result.isSuccessful());
    }

    @Test
    public void shouldNotReportNodesWithoutAllPropertiesInIndex() throws Exception {
        GraphDatabaseService db = this.createDatabase();
        try (Transaction tx = db.beginTx();){
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "nodes", FulltextIndexProceduresUtil.asStrList((String[])new String[]{"L1", "L2"}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"p1", "p2"}))).close();
            tx.commit();
        }
        tx = db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
            Node node = tx.createNode(new Label[]{Label.label((String)"L1"), Label.label((String)"L2")});
            node.setProperty("p1", (Object)"value");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.managementService.shutdown();
        FulltextIndexConsistencyCheckIT.assertIsConsistent(this.checkConsistency());
    }

    @Test
    public void shouldNotReportNodesWithMorePropertiesThanInIndex() throws Exception {
        GraphDatabaseService db = this.createDatabase();
        try (Transaction tx = db.beginTx();){
            tx.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "nodes", FulltextIndexProceduresUtil.asStrList((String[])new String[]{"L1", "L2"}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"p1"}))).close();
            tx.commit();
        }
        tx = db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
            Node node = tx.createNode(new Label[]{Label.label((String)"L1"), Label.label((String)"L2")});
            node.setProperty("p1", (Object)"value");
            node.setProperty("p2", (Object)"value");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.managementService.shutdown();
        FulltextIndexConsistencyCheckIT.assertIsConsistent(this.checkConsistency());
    }

    @Test
    void mustDiscoverRelationshipInStoreMissingFromIndex() throws Exception {
        long relId;
        IndexDescriptor indexDescriptor;
        GraphDatabaseService db = this.createDatabase();
        try (Transaction tx = db.beginTx();){
            tx.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", "rels", FulltextIndexProceduresUtil.asStrList((String[])new String[]{"REL"}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"prop"}))).close();
            tx.commit();
        }
        try (Transaction tx = db.beginTx();){
            tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
            indexDescriptor = FulltextIndexConsistencyCheckIT.getFulltextIndexDescriptor(tx.schema().getIndexes());
            Node node = tx.createNode();
            Relationship rel = node.createRelationshipTo(node, RelationshipType.withName((String)"REL"));
            rel.setProperty("prop", (Object)"value");
            relId = rel.getId();
            tx.commit();
        }
        IndexingService indexes = FulltextIndexConsistencyCheckIT.getIndexingService(db);
        IndexProxy indexProxy = indexes.getIndexProxy(indexDescriptor);
        try (IndexUpdater updater = indexProxy.newUpdater(IndexUpdateMode.ONLINE, CursorContext.NULL);){
            updater.process((IndexEntryUpdate)IndexEntryUpdate.remove((long)relId, (SchemaDescriptorSupplier)indexDescriptor, (Value[])new Value[]{Values.stringValue((String)"value")}));
        }
        this.managementService.shutdown();
        ConsistencyCheckService.Result result = this.checkConsistency();
        Assertions.assertFalse((boolean)result.isSuccessful());
    }

    @Disabled(value="Turns out that this is not something that the consistency checker actually looks for, currently. The test is disabled until the consistency checker is extended with checks that will discover this sort of inconsistency.")
    @Test
    void mustDiscoverRelationshipInIndexMissingFromStore() throws Exception {
        long relId;
        GraphDatabaseService db = this.createDatabase();
        try (Transaction tx = db.beginTx();){
            tx.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", "rels", FulltextIndexProceduresUtil.asStrList((String[])new String[]{"REL"}), FulltextIndexProceduresUtil.asStrList((String[])new String[]{"prop"}))).close();
            tx.commit();
        }
        try (Transaction tx = db.beginTx();){
            tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
            Node node = tx.createNode();
            Relationship rel = node.createRelationshipTo(node, RelationshipType.withName((String)"REL"));
            relId = rel.getId();
            rel.setProperty("prop", (Object)"value");
            tx.commit();
        }
        NeoStores stores = FulltextIndexConsistencyCheckIT.getNeoStores(db);
        try (CachedStoreCursors storeCursors = new CachedStoreCursors(stores, CursorContext.NULL);){
            RelationshipStore relationshipStore = stores.getRelationshipStore();
            RelationshipRecord record = (RelationshipRecord)relationshipStore.newRecord();
            PropertyStore propertyStore = stores.getPropertyStore();
            relationshipStore.getRecordByCursor(relId, (AbstractBaseRecord)record, RecordLoad.NORMAL, storeCursors.readCursor((CursorType)RecordCursorTypes.RELATIONSHIP_CURSOR));
            long propId = record.getNextProp();
            record.setNextProp(-1L);
            try (PageCursor storeCursor = storeCursors.writeCursor((CursorType)RecordCursorTypes.RELATIONSHIP_CURSOR);){
                relationshipStore.updateRecord((AbstractBaseRecord)record, storeCursor, CursorContext.NULL, (StoreCursors)storeCursors);
            }
            PropertyRecord propRecord = propertyStore.newRecord();
            propertyStore.getRecordByCursor(propId, (AbstractBaseRecord)propertyStore.newRecord(), RecordLoad.NORMAL, storeCursors.readCursor((CursorType)RecordCursorTypes.PROPERTY_CURSOR));
            propRecord.setInUse(false);
            try (PageCursor cursor = storeCursors.writeCursor((CursorType)RecordCursorTypes.PROPERTY_CURSOR);){
                propertyStore.updateRecord((AbstractBaseRecord)propRecord, cursor, CursorContext.NULL, (StoreCursors)storeCursors);
            }
        }
        this.managementService.shutdown();
        ConsistencyCheckService.Result result = this.checkConsistency();
        Assertions.assertFalse((boolean)result.isSuccessful());
    }

    private GraphDatabaseService createDatabase() {
        this.managementService = this.builder.build();
        this.database = this.managementService.database("neo4j");
        return this.database;
    }

    private ConsistencyCheckService.Result checkConsistency() throws ConsistencyCheckIncompleteException {
        Config config = Config.defaults((Setting)GraphDatabaseSettings.logs_directory, (Object)this.databaseLayout.databaseDirectory());
        ConsistencyCheckService consistencyCheckService = new ConsistencyCheckService(new Date());
        return consistencyCheckService.runFullConsistencyCheck(this.databaseLayout, config, ProgressMonitorFactory.NONE, (LogProvider)NullLogProvider.getInstance(), false, ConsistencyFlags.DEFAULT);
    }

    private static IndexDescriptor getFulltextIndexDescriptor(Iterable<IndexDefinition> indexes) {
        for (IndexDefinition index : indexes) {
            if (index.getIndexType() != IndexType.FULLTEXT) continue;
            return FulltextIndexConsistencyCheckIT.getIndexDescriptor(index);
        }
        return IndexDescriptor.NO_INDEX;
    }

    private static IndexDescriptor getIndexDescriptor(IndexDefinition definition) {
        IndexDefinitionImpl indexDefinition = (IndexDefinitionImpl)definition;
        return indexDefinition.getIndexReference();
    }

    private static IndexingService getIndexingService(GraphDatabaseService db) {
        DependencyResolver dependencyResolver = FulltextIndexConsistencyCheckIT.getDependencyResolver(db);
        return (IndexingService)dependencyResolver.resolveDependency(IndexingService.class);
    }

    private static NeoStores getNeoStores(GraphDatabaseService db) {
        DependencyResolver dependencyResolver = FulltextIndexConsistencyCheckIT.getDependencyResolver(db);
        return ((RecordStorageEngine)dependencyResolver.resolveDependency(RecordStorageEngine.class)).testAccessNeoStores();
    }

    private static DependencyResolver getDependencyResolver(GraphDatabaseService db) {
        GraphDatabaseAPI api = (GraphDatabaseAPI)db;
        return api.getDependencyResolver();
    }

    private static void assertIsConsistent(ConsistencyCheckService.Result result) throws IOException {
        if (!result.isSuccessful()) {
            FulltextIndexConsistencyCheckIT.printReport(result);
            Assertions.fail((String)"Expected consistency check to be successful.");
        }
    }

    private static void printReport(ConsistencyCheckService.Result result) throws IOException {
        Files.readAllLines(result.reportFile()).forEach(System.err::println);
    }
}

