/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index;

import java.io.IOException;
import java.nio.file.Path;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexProvider;

abstract class NativeIndexRestartAction {
    private static final IndexProviderDescriptor DEFAULT_PROVIDER_DESCRIPTOR = GenericNativeIndexProvider.DESCRIPTOR;
    final IndexProviderDescriptor providerDescriptor;

    NativeIndexRestartAction() {
        this(DEFAULT_PROVIDER_DESCRIPTOR);
    }

    NativeIndexRestartAction(IndexProviderDescriptor providerDescriptor) {
        this.providerDescriptor = providerDescriptor;
    }

    public void run(FileSystemAbstraction fs, DatabaseLayout databaseLayout) throws IOException {
        IndexDirectoryStructure indexDirectoryStructure = NativeIndexRestartAction.nativeIndexDirectoryStructure(databaseLayout, this.providerDescriptor);
        this.runOnDirectoryStructure(fs, indexDirectoryStructure);
    }

    protected abstract void runOnDirectoryStructure(FileSystemAbstraction var1, IndexDirectoryStructure var2) throws IOException;

    static IndexDirectoryStructure nativeIndexDirectoryStructure(DatabaseLayout databaseLayout) {
        return IndexDirectoryStructure.directoriesByProvider((Path)databaseLayout.databaseDirectory()).forProvider(DEFAULT_PROVIDER_DESCRIPTOR);
    }

    static IndexDirectoryStructure nativeIndexDirectoryStructure(DatabaseLayout databaseLayout, IndexProviderDescriptor providerDescriptor) {
        return IndexDirectoryStructure.directoriesByProvider((Path)databaseLayout.databaseDirectory()).forProvider(providerDescriptor);
    }
}

