/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.graphdb.event.TransactionEventListener;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.impl.index.schema.TokenScanWriteMonitor;
import org.neo4j.kernel.internal.event.InternalTransactionEventListener;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.Inject;

@DbmsExtension(configurationCallback="configure")
class TokenIndexWriteMonitorIT {
    @Inject
    private GraphDatabaseService db;
    @Inject
    private DatabaseLayout databaseLayout;
    @Inject
    private DatabaseManagementService databaseManagementService;
    private final List<Long> txIds = new ArrayList<Long>();

    TokenIndexWriteMonitorIT() {
    }

    @ExtensionCallback
    void configure(TestDatabaseManagementServiceBuilder builder) {
        builder.setConfig(GraphDatabaseInternalSettings.token_scan_write_log_enabled, (Object)true);
    }

    @BeforeEach
    void beforeEach() {
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode(new Label[]{Label.label((String)"l1"), Label.label((String)"l2"), Label.label((String)"l3")});
            node.createRelationshipTo(node, RelationshipType.withName((String)"t1"));
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.getRelationshipById(0L).delete();
            tx.getNodeById(0L).delete();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.databaseManagementService.registerTransactionEventListener(this.db.databaseName(), (TransactionEventListener)new InternalTransactionEventListener.Adapter<Object>(){

            public void afterCommit(TransactionData data, Object state, GraphDatabaseService databaseService) {
                TokenIndexWriteMonitorIT.this.txIds.add(data.getTransactionId());
            }
        });
    }

    @Test
    void testLabelChangeLogging() throws IOException {
        long nodeId;
        try (Transaction tx = this.db.beginTx();){
            nodeId = tx.createNode(new Label[]{Label.label((String)"l1"), Label.label((String)"l2")}).getId();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            Node node = tx.getNodeById(nodeId);
            node.removeLabel(Label.label((String)"l2"));
            node.addLabel(Label.label((String)"l3"));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        Path labelIndex = this.databaseLayout.labelScanStore();
        String logContent = this.getLogContent(labelIndex);
        ((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)logContent).contains(new CharSequence[]{"+tx:" + String.valueOf(this.txIds.get(0)) + ",entity:" + nodeId + ",token:0"})).contains(new CharSequence[]{"+tx:" + String.valueOf(this.txIds.get(0)) + ",entity:" + nodeId + ",token:1"})).contains(new CharSequence[]{"-tx:" + String.valueOf(this.txIds.get(1)) + ",entity:" + nodeId + ",token:1"})).contains(new CharSequence[]{"+tx:" + String.valueOf(this.txIds.get(1)) + ",entity:" + nodeId + ",token:2"});
    }

    @Test
    void testRelationshipTypeChangeLogging() throws IOException {
        long relId;
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode();
            relId = node.createRelationshipTo(node, RelationshipType.withName((String)"t1")).getId();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.getRelationshipById(relId).delete();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        Path relIndex = this.databaseLayout.relationshipTypeScanStore();
        String logContent = this.getLogContent(relIndex);
        ((AbstractStringAssert)Assertions.assertThat((String)logContent).contains(new CharSequence[]{"+tx:" + String.valueOf(this.txIds.get(0)) + ",entity:" + relId + ",token:0"})).contains(new CharSequence[]{"-tx:" + String.valueOf(this.txIds.get(1)) + ",entity:" + relId + ",token:0"});
    }

    private String getLogContent(Path index) throws IOException {
        this.databaseManagementService.shutdown();
        TokenScanWriteMonitor.main((String[])new String[]{"--tofile", this.databaseLayout.databaseDirectory().toString()});
        Path logFile = index.resolveSibling(String.valueOf(index.getFileName()) + ".writelog.txt");
        return Files.readString(logFile);
    }
}

