/*
 * Decompiled with CFR 0.152.
 */
package migration;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.api.DatabaseManagementServiceBuilder;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.internal.helpers.ArrayUtil;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.IndexMonitor;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.io.compress.ZipUtils;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexProvider;
import org.neo4j.kernel.impl.index.schema.fusion.NativeLuceneFusionIndexProviderFactory30;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.monitoring.Monitors;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.Unzip;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.utils.TestDirectory;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.Values;

@Neo4jLayoutExtension
class StartOldDbOnCurrentVersionAndCreateFusionIndexIT {
    private static final String ZIP_FILE_3_5 = "3_5-db.zip";
    private static final String KEY1 = "key1";
    private static final String KEY2 = "key2";
    private DatabaseManagementService managementService;
    private static final int NUMBER_OF_SYSTEM_INDEXES = 5;
    private static final Provider DEFAULT_PROVIDER = Provider.BTREE_10_40;
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private DatabaseLayout databaseLayout;

    StartOldDbOnCurrentVersionAndCreateFusionIndexIT() {
    }

    @Disabled(value="Here as reference for how 3.5 db was created")
    @Test
    void create3_5Database() throws Exception {
        Path storeDir = StartOldDbOnCurrentVersionAndCreateFusionIndexIT.tempStoreDirectory();
        TestDatabaseManagementServiceBuilder builder = new TestDatabaseManagementServiceBuilder(storeDir);
        StartOldDbOnCurrentVersionAndCreateFusionIndexIT.createIndexDataAndShutdown((DatabaseManagementServiceBuilder)builder, "lucene-1.0", Provider.LUCENE_10.label);
        StartOldDbOnCurrentVersionAndCreateFusionIndexIT.createIndexDataAndShutdown((DatabaseManagementServiceBuilder)builder, "lucene+native-1.0", Provider.FUSION_10.label);
        StartOldDbOnCurrentVersionAndCreateFusionIndexIT.createIndexDataAndShutdown((DatabaseManagementServiceBuilder)builder, "lucene+native-2.0", Provider.FUSION_20.label);
        StartOldDbOnCurrentVersionAndCreateFusionIndexIT.createIndexDataAndShutdown((DatabaseManagementServiceBuilder)builder, GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10.providerName(), Provider.BTREE_10.label, db -> {
            try (Transaction tx = db.beginTx();){
                tx.execute("CALL db.index.fulltext.createNodeIndex('fts1', ['Fts1'], ['prop1'] )").close();
                tx.execute("CALL db.index.fulltext.createNodeIndex('fts2', ['Fts2', 'Fts3'], ['prop1', 'prop2'] )").close();
                tx.execute("CALL db.index.fulltext.createNodeIndex('fts3', ['Fts4'], ['prop1'], {eventually_consistent: 'true'} )").close();
                tx.execute("CALL db.index.fulltext.createRelationshipIndex('fts4', ['FtsRel1', 'FtsRel2'], ['prop1', 'prop2'], {eventually_consistent: 'true'} )").close();
                tx.commit();
            }
            tx = db.beginTx();
            try {
                tx.schema().awaitIndexesOnline(10L, TimeUnit.MINUTES);
                Node node = tx.createNode(new Label[]{Label.label((String)"Fts1"), Label.label((String)"Fts2"), Label.label((String)"Fts3"), Label.label((String)"Fts4")});
                node.setProperty("prop1", (Object)"abc");
                node.setProperty("prop2", (Object)"abc");
                node.createRelationshipTo(node, RelationshipType.withName((String)"FtsRel1")).setProperty("prop1", (Object)"abc");
                node.createRelationshipTo(node, RelationshipType.withName((String)"FtsRel2")).setProperty("prop2", (Object)"abc");
                tx.commit();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
            tx = db.beginTx();
            try {
                tx.execute("call db.index.fulltext.awaitEventuallyConsistentIndexRefresh").close();
                tx.commit();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        });
        Path zipFile = storeDir.resolveSibling(storeDir.getFileName().toString() + ".zip");
        ZipUtils.zip((FileSystemAbstraction)new DefaultFileSystemAbstraction(), (Path)storeDir, (Path)zipFile);
        System.out.println("Db created in " + String.valueOf(zipFile.toAbsolutePath()));
    }

    @Test
    void shouldOpen3_5DbAndCreateAndWorkWithSomeFusionIndexes() throws Exception {
        Provider highestProviderInOldVersion = Provider.BTREE_10;
        this.shouldOpenOldDbAndCreateAndWorkWithSomeFusionIndexes(ZIP_FILE_3_5, highestProviderInOldVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shouldOpenOldDbAndCreateAndWorkWithSomeFusionIndexes(String zippedDbName, Provider highestProviderInOldVersion) throws Exception {
        Path targetDirectory = this.databaseLayout.databaseDirectory();
        Unzip.unzip(this.getClass(), (String)zippedDbName, (Path)targetDirectory);
        IndexRecoveryTracker indexRecoveryTracker = new IndexRecoveryTracker();
        Path storeDir = this.testDirectory.homePath();
        this.managementService = StartOldDbOnCurrentVersionAndCreateFusionIndexIT.setupDb(storeDir, indexRecoveryTracker);
        GraphDatabaseAPI db = this.getDefaultDatabase();
        Provider[] providers = StartOldDbOnCurrentVersionAndCreateFusionIndexIT.providersUpToAndIncluding(highestProviderInOldVersion);
        Provider[] providersIncludingSubject = (Provider[])ArrayUtil.concat((Object[])providers, (Object[])new Provider[]{DEFAULT_PROVIDER});
        int fulltextIndexes = 4;
        int lookupIndexes = 1;
        int expectedNumberOfIndexes = fulltextIndexes + lookupIndexes + providers.length * 2;
        try {
            StartOldDbOnCurrentVersionAndCreateFusionIndexIT.verifyInitialState(indexRecoveryTracker, expectedNumberOfIndexes, InternalIndexState.POPULATING);
            try (Provider[] tx = db.beginTx();){
                tx.schema().awaitIndexesOnline(10L, TimeUnit.MINUTES);
                tx.commit();
            }
            for (Provider provider : providers) {
                StartOldDbOnCurrentVersionAndCreateFusionIndexIT.verifyIndexes(db, provider.label);
            }
            StartOldDbOnCurrentVersionAndCreateFusionIndexIT.createIndexesAndData((GraphDatabaseService)db, StartOldDbOnCurrentVersionAndCreateFusionIndexIT.DEFAULT_PROVIDER.label);
            StartOldDbOnCurrentVersionAndCreateFusionIndexIT.verifyIndexes(db, StartOldDbOnCurrentVersionAndCreateFusionIndexIT.DEFAULT_PROVIDER.label);
            for (Provider provider : providersIncludingSubject) {
                StartOldDbOnCurrentVersionAndCreateFusionIndexIT.additionalUpdates(db, provider.label);
                StartOldDbOnCurrentVersionAndCreateFusionIndexIT.verifyAfterAdditionalUpdate(db, provider.label);
            }
            tx = db.beginTx();
            try {
                IndexDefinition fts1 = tx.schema().getIndexByName("fts1");
                Iterator fts1labels = fts1.getLabels().iterator();
                Assertions.assertTrue((boolean)fts1labels.hasNext());
                Assertions.assertEquals((Object)((Label)fts1labels.next()).name(), (Object)"Fts1");
                Assertions.assertFalse((boolean)fts1labels.hasNext());
                Iterator fts1props = fts1.getPropertyKeys().iterator();
                Assertions.assertTrue((boolean)fts1props.hasNext());
                Assertions.assertEquals((Object)"prop1", fts1props.next());
                Assertions.assertFalse((boolean)fts1props.hasNext());
                IndexDefinition fts2 = tx.schema().getIndexByName("fts2");
                Iterator fts2labels = fts2.getLabels().iterator();
                Assertions.assertTrue((boolean)fts2labels.hasNext());
                Assertions.assertEquals((Object)((Label)fts2labels.next()).name(), (Object)"Fts2");
                Assertions.assertTrue((boolean)fts2labels.hasNext());
                Assertions.assertEquals((Object)((Label)fts2labels.next()).name(), (Object)"Fts3");
                Assertions.assertFalse((boolean)fts2labels.hasNext());
                Iterator fts2props = fts2.getPropertyKeys().iterator();
                Assertions.assertTrue((boolean)fts2props.hasNext());
                Assertions.assertEquals((Object)"prop1", fts2props.next());
                Assertions.assertTrue((boolean)fts2props.hasNext());
                Assertions.assertEquals((Object)"prop2", fts2props.next());
                Assertions.assertFalse((boolean)fts2props.hasNext());
                IndexDefinition fts3 = tx.schema().getIndexByName("fts3");
                Iterator fts3labels = fts3.getLabels().iterator();
                Assertions.assertTrue((boolean)fts3labels.hasNext());
                Assertions.assertEquals((Object)((Label)fts3labels.next()).name(), (Object)"Fts4");
                Assertions.assertFalse((boolean)fts3labels.hasNext());
                Iterator fts3props = fts3.getPropertyKeys().iterator();
                Assertions.assertTrue((boolean)fts3props.hasNext());
                Assertions.assertEquals((Object)"prop1", fts3props.next());
                Assertions.assertFalse((boolean)fts3props.hasNext());
                IndexDefinition fts4 = tx.schema().getIndexByName("fts4");
                Iterator fts4relTypes = fts4.getRelationshipTypes().iterator();
                Assertions.assertTrue((boolean)fts4relTypes.hasNext());
                Assertions.assertEquals((Object)((RelationshipType)fts4relTypes.next()).name(), (Object)"FtsRel1");
                Assertions.assertTrue((boolean)fts4relTypes.hasNext());
                Assertions.assertEquals((Object)((RelationshipType)fts4relTypes.next()).name(), (Object)"FtsRel2");
                Assertions.assertFalse((boolean)fts4relTypes.hasNext());
                Iterator fts4props = fts4.getPropertyKeys().iterator();
                Assertions.assertTrue((boolean)fts4props.hasNext());
                Assertions.assertEquals((Object)"prop1", fts4props.next());
                Assertions.assertTrue((boolean)fts4props.hasNext());
                Assertions.assertEquals((Object)"prop2", fts4props.next());
                Assertions.assertFalse((boolean)fts4props.hasNext());
                try (Stream result = tx.execute("CALL db.index.fulltext.queryNodes( 'fts1', 'abc' )").stream();){
                    Assertions.assertEquals((long)result.count(), (long)1L);
                }
                result = tx.execute("CALL db.index.fulltext.queryNodes( 'fts2', 'abc' )").stream();
                try {
                    Assertions.assertEquals((long)result.count(), (long)1L);
                }
                finally {
                    if (result != null) {
                        result.close();
                    }
                }
                result = tx.execute("CALL db.index.fulltext.queryNodes( 'fts3', 'abc' )").stream();
                try {
                    Assertions.assertEquals((long)result.count(), (long)1L);
                }
                finally {
                    if (result != null) {
                        result.close();
                    }
                }
                result = tx.execute("CALL db.index.fulltext.queryRelationships( 'fts4', 'abc' )").stream();
                try {
                    Assertions.assertEquals((long)result.count(), (long)2L);
                }
                finally {
                    if (result != null) {
                        result.close();
                    }
                }
                tx.commit();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
            for (Provider provider : providersIncludingSubject) {
                StartOldDbOnCurrentVersionAndCreateFusionIndexIT.verifyExpectedProvider(db, provider.label, provider.descriptor);
            }
        }
        finally {
            this.managementService.shutdown();
        }
        indexRecoveryTracker = new IndexRecoveryTracker();
        this.managementService = StartOldDbOnCurrentVersionAndCreateFusionIndexIT.setupDb(storeDir, indexRecoveryTracker);
        try {
            int numberNewIndexes = 2;
            StartOldDbOnCurrentVersionAndCreateFusionIndexIT.verifyInitialState(indexRecoveryTracker, expectedNumberOfIndexes + numberNewIndexes + 5, InternalIndexState.ONLINE);
        }
        finally {
            this.managementService.shutdown();
        }
    }

    private static Provider[] providersUpToAndIncluding(Provider provider) {
        return (Provider[])Stream.of(Provider.values()).filter(p -> p.ordinal() <= provider.ordinal()).toArray(Provider[]::new);
    }

    private static DatabaseManagementService setupDb(Path storeDir, IndexRecoveryTracker indexRecoveryTracker) {
        Monitors monitors = new Monitors();
        monitors.addMonitorListener((Object)indexRecoveryTracker, new String[0]);
        return new TestDatabaseManagementServiceBuilder(storeDir).setMonitors(monitors).setConfig(GraphDatabaseSettings.allow_upgrade, (Object)true).build();
    }

    private GraphDatabaseAPI getDefaultDatabase() {
        return (GraphDatabaseAPI)this.managementService.database("neo4j");
    }

    private static void verifyInitialState(IndexRecoveryTracker indexRecoveryTracker, int expectedNumberOfIndexes, InternalIndexState expectedInitialState) {
        Assertions.assertEquals((int)expectedNumberOfIndexes, (int)indexRecoveryTracker.initialStateMap.size(), (String)("exactly " + expectedNumberOfIndexes + " indexes "));
        block3: for (Map.Entry<IndexDescriptor, InternalIndexState> indexStateEntry : indexRecoveryTracker.initialStateMap.entrySet()) {
            switch (indexStateEntry.getKey().getIndexType()) {
                case LOOKUP: {
                    Assertions.assertEquals((Object)InternalIndexState.ONLINE, (Object)indexStateEntry.getValue(), (String)("Unexpected lookup index state: " + String.valueOf(indexRecoveryTracker.initialStateMap)));
                    continue block3;
                }
            }
            Assertions.assertEquals((Object)expectedInitialState, (Object)indexStateEntry.getValue(), (String)("initial state is online, don't do recovery: " + String.valueOf(indexRecoveryTracker.initialStateMap)));
        }
    }

    private static void verifyExpectedProvider(GraphDatabaseAPI db, Label label, IndexProviderDescriptor expectedDescriptor) throws TransactionFailureException {
        try (InternalTransaction tx = (InternalTransaction)db.beginTx();
             KernelTransaction kernelTransaction = tx.kernelTransaction();){
            TokenRead tokenRead = kernelTransaction.tokenRead();
            SchemaRead schemaRead = kernelTransaction.schemaRead();
            int labelId = tokenRead.nodeLabel(label.name());
            int key1Id = tokenRead.propertyKey(KEY1);
            int key2Id = tokenRead.propertyKey(KEY2);
            IndexDescriptor index = (IndexDescriptor)Iterators.single((Iterator)schemaRead.index((SchemaDescriptor)SchemaDescriptors.forLabel((int)labelId, (int[])new int[]{key1Id})));
            StartOldDbOnCurrentVersionAndCreateFusionIndexIT.assertIndexHasExpectedProvider(expectedDescriptor, index);
            index = (IndexDescriptor)Iterators.single((Iterator)schemaRead.index((SchemaDescriptor)SchemaDescriptors.forLabel((int)labelId, (int[])new int[]{key1Id, key2Id})));
            StartOldDbOnCurrentVersionAndCreateFusionIndexIT.assertIndexHasExpectedProvider(expectedDescriptor, index);
            tx.commit();
        }
    }

    private static void assertIndexHasExpectedProvider(IndexProviderDescriptor expectedDescriptor, IndexDescriptor index) {
        Assertions.assertEquals((Object)expectedDescriptor.getKey(), (Object)index.getIndexProvider().getKey(), (String)"same key");
        Assertions.assertEquals((Object)expectedDescriptor.getVersion(), (Object)index.getIndexProvider().getVersion(), (String)"same version");
    }

    private static void createIndexDataAndShutdown(DatabaseManagementServiceBuilder builder, String indexProvider, Label label) {
        StartOldDbOnCurrentVersionAndCreateFusionIndexIT.createIndexDataAndShutdown(builder, indexProvider, label, db -> {});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createIndexDataAndShutdown(DatabaseManagementServiceBuilder builder, String indexProvider, Label label, Consumer<GraphDatabaseService> otherActions) {
        builder.setConfig(GraphDatabaseSettings.default_schema_provider, (Object)indexProvider);
        DatabaseManagementService dbms = builder.build();
        try {
            GraphDatabaseService db = dbms.database("neo4j");
            otherActions.accept(db);
            StartOldDbOnCurrentVersionAndCreateFusionIndexIT.createIndexData(db, label);
        }
        finally {
            dbms.shutdown();
        }
    }

    private static void createIndexData(GraphDatabaseService db, Label label) {
        StartOldDbOnCurrentVersionAndCreateFusionIndexIT.createIndexesAndData(db, label);
    }

    private static Path tempStoreDirectory() throws IOException {
        return Files.createTempDirectory("create-db-neo4j", new FileAttribute[0]);
    }

    private static void createIndexesAndData(GraphDatabaseService db, Label label) {
        try (Transaction tx = db.beginTx();){
            tx.schema().indexFor(label).on(KEY1).create();
            tx.schema().indexFor(label).on(KEY1).on(KEY2).create();
            tx.commit();
        }
        tx = db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(10L, TimeUnit.MINUTES);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        StartOldDbOnCurrentVersionAndCreateFusionIndexIT.createData(db, label);
    }

    private static void createData(GraphDatabaseService db, Label label) {
        try (Transaction tx = db.beginTx();){
            for (int i = 0; i < 100; ++i) {
                Node node = tx.createNode(new Label[]{label});
                Object value = i % 2 == 0 ? Integer.valueOf(i) : String.valueOf(i);
                node.setProperty(KEY1, value);
                if (i % 3 != 0) continue;
                node.setProperty(KEY2, value);
            }
            tx.commit();
        }
    }

    private static void createSpatialAndTemporalData(GraphDatabaseAPI db, Label label) {
        try (Transaction tx = db.beginTx();){
            for (int i = 0; i < 100; ++i) {
                Node node = tx.createNode(new Label[]{label});
                DurationValue value = i % 2 == 0 ? Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{i, i}) : DurationValue.duration((long)0L, (long)0L, (long)i, (long)0L);
                node.setProperty(KEY1, (Object)value);
                if (i % 3 != 0) continue;
                node.setProperty(KEY2, (Object)value);
            }
            tx.commit();
        }
    }

    private static void additionalUpdates(GraphDatabaseAPI db, Label label) {
        StartOldDbOnCurrentVersionAndCreateFusionIndexIT.createData((GraphDatabaseService)db, label);
        StartOldDbOnCurrentVersionAndCreateFusionIndexIT.createSpatialAndTemporalData(db, label);
    }

    private static void verifyIndexes(GraphDatabaseAPI db, Label label) throws Exception {
        Assertions.assertTrue((boolean)StartOldDbOnCurrentVersionAndCreateFusionIndexIT.hasIndex((GraphDatabaseService)db, label, KEY1));
        Assertions.assertEquals((int)100, (int)StartOldDbOnCurrentVersionAndCreateFusionIndexIT.countIndexedNodes(db, label, KEY1));
        Assertions.assertTrue((boolean)StartOldDbOnCurrentVersionAndCreateFusionIndexIT.hasIndex((GraphDatabaseService)db, label, KEY1, KEY2));
        Assertions.assertEquals((int)34, (int)StartOldDbOnCurrentVersionAndCreateFusionIndexIT.countIndexedNodes(db, label, KEY1, KEY2));
    }

    private static void verifyAfterAdditionalUpdate(GraphDatabaseAPI db, Label label) throws Exception {
        Assertions.assertTrue((boolean)StartOldDbOnCurrentVersionAndCreateFusionIndexIT.hasIndex((GraphDatabaseService)db, label, KEY1));
        Assertions.assertEquals((int)300, (int)StartOldDbOnCurrentVersionAndCreateFusionIndexIT.countIndexedNodes(db, label, KEY1));
        Assertions.assertTrue((boolean)StartOldDbOnCurrentVersionAndCreateFusionIndexIT.hasIndex((GraphDatabaseService)db, label, KEY1, KEY2));
        Assertions.assertEquals((int)102, (int)StartOldDbOnCurrentVersionAndCreateFusionIndexIT.countIndexedNodes(db, label, KEY1, KEY2));
    }

    private static int countIndexedNodes(GraphDatabaseAPI db, Label label, String ... keys) throws Exception {
        try (InternalTransaction tx = (InternalTransaction)db.beginTx();){
            KernelTransaction ktx = tx.kernelTransaction();
            TokenRead tokenRead = ktx.tokenRead();
            int labelId = tokenRead.nodeLabel(label.name());
            int[] propertyKeyIds = new int[keys.length];
            for (int i = 0; i < propertyKeyIds.length; ++i) {
                propertyKeyIds[i] = tokenRead.propertyKey(keys[i]);
            }
            PropertyIndexQuery[] predicates = new PropertyIndexQuery[propertyKeyIds.length];
            for (int i = 0; i < propertyKeyIds.length; ++i) {
                predicates[i] = PropertyIndexQuery.exists((int)propertyKeyIds[i]);
            }
            IndexDescriptor index = (IndexDescriptor)Iterators.single((Iterator)ktx.schemaRead().index((SchemaDescriptor)SchemaDescriptors.forLabel((int)labelId, (int[])propertyKeyIds)));
            IndexReadSession indexSession = ktx.dataRead().indexReadSession(index);
            int count = 0;
            try (NodeValueIndexCursor cursor = ktx.cursors().allocateNodeValueIndexCursor(ktx.cursorContext(), ktx.memoryTracker());){
                ktx.dataRead().nodeIndexSeek(ktx.queryContext(), indexSession, cursor, IndexQueryConstraints.unconstrained(), predicates);
                while (cursor.next()) {
                    ++count;
                }
            }
            tx.commit();
            int n = count;
            return n;
        }
    }

    private static boolean hasIndex(GraphDatabaseService db, Label label, String ... keys) {
        try (Transaction tx = db.beginTx();){
            List<String> keyList = Arrays.asList(keys);
            for (IndexDefinition index : tx.schema().getIndexes(label)) {
                if (!Iterables.asList((Iterable)index.getPropertyKeys()).equals(keyList)) continue;
                boolean bl = true;
                return bl;
            }
            tx.commit();
        }
        return false;
    }

    private static class IndexRecoveryTracker
    extends IndexMonitor.MonitorAdapter {
        Map<IndexDescriptor, InternalIndexState> initialStateMap = new HashMap<IndexDescriptor, InternalIndexState>();

        private IndexRecoveryTracker() {
        }

        public void initialState(String databaseName, IndexDescriptor descriptor, InternalIndexState state) {
            this.initialStateMap.put(descriptor, state);
        }

        public void reset() {
            this.initialStateMap = new HashMap<IndexDescriptor, InternalIndexState>();
        }
    }

    private static enum Provider {
        LUCENE_10("Label1", "lucene-1.0", NativeLuceneFusionIndexProviderFactory30.DESCRIPTOR),
        FUSION_10("Label2", "lucene+native-1.0", NativeLuceneFusionIndexProviderFactory30.DESCRIPTOR),
        FUSION_20("Label3", "lucene+native-2.0", GenericNativeIndexProvider.DESCRIPTOR),
        BTREE_10("Label4", "native-btree-1.0", GenericNativeIndexProvider.DESCRIPTOR),
        BTREE_10_40("Label5", "native-btree-1.0", GenericNativeIndexProvider.DESCRIPTOR);

        private final Label label;
        private final String originallyCreatedWithProvider;
        private final IndexProviderDescriptor descriptor;

        private Provider(String labelName, String originallyCreatedWithProvider, IndexProviderDescriptor descriptor) {
            this.label = Label.label((String)labelName);
            this.originallyCreatedWithProvider = originallyCreatedWithProvider;
            this.descriptor = descriptor;
        }
    }
}

