/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.lucene;

import java.nio.file.Path;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.IndexingTestUtil;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.api.exceptions.schema.UnableToValidateConstraintException;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.impl.coreapi.TransactionImpl;
import org.neo4j.kernel.impl.index.schema.AbstractIndexProviderFactory;
import org.neo4j.kernel.impl.index.schema.BuiltInDelegatingIndexProviderFactory;
import org.neo4j.kernel.impl.index.schema.FailingNativeIndexProviderFactory;
import org.neo4j.kernel.impl.index.schema.RangeIndexProviderFactory;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
class ConstraintIndexFailureIT {
    @Inject
    private TestDirectory directory;

    ConstraintIndexFailureIT() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldFailToValidateConstraintsIfUnderlyingIndexIsFailed() throws Exception {
        TransactionImpl tx;
        Path dir = this.directory.homePath();
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(dir).addExtension((ExtensionFactory)new BuiltInDelegatingIndexProviderFactory((AbstractIndexProviderFactory)new RangeIndexProviderFactory(), FailingNativeIndexProviderFactory.DESCRIPTOR)).noOpSystemGraphInitializer().build();
        GraphDatabaseService db = managementService.database("neo4j");
        try {
            tx = (TransactionImpl)db.beginTx();
            try {
                IndexingTestUtil.createNodePropUniqueConstraintWithSpecifiedProvider((TransactionImpl)tx, (IndexProviderDescriptor)FailingNativeIndexProviderFactory.DESCRIPTOR, (Label)Label.label((String)"Label1"), (String)"key1");
                tx.commit();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        finally {
            managementService.shutdown();
        }
        FileUtils.deleteDirectory((Path)IndexDirectoryStructure.baseSchemaIndexFolder((Path)dir));
        managementService = new TestDatabaseManagementServiceBuilder(dir).addExtension((ExtensionFactory)new FailingNativeIndexProviderFactory(new FailingNativeIndexProviderFactory.FailureType[]{FailingNativeIndexProviderFactory.FailureType.INITIAL_STATE})).noOpSystemGraphInitializer().build();
        db = managementService.database("neo4j");
        try {
            tx = db.beginTx();
            try {
                ConstraintViolationException e = (ConstraintViolationException)org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> ConstraintIndexFailureIT.lambda$shouldFailToValidateConstraintsIfUnderlyingIndexIsFailed$0((Transaction)tx));
                Assertions.assertThat((Throwable)e.getCause()).isInstanceOf(UnableToValidateConstraintException.class);
                ((AbstractStringAssert)Assertions.assertThat((String)e.getCause().getCause().getMessage()).contains(new CharSequence[]{"The index is in a failed state:"})).contains(new CharSequence[]{"Override initial state as failed"});
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        finally {
            managementService.shutdown();
        }
    }

    private static /* synthetic */ void lambda$shouldFailToValidateConstraintsIfUnderlyingIndexIsFailed$0(Transaction tx) throws Throwable {
        tx.createNode(new Label[]{Label.label((String)"Label1")}).setProperty("key1", (Object)"value1");
    }
}

