/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Iterator;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestBase;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestSupport;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public abstract class ConstraintTestBase<G extends KernelAPIWriteTestSupport>
extends KernelAPIWriteTestBase<G> {
    protected abstract LabelSchemaDescriptor labelSchemaDescriptor(int var1, int ... var2);

    protected abstract ConstraintDescriptor uniqueConstraintDescriptor(int var1, int ... var2);

    @BeforeEach
    public void setup() {
        try (Transaction tx = graphDb.beginTx();){
            for (ConstraintDefinition definition : tx.schema().getConstraints()) {
                definition.drop();
            }
            tx.commit();
        }
    }

    @Test
    void shouldFindConstraintsBySchema() throws Exception {
        this.addConstraints("FOO", "prop");
        try (KernelTransaction tx = ConstraintTestBase.beginTransaction();){
            int label = tx.tokenWrite().labelGetOrCreateForName("FOO");
            int prop = tx.tokenWrite().propertyKeyGetOrCreateForName("prop");
            LabelSchemaDescriptor descriptor = this.labelSchemaDescriptor(label, prop);
            List constraints = Iterators.asList((Iterator)tx.schemaRead().constraintsGetForSchema((SchemaDescriptor)descriptor));
            Assertions.assertThat((List)constraints).hasSize(1);
            Assertions.assertThat((int)((ConstraintDescriptor)constraints.get(0)).schema().getPropertyId()).isEqualTo(prop);
        }
    }

    @Test
    void shouldFindConstraintsByLabel() throws Exception {
        this.addConstraints("FOO", "prop1", "FOO", "prop2");
        try (KernelTransaction tx = ConstraintTestBase.beginTransaction();){
            int label = tx.tokenWrite().labelGetOrCreateForName("FOO");
            List constraints = Iterators.asList((Iterator)tx.schemaRead().constraintsGetForLabel(label));
            Assertions.assertThat((List)constraints).hasSize(2);
        }
    }

    @Test
    void shouldBeAbleCheckExistenceOfConstraints() throws Exception {
        try (Transaction tx = graphDb.beginTx();){
            tx.schema().constraintFor(Label.label((String)"FOO")).assertPropertyIsUnique("prop1").create();
            ConstraintDefinition dropped = tx.schema().constraintFor(Label.label((String)"FOO")).assertPropertyIsUnique("prop2").create();
            dropped.drop();
            tx.commit();
        }
        tx = ConstraintTestBase.beginTransaction();
        try {
            int label = tx.tokenWrite().labelGetOrCreateForName("FOO");
            int prop1 = tx.tokenWrite().propertyKeyGetOrCreateForName("prop1");
            int prop2 = tx.tokenWrite().propertyKeyGetOrCreateForName("prop2");
            org.junit.jupiter.api.Assertions.assertTrue((boolean)tx.schemaRead().constraintExists(this.uniqueConstraintDescriptor(label, prop1)));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)tx.schemaRead().constraintExists(this.uniqueConstraintDescriptor(label, prop2)));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldFindAllConstraints() throws Exception {
        this.addConstraints("FOO", "prop1", "BAR", "prop2", "BAZ", "prop3");
        try (KernelTransaction tx = ConstraintTestBase.beginTransaction();){
            List constraints = Iterators.asList((Iterator)tx.schemaRead().constraintsGetAll());
            Assertions.assertThat((List)constraints).hasSize(3);
        }
    }

    @Test
    void shouldCheckUniquenessWhenAddingLabel() throws Exception {
        int label;
        long nodeNotConflicting;
        long nodeConflicting;
        this.addConstraints("FOO", "prop");
        try (Transaction tx = graphDb.beginTx();){
            Node conflict = tx.createNode();
            conflict.setProperty("prop", (Object)1337);
            nodeConflicting = conflict.getId();
            Node ok = tx.createNode();
            ok.setProperty("prop", (Object)42);
            nodeNotConflicting = ok.getId();
            Node existing = tx.createNode();
            existing.addLabel(Label.label((String)"FOO"));
            existing.setProperty("prop", (Object)1337);
            tx.commit();
        }
        try (KernelTransaction tx = ConstraintTestBase.beginTransaction();){
            label = tx.tokenWrite().labelGetOrCreateForName("FOO");
            org.junit.jupiter.api.Assertions.assertTrue((boolean)tx.dataWrite().nodeAddLabel(nodeNotConflicting, label));
            try {
                tx.dataWrite().nodeAddLabel(nodeConflicting, label);
                org.junit.jupiter.api.Assertions.fail();
            }
            catch (ConstraintValidationException ok) {
                // empty catch block
            }
            tx.commit();
        }
        tx = ConstraintTestBase.beginTransaction();
        try (NodeCursor nodeCursor = tx.cursors().allocateNodeCursor(tx.cursorContext());){
            tx.dataRead().singleNode(nodeNotConflicting, nodeCursor);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)nodeCursor.next());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)nodeCursor.labels().contains(label));
            tx.dataRead().singleNode(nodeConflicting, nodeCursor);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)nodeCursor.next());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)nodeCursor.labels().contains(label));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldCheckUniquenessWhenAddingProperties() throws Exception {
        int property;
        long nodeNotConflicting;
        long nodeConflicting;
        this.addConstraints("FOO", "prop");
        try (Transaction tx = graphDb.beginTx();){
            Node conflict = tx.createNode();
            conflict.addLabel(Label.label((String)"FOO"));
            nodeConflicting = conflict.getId();
            Node ok = tx.createNode();
            ok.addLabel(Label.label((String)"BAR"));
            nodeNotConflicting = ok.getId();
            Node existing = tx.createNode();
            existing.addLabel(Label.label((String)"FOO"));
            existing.setProperty("prop", (Object)1337);
            tx.commit();
        }
        try (KernelTransaction tx = ConstraintTestBase.beginTransaction();){
            property = tx.tokenWrite().propertyKeyGetOrCreateForName("prop");
            tx.dataWrite().nodeSetProperty(nodeNotConflicting, property, (Value)Values.intValue((int)1337));
            try {
                tx.dataWrite().nodeSetProperty(nodeConflicting, property, (Value)Values.intValue((int)1337));
                org.junit.jupiter.api.Assertions.fail();
            }
            catch (ConstraintValidationException ok) {
                // empty catch block
            }
            tx.commit();
        }
        tx = ConstraintTestBase.beginTransaction();
        try (NodeCursor nodeCursor = tx.cursors().allocateNodeCursor(tx.cursorContext());
             PropertyCursor propertyCursor = tx.cursors().allocatePropertyCursor(tx.cursorContext(), tx.memoryTracker());){
            tx.dataRead().singleNode(nodeNotConflicting, nodeCursor);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)nodeCursor.next());
            nodeCursor.properties(propertyCursor, PropertySelection.selection((int)property));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)propertyCursor.next());
            tx.dataRead().singleNode(nodeConflicting, nodeCursor);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)nodeCursor.next());
            nodeCursor.properties(propertyCursor, PropertySelection.selection((int)property));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)propertyCursor.next());
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private void addConstraints(String ... labelProps) {
        assert (labelProps.length % 2 == 0);
        try (Transaction tx = graphDb.beginTx();){
            for (int i = 0; i < labelProps.length; i += 2) {
                tx.schema().constraintFor(Label.label((String)labelProps[i])).assertPropertyIsUnique(labelProps[i + 1]).create();
            }
            tx.commit();
        }
    }
}

