/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.IndexingAcceptanceTestBase;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.SchemaAcceptanceTest;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.helpers.collection.MapUtil;

public class NodeIndexingAcceptanceTest {

    @Nested
    class RangeIndexTest
    extends NodeIndexingAcceptanceTestBase {
        RangeIndexTest() {
        }

        @Override
        protected IndexType indexType() {
            return IndexType.RANGE;
        }
    }

    static abstract class NodeIndexingAcceptanceTestBase
    extends IndexingAcceptanceTestBase<Label, Node> {
        NodeIndexingAcceptanceTestBase() {
        }

        @Override
        protected Label createToken(String name) {
            return Label.label((String)name);
        }

        @Override
        protected Node createEntity(GraphDatabaseService db, Map<String, Object> properties, Label label) {
            return NodeIndexingAcceptanceTestBase.createNode(db, properties, label);
        }

        private static Node createNode(GraphDatabaseService db, Map<String, Object> properties, Label ... labels) {
            try (Transaction tx = db.beginTx();){
                Node node = tx.createNode(labels);
                properties.forEach((arg_0, arg_1) -> ((Node)node).setProperty(arg_0, arg_1));
                tx.commit();
                Node node2 = node;
                return node2;
            }
        }

        @Override
        protected Node createEntity(Transaction tx, Label label) {
            return tx.createNode(new Label[]{label});
        }

        @Override
        protected void deleteEntity(Transaction tx, long id) {
            tx.getNodeById(id).delete();
        }

        @Override
        protected Node getEntity(Transaction tx, long id) {
            return tx.getNodeById(id);
        }

        @Override
        protected IndexDefinition createIndex(GraphDatabaseService db, IndexType indexType, Label token, String ... properties) {
            return SchemaAcceptanceTest.createIndex((GraphDatabaseService)db, (IndexType)indexType, (Label)token, (String[])properties);
        }

        @Override
        protected List<Node> findEntitiesByTokenAndProperty(Transaction tx, Label label, String propertyName, Object value) {
            return Iterators.asList((Iterator)tx.findNodes(label, propertyName, value));
        }

        @Override
        protected ResourceIterator<Node> findEntities(Transaction tx, Label label, String key, Object value) {
            return tx.findNodes(label, key, value);
        }

        @Override
        protected Node findEntity(Transaction tx, Label label, String key, Object value) {
            return tx.findNode(label, key, value);
        }

        @Test
        void shouldUseDynamicPropertiesToIndexANodeWhenAddedAlongsideExistingPropertiesInASeparateTransaction() {
            Node myNode;
            long id = NodeIndexingAcceptanceTestBase.createNode((GraphDatabaseService)this.db, MapUtil.map((Object[])new Object[]{"key0", true, "key1", true}), new Label[0]).getId();
            this.createIndex((GraphDatabaseService)this.db, this.indexType(), (Label)this.TOKEN1, "key2");
            try (Transaction tx = this.db.beginTx();){
                myNode = tx.getNodeById(id);
                myNode.addLabel((Label)this.TOKEN1);
                myNode.setProperty("key2", (Object)"a long string that has to be stored in dynamic records");
                myNode.setProperty("key3", (Object)"a long string that has to be stored in dynamic records");
                tx.commit();
            }
            try (Transaction transaction = this.db.beginTx();){
                myNode = transaction.getNodeById(myNode.getId());
                org.junit.jupiter.api.Assertions.assertEquals((Object)"a long string that has to be stored in dynamic records", (Object)myNode.getProperty("key2"));
                org.junit.jupiter.api.Assertions.assertEquals((Object)"a long string that has to be stored in dynamic records", (Object)myNode.getProperty("key3"));
                Assertions.assertThat(this.findEntitiesByTokenAndProperty(transaction, (Label)this.TOKEN1, "key2", (Object)"a long string that has to be stored in dynamic records")).containsOnly((Object[])new Node[]{myNode});
            }
        }

        @Test
        void shouldCorrectlyUpdateIndexesWhenChangingLabelsAndPropertyAtTheSameTime() {
            Node myNode = NodeIndexingAcceptanceTestBase.createNode((GraphDatabaseService)this.db, MapUtil.map((Object[])new Object[]{"name", "Hawking"}), (Label)this.TOKEN1, (Label)this.TOKEN2);
            this.createIndex((GraphDatabaseService)this.db, this.indexType(), (Label)this.TOKEN1, "name");
            this.createIndex((GraphDatabaseService)this.db, this.indexType(), (Label)this.TOKEN2, "name");
            this.createIndex((GraphDatabaseService)this.db, this.indexType(), (Label)this.TOKEN3, "name");
            try (Transaction tx = this.db.beginTx();){
                myNode = tx.getNodeById(myNode.getId());
                myNode.removeLabel((Label)this.TOKEN1);
                myNode.addLabel((Label)this.TOKEN3);
                myNode.setProperty("name", (Object)"Einstein");
                tx.commit();
            }
            try (Transaction transaction = this.db.beginTx();){
                myNode = transaction.getNodeById(myNode.getId());
                org.junit.jupiter.api.Assertions.assertEquals((Object)"Einstein", (Object)myNode.getProperty("name"));
                Assertions.assertThat((Iterable)myNode.getLabels()).containsOnly((Object[])new Label[]{(Label)this.TOKEN2, (Label)this.TOKEN3});
                Assertions.assertThat(this.findEntitiesByTokenAndProperty(transaction, (Label)this.TOKEN1, "name", (Object)"Hawking")).isEmpty();
                Assertions.assertThat(this.findEntitiesByTokenAndProperty(transaction, (Label)this.TOKEN1, "name", (Object)"Einstein")).isEmpty();
                Assertions.assertThat(this.findEntitiesByTokenAndProperty(transaction, (Label)this.TOKEN2, "name", (Object)"Hawking")).isEmpty();
                Assertions.assertThat(this.findEntitiesByTokenAndProperty(transaction, (Label)this.TOKEN2, "name", (Object)"Einstein")).containsOnly((Object[])new Node[]{myNode});
                Assertions.assertThat(this.findEntitiesByTokenAndProperty(transaction, (Label)this.TOKEN3, "name", (Object)"Hawking")).isEmpty();
                Assertions.assertThat(this.findEntitiesByTokenAndProperty(transaction, (Label)this.TOKEN3, "name", (Object)"Einstein")).containsOnly((Object[])new Node[]{myNode});
                transaction.commit();
            }
        }

        @Test
        void shouldCorrectlyUpdateIndexesWhenChangingLabelsAndPropertyMultipleTimesAllAtOnce() {
            Node myNode = NodeIndexingAcceptanceTestBase.createNode((GraphDatabaseService)this.db, MapUtil.map((Object[])new Object[]{"name", "Hawking"}), (Label)this.TOKEN1, (Label)this.TOKEN2);
            this.createIndex((GraphDatabaseService)this.db, this.indexType(), (Label)this.TOKEN1, "name");
            this.createIndex((GraphDatabaseService)this.db, this.indexType(), (Label)this.TOKEN2, "name");
            this.createIndex((GraphDatabaseService)this.db, this.indexType(), (Label)this.TOKEN3, "name");
            try (Transaction tx = this.db.beginTx();){
                myNode = tx.getNodeById(myNode.getId());
                myNode.addLabel((Label)this.TOKEN3);
                myNode.setProperty("name", (Object)"Einstein");
                myNode.removeLabel((Label)this.TOKEN1);
                myNode.setProperty("name", (Object)"Feynman");
                tx.commit();
            }
            try (Transaction transaction = this.db.beginTx();){
                myNode = transaction.getNodeById(myNode.getId());
                org.junit.jupiter.api.Assertions.assertEquals((Object)"Feynman", (Object)myNode.getProperty("name"));
                Assertions.assertThat((Iterable)myNode.getLabels()).containsOnly((Object[])new Label[]{(Label)this.TOKEN2, (Label)this.TOKEN3});
                Assertions.assertThat(this.findEntitiesByTokenAndProperty(transaction, (Label)this.TOKEN1, "name", (Object)"Hawking")).isEmpty();
                Assertions.assertThat(this.findEntitiesByTokenAndProperty(transaction, (Label)this.TOKEN1, "name", (Object)"Einstein")).isEmpty();
                Assertions.assertThat(this.findEntitiesByTokenAndProperty(transaction, (Label)this.TOKEN1, "name", (Object)"Feynman")).isEmpty();
                Assertions.assertThat(this.findEntitiesByTokenAndProperty(transaction, (Label)this.TOKEN2, "name", (Object)"Hawking")).isEmpty();
                Assertions.assertThat(this.findEntitiesByTokenAndProperty(transaction, (Label)this.TOKEN2, "name", (Object)"Einstein")).isEmpty();
                Assertions.assertThat(this.findEntitiesByTokenAndProperty(transaction, (Label)this.TOKEN2, "name", (Object)"Feynman")).containsOnly((Object[])new Node[]{myNode});
                Assertions.assertThat(this.findEntitiesByTokenAndProperty(transaction, (Label)this.TOKEN3, "name", (Object)"Hawking")).isEmpty();
                Assertions.assertThat(this.findEntitiesByTokenAndProperty(transaction, (Label)this.TOKEN3, "name", (Object)"Einstein")).isEmpty();
                Assertions.assertThat(this.findEntitiesByTokenAndProperty(transaction, (Label)this.TOKEN3, "name", (Object)"Feynman")).containsOnly((Object[])new Node[]{myNode});
                transaction.commit();
            }
        }

        @Test
        void shouldAddIndexedPropertyToNodeWithDynamicLabels() {
            long nodeId;
            int indexesCount = 20;
            String labelPrefix = "foo";
            String propertyKeyPrefix = "bar";
            String propertyValuePrefix = "baz";
            for (int i = 0; i < indexesCount; ++i) {
                this.createIndex((GraphDatabaseService)this.db, this.indexType(), this.createToken(labelPrefix + i), propertyKeyPrefix + i);
            }
            try (Transaction tx = this.db.beginTx();){
                nodeId = tx.createNode().getId();
                tx.commit();
            }
            tx = this.db.beginTx();
            try {
                Node node = tx.getNodeById(nodeId);
                for (int i = 0; i < indexesCount; ++i) {
                    node.addLabel(Label.label((String)(labelPrefix + i)));
                    node.setProperty(propertyKeyPrefix + i, (Object)(propertyValuePrefix + i));
                }
                tx.commit();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
            tx = this.db.beginTx();
            try {
                for (int i = 0; i < indexesCount; ++i) {
                    Label label = Label.label((String)(labelPrefix + i));
                    String key = propertyKeyPrefix + i;
                    String value = propertyValuePrefix + i;
                    ResourceIterator<Node> nodes = this.findEntities(tx, label, key, (Object)value);
                    org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)Iterators.count(nodes));
                }
                tx.commit();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }

        @Override
        protected String getMultipleEntitiesMessageTemplate() {
            return "Found multiple nodes with label: '%s', property name: 'name' and property value: 'Stefan' while only one was expected.";
        }
    }
}

