/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.ZippedStoreCommunity;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.index.IndexUsageStats;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.coreapi.TransactionImpl;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
public class IndexUsageStatsBehindKernelVersionIT {
    @Inject
    private TestDirectory testDirectory;
    private DatabaseManagementService dbms;

    @AfterEach
    void tearDown() {
        if (this.dbms != null) {
            this.dbms.shutdown();
        }
    }

    @Test
    void shouldReportDefaultValuesWhenKernelVersionIsOld() throws KernelException, IOException {
        ZippedStoreCommunity storeWithOldKernelVersion = ZippedStoreCommunity.REC_AF11_V50_EMPTY;
        storeWithOldKernelVersion.unzip(this.testDirectory.homePath());
        GraphDatabaseAPI db = this.database();
        String indexName = this.createIndex(db);
        this.singleIndexRead(db, indexName);
        this.triggerReportUsageStatistics(db);
        try (InternalTransaction tx = db.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED);){
            IndexUsageStats stats = this.getIndexUsageStats(tx, indexName);
            Assertions.assertThat((long)stats.trackedSince()).isEqualTo(0L);
            Assertions.assertThat((long)stats.lastRead()).isEqualTo(0L);
            Assertions.assertThat((long)stats.readCount()).isEqualTo(0L);
        }
    }

    @Test
    void assertDeliverCorrectValueAfterUpgradeToLatestKernelVersion() throws KernelException, IOException {
        ZippedStoreCommunity storeWithOldKernelVersion = ZippedStoreCommunity.REC_AF11_V50_EMPTY;
        storeWithOldKernelVersion.unzip(this.testDirectory.homePath());
        GraphDatabaseAPI db = this.database();
        String indexName = this.createIndex(db);
        this.triggerUpgrade(db);
        this.singleIndexRead(db, indexName);
        this.triggerReportUsageStatistics(db);
        try (InternalTransaction tx = db.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED);){
            IndexUsageStats stats = this.getIndexUsageStats(tx, indexName);
            Assertions.assertThat((long)stats.trackedSince()).isGreaterThan(0L);
            Assertions.assertThat((long)stats.lastRead()).isGreaterThan(0L);
            Assertions.assertThat((long)stats.readCount()).isEqualTo(1L);
        }
    }

    private IndexUsageStats getIndexUsageStats(InternalTransaction tx, String indexName) throws IndexNotFoundKernelException {
        KernelTransaction ktx = tx.kernelTransaction();
        IndexDescriptor index = ktx.schemaRead().indexGetForName(indexName);
        return ktx.schemaRead().indexUsageStats(index);
    }

    private void triggerUpgrade(GraphDatabaseAPI db) {
        GraphDatabaseService system = this.dbms.database("system");
        system.executeTransactionally("CALL dbms.upgrade()");
        this.createWriteTransaction(db);
    }

    private void createWriteTransaction(GraphDatabaseAPI db) {
        try (Transaction tx = db.beginTx();){
            tx.createNode().delete();
            tx.commit();
        }
    }

    private String createIndex(GraphDatabaseAPI db) {
        String indexName = "index";
        try (Transaction tx = db.beginTx();){
            tx.schema().indexFor(Label.label((String)"Label")).on("prop").withName(indexName).create();
            tx.commit();
        }
        tx = db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        return indexName;
    }

    private void singleIndexRead(GraphDatabaseAPI db, String indexName) throws KernelException {
        try (Transaction tx = db.beginTx();){
            KernelTransaction ktx = ((TransactionImpl)tx).kernelTransaction();
            SchemaRead schemaRead = ktx.schemaRead();
            Read dataRead = ktx.dataRead();
            IndexDescriptor descriptor = schemaRead.indexGetForName(indexName);
            IndexReadSession indexReadSession = dataRead.indexReadSession(descriptor);
            try (NodeValueIndexCursor cursor = ktx.cursors().allocateNodeValueIndexCursor(ktx.cursorContext(), ktx.memoryTracker());){
                dataRead.nodeIndexSeek(QueryContext.NULL_CONTEXT, indexReadSession, cursor, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{PropertyIndexQuery.allEntries()});
                while (cursor.next()) {
                }
            }
            tx.commit();
        }
    }

    private GraphDatabaseAPI database() {
        this.dbms = new TestDatabaseManagementServiceBuilder(this.testDirectory.homePath()).setConfig(GraphDatabaseInternalSettings.automatic_upgrade_enabled, (Object)false).build();
        return (GraphDatabaseAPI)this.dbms.database("neo4j");
    }

    private void triggerReportUsageStatistics(GraphDatabaseAPI db) {
        ((IndexingService)db.getDependencyResolver().resolveDependency(IndexingService.class)).reportUsageStatistics();
    }
}

