/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index;

import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.index.IndexUsageStats;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.assertion.Assert;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.time.FakeClock;
import org.neo4j.time.SystemNanoClock;

@ImpermanentDbmsExtension(configurationCallback="configuration")
class IndexUsageStatsIT {
    private static final String LABEL = "Label";
    private static final String KEY = "key";
    private static final String INDEX_NAME = "myIndex";
    @Inject
    private GraphDatabaseAPI db;
    private long beforeCreateTime;
    private long beforeQueryTime;
    private final FakeClock fakeClock = new FakeClock(System.currentTimeMillis(), TimeUnit.MILLISECONDS);

    IndexUsageStatsIT() {
    }

    @ExtensionCallback
    void configuration(TestDatabaseManagementServiceBuilder builder) {
        builder.setClock((SystemNanoClock)this.fakeClock);
    }

    @BeforeEach
    void setup() {
        this.beforeCreateTime = this.fakeClock.millis();
        this.createIndex();
        this.fakeClock.forward(100L, TimeUnit.MILLISECONDS);
        this.beforeQueryTime = this.fakeClock.millis();
    }

    @Test
    void shouldGatherUsageStatsWhenUsingKernelAPI() throws KernelException {
        try (InternalTransaction tx = this.db.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED);){
            KernelTransaction ktx = tx.kernelTransaction();
            IndexDescriptor index = ktx.schemaRead().indexGetForName(INDEX_NAME);
            try (NodeValueIndexCursor cursor = ktx.cursors().allocateNodeValueIndexCursor(CursorContext.NULL_CONTEXT, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
                IndexReadSession indexSession = ktx.dataRead().indexReadSession(index);
                ktx.dataRead().nodeIndexSeek(ktx.queryContext(), indexSession, cursor, IndexQueryConstraints.unorderedValues(), new PropertyIndexQuery[]{PropertyIndexQuery.allEntries()});
                while (cursor.next()) {
                }
            }
            tx.commit();
        }
        this.triggerReportUsageStatistics();
        this.assertIndexUsageStats(stats -> {
            Assertions.assertThat((long)stats.trackedSince()).isGreaterThanOrEqualTo(this.beforeCreateTime);
            Assertions.assertThat((long)stats.lastRead()).isGreaterThanOrEqualTo(this.beforeQueryTime);
            Assertions.assertThat((long)stats.readCount()).isEqualTo(1L);
        });
    }

    @Test
    void shouldGatherUsageStatsWhenUsingCypher() throws IndexNotFoundKernelException {
        try (InternalTransaction tx = this.db.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED);){
            try (Result result = tx.execute(String.format("MATCH (n:%s) WHERE n.%s='hello' RETURN n", LABEL, KEY));){
                while (result.hasNext()) {
                    result.next();
                }
            }
            tx.commit();
        }
        this.triggerReportUsageStatistics();
        this.assertIndexUsageStats(stats -> {
            Assertions.assertThat((long)stats.trackedSince()).isGreaterThanOrEqualTo(this.beforeCreateTime);
            Assertions.assertThat((long)stats.lastRead()).isGreaterThanOrEqualTo(this.beforeQueryTime);
            Assertions.assertThat((long)stats.readCount()).isEqualTo(1L);
        });
    }

    @Test
    void shouldHaveRealValueForNotUsedYetIndex() throws IndexNotFoundKernelException {
        this.triggerReportUsageStatistics();
        this.assertIndexUsageStats(stats -> {
            Assertions.assertThat((long)stats.trackedSince()).isGreaterThanOrEqualTo(this.beforeCreateTime);
            Assertions.assertThat((long)stats.lastRead()).isEqualTo(0L);
            Assertions.assertThat((long)stats.readCount()).isEqualTo(0L);
        });
    }

    @Test
    void shouldHaveDefaultValueForNonExistingIndex() throws IndexNotFoundKernelException {
        this.triggerReportUsageStatistics();
        try (InternalTransaction tx = this.db.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED);){
            KernelTransaction ktx = tx.kernelTransaction();
            LabelSchemaDescriptor descriptor = SchemaDescriptors.forLabel((int)1, (int[])new int[]{42});
            IndexDescriptor nonExistingIndex = TestIndexDescriptorFactory.forSchema((long)13L, (SchemaDescriptor)descriptor);
            IndexUsageStats stats = ktx.schemaRead().indexUsageStats(nonExistingIndex);
            Assertions.assertThat((long)stats.trackedSince()).isEqualTo(0L);
            Assertions.assertThat((long)stats.lastRead()).isEqualTo(0L);
            Assertions.assertThat((long)stats.readCount()).isEqualTo(0L);
        }
    }

    @Test
    void shouldHaveDefaultValueIfNoPeriodicUpdateYet() throws IndexNotFoundKernelException {
        try (InternalTransaction tx = this.db.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED);){
            try (Result result = tx.execute(String.format("MATCH (n:%s) WHERE n.%s='hello' RETURN n", LABEL, KEY));){
                while (result.hasNext()) {
                    result.next();
                }
            }
            tx.commit();
        }
        this.assertIndexUsageStats(stats -> {
            Assertions.assertThat((long)stats.trackedSince()).isEqualTo(0L);
            Assertions.assertThat((long)stats.lastRead()).isEqualTo(0L);
            Assertions.assertThat((long)stats.readCount()).isEqualTo(0L);
        });
    }

    @Test
    void shouldRunPeriodicUpdateWhenClockIsForwarded() {
        this.fakeClock.forward(10L, TimeUnit.SECONDS);
        this.assertEventuallyIndexUsageStats(stats -> stats.trackedSince() >= this.beforeCreateTime);
    }

    @Test
    void shouldThrowWhenTryingToGetStatsFromDroppedIndex() throws KernelException {
        try (InternalTransaction tx = this.db.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED);){
            KernelTransaction ktx = tx.kernelTransaction();
            IndexDescriptor index = ktx.schemaRead().indexGetForName(INDEX_NAME);
            try (NodeValueIndexCursor cursor = ktx.cursors().allocateNodeValueIndexCursor(CursorContext.NULL_CONTEXT, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
                IndexReadSession indexSession = ktx.dataRead().indexReadSession(index);
                ktx.dataRead().nodeIndexSeek(ktx.queryContext(), indexSession, cursor, IndexQueryConstraints.unorderedValues(), new PropertyIndexQuery[]{PropertyIndexQuery.allEntries()});
                while (cursor.next()) {
                }
            }
            tx.commit();
        }
        this.triggerReportUsageStatistics();
        this.assertIndexUsageStats(stats -> {
            Assertions.assertThat((long)stats.trackedSince()).isGreaterThanOrEqualTo(this.beforeCreateTime);
            Assertions.assertThat((long)stats.lastRead()).isGreaterThanOrEqualTo(this.beforeQueryTime);
            Assertions.assertThat((long)stats.readCount()).isEqualTo(1L);
        });
        this.dropIndex();
        Assertions.assertThatThrownBy(this::getIndexUsageStats).isInstanceOf(IndexNotFoundKernelException.class);
    }

    @Test
    void shouldResetIndexStatsBetweenDropAndRecreate() throws KernelException {
        try (InternalTransaction tx = this.db.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED);){
            KernelTransaction ktx = tx.kernelTransaction();
            IndexDescriptor index = ktx.schemaRead().indexGetForName(INDEX_NAME);
            try (NodeValueIndexCursor cursor = ktx.cursors().allocateNodeValueIndexCursor(CursorContext.NULL_CONTEXT, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
                IndexReadSession indexSession = ktx.dataRead().indexReadSession(index);
                ktx.dataRead().nodeIndexSeek(ktx.queryContext(), indexSession, cursor, IndexQueryConstraints.unorderedValues(), new PropertyIndexQuery[]{PropertyIndexQuery.allEntries()});
                while (cursor.next()) {
                }
            }
            tx.commit();
        }
        this.triggerReportUsageStatistics();
        this.assertIndexUsageStats(stats -> {
            Assertions.assertThat((long)stats.trackedSince()).isGreaterThanOrEqualTo(this.beforeCreateTime);
            Assertions.assertThat((long)stats.lastRead()).isGreaterThanOrEqualTo(this.beforeQueryTime);
            Assertions.assertThat((long)stats.readCount()).isEqualTo(1L);
        });
        this.dropIndex();
        this.createIndex();
        this.triggerReportUsageStatistics();
        this.assertIndexUsageStats(stats -> {
            Assertions.assertThat((long)stats.trackedSince()).isGreaterThanOrEqualTo(this.beforeCreateTime);
            Assertions.assertThat((long)stats.lastRead()).isEqualTo(0L);
            Assertions.assertThat((long)stats.readCount()).isEqualTo(0L);
        });
    }

    private void createIndex() {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().indexFor(Label.label((String)LABEL)).on(KEY).withName(INDEX_NAME).create();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private void dropIndex() {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().getIndexByName(INDEX_NAME).drop();
            tx.commit();
        }
    }

    private void triggerReportUsageStatistics() {
        ((IndexingService)this.db.getDependencyResolver().resolveDependency(IndexingService.class)).reportUsageStatistics();
    }

    private void assertIndexUsageStats(Consumer<IndexUsageStats> asserter) throws IndexNotFoundKernelException {
        IndexUsageStats usageStats = this.getIndexUsageStats();
        asserter.accept(usageStats);
    }

    private IndexUsageStats getIndexUsageStats() throws IndexNotFoundKernelException {
        try (InternalTransaction tx = this.db.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED);){
            KernelTransaction ktx = tx.kernelTransaction();
            IndexDescriptor index = ktx.schemaRead().indexGetForName(INDEX_NAME);
            IndexUsageStats indexUsageStats = ktx.schemaRead().indexUsageStats(index);
            return indexUsageStats;
        }
    }

    private void assertEventuallyIndexUsageStats(Predicate<IndexUsageStats> asserter) {
        try (InternalTransaction tx = this.db.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED);){
            KernelTransaction ktx = tx.kernelTransaction();
            IndexDescriptor index = ktx.schemaRead().indexGetForName(INDEX_NAME);
            Assert.assertEventually(() -> ktx.schemaRead().indexUsageStats(index), asserter, (long)1L, (TimeUnit)TimeUnit.MINUTES);
        }
    }
}

