/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index;

import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;

abstract class NativeIndexRestartAction {
    final IndexProviderDescriptor providerDescriptor;

    NativeIndexRestartAction(IndexProviderDescriptor providerDescriptor) {
        this.providerDescriptor = providerDescriptor;
    }

    public void run(FileSystemAbstraction fs, DatabaseLayout databaseLayout, ImmutableSet<OpenOption> openOptions) throws IOException {
        IndexDirectoryStructure indexDirectoryStructure = NativeIndexRestartAction.nativeIndexDirectoryStructure(databaseLayout, this.providerDescriptor);
        this.runOnDirectoryStructure(fs, indexDirectoryStructure, openOptions);
    }

    protected abstract void runOnDirectoryStructure(FileSystemAbstraction var1, IndexDirectoryStructure var2, ImmutableSet<OpenOption> var3) throws IOException;

    static IndexDirectoryStructure nativeIndexDirectoryStructure(DatabaseLayout databaseLayout, IndexProviderDescriptor providerDescriptor) {
        return IndexDirectoryStructure.directoriesByProvider((Path)databaseLayout.databaseDirectory()).forProvider(providerDescriptor);
    }
}

