/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Random;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.index.NativeIndexRestartAction;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;

public class SabotageNativeIndex
extends NativeIndexRestartAction {
    private final Random random;

    SabotageNativeIndex(Random random, IndexProviderDescriptor descriptor) {
        super(descriptor);
        this.random = random;
    }

    @Override
    protected void runOnDirectoryStructure(FileSystemAbstraction fs, IndexDirectoryStructure indexDirectoryStructure, ImmutableSet<OpenOption> openOptions) throws IOException {
        int files = this.scrambleIndexFiles(fs, indexDirectoryStructure.rootDirectory());
        ((AbstractIntegerAssert)Assertions.assertThat((int)files).as("there is no index to sabotage", new Object[0])).isGreaterThanOrEqualTo(1);
    }

    private int scrambleIndexFiles(FileSystemAbstraction fs, Path fileOrDir) throws IOException {
        if (fs.isDirectory(fileOrDir)) {
            Path[] children;
            int count = 0;
            for (Path child : children = fs.listFiles(fileOrDir)) {
                count += this.scrambleIndexFiles(fs, child);
            }
            return count;
        }
        try (StoreChannel channel = fs.write(fileOrDir);){
            if (channel.size() > ByteUnit.mebiBytes((long)10L)) {
                throw new IllegalArgumentException("Was expecting small files here");
            }
            byte[] bytes = new byte[(int)channel.size()];
            this.random.nextBytes(bytes);
            channel.writeAll(ByteBuffer.wrap(bytes));
        }
        return 1;
    }
}

