/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.util.Iterator;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.kernel.api.impl.fulltext.FulltextProceduresTestSupport;

class FulltextIndexQueryAnalyzerTest
extends FulltextProceduresTestSupport {
    private String topEntity;
    private String middleEntity;
    private String bottomEntity;

    FulltextIndexQueryAnalyzerTest() {
    }

    private void setUp(FulltextProceduresTestSupport.EntityUtil entityUtil) {
        try (Transaction tx = this.db.beginTx();){
            entityUtil.createIndexWithAnalyzer(tx, "caseSensitive");
            tx.commit();
        }
        this.awaitIndexesOnline();
        tx = this.db.beginTx();
        try {
            this.topEntity = entityUtil.createEntityWithProperty(tx, "zebra zebra zebra zebra donkey");
            this.middleEntity = entityUtil.createEntityWithProperty(tx, "zebra zebra zebra donkey");
            this.bottomEntity = entityUtil.createEntityWithProperty(tx, "ZEBRA donkey");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @MethodSource(value={"entityTypeProvider"})
    @ParameterizedTest
    void shouldBePossibleToSelectAnalyzerAtQueryTime(FulltextProceduresTestSupport.EntityUtil entityUtil) {
        ResourceIterator<Entity> iterator;
        this.setUp(entityUtil);
        try (Transaction tx = this.db.beginTx();){
            iterator = entityUtil.queryIndexWithOptions(tx, "ZEBRA", "{}");
            try {
                Assertions.assertThat((String)((Entity)iterator.next()).getElementId()).isEqualTo(this.bottomEntity);
                org.junit.jupiter.api.Assertions.assertFalse((boolean)iterator.hasNext());
                tx.commit();
            }
            finally {
                if (iterator != null) {
                    iterator.close();
                }
            }
        }
        tx = this.db.beginTx();
        try {
            iterator = entityUtil.queryIndexWithOptions(tx, "ZEBRA", "{analyzer:'standard'}");
            try {
                Assertions.assertThat((List)Iterators.asList((Iterator)iterator.map(Entity::getElementId))).containsExactlyInAnyOrder((Object[])new String[]{this.topEntity, this.middleEntity});
            }
            finally {
                if (iterator != null) {
                    iterator.close();
                }
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @MethodSource(value={"entityTypeProvider"})
    @ParameterizedTest
    void shouldFailOnNonExistingAnalyzerAtQueryTime(FulltextProceduresTestSupport.EntityUtil entityUtil) {
        this.setUp(entityUtil);
        Assertions.assertThatThrownBy(() -> {
            try (Transaction tx = this.db.beginTx();
                 ResourceIterator<Entity> iterator = entityUtil.queryIndexWithOptions(tx, "ZEBRA", "{analyzer:'hej'}");){
                org.junit.jupiter.api.Assertions.assertFalse((boolean)iterator.hasNext());
            }
        }).hasMessageContaining("Could not create fulltext analyzer: hej. Could not find service provider");
    }
}

