/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Path;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.cli.ExecutionContext;
import org.neo4j.commandline.dbms.MigrateStoreCommand;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.coreapi.TransactionImpl;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.Unzip;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.tags.MultiVersionedTag;
import org.neo4j.test.utils.TestDirectory;
import picocli.CommandLine;

@TestDirectoryExtension
@MultiVersionedTag
class Lucene8IndexCompatibilityTest {
    private static final String ARCHIVE_NAME = "4-4-lucene-idx-db.zip";
    private static final String TEXT_IDX_NAME = "TextIndex";
    private static final String FULLTEXT_IDX_NAME = "FulltextIndex";
    private static final String LABEL = "Label";
    private static final String PROPERTY = "property";
    @Inject
    TestDirectory testDirectory;
    private DatabaseManagementService dbms;
    private GraphDatabaseService db;

    Lucene8IndexCompatibilityTest() {
    }

    @BeforeEach
    void beforeEach() throws Exception {
        Unzip.unzip(this.getClass(), (String)ARCHIVE_NAME, (Path)this.testDirectory.homePath());
        this.runStoreMigrationCommandFromSameJvm();
        this.dbms = new TestDatabaseManagementServiceBuilder(this.testDirectory.homePath()).build();
        this.db = this.dbms.database("neo4j");
    }

    @AfterEach
    void tearDown() {
        if (this.dbms != null) {
            this.dbms.shutdown();
        }
    }

    @Test
    void testExistingIndexesWork() throws KernelException {
        this.assertTextIndexContainsExactlyValues("Text 0 written by 4.4", "Text 1 written by 4.4", "Text 2 written by 4.4", "Text 3 written by 4.4", "Text 4 written by 4.4");
        this.assertFulltextIndexContainsExactlyValues("Text 0 written by 4.4", "Text 1 written by 4.4", "Text 2 written by 4.4", "Text 3 written by 4.4", "Text 4 written by 4.4");
        try (Transaction tx = this.db.beginTx();){
            Node node1 = tx.findNode(Label.label((String)LABEL), PROPERTY, (Object)"Text 1 written by 4.4");
            node1.setProperty(PROPERTY, (Object)"New text 1");
            Node node2 = tx.findNode(Label.label((String)LABEL), PROPERTY, (Object)"Text 3 written by 4.4");
            node2.delete();
            Node node3 = tx.createNode(new Label[]{Label.label((String)LABEL)});
            node3.setProperty(PROPERTY, (Object)"New text 2");
            tx.commit();
        }
        this.assertTextIndexContainsExactlyValues("Text 0 written by 4.4", "Text 2 written by 4.4", "Text 4 written by 4.4", "New text 1", "New text 2");
        this.assertFulltextIndexContainsExactlyValues("Text 0 written by 4.4", "Text 2 written by 4.4", "Text 4 written by 4.4", "New text 1", "New text 2");
    }

    private void assertTextIndexContainsExactlyValues(String ... values) throws KernelException {
        try (Transaction tx = this.db.beginTx();){
            KernelTransaction kernelTx = ((TransactionImpl)tx).kernelTransaction();
            IndexDescriptor index = kernelTx.schemaRead().indexGetForName(TEXT_IDX_NAME);
            IndexReadSession indexSession = kernelTx.dataRead().indexReadSession(index);
            try (NodeValueIndexCursor cursor = kernelTx.cursors().allocateNodeValueIndexCursor(kernelTx.cursorContext(), kernelTx.memoryTracker());){
                kernelTx.dataRead().nodeIndexSeek(kernelTx.queryContext(), indexSession, cursor, IndexQueryConstraints.unordered((boolean)false), new PropertyIndexQuery[]{PropertyIndexQuery.allEntries()});
                int entryCounter = 0;
                while (cursor.next()) {
                    ++entryCounter;
                }
                Assertions.assertEquals((int)values.length, (int)entryCounter);
            }
            int prop = kernelTx.tokenRead().propertyKey(PROPERTY);
            for (String value : values) {
                try (NodeValueIndexCursor cursor = kernelTx.cursors().allocateNodeValueIndexCursor(kernelTx.cursorContext(), kernelTx.memoryTracker());){
                    PropertyIndexQuery.ExactPredicate predicate = PropertyIndexQuery.exact((int)prop, (Object)value);
                    kernelTx.dataRead().nodeIndexSeek(kernelTx.queryContext(), indexSession, cursor, IndexQueryConstraints.unordered((boolean)false), new PropertyIndexQuery[]{predicate});
                    Assertions.assertTrue((boolean)cursor.next());
                }
            }
        }
    }

    private void assertFulltextIndexContainsExactlyValues(String ... values) throws KernelException {
        try (Transaction tx = this.db.beginTx();){
            KernelTransaction kernelTx = ((TransactionImpl)tx).kernelTransaction();
            IndexDescriptor index = kernelTx.schemaRead().indexGetForName(FULLTEXT_IDX_NAME);
            IndexReadSession indexSession = kernelTx.dataRead().indexReadSession(index);
            try (NodeValueIndexCursor cursor = kernelTx.cursors().allocateNodeValueIndexCursor(kernelTx.cursorContext(), kernelTx.memoryTracker());){
                kernelTx.dataRead().nodeIndexSeek(kernelTx.queryContext(), indexSession, cursor, IndexQueryConstraints.unordered((boolean)false), new PropertyIndexQuery[]{PropertyIndexQuery.fulltextSearch((String)"*")});
                int entryCounter = 0;
                while (cursor.next()) {
                    ++entryCounter;
                }
                Assertions.assertEquals((int)values.length, (int)entryCounter);
            }
            for (String value : values) {
                try (NodeValueIndexCursor cursor = kernelTx.cursors().allocateNodeValueIndexCursor(kernelTx.cursorContext(), kernelTx.memoryTracker());){
                    kernelTx.dataRead().nodeIndexSeek(kernelTx.queryContext(), indexSession, cursor, IndexQueryConstraints.unordered((boolean)false), new PropertyIndexQuery[]{PropertyIndexQuery.fulltextSearch((String)value)});
                    Assertions.assertTrue((boolean)cursor.next());
                }
            }
        }
    }

    private void runStoreMigrationCommandFromSameJvm() throws Exception {
        Path homeDir = this.testDirectory.homePath().toAbsolutePath();
        Path configDir = homeDir.resolve("conf");
        PrintStream nullOut = new PrintStream(OutputStream.nullOutputStream());
        ExecutionContext ctx = new ExecutionContext(homeDir, configDir, nullOut, nullOut, (FileSystemAbstraction)new DefaultFileSystemAbstraction());
        MigrateStoreCommand command = (MigrateStoreCommand)CommandLine.populateCommand((Object)new MigrateStoreCommand(ctx), (String[])new String[]{"*"});
        command.call();
    }
}

