/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.schema;

import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.kernel.impl.index.schema.config.SpatialIndexValueTestUtil;
import org.neo4j.test.TestLabels;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.values.storable.PointValue;

@DbmsExtension
class UniqueSpatialIndexIT {
    private static final String KEY = "prop";
    @Inject
    private GraphDatabaseService db;
    private PointValue point1;
    private PointValue point2;

    UniqueSpatialIndexIT() {
    }

    @BeforeEach
    void setup() {
        Pair collidingPoints = SpatialIndexValueTestUtil.pointsWithSameValueOnSpaceFillingCurve((Config)Config.defaults());
        this.point1 = (PointValue)collidingPoints.first();
        this.point2 = (PointValue)collidingPoints.other();
    }

    @Test
    void shouldPopulateIndexWithUniquePointsThatCollideOnSpaceFillingCurve() {
        Pair<Long, Long> nodeIds = this.createUniqueNodes();
        this.createUniquenessConstraint();
        this.assertBothNodesArePresent(nodeIds);
    }

    @Test
    void shouldAddPointsThatCollideOnSpaceFillingCurveToUniqueIndexInSameTx() {
        this.createUniquenessConstraint();
        Pair<Long, Long> nodeIds = this.createUniqueNodes();
        this.assertBothNodesArePresent(nodeIds);
    }

    @Test
    void shouldThrowWhenPopulatingWithNonUniquePoints() {
        this.createNonUniqueNodes();
        Assertions.assertThrows(ConstraintViolationException.class, this::createUniquenessConstraint);
    }

    @Test
    void shouldThrowWhenAddingNonUniquePoints() {
        this.createUniquenessConstraint();
        Assertions.assertThrows(ConstraintViolationException.class, this::createNonUniqueNodes);
    }

    private void createNonUniqueNodes() {
        try (Transaction tx = this.db.beginTx();){
            Node originNode = tx.createNode(new Label[]{TestLabels.LABEL_ONE});
            originNode.setProperty(KEY, (Object)this.point1);
            Node centerNode = tx.createNode(new Label[]{TestLabels.LABEL_ONE});
            centerNode.setProperty(KEY, (Object)this.point1);
            tx.commit();
        }
    }

    private Pair<Long, Long> createUniqueNodes() {
        Pair nodeIds;
        try (Transaction tx = this.db.beginTx();){
            Node originNode = tx.createNode(new Label[]{TestLabels.LABEL_ONE});
            originNode.setProperty(KEY, (Object)this.point1);
            Node centerNode = tx.createNode(new Label[]{TestLabels.LABEL_ONE});
            centerNode.setProperty(KEY, (Object)this.point2);
            nodeIds = Pair.of((Object)originNode.getId(), (Object)centerNode.getId());
            tx.commit();
        }
        return nodeIds;
    }

    private void assertBothNodesArePresent(Pair<Long, Long> nodeIds) {
        try (Transaction tx = this.db.beginTx();){
            try (ResourceIterator origin = tx.findNodes(TestLabels.LABEL_ONE, KEY, (Object)this.point1);){
                Assertions.assertTrue((boolean)origin.hasNext());
                Assertions.assertEquals((long)((Long)nodeIds.first()), (long)((Node)origin.next()).getId());
                Assertions.assertFalse((boolean)origin.hasNext());
            }
            try (ResourceIterator center = tx.findNodes(TestLabels.LABEL_ONE, KEY, (Object)this.point2);){
                Assertions.assertTrue((boolean)center.hasNext());
                Assertions.assertEquals((long)((Long)nodeIds.other()), (long)((Node)center.next()).getId());
                Assertions.assertFalse((boolean)center.hasNext());
            }
            tx.commit();
        }
    }

    private void createUniquenessConstraint() {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().constraintFor(TestLabels.LABEL_ONE).assertPropertyIsUnique(KEY).create();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }
}

