/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.neo4j.common.DependencyResolver;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.IndexSettingUtil;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.PopulationProgress;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.coreapi.schema.IndexDefinitionImpl;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.test.Race;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@TestDirectoryExtension
public class IndexingServiceIntegrationTest {
    private static final String FOOD_LABEL = "food";
    private static final String CLOTHES_LABEL = "clothes";
    private static final String WEATHER_LABEL = "weather";
    private static final String PROPERTY_NAME = "name";
    private static final int NUMBER_OF_NODES = 100;
    @Inject
    private TestDirectory directory;
    private GraphDatabaseService database;
    private DatabaseManagementService managementService;

    @BeforeEach
    void setUp() {
        this.managementService = new TestDatabaseManagementServiceBuilder(this.directory.homePath()).build();
        this.database = this.managementService.database("neo4j");
        IndexingServiceIntegrationTest.createData(this.database);
    }

    @AfterEach
    void tearDown() {
        this.managementService.shutdown();
    }

    @Test
    void tracePageCacheAccessOnIndexUpdatesApply() throws KernelException {
        Label marker = Label.label((String)"marker");
        String propertyName = "property";
        String testConstraint = "testConstraint";
        try (Transaction transaction = this.database.beginTx();){
            transaction.schema().constraintFor(marker).withName(testConstraint).assertPropertyIsUnique(propertyName).create();
            transaction.commit();
        }
        DependencyResolver dependencyResolver = ((GraphDatabaseAPI)this.database).getDependencyResolver();
        IndexingService indexingService = (IndexingService)dependencyResolver.resolveDependency(IndexingService.class);
        CursorContextFactory contextFactory = (CursorContextFactory)dependencyResolver.resolveDependency(CursorContextFactory.class);
        try (Transaction transaction = this.database.beginTx();){
            KernelTransaction kernelTransaction = ((InternalTransaction)transaction).kernelTransaction();
            IndexDescriptor indexDescriptor = kernelTransaction.schemaRead().indexGetForName(testConstraint);
            try (CursorContext cursorContext = contextFactory.create("tracePageCacheAccessOnIndexUpdatesApply");){
                List<ValueIndexEntryUpdate> updates = List.of(IndexEntryUpdate.add((long)1L, (SchemaDescriptorSupplier)indexDescriptor, (Value[])new Value[]{Values.longValue((long)4L)}));
                indexingService.applyUpdates(updates, cursorContext, false);
                PageCursorTracer cursorTracer = cursorContext.getCursorTracer();
                Assertions.assertEquals((long)4L, (long)cursorTracer.pins());
                Assertions.assertEquals((long)4L, (long)cursorTracer.unpins());
                Assertions.assertEquals((long)2L, (long)cursorTracer.hits());
                Assertions.assertEquals((long)2L, (long)cursorTracer.faults());
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=IndexType.class, mode=EnumSource.Mode.EXCLUDE, names={"LOOKUP"})
    void testManualIndexPopulation(IndexType indexType) throws InterruptedException, IndexNotFoundKernelException {
        IndexDescriptor index;
        try (Transaction tx = this.database.beginTx();){
            IndexDefinitionImpl indexDefinition = (IndexDefinitionImpl)tx.schema().indexFor(Label.label((String)FOOD_LABEL)).on(PROPERTY_NAME).withIndexType(indexType).withIndexConfiguration(IndexSettingUtil.defaultSettingsForTesting((IndexType)indexType)).create();
            index = indexDefinition.getIndexReference();
            tx.commit();
        }
        IndexingService indexingService = IndexingServiceIntegrationTest.getIndexingService(this.database);
        IndexProxy indexProxy = indexingService.getIndexProxy(index);
        IndexingServiceIntegrationTest.waitIndexOnline(indexProxy);
        Assertions.assertEquals((Object)InternalIndexState.ONLINE, (Object)indexProxy.getState());
        PopulationProgress progress = indexProxy.getIndexPopulationProgress();
        Assertions.assertEquals((long)progress.getCompleted(), (long)progress.getTotal());
    }

    @ParameterizedTest
    @EnumSource(value=IndexType.class, mode=EnumSource.Mode.EXCLUDE, names={"LOOKUP", "VECTOR"})
    void testManualRelationshipIndexPopulation(IndexType indexType) throws Exception {
        IndexDescriptor index;
        try (Transaction tx = this.database.beginTx();){
            IndexDefinitionImpl indexDefinition = (IndexDefinitionImpl)tx.schema().indexFor(RelationshipType.withName((String)FOOD_LABEL)).on(PROPERTY_NAME).withIndexType(indexType).withIndexConfiguration(IndexSettingUtil.defaultSettingsForTesting((IndexType)indexType)).create();
            index = indexDefinition.getIndexReference();
            tx.commit();
        }
        IndexingService indexingService = IndexingServiceIntegrationTest.getIndexingService(this.database);
        IndexProxy indexProxy = indexingService.getIndexProxy(index);
        IndexingServiceIntegrationTest.waitIndexOnline(indexProxy);
        Assertions.assertEquals((Object)InternalIndexState.ONLINE, (Object)indexProxy.getState());
        PopulationProgress progress = indexProxy.getIndexPopulationProgress();
        Assertions.assertEquals((long)progress.getCompleted(), (long)progress.getTotal());
    }

    @ParameterizedTest
    @EnumSource(value=IndexType.class, mode=EnumSource.Mode.EXCLUDE, names={"LOOKUP"})
    void testSchemaIndexMatchIndexingService(IndexType indexType) throws IndexNotFoundKernelException {
        String constraintName = "MyConstraint";
        String indexName = "MyIndex";
        try (Transaction transaction = this.database.beginTx();){
            transaction.schema().constraintFor(Label.label((String)CLOTHES_LABEL)).assertPropertyIsUnique(PROPERTY_NAME).withName(constraintName).create();
            transaction.schema().indexFor(Label.label((String)WEATHER_LABEL)).on(PROPERTY_NAME).withIndexType(indexType).withIndexConfiguration(IndexSettingUtil.defaultSettingsForTesting((IndexType)indexType)).withName(indexName).create();
            transaction.commit();
        }
        try (Transaction tx = this.database.beginTx();){
            tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
        }
        IndexingService indexingService = IndexingServiceIntegrationTest.getIndexingService(this.database);
        IndexProxy clothesIndex = indexingService.getIndexProxy(this.getIndexByName(constraintName));
        IndexProxy weatherIndex = indexingService.getIndexProxy(this.getIndexByName(indexName));
        Assertions.assertEquals((Object)InternalIndexState.ONLINE, (Object)clothesIndex.getState());
        Assertions.assertEquals((Object)InternalIndexState.ONLINE, (Object)weatherIndex.getState());
    }

    @ParameterizedTest
    @EnumSource(value=IndexType.class, mode=EnumSource.Mode.EXCLUDE, names={"LOOKUP"})
    void dropIndexDirectlyOnIndexingServiceRaceWithCheckpoint(IndexType indexType) throws Throwable {
        IndexDescriptor indexDescriptor;
        IndexingService indexingService = IndexingServiceIntegrationTest.getIndexingService(this.database);
        CheckPointer checkPointer = IndexingServiceIntegrationTest.getCheckPointer(this.database);
        try (Transaction tx = this.database.beginTx();){
            IndexDefinitionImpl indexDefinition = (IndexDefinitionImpl)tx.schema().indexFor(Label.label((String)"label")).on("prop").withIndexType(indexType).withIndexConfiguration(IndexSettingUtil.defaultSettingsForTesting((IndexType)indexType)).create();
            indexDescriptor = indexDefinition.getIndexReference();
            tx.commit();
        }
        tx = this.database.beginTx();
        try {
            tx.schema().awaitIndexesOnline(1L, TimeUnit.HOURS);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        Race race = new Race();
        race.addContestant(Race.throwing(() -> checkPointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("Test force"))));
        race.addContestant(Race.throwing(() -> indexingService.dropIndex(indexDescriptor)));
        race.go();
    }

    @ParameterizedTest
    @EnumSource(value=IndexType.class, mode=EnumSource.Mode.EXCLUDE, names={"LOOKUP"})
    void dropIndexRaceWithCheckpoint(IndexType indexType) throws Throwable {
        CheckPointer checkPointer = IndexingServiceIntegrationTest.getCheckPointer(this.database);
        int nbrOfIndexes = 10;
        try (Transaction tx = this.database.beginTx();){
            for (int i = 0; i < nbrOfIndexes; ++i) {
                tx.schema().indexFor(Label.label((String)"label")).on("prop" + i).withIndexType(indexType).withIndexConfiguration(IndexSettingUtil.defaultSettingsForTesting((IndexType)indexType)).create();
            }
            tx.commit();
        }
        tx = this.database.beginTx();
        try {
            tx.schema().awaitIndexesOnline(1L, TimeUnit.HOURS);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        AtomicBoolean allIndexesDropped = new AtomicBoolean();
        Race race = new Race();
        race.addContestant(Race.throwing(() -> {
            while (!allIndexesDropped.get()) {
                checkPointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("Test force"));
            }
        }));
        race.addContestant(Race.throwing(() -> {
            try (Transaction tx = this.database.beginTx();){
                tx.schema().getIndexes().forEach(IndexDefinition::drop);
                tx.commit();
            }
            finally {
                allIndexesDropped.set(true);
            }
        }));
        race.go();
    }

    private static void waitIndexOnline(IndexProxy indexProxy) throws InterruptedException {
        while (InternalIndexState.ONLINE != indexProxy.getState()) {
            Thread.sleep(10L);
        }
    }

    private static IndexingService getIndexingService(GraphDatabaseService database) {
        return (IndexingService)IndexingServiceIntegrationTest.getDependencyResolver(database).resolveDependency(IndexingService.class);
    }

    private static CheckPointer getCheckPointer(GraphDatabaseService database) {
        return (CheckPointer)IndexingServiceIntegrationTest.getDependencyResolver(database).resolveDependency(CheckPointer.class);
    }

    private static DependencyResolver getDependencyResolver(GraphDatabaseService database) {
        return ((GraphDatabaseAPI)database).getDependencyResolver();
    }

    private static void createData(GraphDatabaseService database) {
        for (int i = 0; i < 100; ++i) {
            try (Transaction transaction = database.beginTx();){
                Node node = transaction.createNode(new Label[]{Label.label((String)FOOD_LABEL), Label.label((String)CLOTHES_LABEL), Label.label((String)WEATHER_LABEL)});
                node.setProperty(PROPERTY_NAME, (Object)("Node" + i));
                Relationship relationship = node.createRelationshipTo(node, RelationshipType.withName((String)FOOD_LABEL));
                relationship.setProperty(PROPERTY_NAME, (Object)("Relationship" + i));
                transaction.commit();
                continue;
            }
        }
    }

    private IndexDescriptor getIndexByName(String name) {
        try (Transaction tx = this.database.beginTx();){
            KernelTransaction transaction = ((InternalTransaction)tx).kernelTransaction();
            IndexDescriptor indexDescriptor = transaction.schemaRead().indexGetForName(name);
            return indexDescriptor;
        }
    }
}

