/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api;

import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.RelationshipValueIndexCursor;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotApplicableKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.newapi.KernelAPIReadTestBase;
import org.neo4j.kernel.impl.newapi.KernelAPIReadTestSupport;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;

public abstract class AbstractIndexQueryingTest<S extends KernelAPIReadTestSupport>
extends KernelAPIReadTestBase<S> {
    public void createTestGraph(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            tx.execute("CREATE FULLTEXT INDEX ftsNodes FOR (n:Label) ON EACH [n.prop]").close();
            tx.execute("CREATE FULLTEXT INDEX ftsRels FOR ()-[r:Type]-() ON EACH [r.prop]").close();
            tx.commit();
        }
        tx = db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void nodeIndexSeekMustThrowOnWrongIndexEntityType() throws Exception {
        IndexReadSession index = this.read.indexReadSession(this.schemaRead.indexGetForName("ftsRels"));
        try (NodeValueIndexCursor cursor = this.cursors.allocateNodeValueIndexCursor(CursorContext.NULL_CONTEXT, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            Assertions.assertThrows(IndexNotApplicableKernelException.class, () -> this.read.nodeIndexSeek(this.tx.queryContext(), index, cursor, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{PropertyIndexQuery.fulltextSearch((String)"search")}));
        }
    }

    @Test
    void relationshipIndexSeekMustThrowOnWrongIndexEntityType() throws IndexNotFoundKernelException {
        IndexDescriptor index = this.schemaRead.indexGetForName("ftsNodes");
        IndexReadSession indexReadSession = this.read.indexReadSession(index);
        try (RelationshipValueIndexCursor cursor = this.cursors.allocateRelationshipValueIndexCursor(CursorContext.NULL_CONTEXT, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            Assertions.assertThrows(IndexNotApplicableKernelException.class, () -> this.read.relationshipIndexSeek(this.tx.queryContext(), indexReadSession, cursor, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{PropertyIndexQuery.fulltextSearch((String)"search")}));
        }
    }
}

