/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.set.MutableSet;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.api.impl.fulltext.FulltextProceduresTestSupport;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.OtherThread;
import org.neo4j.test.extension.OtherThreadExtension;

@ExtendWith(value={OtherThreadExtension.class})
class FulltextIndexTransactionStateTest
extends FulltextProceduresTestSupport {
    @Inject
    private OtherThread otherThread;

    FulltextIndexTransactionStateTest() {
    }

    @MethodSource(value={"entityTypeProvider"})
    @ParameterizedTest
    void queryResultFromTransactionStateMustSortTogetherWithResultFromBaseIndex(FulltextProceduresTestSupport.EntityUtil entityUtil) {
        String thirdId;
        String firstId;
        this.createIndexAndWait(entityUtil);
        try (Transaction tx = this.db.beginTx();){
            firstId = entityUtil.createEntityWithProperty(tx, "God of War");
            thirdId = entityUtil.createEntityWithProperty(tx, "God Wars: Future Past");
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            String secondId = entityUtil.createEntityWithProperty(tx, "God of War III Remastered");
            entityUtil.assertQueryFindsIdsInOrder(tx, "god of war", firstId, secondId, thirdId);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @MethodSource(value={"entityTypeProvider"})
    @ParameterizedTest
    void queryResultsMustIncludeEntitiesAddedInTheSameTransaction(FulltextProceduresTestSupport.EntityUtil entityUtil) {
        this.createIndexAndWait(entityUtil);
        try (Transaction tx = this.db.beginTx();){
            String id = entityUtil.createEntityWithProperty(tx, "value");
            entityUtil.assertQueryFindsIdsInOrder(tx, "value", id);
            tx.commit();
        }
    }

    @MethodSource(value={"entityTypeProvider"})
    @ParameterizedTest
    void queryResultsMustNotIncludeEntitiesDeletedInTheSameTransaction(FulltextProceduresTestSupport.EntityUtil entityUtil) {
        String entityIdB;
        String entityIdA;
        this.createIndexAndWait(entityUtil);
        try (Transaction tx = this.db.beginTx();){
            entityIdA = entityUtil.createEntityWithProperty(tx, "value");
            entityIdB = entityUtil.createEntityWithProperty(tx, "value");
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            Object[] bothEntitiesResult = new String[]{entityIdA, entityIdB};
            Arrays.sort(bothEntitiesResult);
            entityUtil.assertQueryFindsIdsInOrder(tx, "value", (String[])bothEntitiesResult);
            entityUtil.deleteEntity(tx, entityIdA);
            entityUtil.assertQueryFindsIdsInOrder(tx, "value", entityIdB);
            entityUtil.deleteEntity(tx, entityIdB);
            entityUtil.assertQueryFindsIdsInOrder(tx, "value", new String[0]);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @MethodSource(value={"entityTypeProvider"})
    @ParameterizedTest
    void queryingIndexInPopulatingStateMustBlockUntilIndexIsOnlineEvenWhenTransactionHasState(FulltextProceduresTestSupport.EntityUtil entityUtil) throws InterruptedException {
        this.trapPopulation.set(true);
        try (Transaction tx = this.db.beginTx();){
            entityUtil.createEntityWithProperty(tx, "value");
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            entityUtil.createIndex(tx);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            entityUtil.createEntityWithProperty(tx, "value");
            try (Stream resultStream = entityUtil.queryIndex(tx, "value").stream();){
                this.populationScanFinished.await();
                this.populationScanFinished.release();
                Assertions.assertThat((long)resultStream.count()).isEqualTo(2L);
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @MethodSource(value={"entityTypeProvider"})
    @ParameterizedTest
    void queryResultsMustIncludeOldPropertyValuesWhenModificationsAreUndone(FulltextProceduresTestSupport.EntityUtil entityUtil) {
        String entityId;
        this.createIndexAndWait(entityUtil);
        try (Transaction tx = this.db.beginTx();){
            entityId = entityUtil.createEntityWithProperty(tx, "primo");
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            Entity entity = entityUtil.getEntity(tx, entityId);
            entityUtil.assertQueryFindsIdsInOrder(tx, "primo", entityId);
            entityUtil.assertQueryFindsIdsInOrder(tx, "secundo", new String[0]);
            entity.setProperty("prop", (Object)"secundo");
            entityUtil.assertQueryFindsIdsInOrder(tx, "primo", new String[0]);
            entityUtil.assertQueryFindsIdsInOrder(tx, "secundo", entityId);
            entity.setProperty("prop", (Object)"primo");
            entityUtil.assertQueryFindsIdsInOrder(tx, "primo", entityId);
            entityUtil.assertQueryFindsIdsInOrder(tx, "secundo", new String[0]);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @MethodSource(value={"entityTypeProvider"})
    @ParameterizedTest
    void queryResultsMustIncludeOldPropertyValuesWhenRemovalsAreUndone(FulltextProceduresTestSupport.EntityUtil entityUtil) {
        String entityId;
        this.createIndexAndWait(entityUtil);
        try (Transaction tx = this.db.beginTx();){
            entityId = entityUtil.createEntityWithProperty(tx, "primo");
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            entityUtil.assertQueryFindsIdsInOrder(tx, "primo", entityId);
            Entity entity = entityUtil.getEntity(tx, entityId);
            entity.removeProperty("prop");
            entityUtil.assertQueryFindsIdsInOrder(tx, "primo", new String[0]);
            entity.setProperty("prop", (Object)"primo");
            entityUtil.assertQueryFindsIdsInOrder(tx, "primo", entityId);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @MethodSource(value={"entityTypeProvider"})
    @ParameterizedTest
    void transactionStateMustNotPreventIndexUpdatesFromBeingApplied(FulltextProceduresTestSupport.EntityUtil entityUtil) throws Exception {
        this.createIndexAndWait(entityUtil);
        MutableSet entityIds = Sets.mutable.empty();
        try (Transaction tx = this.db.beginTx();){
            entityIds.add(entityUtil.createEntityWithProperty(tx, "value"));
            this.otherThread.execute(() -> this.lambda$transactionStateMustNotPreventIndexUpdatesFromBeingApplied$0((Set)entityIds, entityUtil, tx)).get();
            tx.commit();
        }
        entityUtil.assertQueryFindsIds(this.db, "value", (Set<String>)entityIds);
    }

    @MethodSource(value={"entityTypeProvider"})
    @ParameterizedTest
    void fulltextIndexMustWorkAfterRestartWithTxStateChanges(FulltextProceduresTestSupport.EntityUtil entityUtil) {
        this.createIndexAndWait(entityUtil);
        this.restartDatabase();
        try (Transaction tx = this.db.beginTx();){
            String id = entityUtil.createEntityWithProperty(tx, "value");
            entityUtil.createEntity(tx);
            entityUtil.assertQueryFindsIdsInOrder(tx, "*", id);
            tx.commit();
        }
    }

    private /* synthetic */ Object lambda$transactionStateMustNotPreventIndexUpdatesFromBeingApplied$0(Set entityIds, FulltextProceduresTestSupport.EntityUtil entityUtil, Transaction tx) throws Exception {
        try (Transaction forkedTx = this.db.beginTx();){
            entityIds.add(entityUtil.createEntityWithProperty(tx, "value"));
            forkedTx.commit();
        }
        return null;
    }
}

