/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.tracking;

import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.database.Database;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.extension.ExtensionType;
import org.neo4j.kernel.extension.context.ExtensionContext;
import org.neo4j.kernel.impl.index.schema.AbstractIndexProviderFactory;
import org.neo4j.kernel.impl.index.schema.BuiltInDelegatingIndexProviderFactory;
import org.neo4j.kernel.impl.index.schema.tracking.TrackingReadersIndexProvider;

public class TrackingIndexExtensionFactory
extends ExtensionFactory<Dependencies> {
    private final ConcurrentHashMap<String, TrackingReadersIndexProvider> indexProvider = new ConcurrentHashMap();
    private final BuiltInDelegatingIndexProviderFactory delegate;
    public static final IndexProviderDescriptor DESCRIPTOR = new IndexProviderDescriptor("tracking-index", "0.5");

    public TrackingIndexExtensionFactory(AbstractIndexProviderFactory<?> delegate) {
        super(ExtensionType.DATABASE, DESCRIPTOR.getKey());
        this.delegate = new BuiltInDelegatingIndexProviderFactory(delegate, DESCRIPTOR);
    }

    public synchronized IndexProvider newInstance(ExtensionContext context, Dependencies dependencies) {
        NamedDatabaseId namedDatabaseId = dependencies.database().getNamedDatabaseId();
        return (IndexProvider)this.indexProvider.computeIfAbsent(namedDatabaseId.name(), s -> {
            IndexProvider indexProvider = this.delegate.newInstance(context, (BuiltInDelegatingIndexProviderFactory.Dependencies)dependencies);
            return new TrackingReadersIndexProvider(indexProvider);
        });
    }

    public TrackingReadersIndexProvider getIndexProvider(String databaseName) {
        return this.indexProvider.get(databaseName);
    }

    public static interface Dependencies
    extends BuiltInDelegatingIndexProviderFactory.Dependencies {
        public Database database();
    }
}

