/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.assertj.core.api.SoftAssertions;
import org.assertj.core.api.junit.jupiter.InjectSoftAssertions;
import org.assertj.core.api.junit.jupiter.SoftAssertionsExtension;
import org.eclipse.collections.api.factory.Sets;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.neo4j.common.EmptyDependencyResolver;
import org.neo4j.common.EntityType;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.database.readonly.ConfigBasedLookupFactory;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.dbms.database.readonly.ReadOnlyDatabases;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.helpers.collection.BoundedIterable;
import org.neo4j.internal.schema.FulltextSchemaDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.context.EmptyVersionContextSupplier;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.database.DatabaseIdFactory;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.PhaseTracker;
import org.neo4j.kernel.impl.index.schema.FulltextIndexProviderFactory;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.NullLogService;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.Monitors;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobMonitoringParams;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.test.extension.EphemeralNeo4jLayoutExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.pagecache.EphemeralPageCacheExtension;
import org.neo4j.token.DelegatingTokenHolder;
import org.neo4j.token.ReadOnlyTokenCreator;
import org.neo4j.token.TokenCreator;
import org.neo4j.token.TokenHolders;
import org.neo4j.token.api.TokenHolder;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@EphemeralPageCacheExtension
@EphemeralNeo4jLayoutExtension
@ExtendWith(value={SoftAssertionsExtension.class})
class FulltextIndexEntryUpdateTest {
    private static final Config CONFIG = Config.defaults();
    private static final IndexSamplingConfig SAMPLING_CONFIG = new IndexSamplingConfig(CONFIG);
    private final LifeSupport life = new LifeSupport();
    private final TokenHolders tokenHolders = new TokenHolders((TokenHolder)new DelegatingTokenHolder((TokenCreator)new ReadOnlyTokenCreator(), "PropertyKey"), (TokenHolder)new DelegatingTokenHolder((TokenCreator)new ReadOnlyTokenCreator(), "Label"), (TokenHolder)new DelegatingTokenHolder((TokenCreator)new ReadOnlyTokenCreator(), "RelationshipType"));
    private final IndexPopulator.PopulationWorkScheduler populationWorkScheduler = new IndexPopulator.PopulationWorkScheduler(){

        public <T> JobHandle<T> schedule(IndexPopulator.JobDescriptionSupplier descriptionSupplier, Callable<T> job) {
            return FulltextIndexEntryUpdateTest.this.jobScheduler.schedule(Group.INDEX_POPULATION_WORK, new JobMonitoringParams(null, null, null), job);
        }
    };
    private IndexProvider provider;
    private IndexDescriptor index;
    private JobScheduler jobScheduler;
    @Inject
    private PageCache pageCache;
    @Inject
    private FileSystemAbstraction fs;
    @Inject
    private DatabaseLayout databaseLayout;
    @InjectSoftAssertions
    private SoftAssertions softly;

    FulltextIndexEntryUpdateTest() {
    }

    @BeforeEach
    final void setup() {
        DefaultPageCacheTracer cacheTracer = new DefaultPageCacheTracer();
        CursorContextFactory contextFactory = new CursorContextFactory((PageCacheTracer)cacheTracer, EmptyVersionContextSupplier.EMPTY);
        NamedDatabaseId defaultDatabaseId = DatabaseIdFactory.from((String)"neo4j", (UUID)UUID.randomUUID());
        DatabaseIdRepository databaseIdRepository = (DatabaseIdRepository)Mockito.mock(DatabaseIdRepository.class);
        Mockito.when((Object)databaseIdRepository.getByName("neo4j")).thenReturn(Optional.of(defaultDatabaseId));
        ConfigBasedLookupFactory configBasedLookup = new ConfigBasedLookupFactory(CONFIG, databaseIdRepository);
        ReadOnlyDatabases readOnlyDatabases = new ReadOnlyDatabases(new ReadOnlyDatabases.LookupFactory[]{configBasedLookup});
        DatabaseReadOnlyChecker readOnlyChecker = readOnlyDatabases.forDatabase(defaultDatabaseId);
        this.jobScheduler = JobSchedulerFactory.createInitialisedScheduler();
        this.provider = new FulltextIndexProviderFactory().create(this.pageCache, this.fs, (LogService)NullLogService.getInstance(), new Monitors(), CONFIG, readOnlyChecker, TopologyGraphDbmsModel.HostedOnMode.SINGLE, RecoveryCleanupWorkCollector.ignore(), this.databaseLayout, this.tokenHolders, this.jobScheduler, contextFactory, (PageCacheTracer)cacheTracer, EmptyDependencyResolver.EMPTY_RESOLVER);
        this.life.add((Lifecycle)this.provider);
        this.life.start();
        FulltextSchemaDescriptor schema = SchemaDescriptors.fulltext((EntityType)EntityType.NODE, (int[])new int[]{123}, (int[])new int[]{321});
        this.index = this.provider.completeConfiguration(IndexPrototype.forSchema((SchemaDescriptor)schema).withIndexType(this.provider.getIndexType()).withIndexProvider(this.provider.getProviderDescriptor()).withName("FulltextIndex").materialise(0L));
    }

    @AfterEach
    final void teardown() throws Exception {
        this.life.shutdown();
        this.jobScheduler.shutdown();
    }

    @Test
    final void populatorShouldNotIgnoreSupportedValueTypes() throws Exception {
        Collection<Long> ids = FulltextIndexEntryUpdateTest.generateIds(0L, 10L);
        Collection<ValueIndexEntryUpdate<IndexDescriptor>> updates = FulltextIndexEntryUpdateTest.generateUpdates(ids, id -> IndexEntryUpdate.add((long)id, (SchemaDescriptorSupplier)this.index, (Value[])new Value[]{FulltextIndexEntryUpdateTest.supportedValue(id)}));
        this.populatorTest(updates, ids);
    }

    @Test
    final void populatorShouldIgnoreUnsupportedValueTypes() throws Exception {
        Collection<Long> ids = FulltextIndexEntryUpdateTest.generateIds(0L, 10L);
        Collection<ValueIndexEntryUpdate<IndexDescriptor>> updates = FulltextIndexEntryUpdateTest.generateUpdates(ids, id -> IndexEntryUpdate.add((long)id, (SchemaDescriptorSupplier)this.index, (Value[])new Value[]{FulltextIndexEntryUpdateTest.unsupportedValue(id)}));
        this.populatorTest(updates, List.of());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populatorTest(Collection<ValueIndexEntryUpdate<IndexDescriptor>> updates, Iterable<Long> expectedIds) throws Exception {
        IndexPopulator populator = this.getPopulator();
        try {
            populator.add(updates, CursorContext.NULL_CONTEXT);
            this.completePopulation(populator);
        }
        finally {
            populator.close(true, CursorContext.NULL_CONTEXT);
        }
        this.assertIndexed(expectedIds);
    }

    @Test
    final void populatingUpdaterShouldNotIgnoreAddedSupportedValueType() throws Exception {
        Collection<Long> ids = FulltextIndexEntryUpdateTest.generateIds(0L, 10L);
        Collection<ValueIndexEntryUpdate<IndexDescriptor>> updates = FulltextIndexEntryUpdateTest.generateUpdates(ids, id -> IndexEntryUpdate.add((long)id, (SchemaDescriptorSupplier)this.index, (Value[])new Value[]{FulltextIndexEntryUpdateTest.supportedValue(id)}));
        this.populatingUpdaterTest(updates, ids);
    }

    @Test
    final void populatingUpdaterShouldIgnoreAddedUnsupportedValueType() throws Exception {
        Collection<Long> ids = FulltextIndexEntryUpdateTest.generateIds(0L, 10L);
        Collection<ValueIndexEntryUpdate<IndexDescriptor>> updates = FulltextIndexEntryUpdateTest.generateUpdates(ids, id -> IndexEntryUpdate.add((long)id, (SchemaDescriptorSupplier)this.index, (Value[])new Value[]{FulltextIndexEntryUpdateTest.unsupportedValue(id)}));
        this.populatingUpdaterTest(updates, List.of());
    }

    @Test
    final void populatingUpdaterShouldNotIgnoreRemovedSupportedValueType() throws Exception {
        Collection<Long> addedIds = FulltextIndexEntryUpdateTest.generateIds(0L, 20L);
        Collection<Long> removedIds = FulltextIndexEntryUpdateTest.generateIds(11L, 17L);
        List<ValueIndexEntryUpdate<IndexDescriptor>> updates = Stream.of(FulltextIndexEntryUpdateTest.generateUpdates(addedIds, id -> IndexEntryUpdate.add((long)id, (SchemaDescriptorSupplier)this.index, (Value[])new Value[]{FulltextIndexEntryUpdateTest.supportedValue(id)})), FulltextIndexEntryUpdateTest.generateUpdates(removedIds, id -> IndexEntryUpdate.remove((long)id, (SchemaDescriptorSupplier)this.index, (Value[])new Value[]{FulltextIndexEntryUpdateTest.supportedValue(id)}))).flatMap(Collection::stream).toList();
        HashSet<Long> expectedIds = new HashSet<Long>(addedIds);
        expectedIds.removeAll(removedIds);
        this.populatingUpdaterTest(updates, expectedIds);
    }

    @Test
    final void populatingUpdaterShouldIgnoreRemovedUnsupportedValueType() throws Exception {
        Collection<Long> addedIds = FulltextIndexEntryUpdateTest.generateIds(0L, 20L);
        Collection<Long> removedIds = FulltextIndexEntryUpdateTest.generateIds(11L, 17L);
        List<ValueIndexEntryUpdate<IndexDescriptor>> updates = Stream.of(FulltextIndexEntryUpdateTest.generateUpdates(addedIds, id -> IndexEntryUpdate.add((long)id, (SchemaDescriptorSupplier)this.index, (Value[])new Value[]{FulltextIndexEntryUpdateTest.unsupportedValue(id)})), FulltextIndexEntryUpdateTest.generateUpdates(removedIds, id -> IndexEntryUpdate.remove((long)id, (SchemaDescriptorSupplier)this.index, (Value[])new Value[]{FulltextIndexEntryUpdateTest.unsupportedValue(id)}))).flatMap(Collection::stream).toList();
        this.populatingUpdaterTest(updates, List.of());
    }

    @Test
    final void populatingUpdaterShouldNotIgnoreChangedBetweenSupportedValueTypes() throws Exception {
        Collection<Long> ids = FulltextIndexEntryUpdateTest.generateIds(0L, 20L);
        Collection<ValueIndexEntryUpdate<IndexDescriptor>> updates = FulltextIndexEntryUpdateTest.generateUpdates(ids, id -> IndexEntryUpdate.change((long)id, (SchemaDescriptorSupplier)this.index, (Value)FulltextIndexEntryUpdateTest.supportedValue(id), (Value)FulltextIndexEntryUpdateTest.supportedValue(id + 1L)));
        this.populatingUpdaterTest(updates, ids);
    }

    @Test
    final void populatingUpdaterShouldTreatChangedFromUnsupportedToSupportedValueTypesAsAdded() throws Exception {
        Collection<Long> addedIds = FulltextIndexEntryUpdateTest.generateIds(0L, 20L);
        Collection<Long> changedIds = FulltextIndexEntryUpdateTest.generateIds(11L, 17L);
        List<ValueIndexEntryUpdate<IndexDescriptor>> updates = Stream.of(FulltextIndexEntryUpdateTest.generateUpdates(addedIds, id -> IndexEntryUpdate.add((long)id, (SchemaDescriptorSupplier)this.index, (Value[])new Value[]{FulltextIndexEntryUpdateTest.unsupportedValue(id)})), FulltextIndexEntryUpdateTest.generateUpdates(changedIds, id -> IndexEntryUpdate.change((long)id, (SchemaDescriptorSupplier)this.index, (Value)FulltextIndexEntryUpdateTest.unsupportedValue(id), (Value)FulltextIndexEntryUpdateTest.supportedValue(id)))).flatMap(Collection::stream).toList();
        this.populatingUpdaterTest(updates, changedIds);
    }

    @Test
    final void populatingUpdaterShouldTreatChangedFromSupportedToUnsupportedValueTypesAsRemoved() throws Exception {
        Collection<Long> addedIds = FulltextIndexEntryUpdateTest.generateIds(0L, 20L);
        Collection<Long> changedIds = FulltextIndexEntryUpdateTest.generateIds(11L, 17L);
        List<ValueIndexEntryUpdate<IndexDescriptor>> updates = Stream.of(FulltextIndexEntryUpdateTest.generateUpdates(addedIds, id -> IndexEntryUpdate.add((long)id, (SchemaDescriptorSupplier)this.index, (Value[])new Value[]{FulltextIndexEntryUpdateTest.supportedValue(id)})), FulltextIndexEntryUpdateTest.generateUpdates(changedIds, id -> IndexEntryUpdate.change((long)id, (SchemaDescriptorSupplier)this.index, (Value)FulltextIndexEntryUpdateTest.supportedValue(id), (Value)FulltextIndexEntryUpdateTest.unsupportedValue(id)))).flatMap(Collection::stream).toList();
        HashSet<Long> expectedIds = new HashSet<Long>(addedIds);
        expectedIds.removeAll(changedIds);
        this.populatingUpdaterTest(updates, expectedIds);
    }

    @Test
    final void populatingUpdaterShouldIgnoreChangedBetweenUnsupportedValueTypes() throws Exception {
        Collection<Long> ids = FulltextIndexEntryUpdateTest.generateIds(0L, 20L);
        Collection<ValueIndexEntryUpdate<IndexDescriptor>> updates = FulltextIndexEntryUpdateTest.generateUpdates(ids, id -> IndexEntryUpdate.change((long)id, (SchemaDescriptorSupplier)this.index, (Value)FulltextIndexEntryUpdateTest.unsupportedValue(id), (Value)FulltextIndexEntryUpdateTest.unsupportedValue(id + 1L)));
        this.populatingUpdaterTest(updates, List.of());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populatingUpdaterTest(Iterable<ValueIndexEntryUpdate<IndexDescriptor>> updates, Iterable<Long> expectedIds) throws Exception {
        IndexPopulator populator = this.getPopulator();
        try (IndexUpdater updater = this.getPopulatingUpdater(populator);){
            for (ValueIndexEntryUpdate<IndexDescriptor> update : updates) {
                updater.process(update);
            }
            this.completePopulation(populator);
        }
        finally {
            populator.close(true, CursorContext.NULL_CONTEXT);
        }
        this.assertIndexed(expectedIds);
    }

    @Test
    final void updaterShouldNotIgnoreAddedSupportedValueType() throws Exception {
        Collection<Long> ids = FulltextIndexEntryUpdateTest.generateIds(0L, 10L);
        Collection<ValueIndexEntryUpdate<IndexDescriptor>> updates = FulltextIndexEntryUpdateTest.generateUpdates(ids, id -> IndexEntryUpdate.add((long)id, (SchemaDescriptorSupplier)this.index, (Value[])new Value[]{FulltextIndexEntryUpdateTest.supportedValue(id)}));
        this.updaterTest(updates, ids);
    }

    @Test
    final void updaterShouldIgnoreAddedUnsupportedValueType() throws Exception {
        Collection<Long> ids = FulltextIndexEntryUpdateTest.generateIds(0L, 10L);
        Collection<ValueIndexEntryUpdate<IndexDescriptor>> updates = FulltextIndexEntryUpdateTest.generateUpdates(ids, id -> IndexEntryUpdate.add((long)id, (SchemaDescriptorSupplier)this.index, (Value[])new Value[]{FulltextIndexEntryUpdateTest.unsupportedValue(id)}));
        this.updaterTest(updates, List.of());
    }

    @Test
    final void updaterShouldNotIgnoreRemovedSupportedValueType() throws Exception {
        Collection<Long> addedIds = FulltextIndexEntryUpdateTest.generateIds(0L, 20L);
        Collection<Long> removedIds = FulltextIndexEntryUpdateTest.generateIds(11L, 17L);
        List<ValueIndexEntryUpdate<IndexDescriptor>> updates = Stream.of(FulltextIndexEntryUpdateTest.generateUpdates(addedIds, id -> IndexEntryUpdate.add((long)id, (SchemaDescriptorSupplier)this.index, (Value[])new Value[]{FulltextIndexEntryUpdateTest.supportedValue(id)})), FulltextIndexEntryUpdateTest.generateUpdates(removedIds, id -> IndexEntryUpdate.remove((long)id, (SchemaDescriptorSupplier)this.index, (Value[])new Value[]{FulltextIndexEntryUpdateTest.supportedValue(id)}))).flatMap(Collection::stream).toList();
        HashSet<Long> expectedIds = new HashSet<Long>(addedIds);
        expectedIds.removeAll(removedIds);
        this.updaterTest(updates, expectedIds);
    }

    @Test
    final void updaterShouldIgnoreRemovedUnsupportedValueType() throws Exception {
        Collection<Long> addedIds = FulltextIndexEntryUpdateTest.generateIds(0L, 20L);
        Collection<Long> removedIds = FulltextIndexEntryUpdateTest.generateIds(11L, 17L);
        List<ValueIndexEntryUpdate<IndexDescriptor>> updates = Stream.of(FulltextIndexEntryUpdateTest.generateUpdates(addedIds, id -> IndexEntryUpdate.add((long)id, (SchemaDescriptorSupplier)this.index, (Value[])new Value[]{FulltextIndexEntryUpdateTest.unsupportedValue(id)})), FulltextIndexEntryUpdateTest.generateUpdates(removedIds, id -> IndexEntryUpdate.remove((long)id, (SchemaDescriptorSupplier)this.index, (Value[])new Value[]{FulltextIndexEntryUpdateTest.unsupportedValue(id)}))).flatMap(Collection::stream).toList();
        this.updaterTest(updates, List.of());
    }

    @Test
    final void updaterShouldNotIgnoreChangedBetweenSupportedValueTypes() throws Exception {
        Collection<Long> ids = FulltextIndexEntryUpdateTest.generateIds(0L, 20L);
        Collection<ValueIndexEntryUpdate<IndexDescriptor>> updates = FulltextIndexEntryUpdateTest.generateUpdates(ids, id -> IndexEntryUpdate.change((long)id, (SchemaDescriptorSupplier)this.index, (Value)FulltextIndexEntryUpdateTest.supportedValue(id), (Value)FulltextIndexEntryUpdateTest.supportedValue(id + 1L)));
        this.updaterTest(updates, ids);
    }

    @Test
    final void updaterShouldTreatChangedFromUnsupportedToSupportedValueTypesAsAdded() throws Exception {
        Collection<Long> addedIds = FulltextIndexEntryUpdateTest.generateIds(0L, 20L);
        Collection<Long> changedIds = FulltextIndexEntryUpdateTest.generateIds(11L, 17L);
        List<ValueIndexEntryUpdate<IndexDescriptor>> updates = Stream.of(FulltextIndexEntryUpdateTest.generateUpdates(addedIds, id -> IndexEntryUpdate.add((long)id, (SchemaDescriptorSupplier)this.index, (Value[])new Value[]{FulltextIndexEntryUpdateTest.unsupportedValue(id)})), FulltextIndexEntryUpdateTest.generateUpdates(changedIds, id -> IndexEntryUpdate.change((long)id, (SchemaDescriptorSupplier)this.index, (Value)FulltextIndexEntryUpdateTest.unsupportedValue(id), (Value)FulltextIndexEntryUpdateTest.supportedValue(id)))).flatMap(Collection::stream).toList();
        this.updaterTest(updates, changedIds);
    }

    @Test
    final void updaterShouldTreatChangedFromSupportedToUnsupportedValueTypesAsRemoved() throws Exception {
        Collection<Long> addedIds = FulltextIndexEntryUpdateTest.generateIds(0L, 20L);
        Collection<Long> changedIds = FulltextIndexEntryUpdateTest.generateIds(11L, 17L);
        List<ValueIndexEntryUpdate<IndexDescriptor>> updates = Stream.of(FulltextIndexEntryUpdateTest.generateUpdates(addedIds, id -> IndexEntryUpdate.add((long)id, (SchemaDescriptorSupplier)this.index, (Value[])new Value[]{FulltextIndexEntryUpdateTest.supportedValue(id)})), FulltextIndexEntryUpdateTest.generateUpdates(changedIds, id -> IndexEntryUpdate.change((long)id, (SchemaDescriptorSupplier)this.index, (Value)FulltextIndexEntryUpdateTest.supportedValue(id), (Value)FulltextIndexEntryUpdateTest.unsupportedValue(id)))).flatMap(Collection::stream).toList();
        HashSet<Long> expectedIds = new HashSet<Long>(addedIds);
        expectedIds.removeAll(changedIds);
        this.updaterTest(updates, expectedIds);
    }

    @Test
    final void updaterShouldIgnoreChangedBetweenUnsupportedValueTypes() throws Exception {
        Collection<Long> ids = FulltextIndexEntryUpdateTest.generateIds(0L, 20L);
        Collection<ValueIndexEntryUpdate<IndexDescriptor>> updates = FulltextIndexEntryUpdateTest.generateUpdates(ids, id -> IndexEntryUpdate.change((long)id, (SchemaDescriptorSupplier)this.index, (Value)FulltextIndexEntryUpdateTest.unsupportedValue(id), (Value)FulltextIndexEntryUpdateTest.unsupportedValue(id + 1L)));
        this.updaterTest(updates, List.of());
    }

    private void updaterTest(Iterable<ValueIndexEntryUpdate<IndexDescriptor>> updates, Iterable<Long> expectedIds) throws Exception {
        try (IndexAccessor accessor = this.getAccessor();
             IndexUpdater updater = this.getUpdater(accessor);){
            for (ValueIndexEntryUpdate<IndexDescriptor> update : updates) {
                updater.process(update);
            }
        }
        this.assertIndexed(expectedIds);
    }

    private static Collection<ValueIndexEntryUpdate<IndexDescriptor>> generateUpdates(Collection<Long> ids, Function<Long, ValueIndexEntryUpdate<IndexDescriptor>> toUpdate) {
        return ids.stream().map(toUpdate).toList();
    }

    private static Collection<Long> generateIds(long from, long to) {
        return LongStream.range(from, to).boxed().collect(Collectors.toUnmodifiableSet());
    }

    private static Value supportedValue(long i) {
        return Values.of((Object)("string_" + i));
    }

    private static Value unsupportedValue(long i) {
        return Values.of((Object)i);
    }

    private IndexPopulator getPopulator() throws IOException {
        IndexPopulator populator = this.provider.getPopulator(this.index, SAMPLING_CONFIG, ByteBufferFactory.heapBufferFactory((int)((int)ByteUnit.kibiBytes((long)100L))), (MemoryTracker)EmptyMemoryTracker.INSTANCE, this.tokenHolders.lookupWithIds(), Sets.immutable.empty());
        populator.create();
        return populator;
    }

    private void completePopulation(IndexPopulator populator) throws IndexEntryConflictException {
        populator.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, CursorContext.NULL_CONTEXT);
    }

    private IndexUpdater getPopulatingUpdater(IndexPopulator populator) {
        return populator.newPopulatingUpdater(CursorContext.NULL_CONTEXT);
    }

    private IndexAccessor getAccessor() throws IOException {
        return this.provider.getOnlineAccessor(this.index, SAMPLING_CONFIG, this.tokenHolders.lookupWithIds(), Sets.immutable.empty());
    }

    private IndexUpdater getUpdater(IndexAccessor accessor) {
        return accessor.newUpdater(IndexUpdateMode.ONLINE, CursorContext.NULL_CONTEXT, false);
    }

    private BoundedIterable<Long> getReader(IndexAccessor accessor) {
        return accessor.newAllEntriesValueReader(CursorContext.NULL_CONTEXT);
    }

    private void assertIndexed(Iterable<Long> expectedIds) throws Exception {
        try (IndexAccessor accessor = this.getAccessor();
             BoundedIterable<Long> reader = this.getReader(accessor);){
            this.softly.assertThat(reader).containsExactlyInAnyOrderElementsOf(expectedIds);
        }
    }
}

