/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.util.Arrays;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.junit.jupiter.api.BeforeEach;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.RelationshipValueIndexCursor;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexProvider;
import org.neo4j.kernel.impl.api.KernelImpl;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.coreapi.TransactionImpl;
import org.neo4j.kernel.impl.index.schema.FulltextIndexProviderFactory;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.DbmsController;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
public class LuceneFulltextTestSupport {
    static final Label LABEL = Label.label((String)"LABEL");
    static final RelationshipType RELTYPE = RelationshipType.withName((String)"type");
    static final String PROP = "prop";
    static final String PROP2 = "prop2";
    static final String PROP3 = "prop3";
    @Inject
    DbmsController controller;
    @Inject
    GraphDatabaseAPI db;
    @Inject
    IndexProviderMap indexProviderMap;
    @Inject
    KernelImpl kernel;
    FulltextIndexProvider indexProvider;

    @BeforeEach
    void setUp() {
        this.indexProvider = this.getAdapter();
    }

    void applySetting(Setting<String> setting, String value) {
        this.controller.restartDbms(builder -> builder.setConfig(setting, (Object)value));
        this.indexProvider = this.getAdapter();
    }

    KernelTransactionImplementation getKernelTransaction() {
        try {
            return (KernelTransactionImplementation)this.kernel.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED);
        }
        catch (TransactionFailureException e) {
            throw new RuntimeException("oops");
        }
    }

    private FulltextIndexProvider getAdapter() {
        return (FulltextIndexProvider)this.indexProviderMap.lookup(FulltextIndexProviderFactory.DESCRIPTOR);
    }

    static long createNodeIndexableByPropertyValue(Transaction tx, Label label, Object propertyValue) {
        return LuceneFulltextTestSupport.createNodeWithProperty(tx, label, PROP, propertyValue);
    }

    static long createNodeWithProperty(Transaction tx, Label label, String propertyKey, Object propertyValue) {
        Node node = tx.createNode(new Label[]{label});
        node.setProperty(propertyKey, propertyValue);
        return node.getId();
    }

    static long createRelationshipIndexableByPropertyValue(Transaction transaction, long firstNodeId, long secondNodeId, Object propertyValue) {
        return LuceneFulltextTestSupport.createRelationshipWithProperty(transaction, firstNodeId, secondNodeId, PROP, propertyValue);
    }

    static long createRelationshipWithProperty(Transaction transaction, long firstNodeId, long secondNodeId, String propertyKey, Object propertyValue) {
        Node first = transaction.getNodeById(firstNodeId);
        Node second = transaction.getNodeById(secondNodeId);
        Relationship relationship = first.createRelationshipTo(second, RELTYPE);
        relationship.setProperty(propertyKey, propertyValue);
        return relationship.getId();
    }

    static KernelTransaction kernelTransaction(Transaction tx) {
        Assertions.assertThat((Object)tx).isInstanceOf(TransactionImpl.class);
        return ((InternalTransaction)tx).kernelTransaction();
    }

    static void assertQueryFindsNothing(KernelTransaction ktx, boolean nodes, String indexName, String query) throws Exception {
        LuceneFulltextTestSupport.assertQueryFindsIds(ktx, nodes, indexName, query, new long[0]);
    }

    static void assertQueryFindsIds(KernelTransaction ktx, boolean nodes, String indexName, String query, long ... ids) throws Exception {
        IndexDescriptor index = ktx.schemaRead().indexGetForName(indexName);
        IndexReadSession indexSession = ktx.dataRead().indexReadSession(index);
        MutableLongSet set = LongSets.mutable.of(ids);
        if (nodes) {
            try (NodeValueIndexCursor cursor = ktx.cursors().allocateNodeValueIndexCursor(ktx.cursorContext(), ktx.memoryTracker());){
                ktx.dataRead().nodeIndexSeek(ktx.queryContext(), indexSession, cursor, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{PropertyIndexQuery.fulltextSearch((String)query)});
                while (cursor.next()) {
                    long nodeId = cursor.nodeReference();
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)set.remove(nodeId), (String)String.format("Result returned node id %d, expected one of %s", nodeId, Arrays.toString(ids)));
                }
            }
        }
        try (RelationshipValueIndexCursor cursor = ktx.cursors().allocateRelationshipValueIndexCursor(ktx.cursorContext(), ktx.memoryTracker());){
            ktx.dataRead().relationshipIndexSeek(ktx.queryContext(), indexSession, cursor, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{PropertyIndexQuery.fulltextSearch((String)query)});
            while (cursor.next()) {
                long relationshipId = cursor.relationshipReference();
                org.junit.jupiter.api.Assertions.assertTrue((boolean)set.remove(relationshipId), (String)String.format("Result returned relationship id %d, expected one of %s", relationshipId, Arrays.toString(ids)));
            }
        }
        if (!set.isEmpty()) {
            org.junit.jupiter.api.Assertions.fail((String)("Number of results differ from expected. " + set.size() + " IDs were not found in the result: " + set));
        }
    }

    static void assertQueryFindsNodeIdsInOrder(KernelTransaction ktx, String indexName, String query, long ... ids) throws Exception {
        IndexDescriptor index = ktx.schemaRead().indexGetForName(indexName);
        IndexReadSession indexSession = ktx.dataRead().indexReadSession(index);
        try (NodeValueIndexCursor cursor = ktx.cursors().allocateNodeValueIndexCursor(ktx.cursorContext(), ktx.memoryTracker());){
            int num = 0;
            float score = Float.MAX_VALUE;
            ktx.dataRead().nodeIndexSeek(ktx.queryContext(), indexSession, cursor, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{PropertyIndexQuery.fulltextSearch((String)query)});
            while (cursor.next()) {
                long nextId = cursor.nodeReference();
                float nextScore = cursor.score();
                Assertions.assertThat((float)nextScore).isLessThanOrEqualTo(score);
                score = nextScore;
                org.junit.jupiter.api.Assertions.assertEquals((long)ids[num], (long)nextId, (String)String.format("Result returned node id %d, expected %d", nextId, ids[num]));
                ++num;
            }
            org.junit.jupiter.api.Assertions.assertEquals((int)ids.length, (int)num, (String)"Number of results differ from expected");
        }
    }

    static void setNodeProp(Transaction transaction, long nodeId, String value) {
        LuceneFulltextTestSupport.setNodeProp(transaction, nodeId, PROP, value);
    }

    static void setNodeProp(Transaction transaction, long nodeId, String propertyKey, String value) {
        Node node = transaction.getNodeById(nodeId);
        node.setProperty(propertyKey, (Object)value);
    }

    void await(IndexDescriptor index) throws Exception {
        try (KernelTransactionImplementation tx = this.getKernelTransaction();){
            while (tx.schemaRead().indexGetState(index) != InternalIndexState.ONLINE) {
                Thread.sleep(100L);
            }
        }
    }
}

