/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.vector;

import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.coreapi.TransactionImpl;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.Unzip;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
class VectorIndex511CompatibilityIT {
    private static final int EXPECTED_INDEX_VECTOR_DIMENSIONS = 1536;
    private static final String ARCHIVE_NAME = "5-11-vector-idx-db.zip";
    private static final String TEXT_IDX_NAME = "VectorIndex";
    private static final String LABEL = "Label";
    private static final String PROPERTY = "property";
    @Inject
    TestDirectory testDirectory;
    private DatabaseManagementService dbms;
    private GraphDatabaseService db;

    VectorIndex511CompatibilityIT() {
    }

    @BeforeEach
    void beforeEach() throws Exception {
        Unzip.unzip(this.getClass(), (String)ARCHIVE_NAME, (Path)this.testDirectory.homePath());
        this.dbms = new TestDatabaseManagementServiceBuilder(this.testDirectory.homePath()).build();
        this.db = this.dbms.database("neo4j");
    }

    @AfterEach
    void tearDown() {
        if (this.dbms != null) {
            this.dbms.shutdown();
        }
    }

    @Test
    void existingIndexesWorkWithoutMigration() throws KernelException {
        this.assertVectorIndexContainsNumberOfValues(10);
        float[] vector = this.generateVector();
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode(new Label[]{Label.label((String)LABEL)});
            node.setProperty(PROPERTY, (Object)vector);
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            Result vectorQueryResult = tx.execute("CALL db.index.vector.queryNodes('VectorIndex', 20, $vector) YIELD node AS node, score", Map.of("vector", vector));
            int rowCounter = 0;
            while (vectorQueryResult.hasNext()) {
                ++rowCounter;
                Map resultMap = vectorQueryResult.next();
                Assertions.assertThat((Map)resultMap).containsOnlyKeys((Object[])new String[]{"node", "score"});
            }
            org.junit.jupiter.api.Assertions.assertEquals((int)11, (int)rowCounter);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.assertVectorIndexContainsNumberOfValues(11);
    }

    private float[] generateVector() {
        float[] data = new float[1536];
        ThreadLocalRandom localRandom = ThreadLocalRandom.current();
        for (int i = 0; i < data.length; ++i) {
            data[i] = localRandom.nextFloat();
        }
        return data;
    }

    private void assertVectorIndexContainsNumberOfValues(int numberOfValues) throws KernelException {
        try (Transaction tx = this.db.beginTx();){
            KernelTransaction kernelTx = ((TransactionImpl)tx).kernelTransaction();
            IndexDescriptor index = kernelTx.schemaRead().indexGetForName(TEXT_IDX_NAME);
            IndexReadSession indexSession = kernelTx.dataRead().indexReadSession(index);
            try (NodeValueIndexCursor cursor = kernelTx.cursors().allocateNodeValueIndexCursor(kernelTx.cursorContext(), kernelTx.memoryTracker());){
                kernelTx.dataRead().nodeIndexSeek(kernelTx.queryContext(), indexSession, cursor, IndexQueryConstraints.unordered((boolean)false), new PropertyIndexQuery[]{PropertyIndexQuery.allEntries()});
                int entryCounter = 0;
                while (cursor.next()) {
                    ++entryCounter;
                }
                org.junit.jupiter.api.Assertions.assertEquals((int)numberOfValues, (int)entryCounter);
            }
        }
    }
}

