/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.file.Path;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.PhysicalFlushableLogChannel;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.fs.StoreFileChannel;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.memory.HeapScopedBuffer;
import org.neo4j.io.memory.ScopedBuffer;
import org.neo4j.kernel.impl.transaction.CommittedCommandBatchRepresentation;
import org.neo4j.kernel.impl.transaction.log.CommandBatchCursor;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogPositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.recovery.RecoveryMonitor;
import org.neo4j.kernel.recovery.RecoveryStartInformation;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.Monitors;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.test.LatestVersions;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.TestLabels;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.utils.TestDirectory;

@Neo4jLayoutExtension
class RecoverIndexDropIT {
    private static final String KEY = "key";
    @Inject
    private DefaultFileSystemAbstraction fs;
    @Inject
    private TestDirectory directory;
    @Inject
    private DatabaseLayout databaseLayout;

    RecoverIndexDropIT() {
    }

    TestDatabaseManagementServiceBuilder configure(TestDatabaseManagementServiceBuilder builder) {
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldDropIndexOnRecovery() throws IOException {
        CommittedCommandBatchRepresentation dropTransaction = this.prepareDropTransaction();
        DatabaseManagementService managementService = this.configure(new TestDatabaseManagementServiceBuilder(this.databaseLayout)).build();
        GraphDatabaseService db = managementService.database("neo4j");
        long initialIndexCount = RecoverIndexDropIT.currentIndexCount(db);
        RecoverIndexDropIT.createIndex(db);
        StorageEngineFactory storageEngineFactory = (StorageEngineFactory)((GraphDatabaseAPI)db).getDependencyResolver().resolveDependency(StorageEngineFactory.class);
        managementService.shutdown();
        this.appendDropTransactionToTransactionLog(this.databaseLayout.getTransactionLogsDirectory(), dropTransaction, storageEngineFactory);
        Monitors monitors = new Monitors();
        AssertRecoveryIsPerformed recoveryMonitor = new AssertRecoveryIsPerformed();
        monitors.addMonitorListener((Object)recoveryMonitor, new String[0]);
        managementService = this.configure(new TestDatabaseManagementServiceBuilder(this.databaseLayout).setMonitors(monitors)).build();
        db = managementService.database("neo4j");
        try {
            Assertions.assertTrue((boolean)recoveryMonitor.recoveryWasRequired);
            Assertions.assertEquals((long)initialIndexCount, (long)RecoverIndexDropIT.currentIndexCount(db));
        }
        finally {
            managementService.shutdown();
        }
    }

    private static long currentIndexCount(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            long l = Iterables.count((Iterable)tx.schema().getIndexes());
            return l;
        }
    }

    private static IndexDefinition createIndex(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            IndexDefinition index = tx.schema().indexFor(TestLabels.LABEL_ONE).on(KEY).create();
            tx.commit();
            IndexDefinition indexDefinition = index;
            return indexDefinition;
        }
    }

    private void appendDropTransactionToTransactionLog(Path transactionLogsDirectory, CommittedCommandBatchRepresentation dropBatch, StorageEngineFactory storageEngineFactory) throws IOException {
        LogFiles logFiles = LogFilesBuilder.logFilesBasedOnlyBuilder((Path)transactionLogsDirectory, (FileSystemAbstraction)this.fs).withStorageEngineFactory(storageEngineFactory).build();
        LogFile logFile = logFiles.getLogFile();
        try (ReadableLogChannel reader = logFile.getReader(logFile.extractHeader(0L).getStartPosition());){
            VersionAwareLogEntryReader logEntryReader = new VersionAwareLogEntryReader(storageEngineFactory.commandReaderFactory(), LatestVersions.BINARY_VERSIONS);
            while (logEntryReader.readLogEntry((ReadableLogPositionAwareChannel)reader) != null) {
            }
            LogPosition position = logEntryReader.lastPosition();
            StoreFileChannel storeChannel = this.fs.write(logFile.getLogFileForVersion(logFile.getHighestLogVersion()));
            storeChannel.position(position.getByteOffset());
            try (PhysicalFlushableLogChannel writeChannel = new PhysicalFlushableLogChannel((StoreChannel)storeChannel, (ScopedBuffer)new HeapScopedBuffer(100, ByteOrder.LITTLE_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE));){
                new LogEntryWriter((WritableChannel)writeChannel, LatestVersions.BINARY_VERSIONS).serialize(dropBatch);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CommittedCommandBatchRepresentation prepareDropTransaction() throws IOException {
        DatabaseManagementService managementService = this.configure(new TestDatabaseManagementServiceBuilder(this.directory.directory("preparation"))).build();
        GraphDatabaseAPI db = (GraphDatabaseAPI)managementService.database("neo4j");
        try {
            IndexDefinition index = RecoverIndexDropIT.createIndex((GraphDatabaseService)db);
            try (Transaction tx = db.beginTx();){
                tx.schema().getIndexByName(index.getName()).drop();
                tx.commit();
            }
            CommittedCommandBatchRepresentation committedCommandBatchRepresentation = RecoverIndexDropIT.extractLastTransaction(db);
            return committedCommandBatchRepresentation;
        }
        finally {
            managementService.shutdown();
        }
    }

    private static CommittedCommandBatchRepresentation extractLastTransaction(GraphDatabaseAPI db) throws IOException {
        LogicalTransactionStore txStore = (LogicalTransactionStore)db.getDependencyResolver().resolveDependency(LogicalTransactionStore.class);
        CommittedCommandBatchRepresentation transaction = null;
        try (CommandBatchCursor cursor = txStore.getCommandBatches(2L);){
            while (cursor.next()) {
                transaction = (CommittedCommandBatchRepresentation)cursor.get();
            }
        }
        return transaction;
    }

    private static class AssertRecoveryIsPerformed
    implements RecoveryMonitor {
        boolean recoveryWasRequired;

        private AssertRecoveryIsPerformed() {
        }

        public void recoveryRequired(RecoveryStartInformation recoveryStartInformation) {
            this.recoveryWasRequired = true;
        }
    }
}

