/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.drop;

import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongSupplier;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.api.TransactionVisibilityProvider;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.drop.MultiVersionIndexDropController;
import org.neo4j.kernel.impl.coreapi.schema.IndexDefinitionImpl;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogAssertions;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
class MultiVersionIndexDropControllerIT {
    @Inject
    JobScheduler jobScheduler;
    @Inject
    IndexingService indexingService;
    @Inject
    GraphDatabaseService database;
    @Inject
    IndexProviderMap providerMap;
    @Inject
    FileSystemAbstraction fileSystem;
    private MultiVersionIndexDropController indexDropController;

    MultiVersionIndexDropControllerIT() {
    }

    @AfterEach
    void tearDown() {
        if (this.indexDropController != null) {
            this.indexDropController.stop();
        }
    }

    @Test
    void doNotDropIndexesWhileTheyAreVisible() {
        Label label = Label.label((String)"marker");
        try (Transaction transaction = this.database.beginTx();){
            transaction.schema().indexFor(label).on("property1").create();
            transaction.schema().indexFor(label).on("property2").create();
            transaction.schema().indexFor(label).on("property3").create();
            transaction.commit();
        }
        this.awaitIndexes();
        List<IndexDescriptor> indexDescriptors = this.getIndexDescriptors(label);
        IndexProvider indexProvider = this.getIndexProvider(indexDescriptors);
        this.indexDropController = new MultiVersionIndexDropController(this.jobScheduler, (TransactionVisibilityProvider)new TestTransactionVisibilityProvider(10L, 100L), this.indexingService, this.fileSystem, (LogProvider)NullLogProvider.getInstance());
        this.indexDropController.start();
        for (IndexDescriptor indexDescriptor : indexDescriptors) {
            this.indexDropController.dropIndex(indexDescriptor);
        }
        this.indexDropController.dropIndexes();
        Assertions.assertThat((Collection)this.indexDropController.getAsyncDeleteQueue()).hasSize(3);
        IndexDirectoryStructure directoryStructure = indexProvider.directoryStructure();
        for (IndexDescriptor indexDescriptor : indexDescriptors) {
            Path indexDirectory = directoryStructure.directoryForIndex(indexDescriptor.getId());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fileSystem.fileExists(indexDirectory), () -> "Directory " + String.valueOf(indexDirectory) + " should still exist.");
        }
    }

    @Test
    void dropIndexesOnlyWhenTheyAreInvisible() {
        Label label = Label.label((String)"marker");
        try (Transaction transaction = this.database.beginTx();){
            transaction.schema().indexFor(label).on("property1").create();
            transaction.schema().indexFor(label).on("property2").create();
            transaction.schema().indexFor(label).on("property3").create();
            transaction.commit();
        }
        this.awaitIndexes();
        List<IndexDescriptor> indexDescriptors = this.getIndexDescriptors(label);
        IndexProvider indexProvider = this.getIndexProvider(indexDescriptors);
        AtomicLong oldestValue = new AtomicLong(5L);
        this.indexDropController = new MultiVersionIndexDropController(this.jobScheduler, (TransactionVisibilityProvider)new TestTransactionVisibilityProvider(new AtomicStateLongSupplier(oldestValue), new ArrayStateLongSupplier(new long[]{10L, 20L, 30L})), this.indexingService, this.fileSystem, (LogProvider)NullLogProvider.getInstance());
        this.indexDropController.start();
        for (IndexDescriptor indexDescriptor : indexDescriptors) {
            this.indexDropController.dropIndex(indexDescriptor);
        }
        this.indexDropController.dropIndexes();
        Assertions.assertThat((Collection)this.indexDropController.getAsyncDeleteQueue()).hasSize(3);
        oldestValue.set(11L);
        this.indexDropController.dropIndexes();
        Assertions.assertThat((Collection)this.indexDropController.getAsyncDeleteQueue()).hasSize(2);
        oldestValue.set(22L);
        this.indexDropController.dropIndexes();
        Assertions.assertThat((Collection)this.indexDropController.getAsyncDeleteQueue()).hasSize(1);
        IndexDirectoryStructure directoryStructure = indexProvider.directoryStructure();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.fileSystem.fileExists(directoryStructure.directoryForIndex(indexDescriptors.get(0).getId())));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.fileSystem.fileExists(directoryStructure.directoryForIndex(indexDescriptors.get(1).getId())));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fileSystem.fileExists(directoryStructure.directoryForIndex(indexDescriptors.get(2).getId())));
    }

    @Test
    void errorOnDropDoesNotBlockDropQueue() {
        Label label = Label.label((String)"marker");
        try (Transaction transaction = this.database.beginTx();){
            transaction.schema().indexFor(label).on("property1").create();
            transaction.schema().indexFor(label).on("property2").create();
            transaction.schema().indexFor(label).on("property3").create();
            transaction.commit();
        }
        this.awaitIndexes();
        List<IndexDescriptor> indexDescriptors = this.getIndexDescriptors(label);
        AssertableLogProvider logProvider = new AssertableLogProvider();
        this.indexDropController = new MultiVersionIndexDropController(this.jobScheduler, (TransactionVisibilityProvider)new TestTransactionVisibilityProvider(11L, 10L), this.indexingService, this.fileSystem, (LogProvider)logProvider);
        this.indexDropController.start();
        for (IndexDescriptor indexDescriptor : indexDescriptors) {
            this.indexDropController.dropIndex(indexDescriptor);
        }
        this.indexDropController.dropIndexes();
        Assertions.assertThat((Collection)this.indexDropController.getAsyncDeleteQueue()).hasSize(0);
        LogAssertions.assertThat((AssertableLogProvider)logProvider).doesNotContainMessage("Exception on multi version index async drop.");
        for (IndexDescriptor indexDescriptor : indexDescriptors) {
            this.indexDropController.dropIndex(indexDescriptor);
        }
        this.indexDropController.dropIndexes();
        Assertions.assertThat((Collection)this.indexDropController.getAsyncDeleteQueue()).hasSize(0);
        LogAssertions.assertThat((AssertableLogProvider)logProvider).containsMessages(new String[]{"Exception on multi version index async drop."});
    }

    @Test
    void oldestIndexesDroppedBeforeNewlyAdded() {
        Label label = Label.label((String)"marker");
        try (Transaction transaction = this.database.beginTx();){
            transaction.schema().indexFor(label).on("property1").create();
            transaction.schema().indexFor(label).on("property2").create();
            transaction.schema().indexFor(label).on("property3").create();
            transaction.commit();
        }
        this.awaitIndexes();
        List<IndexDescriptor> indexDescriptors = this.getIndexDescriptors(label);
        AtomicLong oldestValue = new AtomicLong(5L);
        this.indexDropController = new MultiVersionIndexDropController(this.jobScheduler, (TransactionVisibilityProvider)new TestTransactionVisibilityProvider(new AtomicStateLongSupplier(oldestValue), new ArrayStateLongSupplier(new long[]{6L, 7L, 8L})), this.indexingService, this.fileSystem, (LogProvider)NullLogProvider.getInstance());
        this.indexDropController.start();
        for (IndexDescriptor indexDescriptor : indexDescriptors) {
            this.indexDropController.dropIndex(indexDescriptor);
            oldestValue.incrementAndGet();
        }
        this.indexDropController.dropIndexes();
        Assertions.assertThat((Collection)this.indexDropController.getAsyncDeleteQueue()).hasSize(1);
    }

    private IndexProvider getIndexProvider(List<IndexDescriptor> indexDescriptors) {
        return this.providerMap.lookup(indexDescriptors.get(0).getIndexProvider());
    }

    private List<IndexDescriptor> getIndexDescriptors(Label label) {
        try (Transaction tx = this.database.beginTx();){
            List<IndexDescriptor> list = Iterables.stream((Iterable)tx.schema().getIndexes(label)).map(indexDefinition -> ((IndexDefinitionImpl)indexDefinition).getIndexReference()).toList();
            return list;
        }
    }

    private void awaitIndexes() {
        try (Transaction tx = this.database.beginTx();){
            tx.schema().awaitIndexesOnline(10L, TimeUnit.MINUTES);
        }
    }

    private static class TestTransactionVisibilityProvider
    implements TransactionVisibilityProvider {
        private final long youngestBoundary;
        private final long oldestBoundary;
        private final LongSupplier oldestBoundarySupplier;
        private final LongSupplier youngestBoundarySupplier;

        public TestTransactionVisibilityProvider(long oldestBoundary, long youngestBoundary) {
            this(oldestBoundary, youngestBoundary, null, null);
        }

        public TestTransactionVisibilityProvider(LongSupplier oldestBoundarySupplier, LongSupplier youngestBoundarySupplier) {
            this(0L, 0L, oldestBoundarySupplier, youngestBoundarySupplier);
        }

        private TestTransactionVisibilityProvider(long oldestBoundary, long youngestBoundary, LongSupplier oldestBoundarySupplier, LongSupplier youngestBoundarySupplier) {
            this.youngestBoundary = youngestBoundary;
            this.oldestBoundary = oldestBoundary;
            this.oldestBoundarySupplier = oldestBoundarySupplier;
            this.youngestBoundarySupplier = youngestBoundarySupplier;
        }

        public long oldestVisibleClosedTransactionId() {
            return 0L;
        }

        public long oldestObservableHorizon() {
            return this.oldestBoundarySupplier == null ? this.oldestBoundary : this.oldestBoundarySupplier.getAsLong();
        }

        public long youngestObservableHorizon() {
            return this.youngestBoundarySupplier == null ? this.youngestBoundary : this.youngestBoundarySupplier.getAsLong();
        }
    }

    private record AtomicStateLongSupplier(AtomicLong oldestValue) implements LongSupplier
    {
        @Override
        public long getAsLong() {
            return this.oldestValue.get();
        }
    }

    private static class ArrayStateLongSupplier
    implements LongSupplier {
        private final long[] states;
        private int index;

        public ArrayStateLongSupplier(long[] states) {
            this.states = states;
        }

        @Override
        public long getAsLong() {
            return this.states[this.index++];
        }
    }
}

