/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.internal.kernel.api.IndexMonitor;
import org.neo4j.internal.kernel.api.SchemaWrite;
import org.neo4j.internal.kernel.api.Token;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.coreapi.TransactionImpl;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.monitoring.Monitors;
import org.neo4j.test.Barrier;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.TestLabels;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;

@DbmsExtension(configurationCallback="configure")
@ExtendWith(value={RandomExtension.class})
public abstract class StringLengthIndexValidationIT {
    private static final String propKey = "largeString";
    private final AtomicBoolean trapPopulation = new AtomicBoolean();
    private final Barrier.Control populationScanFinished = new Barrier.Control();
    private int singleKeySizeLimit;
    @Inject
    private GraphDatabaseAPI db;
    @Inject
    private PageCache pageCache;
    @Inject
    private RandomSupport random;

    protected abstract int getSingleKeySizeLimit(int var1);

    protected abstract String getString(RandomSupport var1, int var2);

    protected abstract IndexType getIndexType();

    protected abstract IndexProviderDescriptor getIndexProvider();

    protected abstract String expectedPopulationFailureCauseMessage(long var1, String var3);

    @BeforeEach
    void setUp() {
        this.singleKeySizeLimit = this.getSingleKeySizeLimit(this.pageCache.pageSize());
    }

    @ExtensionCallback
    void configure(TestDatabaseManagementServiceBuilder builder) {
        builder.setConfig(GraphDatabaseInternalSettings.always_use_latest_index_provider, (Object)false);
        Monitors monitors = new Monitors();
        IndexMonitor.MonitorAdapter trappingMonitor = new IndexMonitor.MonitorAdapter(){

            public void indexPopulationScanComplete(IndexDescriptor[] indexDescriptors) {
                if (StringLengthIndexValidationIT.this.trapPopulation.get()) {
                    StringLengthIndexValidationIT.this.populationScanFinished.reached();
                }
            }
        };
        monitors.addMonitorListener((Object)trappingMonitor, new String[0]);
        builder.setMonitors(monitors);
        this.additionalConfig(builder);
    }

    protected void additionalConfig(TestDatabaseManagementServiceBuilder builder) {
    }

    @Test
    void shouldSuccessfullyWriteAndReadWithinIndexKeySizeLimit() throws KernelException {
        this.createAndAwaitIndex();
        String propValue = this.getString(this.random, this.singleKeySizeLimit);
        String expectedNodeId = this.createNode(propValue);
        this.assertReadNode(propValue, expectedNodeId);
    }

    @Test
    void shouldSuccessfullyPopulateIndexWithinIndexKeySizeLimit() throws KernelException {
        String propValue = this.getString(this.random, this.singleKeySizeLimit);
        String expectedNodeId = this.createNode(propValue);
        this.createAndAwaitIndex();
        this.assertReadNode(propValue, expectedNodeId);
    }

    @Test
    void txMustFailIfExceedingIndexKeySizeLimit() throws KernelException {
        long indexId = this.createAndAwaitIndex();
        try (Transaction tx = this.db.beginTx();){
            String propValue = this.getString(this.random, this.singleKeySizeLimit + 1);
            Node node = tx.createNode(new Label[]{TestLabels.LABEL_ONE});
            String nodeId = node.getElementId();
            IllegalArgumentException e = (IllegalArgumentException)org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> node.setProperty(propKey, (Object)propValue));
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{String.format("Property value is too large to index, please see index documentation for limitations. Index: Index( id=%d, name='coolName', type='%s', schema=(:LABEL_ONE {largeString}), indexProvider='%s' ), element id: %s", indexId, this.getIndexType(), this.getIndexProvider().name(), nodeId)});
        }
    }

    @Test
    void indexPopulationMustFailIfExceedingIndexKeySizeLimit() throws KernelException {
        String propValue = this.getString(this.random, this.singleKeySizeLimit + 1);
        String nodeId = this.createNode(propValue);
        long indexId = this.createIndex();
        this.assertIndexFailToComeOnline(indexId, nodeId);
        this.assertIndexInFailedState(indexId, nodeId);
    }

    @Test
    public void externalUpdatesMustNotFailIndexPopulationIfWithinIndexKeySizeLimit() throws InterruptedException, KernelException {
        this.trapPopulation.set(true);
        try (Transaction tx = this.db.beginTx();){
            tx.createNode();
            tx.commit();
        }
        this.createIndex();
        this.populationScanFinished.await();
        String propValue = this.getString(this.random, this.singleKeySizeLimit);
        String nodeId = this.createNode(propValue);
        this.populationScanFinished.release();
        try (Transaction tx = this.db.beginTx();){
            tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
            tx.commit();
        }
        this.assertReadNode(propValue, nodeId);
    }

    @Test
    public void externalUpdatesMustFailIndexPopulationIfExceedingIndexKeySizeLimit() throws InterruptedException, KernelException {
        this.trapPopulation.set(true);
        try (Transaction tx = this.db.beginTx();){
            tx.createNode();
            tx.commit();
        }
        long indexId = this.createIndex();
        this.populationScanFinished.await();
        String propValue = this.getString(this.random, this.singleKeySizeLimit + 1);
        String nodeId = this.createNode(propValue);
        this.populationScanFinished.release();
        this.assertIndexFailToComeOnline(indexId, nodeId);
        this.assertIndexInFailedState(indexId, nodeId);
    }

    public void assertIndexFailToComeOnline(long indexId, String elementId) {
        Exception e = (Exception)org.junit.jupiter.api.Assertions.assertThrows(Exception.class, () -> {
            try (Transaction tx = this.db.beginTx();){
                tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
                tx.commit();
            }
        });
        Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{String.format("Index IndexDefinition[label:LABEL_ONE on:largeString] (Index( id=%d, name='coolName', type='%s', schema=(:LABEL_ONE {largeString}), indexProvider='%s' )) entered a FAILED state.", indexId, this.getIndexType(), this.getIndexProvider().name()), this.expectedPopulationFailureCauseMessage(indexId, elementId)});
    }

    public void assertIndexInFailedState(long indexId, String elementId) {
        try (Transaction tx = this.db.beginTx();){
            Iterator iterator = tx.schema().getIndexes(TestLabels.LABEL_ONE).iterator();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)iterator.hasNext());
            IndexDefinition next = (IndexDefinition)iterator.next();
            org.junit.jupiter.api.Assertions.assertEquals((Object)Schema.IndexState.FAILED, (Object)tx.schema().getIndexState(next), (String)"state is FAILED");
            Assertions.assertThat((String)tx.schema().getIndexFailure(next)).contains(new CharSequence[]{this.expectedPopulationFailureCauseMessage(indexId, elementId)});
            tx.commit();
        }
    }

    @Test
    void shouldHandleSizesCloseToTheLimit() throws KernelException {
        Node node;
        this.createAndAwaitIndex();
        HashMap<String, Long> strings = new HashMap<String, Long>();
        try (Transaction tx = this.db.beginTx();){
            for (int i = 0; i < 1000; ++i) {
                String string;
                while (strings.containsKey(string = this.getString(this.random, this.random.nextInt(this.singleKeySizeLimit / 2, this.singleKeySizeLimit)))) {
                }
                node = tx.createNode(new Label[]{TestLabels.LABEL_ONE});
                node.setProperty(propKey, (Object)string);
                strings.put(string, node.getId());
            }
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            for (String string : strings.keySet()) {
                node = tx.findNode(TestLabels.LABEL_ONE, propKey, (Object)string);
                org.junit.jupiter.api.Assertions.assertEquals((long)((Long)strings.get(string)), (long)node.getId());
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private long createAndAwaitIndex() throws KernelException {
        long indexId = this.createIndex();
        try (Transaction tx = this.db.beginTx();){
            tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
            tx.commit();
        }
        return indexId;
    }

    private long createIndex() throws KernelException {
        long indexId;
        try (Transaction tx = this.db.beginTx();){
            Token token = ((TransactionImpl)tx).kernelTransaction().token();
            int labelId = token.labelGetOrCreateForName(TestLabels.LABEL_ONE.name());
            int propertyId = token.propertyKeyGetOrCreateForName(propKey);
            SchemaWrite schemaWrite = ((TransactionImpl)tx).kernelTransaction().schemaWrite();
            IndexPrototype indexPrototype = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)labelId, (int[])new int[]{propertyId})).withIndexType(this.getIndexType()).withName("coolName").withIndexProvider(this.getIndexProvider());
            IndexDescriptor indexDescriptor = schemaWrite.indexCreate(indexPrototype);
            indexId = indexDescriptor.getId();
            tx.commit();
        }
        return indexId;
    }

    private String createNode(String propValue) {
        String expectedNodeId;
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode(new Label[]{TestLabels.LABEL_ONE});
            node.setProperty(propKey, (Object)propValue);
            expectedNodeId = node.getElementId();
            tx.commit();
        }
        return expectedNodeId;
    }

    private void assertReadNode(String propValue, String expectedNodeId) {
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.findNode(TestLabels.LABEL_ONE, propKey, (Object)propValue);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)node);
            org.junit.jupiter.api.Assertions.assertEquals((Object)expectedNodeId, (Object)node.getElementId(), (String)"node id");
            tx.commit();
        }
    }
}

