/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.lucene.analysis.miscellaneous.ASCIIFoldingFilter;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.set.MutableSet;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.io.IOUtils;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexProceduresUtil;
import org.neo4j.kernel.api.impl.fulltext.FulltextProceduresTestSupport;
import org.neo4j.procedure.builtin.FulltextProcedures;
import org.neo4j.test.ThreadTestUtils;
import org.neo4j.util.concurrent.BinaryLatch;
import org.neo4j.values.storable.Value;

class FulltextProceduresTest
extends FulltextProceduresTestSupport {
    FulltextProceduresTest() {
    }

    @Test
    void createFulltextRelationshipIndex() {
        String createMethod = String.format("CREATE FULLTEXT INDEX `%s` FOR %s ON EACH %s", "test-index", FulltextIndexProceduresUtil.asRelationshipTypeStr((String[])new String[]{"EntityToken1", "EntityToken2"}), FulltextIndexProceduresUtil.asPropertiesStrList((String[])new String[]{"prop1", "prop2"}));
        this.createFulltextIndex(createMethod);
    }

    @Test
    void createFulltextNodeIndex() {
        String createMethod = String.format("CREATE FULLTEXT INDEX `%s` FOR %s ON EACH %s", "test-index", FulltextIndexProceduresUtil.asNodeLabelStr((String[])new String[]{"EntityToken1", "EntityToken2"}), FulltextIndexProceduresUtil.asPropertiesStrList((String[])new String[]{"prop1", "prop2"}));
        this.createFulltextIndex(createMethod);
    }

    private void createFulltextIndex(String indexCreateMethod) {
        Map row;
        Result result;
        try (Transaction tx = this.db.beginTx();){
            tx.execute(indexCreateMethod).close();
            tx.commit();
        }
        try (Transaction tx = this.db.beginTx();){
            result = tx.execute("SHOW FULLTEXT INDEXES");
            org.junit.jupiter.api.Assertions.assertTrue((boolean)result.hasNext());
            row = result.next();
            org.junit.jupiter.api.Assertions.assertEquals(Arrays.asList("EntityToken1", "EntityToken2"), row.get("labelsOrTypes"));
            org.junit.jupiter.api.Assertions.assertEquals(Arrays.asList("prop1", "prop2"), row.get("properties"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)"test-index", row.get("name"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)"FULLTEXT", row.get("type"));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)result.hasNext());
            result.close();
            tx.commit();
        }
        this.awaitIndexesOnline();
        tx = this.db.beginTx();
        try {
            result = tx.execute("SHOW FULLTEXT INDEXES");
            org.junit.jupiter.api.Assertions.assertTrue((boolean)result.hasNext());
            org.junit.jupiter.api.Assertions.assertEquals((Object)"ONLINE", result.next().get("state"));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)result.hasNext());
            result.close();
            org.junit.jupiter.api.Assertions.assertNotNull((Object)tx.schema().getIndexByName("test-index"));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.restartDatabase();
        tx = this.db.beginTx();
        try {
            result = tx.execute("SHOW FULLTEXT INDEXES");
            org.junit.jupiter.api.Assertions.assertTrue((boolean)result.hasNext());
            row = result.next();
            org.junit.jupiter.api.Assertions.assertEquals(Arrays.asList("EntityToken1", "EntityToken2"), row.get("labelsOrTypes"));
            org.junit.jupiter.api.Assertions.assertEquals(Arrays.asList("prop1", "prop2"), row.get("properties"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)"test-index", row.get("name"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)"FULLTEXT", row.get("type"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)"ONLINE", row.get("state"));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)result.hasNext());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)result.hasNext());
            org.junit.jupiter.api.Assertions.assertNotNull((Object)tx.schema().getIndexByName("test-index"));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void nodeIndexesMustHaveLabels() {
        Exception e = (Exception)org.junit.jupiter.api.Assertions.assertThrows(QueryExecutionException.class, () -> {
            try (Transaction tx = this.db.beginTx();){
                tx.execute(String.format("CREATE FULLTEXT INDEX `%s` FOR %s ON EACH %s", "nodeIndex", FulltextIndexProceduresUtil.asNodeLabelStr((String[])new String[0]), FulltextIndexProceduresUtil.asPropertiesStrList((String[])new String[]{"prop"}))).close();
            }
        });
        Assertions.assertThat((Throwable)e).message().containsAnyOf(new CharSequence[]{"Invalid input ')': expected \":\"", "Invalid input ')': expected ':'"});
    }

    @Test
    void relationshipIndexesMustHaveRelationshipTypes() {
        Exception e = (Exception)org.junit.jupiter.api.Assertions.assertThrows(QueryExecutionException.class, () -> {
            try (Transaction tx = this.db.beginTx();){
                tx.execute(String.format("CREATE FULLTEXT INDEX `%s` FOR %s ON EACH %s", "relIndex", FulltextIndexProceduresUtil.asRelationshipTypeStr((String[])new String[0]), FulltextIndexProceduresUtil.asPropertiesStrList((String[])new String[]{"prop"})));
            }
        });
        Assertions.assertThat((Throwable)e).message().containsAnyOf(new CharSequence[]{"Invalid input ']': expected \":\"", "Invalid input ']': expected ':'"});
    }

    @Test
    void relationshipIndexesMustHaveProperties() {
        Exception e = (Exception)org.junit.jupiter.api.Assertions.assertThrows(QueryExecutionException.class, () -> {
            try (Transaction tx = this.db.beginTx();){
                tx.execute(String.format("CREATE FULLTEXT INDEX `%s` FOR %s ON EACH %s", "index", FulltextIndexProceduresUtil.asRelationshipTypeStr((String[])new String[]{"EntityToken"}), FulltextIndexProceduresUtil.asPropertiesStrList((String[])new String[0]))).close();
            }
        });
        Assertions.assertThat((Throwable)e).message().containsAnyOf(new CharSequence[]{"Invalid input ']': expected an identifier", "Invalid input ']': expected a variable name"});
    }

    @Test
    void nodeIndexesMustHaveProperties() {
        String indexCreateMethod = String.format("CREATE FULLTEXT INDEX `%s` FOR %s ON EACH %s", "index", FulltextIndexProceduresUtil.asNodeLabelStr((String[])new String[]{"EntityToken"}), FulltextIndexProceduresUtil.asPropertiesStrList((String[])new String[0]));
        Exception e = (Exception)org.junit.jupiter.api.Assertions.assertThrows(QueryExecutionException.class, () -> {
            try (Transaction tx = this.db.beginTx();){
                tx.execute(indexCreateMethod).close();
            }
        });
        Assertions.assertThat((Throwable)e).message().containsAnyOf(new CharSequence[]{"Invalid input ']': expected an identifier", "Invalid input ']': expected a variable name"});
    }

    @Test
    void creatingIndexesWhichImpliesTokenCreateMustNotBlockForever() {
        try (Transaction tx = this.db.beginTx();){
            tx.execute(String.format("CREATE FULLTEXT INDEX `%s` FOR %s ON EACH %s", "nodesA", FulltextIndexProceduresUtil.asNodeLabelStr((String[])new String[]{"SOME_LABEL"}), FulltextIndexProceduresUtil.asPropertiesStrList((String[])new String[]{"this"})));
            tx.execute(String.format("CREATE FULLTEXT INDEX `%s` FOR %s ON EACH %s", "relsA", FulltextIndexProceduresUtil.asRelationshipTypeStr((String[])new String[]{"SOME_REL_TYPE"}), FulltextIndexProceduresUtil.asPropertiesStrList((String[])new String[]{"foo"})));
            tx.execute(String.format("CREATE FULLTEXT INDEX `%s` FOR %s ON EACH %s", "nodesB", FulltextIndexProceduresUtil.asNodeLabelStr((String[])new String[]{"SOME_OTHER_LABEL"}), FulltextIndexProceduresUtil.asPropertiesStrList((String[])new String[]{"that"})));
            tx.execute(String.format("CREATE FULLTEXT INDEX `%s` FOR %s ON EACH %s", "relsB", FulltextIndexProceduresUtil.asRelationshipTypeStr((String[])new String[]{"SOME_OTHER_REL_TYPE"}), FulltextIndexProceduresUtil.asPropertiesStrList((String[])new String[]{"bar"})));
            tx.commit();
        }
    }

    @Test
    void creatingIndexWithSpecificAnalyzerMustUseThatAnalyzerForPopulationUpdatingAndQuerying() {
        MutableSet noResults = Sets.mutable.empty();
        MutableSet swedishNodes = Sets.mutable.empty();
        MutableSet englishNodes = Sets.mutable.empty();
        MutableSet swedishRels = Sets.mutable.empty();
        MutableSet englishRels = Sets.mutable.empty();
        String labelledSwedishNodes = "labelledSwedishNodes";
        String typedSwedishRelationships = "typedSwedishRelationships";
        try (Transaction tx = this.db.beginTx();){
            Node nodeA = tx.createNode(new Label[]{LABEL});
            nodeA.setProperty("prop", (Object)"En apa och en tomte bodde i ett hus.");
            swedishNodes.add(nodeA.getElementId());
            Node nodeB = tx.createNode(new Label[]{LABEL});
            nodeB.setProperty("prop", (Object)"Hello and hello again, in the end.");
            englishNodes.add(nodeB.getElementId());
            Relationship relA = nodeA.createRelationshipTo(nodeB, REL);
            relA.setProperty("prop", (Object)"En apa och en tomte bodde i ett hus.");
            swedishRels.add(relA.getElementId());
            Relationship relB = nodeB.createRelationshipTo(nodeA, REL);
            relB.setProperty("prop", (Object)"Hello and hello again, in the end.");
            englishRels.add(relB.getElementId());
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            String lbl = FulltextIndexProceduresUtil.asNodeLabelStr((String[])new String[]{LABEL.name()});
            String rel = FulltextIndexProceduresUtil.asRelationshipTypeStr((String[])new String[]{REL.name()});
            String props = FulltextIndexProceduresUtil.asPropertiesStrList((String[])new String[]{"prop"});
            String swedish = "{`fulltext.analyzer`: 'swedish'}";
            tx.execute(String.format("CREATE FULLTEXT INDEX `%s` FOR %s ON EACH %s OPTIONS {indexConfig: %s}", labelledSwedishNodes, lbl, props, swedish)).close();
            tx.execute(String.format("CREATE FULLTEXT INDEX `%s` FOR %s ON EACH %s OPTIONS {indexConfig: %s}", typedSwedishRelationships, rel, props, swedish)).close();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.awaitIndexesOnline();
        tx = this.db.beginTx();
        try {
            Node nodeC = tx.createNode(new Label[]{LABEL});
            nodeC.setProperty("prop", (Object)"En apa och en tomte bodde i ett hus.");
            swedishNodes.add(nodeC.getElementId());
            Node nodeD = tx.createNode(new Label[]{LABEL});
            nodeD.setProperty("prop", (Object)"Hello and hello again, in the end.");
            englishNodes.add(nodeD.getElementId());
            Relationship relC = nodeC.createRelationshipTo(nodeD, REL);
            relC.setProperty("prop", (Object)"En apa och en tomte bodde i ett hus.");
            swedishRels.add(relC.getElementId());
            Relationship relD = nodeD.createRelationshipTo(nodeC, REL);
            relD.setProperty("prop", (Object)"Hello and hello again, in the end.");
            englishRels.add(relD.getElementId());
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, labelledSwedishNodes, "and", (Set<String>)englishNodes);
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, labelledSwedishNodes, "ett", (Set<String>)noResults);
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, labelledSwedishNodes, "apa", (Set<String>)swedishNodes);
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, typedSwedishRelationships, "and", (Set<String>)englishRels);
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, typedSwedishRelationships, "ett", (Set<String>)noResults);
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, typedSwedishRelationships, "apa", (Set<String>)swedishRels);
    }

    @Test
    void queryShouldFindDataAddedInLaterTransactions() {
        String horseRelId;
        String horseId;
        try (Transaction tx = this.db.beginTx();){
            tx.execute(String.format("CREATE FULLTEXT INDEX `%s` FOR %s ON EACH %s", "nodes", FulltextIndexProceduresUtil.asNodeLabelStr((String[])new String[]{"Label1", "Label2"}), FulltextIndexProceduresUtil.asPropertiesStrList((String[])new String[]{"prop1", "prop2"}))).close();
            tx.execute(String.format("CREATE FULLTEXT INDEX `%s` FOR %s ON EACH %s", "rels", FulltextIndexProceduresUtil.asRelationshipTypeStr((String[])new String[]{"Reltype1", "Reltype2"}), FulltextIndexProceduresUtil.asPropertiesStrList((String[])new String[]{"prop1", "prop2"}))).close();
            tx.commit();
        }
        this.awaitIndexesOnline();
        try (Transaction tx = this.db.beginTx();){
            Node zebra = tx.createNode();
            zebra.setProperty("prop1", (Object)"zebra");
            Node horse = tx.createNode(new Label[]{Label.label((String)"Label1")});
            horse.setProperty("prop2", (Object)"horse");
            horse.setProperty("prop3", (Object)"zebra");
            Relationship horseRel = zebra.createRelationshipTo(horse, RelationshipType.withName((String)"Reltype1"));
            horseRel.setProperty("prop1", (Object)"horse");
            Relationship loop = horse.createRelationshipTo(horse, RelationshipType.withName((String)"loop"));
            loop.setProperty("prop2", (Object)"zebra");
            horseId = horse.getElementId();
            horseRelId = horseRel.getElementId();
            tx.commit();
        }
        FulltextProceduresTest.assertQueryFindsIdsInOrder((GraphDatabaseService)this.db, true, "nodes", "horse", horseId);
        FulltextProceduresTest.assertQueryFindsIdsInOrder((GraphDatabaseService)this.db, true, "nodes", "horse zebra", horseId);
        FulltextProceduresTest.assertQueryFindsIdsInOrder((GraphDatabaseService)this.db, true, "nodes", "zebra", new String[0]);
        FulltextProceduresTest.assertQueryFindsIdsInOrder((GraphDatabaseService)this.db, false, "rels", "horse", horseRelId);
        FulltextProceduresTest.assertQueryFindsIdsInOrder((GraphDatabaseService)this.db, false, "rels", "horse zebra", horseRelId);
    }

    @Test
    void queryShouldFindDataAddedInIndexPopulation() {
        Relationship relationship;
        Node node2;
        Node node1;
        try (Transaction tx = this.db.beginTx();){
            node1 = tx.createNode(new Label[]{LABEL});
            node1.setProperty("prop", (Object)"This is a integration test.");
            node2 = tx.createNode(new Label[]{LABEL});
            node2.setProperty("otherprop", (Object)"This is a related integration test");
            relationship = node1.createRelationshipTo(node2, REL);
            relationship.setProperty("prop", (Object)"They relate");
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.execute(String.format("CREATE FULLTEXT INDEX `%s` FOR %s ON EACH %s", "nodes", FulltextIndexProceduresUtil.asNodeLabelStr((String[])new String[]{LABEL.name()}), FulltextIndexProceduresUtil.asPropertiesStrList((String[])new String[]{"prop", "otherprop"})));
            tx.execute(String.format("CREATE FULLTEXT INDEX `%s` FOR %s ON EACH %s", "rels", FulltextIndexProceduresUtil.asRelationshipTypeStr((String[])new String[]{REL.name()}), FulltextIndexProceduresUtil.asPropertiesStrList((String[])new String[]{"prop"})));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.awaitIndexesOnline();
        FulltextProceduresTest.assertQueryFindsIdsInOrder((GraphDatabaseService)this.db, true, "nodes", "integration", node1.getElementId(), node2.getElementId());
        FulltextProceduresTest.assertQueryFindsIdsInOrder((GraphDatabaseService)this.db, true, "nodes", "test", node1.getElementId(), node2.getElementId());
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "related", (Set<String>)Sets.mutable.of((Object[])new String[]{node2.getElementId()}));
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rels", "relate", (Set<String>)Sets.mutable.of((Object[])new String[]{relationship.getElementId()}));
    }

    @Test
    void updatesToEventuallyConsistentIndexMustEventuallyBecomeVisible() {
        try (Transaction tx = this.db.beginTx();){
            tx.execute(String.format("CREATE FULLTEXT INDEX `%s` FOR %s ON EACH %s OPTIONS {indexConfig: %s}", "nodes", FulltextIndexProceduresUtil.asNodeLabelStr((String[])new String[]{LABEL.name()}), FulltextIndexProceduresUtil.asPropertiesStrList((String[])new String[]{"prop"}), "{`fulltext.eventually_consistent`: true}"));
            tx.execute(String.format("CREATE FULLTEXT INDEX `%s` FOR %s ON EACH %s OPTIONS {indexConfig: %s}", "rels", FulltextIndexProceduresUtil.asRelationshipTypeStr((String[])new String[]{REL.name()}), FulltextIndexProceduresUtil.asPropertiesStrList((String[])new String[]{"prop"}), "{`fulltext.eventually_consistent`: true}"));
            tx.commit();
        }
        MutableSet nodeIds = Sets.mutable.empty();
        MutableSet relIds = Sets.mutable.empty();
        this.generateNodesAndRelationshipsWithProperty(200, (Set<String>)nodeIds, (Set<String>)relIds, "bla bla");
        long deadline = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(20L);
        boolean success = false;
        while (true) {
            try {
                FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "bla", (Set<String>)nodeIds);
                FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rels", "bla", (Set<String>)relIds);
                success = true;
            }
            finally {
                if (!success) continue;
            }
            break;
        }
    }

    @Test
    void updatesToEventuallyConsistentIndexMustBecomeVisibleAfterAwaitRefresh() {
        try (Transaction tx = this.db.beginTx();){
            tx.execute(String.format("CREATE FULLTEXT INDEX `%s` FOR %s ON EACH %s OPTIONS {indexConfig: %s}", "nodes", FulltextIndexProceduresUtil.asNodeLabelStr((String[])new String[]{LABEL.name()}), FulltextIndexProceduresUtil.asPropertiesStrList((String[])new String[]{"prop"}), "{`fulltext.eventually_consistent`: true}"));
            tx.execute(String.format("CREATE FULLTEXT INDEX `%s` FOR %s ON EACH %s OPTIONS {indexConfig: %s}", "rels", FulltextIndexProceduresUtil.asRelationshipTypeStr((String[])new String[]{REL.name()}), FulltextIndexProceduresUtil.asPropertiesStrList((String[])new String[]{"prop"}), "{`fulltext.eventually_consistent`: true}"));
            tx.commit();
        }
        this.awaitIndexesOnline();
        MutableSet nodeIds = Sets.mutable.empty();
        MutableSet relIds = Sets.mutable.empty();
        this.generateNodesAndRelationshipsWithProperty(200, (Set<String>)nodeIds, (Set<String>)relIds, "bla bla");
        try (Transaction transaction = this.db.beginTx();){
            transaction.execute("CALL db.index.fulltext.awaitEventuallyConsistentIndexRefresh()").close();
            transaction.commit();
        }
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "bla", (Set<String>)nodeIds);
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rels", "bla", (Set<String>)relIds);
    }

    @Test
    void eventuallyConsistentIndexMustPopulateWithExistingDataWhenCreated() {
        MutableSet nodeIds = Sets.mutable.empty();
        MutableSet relIds = Sets.mutable.empty();
        this.generateNodesAndRelationshipsWithProperty(200, (Set<String>)nodeIds, (Set<String>)relIds, "bla bla");
        try (Transaction tx = this.db.beginTx();){
            tx.execute(String.format("CREATE FULLTEXT INDEX `%s` FOR %s ON EACH %s OPTIONS {indexConfig: %s}", "nodes", FulltextIndexProceduresUtil.asNodeLabelStr((String[])new String[]{LABEL.name()}), FulltextIndexProceduresUtil.asPropertiesStrList((String[])new String[]{"prop"}), "{`fulltext.eventually_consistent`: true}"));
            tx.execute(String.format("CREATE FULLTEXT INDEX `%s` FOR %s ON EACH %s OPTIONS {indexConfig: %s}", "rels", FulltextIndexProceduresUtil.asRelationshipTypeStr((String[])new String[]{REL.name()}), FulltextIndexProceduresUtil.asPropertiesStrList((String[])new String[]{"prop"}), "{`fulltext.eventually_consistent`: true}"));
            tx.commit();
        }
        this.awaitIndexesOnline();
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", "bla", (Set<String>)nodeIds);
        FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rels", "bla", (Set<String>)relIds);
    }

    private void generateNodesAndRelationshipsWithProperty(int count, Set<String> nodeIds, Set<String> relIds, String propertyValue) {
        try (Transaction tx = this.db.beginTx();){
            for (int i = 0; i < count; ++i) {
                Node node = tx.createNode(new Label[]{LABEL});
                node.setProperty("prop", (Object)propertyValue);
                Relationship rel = node.createRelationshipTo(node, REL);
                rel.setProperty("prop", (Object)propertyValue);
                nodeIds.add(node.getElementId());
                relIds.add(rel.getElementId());
            }
            tx.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void concurrentPopulationAndUpdatesToAnEventuallyConsistentIndexMustEventuallyResultInCorrectIndexState() throws Exception {
        String oldValue = "red";
        String newValue = "green";
        MutableSet nodeIds = Sets.mutable.empty();
        MutableSet relIds = Sets.mutable.empty();
        this.generateNodesAndRelationshipsWithProperty(200, (Set<String>)nodeIds, (Set<String>)relIds, oldValue);
        CountDownLatch readyLatch = new CountDownLatch(2);
        BinaryLatch startLatch = new BinaryLatch();
        Runnable createIndexes = () -> {
            readyLatch.countDown();
            startLatch.await();
            try (Transaction tx = this.db.beginTx();){
                tx.execute(String.format("CREATE FULLTEXT INDEX `%s` FOR %s ON EACH %s OPTIONS {indexConfig: %s}", "nodes", FulltextIndexProceduresUtil.asNodeLabelStr((String[])new String[]{LABEL.name()}), FulltextIndexProceduresUtil.asPropertiesStrList((String[])new String[]{"prop"}), "{`fulltext.eventually_consistent`: true}"));
                tx.execute(String.format("CREATE FULLTEXT INDEX `%s` FOR %s ON EACH %s OPTIONS {indexConfig: %s}", "rels", FulltextIndexProceduresUtil.asRelationshipTypeStr((String[])new String[]{REL.name()}), FulltextIndexProceduresUtil.asPropertiesStrList((String[])new String[]{"prop"}), "{`fulltext.eventually_consistent`: true}"));
                tx.commit();
            }
        };
        Runnable makeAllEntitiesGreen = () -> this.lambda$concurrentPopulationAndUpdatesToAnEventuallyConsistentIndexMustEventuallyResultInCorrectIndexState$7((Set)nodeIds, newValue, (Set)relIds, readyLatch, startLatch);
        ExecutorService executor = Executors.newFixedThreadPool(2);
        Future<?> future1 = executor.submit(createIndexes);
        Future<?> future2 = executor.submit(makeAllEntitiesGreen);
        readyLatch.await();
        startLatch.release();
        try {
            future1.get();
            future2.get();
            this.awaitIndexesOnline();
            try (Transaction tx = this.db.beginTx();){
                tx.execute("CALL db.index.fulltext.awaitEventuallyConsistentIndexRefresh()").close();
            }
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodes", newValue, (Set<String>)nodeIds);
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "rels", newValue, (Set<String>)relIds);
        }
        catch (Throwable throwable) {
            AutoCloseable[] autoCloseableArray = new AutoCloseable[1];
            autoCloseableArray[0] = executor::shutdown;
            IOUtils.closeAllSilently((AutoCloseable[])autoCloseableArray);
            throw throwable;
        }
        AutoCloseable[] autoCloseableArray = new AutoCloseable[1];
        autoCloseableArray[0] = executor::shutdown;
        IOUtils.closeAllSilently((AutoCloseable[])autoCloseableArray);
    }

    @Test
    void mustBeAbleToListAvailableAnalyzers() {
        try (Transaction tx = this.db.beginTx();){
            HashSet<String> analyzers = new HashSet<String>();
            try (ResourceIterator iterator = tx.execute("CALL db.index.fulltext.listAvailableAnalyzers()").columnAs("analyzer");){
                while (iterator.hasNext()) {
                    analyzers.add((String)iterator.next());
                }
            }
            Assertions.assertThat(analyzers).contains((Object[])new String[]{"english"});
            Assertions.assertThat(analyzers).contains((Object[])new String[]{"swedish"});
            Assertions.assertThat(analyzers).contains((Object[])new String[]{"standard"});
            Assertions.assertThat(analyzers).contains((Object[])new String[]{"galician"});
            Assertions.assertThat(analyzers).contains((Object[])new String[]{"irish"});
            Assertions.assertThat(analyzers).contains((Object[])new String[]{"latvian"});
            Assertions.assertThat(analyzers).contains((Object[])new String[]{"sorani"});
            tx.commit();
        }
    }

    @Test
    void listAvailableAnalyzersMustContainDescriptions() {
        try (Transaction tx = this.db.beginTx();){
            try (Result result = tx.execute("CALL db.index.fulltext.listAvailableAnalyzers()");){
                while (result.hasNext()) {
                    Map row = result.next();
                    Object description = row.get("description");
                    org.junit.jupiter.api.Assertions.assertNotNull(description, (String)("Found no description for analyzer: " + String.valueOf(row)));
                    ((ObjectAssert)Assertions.assertThat(description).withFailMessage("Found description for analyzer '" + String.valueOf(row) + "'' that is not a string", new Object[0])).isInstanceOf(String.class);
                    ((AbstractStringAssert)Assertions.assertThat((String)((String)description)).withFailMessage("Found description for analyzer '" + String.valueOf(row) + "'' that is blank", new Object[0])).isNotBlank();
                }
            }
            tx.commit();
        }
    }

    @Test
    void analyzersMustKnowTheirStopWords() {
        try (Transaction tx = this.db.beginTx();){
            try (Result result = tx.execute("CALL db.index.fulltext.listAvailableAnalyzers()");){
                while (result.hasNext()) {
                    Map row = result.next();
                    Object stopwords = row.get("stopwords");
                    ((ObjectAssert)((ObjectAssert)Assertions.assertThat(stopwords).withFailMessage("Found no stop-words list for analyzer: " + String.valueOf(row), new Object[0])).isNotNull()).isInstanceOf(List.class);
                    List words = (List)stopwords;
                    String analyzerName = (String)row.get("analyzer");
                    if (analyzerName.equals("english") || analyzerName.equals("standard")) {
                        Assertions.assertThat((List)words).contains((Object[])new String[]{"and"});
                        continue;
                    }
                    if (!analyzerName.equals("standard-no-stop-words")) continue;
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)words.isEmpty());
                }
            }
            tx.commit();
        }
    }

    @Test
    void testThatStopWordsAreClean() {
        try (Transaction tx = this.db.beginTx();){
            try (Result result = tx.execute("CALL db.index.fulltext.listAvailableAnalyzers()");){
                while (result.hasNext()) {
                    Map row = result.next();
                    List stopwords = (List)row.get("stopwords");
                    for (String stopword : stopwords) {
                        ((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)stopword).withFailMessage("The list of stop-words for the " + String.valueOf(row.get("analyzer")) + " analyzer contains dirty data. Specifically, '" + stopword + "' does not look like a valid stop-word. The full list:" + System.lineSeparator() + String.valueOf(stopwords), new Object[0])).isNotBlank()).doesNotContainAnyWhitespaces()).doesNotContain(new CharSequence[]{"#"});
                    }
                }
            }
            tx.commit();
        }
    }

    @Test
    void queryNodesMustThrowWhenQueryingRelationshipIndex() {
        try (Transaction tx = this.db.beginTx();){
            FulltextProceduresTest.createSimpleRelationshipIndex(tx);
            tx.commit();
        }
        this.awaitIndexesOnline();
        tx = this.db.beginTx();
        try {
            org.junit.jupiter.api.Assertions.assertThrows(Exception.class, () -> tx.execute(String.format("CALL db.index.fulltext.queryNodes(\"%s\", \"%s\")", "rels", "bla bla")).next());
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void queryRelationshipsMustThrowWhenQueryingNodeIndex() {
        try (Transaction tx = this.db.beginTx();){
            FulltextProceduresTest.createSimpleNodesIndex(tx);
            tx.commit();
        }
        this.awaitIndexesOnline();
        tx = this.db.beginTx();
        try {
            org.junit.jupiter.api.Assertions.assertThrows(Exception.class, () -> tx.execute(String.format("CALL db.index.fulltext.queryRelationships(\"%s\", \"%s\")", "nodes", "bla bla")).next());
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void fulltextIndexMustIgnoreNonStringPropertiesForUpdate() {
        try (Transaction tx = this.db.beginTx();){
            FulltextProceduresTest.createSimpleNodesIndex(tx);
            FulltextProceduresTest.createSimpleRelationshipIndex(tx);
            tx.commit();
        }
        this.awaitIndexesOnline();
        List<Value> values = FulltextProceduresTest.generateRandomNonStringValues();
        try (Transaction tx = this.db.beginTx();){
            for (Value value : values) {
                Node node = tx.createNode(new Label[]{LABEL});
                Object propertyValue = value.asObject();
                node.setProperty("prop", propertyValue);
                node.createRelationshipTo(node, REL).setProperty("prop", propertyValue);
            }
            tx.commit();
        }
        this.assertNodeAndRelationshipIndexEmpty();
    }

    @Test
    void fulltextIndexMustIgnoreNonStringPropertiesForPopulation() {
        List<Value> values = FulltextProceduresTest.generateRandomNonStringValues();
        try (Transaction tx = this.db.beginTx();){
            for (Value value : values) {
                Node node = tx.createNode(new Label[]{LABEL});
                Object propertyValue = value.asObject();
                node.setProperty("prop", propertyValue);
                node.createRelationshipTo(node, REL).setProperty("prop", propertyValue);
            }
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            FulltextProceduresTest.createSimpleNodesIndex(tx);
            FulltextProceduresTest.createSimpleRelationshipIndex(tx);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.awaitIndexesOnline();
        this.assertNodeAndRelationshipIndexEmpty();
    }

    @Test
    void entitiesMustBeRemovedFromFulltextIndexWhenPropertyValuesChangeAwayFromText() {
        String relId;
        Relationship rel;
        String nodeId;
        Node node;
        try (Transaction tx = this.db.beginTx();){
            FulltextProceduresTest.createSimpleNodesIndex(tx);
            FulltextProceduresTest.createSimpleRelationshipIndex(tx);
            tx.commit();
        }
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode(new Label[]{LABEL});
            nodeId = node.getElementId();
            node.setProperty("prop", (Object)"bla bla");
            rel = node.createRelationshipTo(node, REL);
            relId = rel.getElementId();
            rel.setProperty("prop", (Object)"bla bla");
            tx.commit();
        }
        FulltextProceduresTest.assertQueryFindsIdsInOrder((GraphDatabaseService)this.db, true, "nodes", "bla bla", nodeId);
        FulltextProceduresTest.assertQueryFindsIdsInOrder((GraphDatabaseService)this.db, false, "rels", "bla bla", relId);
        this.awaitIndexesOnline();
        tx = this.db.beginTx();
        try {
            node = tx.getNodeByElementId(nodeId);
            node.setProperty("prop", (Object)42);
            rel = tx.getRelationshipByElementId(relId);
            rel.setProperty("prop", (Object)42);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.assertNodeAndRelationshipIndexEmpty();
    }

    private void assertNodeAndRelationshipIndexEmpty() {
        try (Transaction tx = this.db.beginTx();){
            Result nodes = tx.execute(String.format("CALL db.index.fulltext.queryNodes(\"%s\", \"%s\")", "nodes", "*:*"));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)nodes.hasNext());
            Result relationships = tx.execute(String.format("CALL db.index.fulltext.queryRelationships(\"%s\", \"%s\")", "rels", "*:*"));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)relationships.hasNext());
            tx.commit();
        }
    }

    @Test
    void entitiesMustBeAddedToFulltextIndexWhenPropertyValuesChangeToText() {
        String relId;
        Relationship rel;
        String nodeId;
        Node node;
        try (Transaction tx = this.db.beginTx();){
            FulltextProceduresTest.createSimpleNodesIndex(tx);
            FulltextProceduresTest.createSimpleRelationshipIndex(tx);
            tx.commit();
        }
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode(new Label[]{LABEL});
            node.setProperty("prop", (Object)42);
            nodeId = node.getElementId();
            rel = node.createRelationshipTo(node, REL);
            relId = rel.getElementId();
            rel.setProperty("prop", (Object)42);
            tx.commit();
        }
        this.awaitIndexesOnline();
        tx = this.db.beginTx();
        try {
            node = tx.getNodeByElementId(nodeId);
            node.setProperty("prop", (Object)"bla bla");
            rel = tx.getRelationshipByElementId(relId);
            rel.setProperty("prop", (Object)"bla bla");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIdsInOrder((GraphDatabaseService)this.db, true, "nodes", "bla", nodeId);
        FulltextProceduresTest.assertQueryFindsIdsInOrder((GraphDatabaseService)this.db, false, "rels", "bla", relId);
    }

    @Test
    void propertiesMustBeRemovedFromFulltextIndexWhenTheirValueTypeChangesAwayFromText() {
        String relId;
        Relationship rel;
        String nodeId;
        Node node;
        try (Transaction tx = this.db.beginTx();){
            tx.execute(String.format("CREATE FULLTEXT INDEX `%s` FOR %s ON EACH %s", "nodes", FulltextIndexProceduresUtil.asNodeLabelStr((String[])new String[]{LABEL.name()}), FulltextIndexProceduresUtil.asPropertiesStrList((String[])new String[]{"prop1", "prop2"}))).close();
            tx.execute(String.format("CREATE FULLTEXT INDEX `%s` FOR %s ON EACH %s", "rels", FulltextIndexProceduresUtil.asRelationshipTypeStr((String[])new String[]{REL.name()}), FulltextIndexProceduresUtil.asPropertiesStrList((String[])new String[]{"prop1", "prop2"}))).close();
            tx.commit();
        }
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode(new Label[]{LABEL});
            nodeId = node.getElementId();
            node.setProperty("prop1", (Object)"foo");
            node.setProperty("prop2", (Object)"bar");
            rel = node.createRelationshipTo(node, REL);
            relId = rel.getElementId();
            rel.setProperty("prop1", (Object)"foo");
            rel.setProperty("prop2", (Object)"bar");
            tx.commit();
        }
        this.awaitIndexesOnline();
        FulltextProceduresTest.assertQueryFindsIdsInOrder((GraphDatabaseService)this.db, true, "nodes", "foo", nodeId);
        FulltextProceduresTest.assertQueryFindsIdsInOrder((GraphDatabaseService)this.db, true, "nodes", "bar", nodeId);
        FulltextProceduresTest.assertQueryFindsIdsInOrder((GraphDatabaseService)this.db, false, "rels", "foo", relId);
        FulltextProceduresTest.assertQueryFindsIdsInOrder((GraphDatabaseService)this.db, false, "rels", "bar", relId);
        tx = this.db.beginTx();
        try {
            node = tx.getNodeByElementId(nodeId);
            node.setProperty("prop2", (Object)42);
            rel = tx.getRelationshipByElementId(relId);
            rel.setProperty("prop2", (Object)42);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIdsInOrder((GraphDatabaseService)this.db, true, "nodes", "foo", nodeId);
        FulltextProceduresTest.assertQueryFindsIdsInOrder((GraphDatabaseService)this.db, true, "nodes", "bar", new String[0]);
        FulltextProceduresTest.assertQueryFindsIdsInOrder((GraphDatabaseService)this.db, false, "rels", "foo", relId);
        FulltextProceduresTest.assertQueryFindsIdsInOrder((GraphDatabaseService)this.db, false, "rels", "bar", new String[0]);
    }

    @Test
    void propertiesMustBeAddedToFulltextIndexWhenTheirValueTypeChangesToText() {
        String relId;
        Relationship rel;
        String nodeId;
        Node node;
        try (Transaction tx = this.db.beginTx();){
            tx.execute(String.format("CREATE FULLTEXT INDEX `%s` FOR %s ON EACH %s", "nodes", FulltextIndexProceduresUtil.asNodeLabelStr((String[])new String[]{LABEL.name()}), FulltextIndexProceduresUtil.asPropertiesStrList((String[])new String[]{"prop1", "prop2"}))).close();
            tx.execute(String.format("CREATE FULLTEXT INDEX `%s` FOR %s ON EACH %s", "rels", FulltextIndexProceduresUtil.asRelationshipTypeStr((String[])new String[]{REL.name()}), FulltextIndexProceduresUtil.asPropertiesStrList((String[])new String[]{"prop1", "prop2"}))).close();
            tx.commit();
        }
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode(new Label[]{LABEL});
            nodeId = node.getElementId();
            node.setProperty("prop1", (Object)"foo");
            node.setProperty("prop2", (Object)42);
            rel = node.createRelationshipTo(node, REL);
            relId = rel.getElementId();
            rel.setProperty("prop1", (Object)"foo");
            rel.setProperty("prop2", (Object)42);
            tx.commit();
        }
        this.awaitIndexesOnline();
        FulltextProceduresTest.assertQueryFindsIdsInOrder((GraphDatabaseService)this.db, true, "nodes", "foo", nodeId);
        FulltextProceduresTest.assertQueryFindsIdsInOrder((GraphDatabaseService)this.db, false, "rels", "foo", relId);
        tx = this.db.beginTx();
        try {
            node = tx.getNodeByElementId(nodeId);
            node.setProperty("prop2", (Object)"bar");
            rel = tx.getRelationshipByElementId(relId);
            rel.setProperty("prop2", (Object)"bar");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIdsInOrder((GraphDatabaseService)this.db, true, "nodes", "foo", nodeId);
        FulltextProceduresTest.assertQueryFindsIdsInOrder((GraphDatabaseService)this.db, true, "nodes", "bar", nodeId);
        FulltextProceduresTest.assertQueryFindsIdsInOrder((GraphDatabaseService)this.db, false, "rels", "foo", relId);
        FulltextProceduresTest.assertQueryFindsIdsInOrder((GraphDatabaseService)this.db, false, "rels", "bar", relId);
    }

    @Test
    void propertiesMustStayInFulltextIndexWhenSomeOfLabelsRemoved() {
        String nodeId;
        Node node;
        Label secondLabel = Label.label((String)"label2");
        try (Transaction tx = this.db.beginTx();){
            tx.execute(String.format("CREATE FULLTEXT INDEX `%s` FOR %s ON EACH %s", "nodes", FulltextIndexProceduresUtil.asNodeLabelStr((String[])new String[]{LABEL.name(), secondLabel.name()}), FulltextIndexProceduresUtil.asPropertiesStrList((String[])new String[]{"prop"}))).close();
            tx.commit();
        }
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode(new Label[]{LABEL, secondLabel});
            nodeId = node.getElementId();
            node.setProperty("prop", (Object)"foo");
            tx.commit();
        }
        this.awaitIndexesOnline();
        FulltextProceduresTest.assertQueryFindsIdsInOrder((GraphDatabaseService)this.db, true, "nodes", "foo", nodeId);
        tx = this.db.beginTx();
        try {
            node = tx.getNodeByElementId(nodeId);
            node.removeLabel(secondLabel);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIdsInOrder((GraphDatabaseService)this.db, true, "nodes", "foo", nodeId);
    }

    @Test
    void mustBeAbleToIndexHugeTextPropertiesInIndexUpdates() throws Exception {
        String nodeId;
        String meditationes;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Objects.requireNonNull(this.getClass().getResourceAsStream("/meditationes--rene-descartes--public-domain.txt")), StandardCharsets.UTF_8));){
            meditationes = reader.lines().collect(Collectors.joining("\n"));
        }
        Label label = Label.label((String)"Book");
        try (Transaction tx = this.db.beginTx();){
            tx.execute(String.format("CREATE FULLTEXT INDEX `%s` FOR %s ON EACH %s", "books", FulltextIndexProceduresUtil.asNodeLabelStr((String[])new String[]{label.name()}), FulltextIndexProceduresUtil.asPropertiesStrList((String[])new String[]{"title", "author", "contents"}))).close();
            tx.commit();
        }
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode(new Label[]{label});
            nodeId = node.getElementId();
            node.setProperty("title", (Object)"Meditationes de prima philosophia");
            node.setProperty("author", (Object)"Ren\u00e9 Descartes");
            node.setProperty("contents", (Object)meditationes);
            tx.commit();
        }
        this.awaitIndexesOnline();
        FulltextProceduresTest.assertQueryFindsIdsInOrder((GraphDatabaseService)this.db, true, "books", "impellit scriptum offerendum", nodeId);
    }

    @Test
    void mustBeAbleToIndexHugeTextPropertiesInIndexPopulation() throws Exception {
        String nodeId;
        String meditationes;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Objects.requireNonNull(this.getClass().getResourceAsStream("/meditationes--rene-descartes--public-domain.txt")), StandardCharsets.UTF_8));){
            meditationes = reader.lines().collect(Collectors.joining("\n"));
        }
        Label label = Label.label((String)"Book");
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode(new Label[]{label});
            nodeId = node.getElementId();
            node.setProperty("title", (Object)"Meditationes de prima philosophia");
            node.setProperty("author", (Object)"Ren\u00e9 Descartes");
            node.setProperty("contents", (Object)meditationes);
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.execute(String.format("CREATE FULLTEXT INDEX `%s` FOR %s ON EACH %s", "books", FulltextIndexProceduresUtil.asNodeLabelStr((String[])new String[]{label.name()}), FulltextIndexProceduresUtil.asPropertiesStrList((String[])new String[]{"title", "author", "contents"}))).close();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.awaitIndexesOnline();
        FulltextProceduresTest.assertQueryFindsIdsInOrder((GraphDatabaseService)this.db, true, "books", "impellit scriptum offerendum", nodeId);
    }

    @Test
    void mustBeAbleToQuerySpecificPropertiesViaLuceneSyntax() {
        String book2id;
        Label book = Label.label((String)"Book");
        try (Transaction tx = this.db.beginTx();){
            tx.execute(String.format("CREATE FULLTEXT INDEX `%s` FOR %s ON EACH %s", "books", FulltextIndexProceduresUtil.asNodeLabelStr((String[])new String[]{book.name()}), FulltextIndexProceduresUtil.asPropertiesStrList((String[])new String[]{"title", "author"}))).close();
            tx.commit();
        }
        try (Transaction tx = this.db.beginTx();){
            tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
            Node book1 = tx.createNode(new Label[]{book});
            book1.setProperty("author", (Object)"Ren\u00e9 Descartes");
            book1.setProperty("title", (Object)"Meditationes de prima philosophia");
            Node book2 = tx.createNode(new Label[]{book});
            book2.setProperty("author", (Object)"E. M. Curley");
            book2.setProperty("title", (Object)"Descartes Against the Skeptics");
            book2id = book2.getElementId();
            tx.commit();
        }
        FulltextProceduresTest.assertQueryFindsIdsInOrder((GraphDatabaseService)this.db, true, "books", "title:Descartes", book2id);
    }

    @Test
    void mustIndexNodesByCorrectProperties() {
        String nodeId;
        try (Transaction tx = this.db.beginTx();){
            tx.execute(String.format("CREATE FULLTEXT INDEX `%s` FOR %s ON EACH %s", "nodes", FulltextIndexProceduresUtil.asNodeLabelStr((String[])new String[]{LABEL.name()}), FulltextIndexProceduresUtil.asPropertiesStrList((String[])new String[]{"a", "b", "c", "d", "e", "f"}))).close();
            tx.commit();
        }
        this.awaitIndexesOnline();
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode(new Label[]{LABEL});
            node.setProperty("e", (Object)"value");
            nodeId = node.getElementId();
            tx.commit();
        }
        FulltextProceduresTest.assertQueryFindsIdsInOrder((GraphDatabaseService)this.db, true, "nodes", "e:value", nodeId);
        FulltextProceduresTest.assertQueryFindsIdsInOrder((GraphDatabaseService)this.db, true, "nodes", "value", nodeId);
    }

    @MethodSource(value={"entityTypeProvider"})
    @ParameterizedTest
    void queryingIndexInPopulatingStateMustBlockUntilIndexIsOnline(FulltextProceduresTestSupport.EntityUtil entityUtil) throws InterruptedException {
        this.trapPopulation.set(true);
        try (Transaction tx = this.db.beginTx();){
            entityUtil.createEntityWithProperty(tx, "value");
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            entityUtil.createIndex(tx);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            try (Result result = entityUtil.queryIndex(tx, "value");
                 Stream stream = result.stream();){
                this.populationScanFinished.await();
                this.populationScanFinished.release();
                Assertions.assertThat((long)stream.count()).isEqualTo(1L);
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @MethodSource(value={"entityTypeProvider"})
    @ParameterizedTest
    void queryingIndexInTransactionItWasCreatedInMustThrow(FulltextProceduresTestSupport.EntityUtil entityUtil) {
        try (Transaction tx = this.db.beginTx();){
            entityUtil.createIndex(tx);
            org.junit.jupiter.api.Assertions.assertThrows(QueryExecutionException.class, () -> entityUtil.queryIndex(tx, "value").next());
        }
    }

    @MethodSource(value={"entityTypeProvider"})
    @ParameterizedTest
    void queryResultsMustNotIncludeEntitiesDeletedInOtherConcurrentlyCommittedTransactions(FulltextProceduresTestSupport.EntityUtil entityUtil) throws Exception {
        String entityIdB;
        String entityIdA;
        this.createIndexAndWait(entityUtil);
        try (Transaction tx = this.db.beginTx();){
            entityIdA = entityUtil.createEntityWithProperty(tx, "value");
            entityIdB = entityUtil.createEntityWithProperty(tx, "value");
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            try (Result result = entityUtil.queryIndex(tx, "value");){
                ThreadTestUtils.forkFuture(() -> {
                    try (Transaction forkedTx = this.db.beginTx();){
                        entityUtil.deleteEntity(tx, entityIdA);
                        entityUtil.deleteEntity(tx, entityIdB);
                        forkedTx.commit();
                    }
                    return null;
                }).get();
                Assertions.assertThat((long)result.stream().count()).isEqualTo(0L);
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @MethodSource(value={"entityTypeProvider"})
    @ParameterizedTest
    void queryResultsMustIncludeEntitiesWithPropertiesAddedToBeIndexed(FulltextProceduresTestSupport.EntityUtil entityUtil) {
        String entityId;
        this.createIndexAndWait(entityUtil);
        try (Transaction tx = this.db.beginTx();){
            entityId = entityUtil.createEntity(tx);
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            entityUtil.getEntity(tx, entityId).setProperty("prop", (Object)"value");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        entityUtil.assertQueryFindsIdsInOrder(this.db, "prop:value", entityId);
        entityUtil.assertQueryFindsIdsInOrder(this.db, "value", entityId);
    }

    @Test
    void queryResultsMustIncludeNodesWithLabelsModifiedToBeIndexed() {
        String nodeId;
        Node node;
        try (Transaction tx = this.db.beginTx();){
            FulltextProceduresTest.createSimpleNodesIndex(tx);
            tx.commit();
        }
        this.awaitIndexesOnline();
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode();
            node.setProperty("prop", (Object)"value");
            nodeId = node.getElementId();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            node = tx.getNodeByElementId(nodeId);
            node.addLabel(LABEL);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIdsInOrder((GraphDatabaseService)this.db, true, "nodes", "value", nodeId);
    }

    @MethodSource(value={"entityTypeProvider"})
    @ParameterizedTest
    void queryResultsMustIncludeUpdatedValueOfChangedProperties(FulltextProceduresTestSupport.EntityUtil entityUtil) {
        String entityId;
        this.createIndexAndWait(entityUtil);
        try (Transaction tx = this.db.beginTx();){
            entityId = entityUtil.createEntityWithProperty(tx, "primo");
            tx.commit();
        }
        entityUtil.assertQueryFindsIdsInOrder(this.db, "primo", entityId);
        tx = this.db.beginTx();
        try {
            entityUtil.getEntity(tx, entityId).setProperty("prop", (Object)"secundo");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        entityUtil.assertQueryFindsIdsInOrder(this.db, "primo", new String[0]);
        entityUtil.assertQueryFindsIdsInOrder(this.db, "secundo", entityId);
    }

    @MethodSource(value={"entityTypeProvider"})
    @ParameterizedTest
    void queryResultsMustNotIncludeEntitiesWithRemovedIndexedProperties(FulltextProceduresTestSupport.EntityUtil entityUtil) {
        String entityId;
        this.createIndexAndWait(entityUtil);
        try (Transaction tx = this.db.beginTx();){
            entityId = entityUtil.createEntityWithProperty(tx, "value");
            tx.commit();
        }
        entityUtil.assertQueryFindsIdsInOrder(this.db, "value", entityId);
        tx = this.db.beginTx();
        try {
            entityUtil.getEntity(tx, entityId).removeProperty("prop");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        entityUtil.assertQueryFindsIdsInOrder(this.db, "value", new String[0]);
    }

    @Test
    void queryResultsMustNotIncludeNodesWithRemovedIndexedLabels() {
        String nodeId;
        try (Transaction tx = this.db.beginTx();){
            FulltextProceduresTest.createSimpleNodesIndex(tx);
            tx.commit();
        }
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode(new Label[]{LABEL});
            node.setProperty("prop", (Object)"value");
            nodeId = node.getElementId();
            tx.commit();
        }
        FulltextProceduresTest.assertQueryFindsIdsInOrder((GraphDatabaseService)this.db, true, "nodes", "value", nodeId);
        tx = this.db.beginTx();
        try {
            tx.getNodeByElementId(nodeId).removeLabel(LABEL);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIdsInOrder((GraphDatabaseService)this.db, true, "nodes", "value", new String[0]);
    }

    @Test
    void queryResultsMustIncludeNodesWhenNodeLabelRemovalsAreUndone() {
        String nodeId;
        Node node;
        try (Transaction tx = this.db.beginTx();){
            FulltextProceduresTest.createSimpleNodesIndex(tx);
            tx.commit();
        }
        this.awaitIndexesOnline();
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode(new Label[]{LABEL});
            node.setProperty("prop", (Object)"primo");
            nodeId = node.getElementId();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            node = tx.getNodeByElementId(nodeId);
            node.removeLabel(LABEL);
            FulltextProceduresTest.assertQueryFindsIdsInOrder(tx, true, "nodes", "primo", new String[0]);
            node.addLabel(LABEL);
            FulltextProceduresTest.assertQueryFindsIdsInOrder(tx, true, "nodes", "primo", nodeId);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIdsInOrder((GraphDatabaseService)this.db, true, "nodes", "primo", nodeId);
    }

    @MethodSource(value={"entityTypeProvider"})
    @ParameterizedTest
    void queryResultsMustBeOrderedByScore(FulltextProceduresTestSupport.EntityUtil entityUtil) {
        String thirdId;
        String secondId;
        String firstId;
        this.createIndexAndWait(entityUtil);
        try (Transaction tx = this.db.beginTx();){
            firstId = entityUtil.createEntityWithProperty(tx, "dude sweet dude sweet");
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            secondId = entityUtil.createEntityWithProperty(tx, "dude sweet");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            thirdId = entityUtil.createEntityWithProperty(tx, "dude sweet dude dude dude sweet");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        entityUtil.assertQueryFindsIdsInOrder(this.db, "dude", thirdId, firstId, secondId);
    }

    @MethodSource(value={"entityTypeProvider"})
    @ParameterizedTest
    void queryingDroppedIndexInDroppingTransactionMustThrow(FulltextProceduresTestSupport.EntityUtil entityUtil) {
        this.createIndexAndWait(entityUtil);
        try (Transaction tx = this.db.beginTx();){
            entityUtil.dropIndex(tx);
            org.junit.jupiter.api.Assertions.assertThrows(QueryExecutionException.class, () -> entityUtil.queryIndex(tx, "blabla").next());
        }
    }

    @MethodSource(value={"entityTypeProvider"})
    @ParameterizedTest
    void eventuallyConsistentIndexMustNotIncludeEntitiesAddedInTransaction() {
        try (Transaction tx = this.db.beginTx();){
            tx.execute(String.format("CREATE FULLTEXT INDEX `%s` FOR %s ON EACH %s OPTIONS {indexConfig: %s}", "nodes", FulltextIndexProceduresUtil.asNodeLabelStr((String[])new String[]{LABEL.name()}), FulltextIndexProceduresUtil.asPropertiesStrList((String[])new String[]{"prop"}), "{`fulltext.eventually_consistent`: true}")).close();
            tx.execute(String.format("CREATE FULLTEXT INDEX `%s` FOR %s ON EACH %s OPTIONS {indexConfig: %s}", "rels", FulltextIndexProceduresUtil.asRelationshipTypeStr((String[])new String[]{REL.name()}), FulltextIndexProceduresUtil.asPropertiesStrList((String[])new String[]{"prop"}), "{`fulltext.eventually_consistent`: true}")).close();
            tx.commit();
        }
        this.awaitIndexesOnline();
        tx = this.db.beginTx();
        try {
            Node node = tx.createNode(new Label[]{LABEL});
            node.setProperty("prop", (Object)"value");
            node.createRelationshipTo(node, REL).setProperty("prop", (Object)"value");
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIdsInOrder((GraphDatabaseService)this.db, true, "nodes", "value", new String[0]);
        FulltextProceduresTest.assertQueryFindsIdsInOrder((GraphDatabaseService)this.db, false, "rels", "value", new String[0]);
        try (Transaction transaction = this.db.beginTx();){
            transaction.execute("CALL db.index.fulltext.awaitEventuallyConsistentIndexRefresh()").close();
            transaction.commit();
        }
        FulltextProceduresTest.assertQueryFindsIdsInOrder((GraphDatabaseService)this.db, true, "nodes", "value", new String[0]);
        FulltextProceduresTest.assertQueryFindsIdsInOrder((GraphDatabaseService)this.db, false, "rels", "value", new String[0]);
    }

    @CsvSource(value={"false, without DB restart", "true, with DB restart"})
    @ParameterizedTest(name="{1}")
    void fulltextIndexMustNotBeAvailableForRegularIndexSeeks(boolean dbRestart, String name) {
        try (Transaction tx = this.db.beginTx();){
            FulltextProceduresTest.createSimpleNodesIndex(tx);
            tx.commit();
        }
        if (dbRestart) {
            this.restartDatabase();
        }
        String valueToQueryFor = "value to query for";
        this.awaitIndexesOnline();
        try (Transaction tx = this.db.beginTx();){
            List<Value> values = FulltextProceduresTest.generateRandomSimpleValues();
            for (Value value : values) {
                tx.createNode(new Label[]{LABEL}).setProperty("prop", value.asObject());
            }
            tx.createNode(new Label[]{LABEL}).setProperty("prop", (Object)valueToQueryFor);
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("prop", valueToQueryFor);
            try (Result result = tx.execute("profile match (n:" + LABEL.name() + ") where n.prop = $prop return n", params);){
                FulltextProceduresTest.assertNoIndexSeeks(result);
            }
            result = tx.execute("cypher profile match (n:" + LABEL.name() + ") where n.prop = $prop return n", params);
            try {
                FulltextProceduresTest.assertNoIndexSeeks(result);
            }
            finally {
                if (result != null) {
                    result.close();
                }
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void nodeOutputMustBeOrderedByScoreDescending() {
        FulltextProcedures.NodeOutput a = new FulltextProcedures.NodeOutput(null, Float.NaN);
        FulltextProcedures.NodeOutput b = new FulltextProcedures.NodeOutput(null, Float.POSITIVE_INFINITY);
        FulltextProcedures.NodeOutput c = new FulltextProcedures.NodeOutput(null, Float.MAX_VALUE);
        FulltextProcedures.NodeOutput d = new FulltextProcedures.NodeOutput(null, 1.0f);
        FulltextProcedures.NodeOutput e = new FulltextProcedures.NodeOutput(null, Float.MIN_NORMAL);
        FulltextProcedures.NodeOutput f = new FulltextProcedures.NodeOutput(null, Float.MIN_VALUE);
        FulltextProcedures.NodeOutput g = new FulltextProcedures.NodeOutput(null, 0.0f);
        FulltextProcedures.NodeOutput h = new FulltextProcedures.NodeOutput(null, -1.0f);
        FulltextProcedures.NodeOutput i = new FulltextProcedures.NodeOutput(null, Float.NEGATIVE_INFINITY);
        Object[] expectedOrder = new FulltextProcedures.NodeOutput[]{a, b, c, d, e, f, g, h, i};
        Object[] array = Arrays.copyOf(expectedOrder, expectedOrder.length);
        for (int counter = 0; counter < 10; ++counter) {
            ArrayUtils.shuffle((Object[])array);
            Arrays.sort(array);
            org.junit.jupiter.api.Assertions.assertArrayEquals((Object[])expectedOrder, (Object[])array);
        }
    }

    @Test
    void relationshipOutputMustBeOrderedByScoreDescending() {
        FulltextProcedures.RelationshipOutput a = new FulltextProcedures.RelationshipOutput(null, Float.NaN);
        FulltextProcedures.RelationshipOutput b = new FulltextProcedures.RelationshipOutput(null, Float.POSITIVE_INFINITY);
        FulltextProcedures.RelationshipOutput c = new FulltextProcedures.RelationshipOutput(null, Float.MAX_VALUE);
        FulltextProcedures.RelationshipOutput d = new FulltextProcedures.RelationshipOutput(null, 1.0f);
        FulltextProcedures.RelationshipOutput e = new FulltextProcedures.RelationshipOutput(null, Float.MIN_NORMAL);
        FulltextProcedures.RelationshipOutput f = new FulltextProcedures.RelationshipOutput(null, Float.MIN_VALUE);
        FulltextProcedures.RelationshipOutput g = new FulltextProcedures.RelationshipOutput(null, 0.0f);
        FulltextProcedures.RelationshipOutput h = new FulltextProcedures.RelationshipOutput(null, -1.0f);
        FulltextProcedures.RelationshipOutput i = new FulltextProcedures.RelationshipOutput(null, Float.NEGATIVE_INFINITY);
        Object[] expectedOrder = new FulltextProcedures.RelationshipOutput[]{a, b, c, d, e, f, g, h, i};
        Object[] array = Arrays.copyOf(expectedOrder, expectedOrder.length);
        for (int counter = 0; counter < 10; ++counter) {
            ArrayUtils.shuffle((Object[])array);
            Arrays.sort(array);
            org.junit.jupiter.api.Assertions.assertArrayEquals((Object[])expectedOrder, (Object[])array);
        }
    }

    @Test
    void awaitIndexProcedureMustWorkOnIndexNames() {
        try (Transaction tx = this.db.beginTx();){
            for (int i = 0; i < 1000; ++i) {
                Node node = tx.createNode(new Label[]{LABEL});
                node.setProperty("prop", (Object)"value");
                Relationship rel = node.createRelationshipTo(node, REL);
                rel.setProperty("prop", (Object)"value");
            }
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            FulltextProceduresTest.createSimpleNodesIndex(tx);
            FulltextProceduresTest.createSimpleRelationshipIndex(tx);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            tx.execute(String.format("CALL db.awaitIndex(\"%s\")", "nodes")).close();
            tx.execute(String.format("CALL db.awaitIndex(\"%s\")", "rels")).close();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @MethodSource(value={"entityTypeProvider"})
    @ParameterizedTest
    void mustSupportWildcardEndsLikeStartsWith(FulltextProceduresTestSupport.EntityUtil entityUtil) {
        this.createIndexAndWait(entityUtil);
        MutableSet ids = Sets.mutable.empty();
        try (Transaction tx = this.db.beginTx();){
            ids.add(entityUtil.createEntityWithProperty(tx, "abcdef"));
            ids.add(entityUtil.createEntityWithProperty(tx, "abcxyz"));
            tx.commit();
        }
        entityUtil.assertQueryFindsIds(this.db, "abc*", (Set<String>)ids);
    }

    @MethodSource(value={"entityTypeProvider"})
    @ParameterizedTest
    void mustSupportWildcardBeginningsLikeEndsWith(FulltextProceduresTestSupport.EntityUtil entityUtil) {
        this.createIndexAndWait(entityUtil);
        MutableSet ids = Sets.mutable.empty();
        try (Transaction tx = this.db.beginTx();){
            ids.add(entityUtil.createEntityWithProperty(tx, "defabc"));
            ids.add(entityUtil.createEntityWithProperty(tx, "xyzabc"));
            tx.commit();
        }
        entityUtil.assertQueryFindsIds(this.db, "*abc", (Set<String>)ids);
    }

    @MethodSource(value={"entityTypeProvider"})
    @ParameterizedTest
    void mustSupportWildcardBeginningsAndEndsLikeContains(FulltextProceduresTestSupport.EntityUtil entityUtil) {
        this.createIndexAndWait(entityUtil);
        MutableSet ids = Sets.mutable.empty();
        try (Transaction tx = this.db.beginTx();){
            ids.add(entityUtil.createEntityWithProperty(tx, "defabcdef"));
            ids.add(entityUtil.createEntityWithProperty(tx, "xyzabcxyz"));
            tx.commit();
        }
        entityUtil.assertQueryFindsIds(this.db, "*abc*", (Set<String>)ids);
    }

    @Test
    void mustMatchCaseInsensitiveWithStandardAnalyzer() {
        this.mustMatchCaseInsensitive("{`fulltext.analyzer`: 'standard'}", false);
    }

    @Test
    void mustMatchCaseInsensitiveWithSimpleAnalyzer() {
        this.mustMatchCaseInsensitive("{`fulltext.analyzer`: 'simple'}", true);
    }

    @Test
    void mustMatchCaseInsensitiveWithDefaultAnalyzer() {
        this.mustMatchCaseInsensitive("{}", true);
    }

    private void mustMatchCaseInsensitive(String analyzerString, boolean expectA) {
        try (Transaction tx = this.db.beginTx();){
            tx.execute("foreach (x in range (1,1000) | create (n:Label {id:'A'}))").close();
            tx.execute("foreach (x in range (1,1000) | create (n:Label {id:'B'}))").close();
            tx.execute("foreach (x in range (1,1000) | create (n:Label {id:'C'}))").close();
            tx.execute("foreach (x in range (1,1000) | create (n:Label {id:'b'}))").close();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.execute(String.format("CREATE FULLTEXT INDEX `%s` FOR %s ON EACH %s OPTIONS {indexConfig: %s}", "myindex", FulltextIndexProceduresUtil.asNodeLabelStr((String[])new String[]{LABEL.name()}), FulltextIndexProceduresUtil.asPropertiesStrList((String[])new String[]{"id"}), analyzerString)).close();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.awaitIndexesOnline();
        tx = this.db.beginTx();
        try {
            try (Result result = tx.execute(String.format("CALL db.index.fulltext.queryNodes(\"%s\", \"%s\")", "myindex", "A"));){
                if (expectA) {
                    Assertions.assertThat((long)result.stream().count()).isEqualTo(1000L);
                } else {
                    Assertions.assertThat((long)result.stream().count()).isEqualTo(0L);
                }
            }
            result = tx.execute(String.format("CALL db.index.fulltext.queryNodes(\"%s\", \"%s\")", "myindex", "B"));
            try {
                Assertions.assertThat((long)result.stream().count()).isEqualTo(2000L);
            }
            finally {
                if (result != null) {
                    result.close();
                }
            }
            result = tx.execute(String.format("CALL db.index.fulltext.queryNodes(\"%s\", \"%s\")", "myindex", "C"));
            try {
                Assertions.assertThat((long)result.stream().count()).isEqualTo(1000L);
            }
            finally {
                if (result != null) {
                    result.close();
                }
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void makeSureFulltextIndexDoesNotBlockSchemaIndexOnSameSchemaPattern() {
        long indexesBefore = this.indexesCount();
        try (Transaction tx = this.db.beginTx();){
            tx.execute(String.format("CREATE FULLTEXT INDEX `%s` FOR %s ON EACH %s", "myindex", FulltextIndexProceduresUtil.asNodeLabelStr((String[])new String[]{LABEL.name()}), FulltextIndexProceduresUtil.asPropertiesStrList((String[])new String[]{"prop"})));
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.execute(String.format("CALL db.awaitIndex(\"%s\")", "myindex"));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            tx.schema().indexFor(LABEL).on("prop").create();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(1L, TimeUnit.HOURS);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        Assertions.assertThat((long)this.indexesCount()).isEqualTo(indexesBefore + 2L);
    }

    @Test
    void makeSureSchemaIndexDoesNotBlockFulltextIndexOnSameSchemaPattern() {
        long indexesBefore = this.indexesCount();
        try (Transaction tx = this.db.beginTx();){
            tx.schema().indexFor(LABEL).on("prop").create();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(1L, TimeUnit.HOURS);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            tx.execute(String.format("CREATE FULLTEXT INDEX `%s` FOR %s ON EACH %s", "myindex", FulltextIndexProceduresUtil.asNodeLabelStr((String[])new String[]{LABEL.name()}), FulltextIndexProceduresUtil.asPropertiesStrList((String[])new String[]{"prop"})));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            tx.execute(String.format("CALL db.awaitIndex(\"%s\")", "myindex"));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        Assertions.assertThat((long)this.indexesCount()).isEqualTo(indexesBefore + 2L);
    }

    @Test
    void attemptingToIndexOnPropertyUsedForInternalReferenceMustThrow() {
        Exception e = (Exception)org.junit.jupiter.api.Assertions.assertThrows(Exception.class, () -> {
            try (Transaction tx = this.db.beginTx();){
                tx.execute(String.format("CREATE FULLTEXT INDEX `%s` FOR %s ON EACH %s", "myindex", FulltextIndexProceduresUtil.asNodeLabelStr((String[])new String[]{LABEL.name()}), FulltextIndexProceduresUtil.asPropertiesStrList((String[])new String[]{"__neo4j__lucene__fulltext__index__internal__id__"}))).close();
                tx.commit();
            }
        });
        Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"__neo4j__lucene__fulltext__index__internal__id__"});
    }

    @CsvSource(value={"false, without DB restart", "true, with DB restart"})
    @ParameterizedTest(name="{1}")
    void relationshipIndexAndDetachDelete(boolean restartDb, String name) {
        String relId;
        String nodeId;
        try (Transaction tx = this.db.beginTx();){
            FulltextProceduresTest.createSimpleRelationshipIndex(tx);
            tx.commit();
        }
        this.awaitIndexesOnline();
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode();
            nodeId = node.getElementId();
            Relationship rel = node.createRelationshipTo(node, REL);
            relId = rel.getElementId();
            rel.setProperty("prop", (Object)"blabla");
            tx.commit();
        }
        if (restartDb) {
            this.restartDatabase();
        }
        tx = this.db.beginTx();
        try {
            FulltextProceduresTest.assertQueryFindsIdsInOrder(tx, false, "rels", "blabla", relId);
            tx.execute("match (n) where elementId(n) = '" + nodeId + "' detach delete n").close();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIdsInOrder((GraphDatabaseService)this.db, false, "rels", "blabla", new String[0]);
        this.checkDatabaseConsistency();
    }

    private void checkDatabaseConsistency() {
        DatabaseLayout layout = this.db.databaseLayout();
        this.controller.restartDbms(b -> {
            try {
                ConsistencyCheckService.Result result = new ConsistencyCheckService(layout).runFullConsistencyCheck();
                if (!result.isSuccessful()) {
                    Files.lines(result.reportFile()).forEach(System.out::println);
                }
                org.junit.jupiter.api.Assertions.assertTrue((boolean)result.isSuccessful());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return b;
        });
    }

    @CsvSource(value={"false, without DB restart", "true, with DB restart"})
    @ParameterizedTest(name="{1}")
    public void relationshipIndexAndPropertyRemove(boolean restartDb, String name) {
        String relId;
        try (Transaction tx = this.db.beginTx();){
            FulltextProceduresTest.createSimpleRelationshipIndex(tx);
            tx.commit();
        }
        this.awaitIndexesOnline();
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode();
            Relationship rel = node.createRelationshipTo(node, REL);
            relId = rel.getElementId();
            rel.setProperty("prop", (Object)"blabla");
            tx.commit();
        }
        if (restartDb) {
            this.restartDatabase();
        }
        tx = this.db.beginTx();
        try {
            FulltextProceduresTest.assertQueryFindsIdsInOrder(tx, false, "rels", "blabla", relId);
            Relationship rel = tx.getRelationshipByElementId(relId);
            rel.removeProperty("prop");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIdsInOrder((GraphDatabaseService)this.db, false, "rels", "blabla", new String[0]);
        this.checkDatabaseConsistency();
    }

    @Test
    public void relationshipIndexAndPropertyRemove() {
        String relId;
        try (Transaction tx = this.db.beginTx();){
            tx.execute(String.format("CREATE FULLTEXT INDEX `%s` FOR %s ON EACH %s", "rels", FulltextIndexProceduresUtil.asRelationshipTypeStr((String[])new String[]{REL.name()}), FulltextIndexProceduresUtil.asPropertiesStrList((String[])new String[]{"prop"}))).close();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode();
            Relationship rel = node.createRelationshipTo(node, REL);
            relId = rel.getElementId();
            rel.setProperty("prop", (Object)"blabla");
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            FulltextProceduresTest.assertQueryFindsIdsInOrder((GraphDatabaseService)this.db, false, "rels", "blabla", relId);
            Relationship rel = tx.getRelationshipByElementId(relId);
            rel.removeProperty("prop");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        FulltextProceduresTest.assertQueryFindsIdsInOrder((GraphDatabaseService)this.db, false, "rels", "blabla", new String[0]);
        this.checkDatabaseConsistency();
    }

    @Test
    public void relationshipIndexAndPropertyRemoveWithRestart() {
        String relId;
        try (Transaction tx = this.db.beginTx();){
            tx.execute(String.format("CREATE FULLTEXT INDEX `%s` FOR %s ON EACH %s", "rels", FulltextIndexProceduresUtil.asRelationshipTypeStr((String[])new String[]{REL.name()}), FulltextIndexProceduresUtil.asPropertiesStrList((String[])new String[]{"prop"}))).close();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode();
            Relationship rel = node.createRelationshipTo(node, REL);
            relId = rel.getElementId();
            rel.setProperty("prop", (Object)"blabla");
            tx.commit();
        }
        this.restartDatabase();
        tx = this.db.beginTx();
        try {
            FulltextProceduresTest.assertQueryFindsIdsInOrder((GraphDatabaseService)this.db, false, "rels", "blabla", relId);
            Relationship rel = tx.getRelationshipByElementId(relId);
            rel.removeProperty("prop");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            FulltextProceduresTest.assertQueryFindsIdsInOrder((GraphDatabaseService)this.db, false, "rels", "blabla", new String[0]);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.checkDatabaseConsistency();
    }

    @Test
    void standardFoldingAnalyzerMustWorkGitHub12662() {
        String nodeId;
        String indexName = "my_index";
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode(new Label[]{LABEL});
            node.setProperty("prop", (Object)"1SOMECODE1");
            nodeId = node.getElementId();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            String label = FulltextIndexProceduresUtil.asNodeLabelStr((String[])new String[]{LABEL.name()});
            String props = FulltextIndexProceduresUtil.asPropertiesStrList((String[])new String[]{"prop"});
            String analyzer = "{`fulltext.analyzer`: 'standard-folding'}";
            tx.execute(String.format("CREATE FULLTEXT INDEX `%s` FOR %s ON EACH %s OPTIONS {indexConfig: %s}", indexName, label, props, analyzer)).close();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(1L, TimeUnit.HOURS);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            try (ResourceIterator iterator = tx.execute(String.format("CALL db.index.fulltext.queryNodes(\"%s\", \"%s\")", indexName, "*SOMECODE*")).columnAs("node");){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)iterator.hasNext());
                Assertions.assertThat((String)((Node)iterator.next()).getElementId()).isEqualTo(nodeId);
                org.junit.jupiter.api.Assertions.assertFalse((boolean)iterator.hasNext());
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=SearchString.class)
    void standardFoldingAnalyzerMustFindNonASCIILettersByTheirFolding(SearchString searchString) {
        String indexName = this.createNodeFulltextIndexWithStandardFoldingAnalyzer();
        char[] nonAsciiLetterArray = "\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u0100\u0102\u0104\u018f\u01cd\u01de\u01e0\u01fa\u0200\u0202\u0226\u023a\u1d00\u1e00\u1ea0\u1ea2\u1ea4\u1ea6\u1ea8\u1eaa\u1eac\u1eae\u1eb0\u1eb2\u1eb4\u1eb6\u24b6\uff21\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u0101\u0103\u0105\u01ce\u01df\u01e1\u01fb\u0201\u0203\u0227\u0250\u0259\u025a\u1d8f\u1d95\u1ea1\u1ea3\u1ea1\u1ea3\u1ea5\u1ea7\u1ea9\u1eab\u1ead\u1eaf\u1eb1\u1eb3\u1eb5\u1eb7\u2090\u2094\u24d0\u2c65\u2c6f\uff41\ua732\u00c6\u01e2\u01fc\u1d01\ua734\ua736\ua738\ua73a\ua73c\u249c\ua733\u00e6\u01e3\u01fd\u1d02\ua735\ua737\ua739\ua73b\ua73d\u0181\u0182\u0243\u0299\u1d03\u1e02\u1e04\u1e06\u24b7\uff22\u0180\u0183\u0253\u1d6c\u1d80\u1e03\u1e05\u1e07\u24d1\uff42\u249d\u00c7\u0106\u0108\u010a\u010c\u0187\u023b\u0297\u1d04\u1e08\u24b8\uff23\u00e7\u0107\u0109\u010b\u010d\u0188\u023c\u0255\u1e09\u2184\u24d2\ua73e\ua73f\uff43\u249e\u00d0\u010e\u0110\u0189\u018a\u018b\u1d05\u1d06\u1e0a\u1e0c\u1e0e\u1e10\u1e12\u24b9\ua779\uff24\u00f0\u010f\u0111\u018c\u0221\u0256\u0257\u1d6d\u1d81\u1d91\u1e0b\u1e0d\u1e0f\u1e11\u1e13\u24d3\ua77a\uff44\u01c4\u01f1\u01c5\u01f2\u249f\u0238\u01c6\u01f3\u02a3\u02a5\u00c8\u00c9\u00ca\u00cb\u0112\u0114\u0116\u0118\u011a\u018e\u0190\u0204\u0206\u0228\u0246\u1d07\u1e14\u1e16\u1e18\u1e1a\u1e1c\u1eb8\u1eba\u1ebc\u1ebe\u1ec0\u1ec2\u1ec4\u1ec6\u24ba\u2c7b\uff25\u00e8\u00e9\u00ea\u00eb\u0113\u0115\u0117\u0119\u011b\u01dd\u0205\u0207\u0229\u0247\u0258\u025b\u025c\u025d\u025e\u029a\u1d08\u1d92\u1d93\u1d94\u1e15\u1e17\u1e19\u1e1b\u1e1d\u1eb9\u1ebb\u1ebd\u1ebf\u1ec1\u1ec3\u1ec5\u1ec7\u2091\u24d4\u2c78\uff45\u24a0\u0191\u1e1e\u24bb\ua730\ua77b\ua7fb\uff26\u0192\u1d6e\u1d82\u1e1f\u1e9b\u24d5\ua77c\uff46\u24a1\ufb00\ufb03\ufb04\ufb01\ufb02\u011c\u011e\u0120\u0122\u0193\u01e4\u01e5\u01e6\u01e7\u01f4\u0262\u029b\u1e20\u24bc\ua77d\ua77e\uff27\u011d\u011f\u0121\u0123\u01f5\u0260\u0261\u1d77\u1d79\u1d83\u1e21\u24d6\ua77f\uff47\u24a2\u0124\u0126\u021e\u029c\u1e22\u1e24\u1e26\u1e28\u1e2a\u24bd\u2c67\u2c75\uff28\u0125\u0127\u021f\u0265\u0266\u02ae\u02af\u1e23\u1e25\u1e27\u1e29\u1e2b\u1e96\u24d7\u2c68\u2c76\uff48\u01f6\u24a3\u0195\u00cc\u00cd\u00ce\u00cf\u0128\u012a\u012c\u012e\u0130\u0196\u0197\u01cf\u0208\u020a\u026a\u1d7b\u1e2c\u1e2e\u1ec8\u1eca\u24be\ua7fe\uff29\u00ec\u00ed\u00ee\u00ef\u0129\u012b\u012d\u012f\u0131\u01d0\u0209\u020b\u0268\u1d09\u1d62\u1d7c\u1d96\u1e2d\u1e2f\u1ec9\u1ecb\u2071\u24d8\uff49\u0132\u24a4\u0133\u0134\u0248\u1d0a\u24bf\uff2a\u0135\u01f0\u0237\u0249\u025f\u0284\u029d\u24d9\u2c7c\uff4a\u24a5\u0136\u0198\u01e8\u1d0b\u1e30\u1e32\u1e34\u24c0\u2c69\ua740\ua742\ua744\uff2b\u0137\u0199\u01e9\u029e\u1d84\u1e31\u1e33\u1e35\u24da\u2c6a\ua741\ua743\ua745\uff4b\u24a6\u0139\u013b\u013d\u013f\u0141\u023d\u029f\u1d0c\u1e36\u1e38\u1e3a\u1e3c\u24c1\u2c60\u2c62\ua746\ua748\ua780\uff2c\u013a\u013c\u013e\u0140\u0142\u019a\u0234\u026b\u026c\u026d\u1d85\u1e37\u1e39\u1e3b\u1e3d\u24db\u2c61\ua747\ua749\ua781\uff4c\u01c7\u1efa\u01c8\u24a7\u01c9\u1efb\u02aa\u02ab\u019c\u1d0d\u1e3e\u1e40\u1e42\u24c2\u2c6e\ua7fd\ua7ff\uff2d\u026f\u0270\u0271\u1d6f\u1d86\u1e3f\u1e41\u1e43\u24dc\uff4d\u24a8\u00d1\u0143\u0145\u0147\u014a\u019d\u01f8\u0220\u0274\u1d0e\u1e44\u1e46\u1e48\u1e4a\u24c3\uff2e\u00f1\u0144\u0146\u0148\u0149\u014b\u019e\u01f9\u0235\u0272\u0273\u1d70\u1d87\u1e45\u1e47\u1e49\u1e4b\u207f\u24dd\uff4e\u01ca\u01cb\u24a9\u01cc\u00d2\u00d3\u00d4\u00d5\u00d6\u00d8\u014c\u014e\u0150\u0186\u019f\u01a0\u01d1\u01ea\u01ec\u01fe\u020c\u020e\u022a\u022c\u022e\u0230\u1d0f\u1d10\u1e4c\u1e4e\u1e50\u1e52\u1ecc\u1ece\u1ed0\u1ed2\u1ed4\u1ed6\u1ed8\u1eda\u1edc\u1ede\u1ee0\u1ee2\u24c4\ua74a\ua74c\uff2f\u00f2\u00f3\u00f4\u00f5\u00f6\u00f8\u014d\u014f\u0151\u01a1\u01d2\u01eb\u01ed\u01ff\u020d\u020f\u022b\u022d\u022f\u0231\u0254\u0275\u1d16\u1d17\u1d97\u1e4d\u1e4f\u1e51\u1e53\u1ecd\u1ecf\u1ed1\u1ed3\u1ed5\u1ed7\u1ed9\u1edb\u1edd\u1edf\u1ee1\u1ee3\u2092\u24de\u2c7a\ua74b\ua74d\uff4f\u0152\u0276\ua74e\u0222\u1d15\u24aa\u0153\u1d14\ua74f\u0223\u01a4\u1d18\u1e54\u1e56\u24c5\u2c63\ua750\ua752\ua754\uff30\u01a5\u1d71\u1d7d\u1d88\u1e55\u1e57\u24df\ua751\ua753\ua755\ua7fc\uff50\u24ab\u024a\u24c6\ua756\ua758\uff31\u0138\u024b\u02a0\u24e0\ua757\ua759\uff51\u24ac\u0239\u0154\u0156\u0158\u0212\u0212\u024c\u0280\u0281\u1d19\u1d1a\u1e58\u1e5a\u1e5c\u1e5e\u24c7\u2c64\ua75a\ua782\uff32\u0155\u0157\u0159\u0211\u0213\u024d\u027c\u027d\u027e\u027f\u1d63\u1d72\u1d73\u1d89\u1e59\u1e5b\u1e5d\u1e5f\u24e1\ua75b\ua783\uff52\u24ad\u015a\u015c\u015e\u0160\u0218\u1e60\u1e62\u1e64\u1e66\u1e68\u24c8\ua731\ua785\uff33\u015b\u015d\u015f\u0161\u017f\u0219\u023f\u0282\u1d74\u1d8a\u1e61\u1e63\u1e65\u1e67\u1e69\u1e9c\u1e9d\u24e2\ua784\uff53\u1e9e\u24ae\u00df\ufb06\u0162\u0164\u0166\u01ac\u01ae\u021a\u023e\u1d1b\u1e6a\u1e6c\u1e6e\u1e70\u24c9\ua786\uff34\u0163\u0165\u0167\u01ab\u01ad\u021b\u0236\u0287\u0288\u1d75\u1e6b\u1e6d\u1e6f\u1e71\u1e97\u24e3\u2c66\uff54\u00de\ua766\ua728\u24af\u02a8\u00fe\u1d7a\ua767\u02a6\ua729\u00d9\u00da\u00db\u00dc\u0168\u016a\u016c\u016e\u0170\u0172\u01af\u01d3\u01d5\u01d7\u01d9\u01db\u0214\u0216\u0244\u1d1c\u1d7e\u1e72\u1e74\u1e76\u1e78\u1e7a\u1ee4\u1ee6\u1ee8\u1eea\u1eec\u1eee\u1ef0\u24ca\uff35\u00f9\u00fa\u00fb\u00fc\u0169\u016b\u016d\u016f\u0171\u0173\u01b0\u01d4\u01d6\u01d8\u01da\u01dc\u0215\u0217\u0289\u1d64\u1d99\u1e73\u1e75\u1e77\u1e79\u1e7b\u1ee5\u1ee7\u1ee9\u1eeb\u1eed\u1eef\u1ef1\u24e4\uff55\u24b0\u1d6b\u01b2\u0245\u1d20\u1e7c\u1e7e\u1efc\u24cb\ua75e\ua768\uff36\u028b\u028c\u1d65\u1d8c\u1e7d\u1e7f\u24e5\u2c71\u2c74\ua75f\uff56\ua760\u24b1\ua761\u0174\u01f7\u1d21\u1e80\u1e82\u1e84\u1e86\u1e88\u24cc\u2c72\uff37\u0175\u01bf\u028d\u1e81\u1e83\u1e85\u1e87\u1e89\u1e98\u24e6\u2c73\uff57\u24b2\u1e8a\u1e8c\u24cd\uff38\u1d8d\u1e8b\u1e8d\u2093\u24e7\uff58\u24b3\u00dd\u0176\u0178\u01b3\u0232\u024e\u028f\u1e8e\u1ef2\u1ef4\u1ef6\u1ef8\u1efe\u24ce\uff39\u00fd\u00ff\u0177\u01b4\u0233\u024f\u028e\u1e8f\u1e99\u1ef3\u1ef5\u1ef7\u1ef9\u1eff\u24e8\uff59\u24b4\u0179\u017b\u017d\u01b5\u021c\u0224\u1d22\u1e90\u1e92\u1e94\u24cf\u2c6b\ua762\uff3a\u017a\u017c\u017e\u01b6\u021d\u0225\u0240\u0290\u0291\u1d76\u1d8e\u1e91\u1e93\u1e95\u24e9\u2c6c\ua763\uff5a\u24b5".toCharArray();
        Map<Character, String> nonAsciiCharsToFolding = FulltextProceduresTest.getFoldingOfChars(nonAsciiLetterArray);
        HashMap<Character, String> nonAsciiCharsToNodeId = new HashMap<Character, String>();
        String propPrefix = "123";
        String propSuffix = "345";
        try (Transaction tx = this.db.beginTx();){
            for (Map.Entry<Character, String> charToFolding : nonAsciiCharsToFolding.entrySet()) {
                Node node = tx.createNode(new Label[]{LABEL});
                Character character = charToFolding.getKey();
                String propValue = propPrefix + character + propSuffix;
                node.setProperty("prop", (Object)propValue);
                String id = node.getElementId();
                nonAsciiCharsToNodeId.put(character, id);
            }
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            for (Object nonAsciiChar : (Object)nonAsciiLetterArray) {
                String expectedNodeId = (String)nonAsciiCharsToNodeId.get(Character.valueOf((char)nonAsciiChar));
                FulltextProceduresTest.assertAtLeastSingleHitOnSearch(indexName, expectedNodeId, tx, searchString.searchString(Character.valueOf((char)nonAsciiChar), propPrefix, propSuffix));
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private static Map<Character, String> getFoldingOfChars(char[] nonAsciiCharacterArray) {
        HashMap<Character, String> nonAsciiCharToAsciiFolding = new HashMap<Character, String>();
        for (char nonASCIIChar : nonAsciiCharacterArray) {
            String folding = FulltextProceduresTest.toASCIIFolding(nonASCIIChar);
            nonAsciiCharToAsciiFolding.put(Character.valueOf(nonASCIIChar), folding);
        }
        return nonAsciiCharToAsciiFolding;
    }

    private String createNodeFulltextIndexWithStandardFoldingAnalyzer() {
        String indexName = "my_index";
        try (Transaction tx = this.db.beginTx();){
            String label = FulltextIndexProceduresUtil.asNodeLabelStr((String[])new String[]{LABEL.name()});
            String props = FulltextIndexProceduresUtil.asPropertiesStrList((String[])new String[]{"prop"});
            String analyzer = "{`fulltext.analyzer`: 'standard-folding'}";
            tx.execute(String.format("CREATE FULLTEXT INDEX `%s` FOR %s ON EACH %s OPTIONS {indexConfig: %s}", indexName, label, props, analyzer)).close();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(1L, TimeUnit.HOURS);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        return indexName;
    }

    private static String toASCIIFolding(char nonASCIIChar) {
        char[] result = new char[4];
        int length = ASCIIFoldingFilter.foldToASCII((char[])new char[]{nonASCIIChar}, (int)0, (char[])result, (int)0, (int)1);
        result = Arrays.copyOf(result, length);
        return new String(result);
    }

    private static void assertAtLeastSingleHitOnSearch(String indexName, String expectedNodeId, Transaction tx, String searchString) {
        TreeSet<String> nodeIds = new TreeSet<String>();
        try (ResourceIterator iterator = tx.execute(String.format("CALL db.index.fulltext.queryNodes(\"%s\", \"%s\")", indexName, searchString)).columnAs("node");){
            while (iterator.hasNext()) {
                nodeIds.add(((Node)iterator.next()).getElementId());
            }
        }
        ((AbstractCollectionAssert)Assertions.assertThat(nodeIds).as("expected search '" + searchString + "' to find " + expectedNodeId, new Object[0])).contains((Object[])new String[]{expectedNodeId});
    }

    private long indexesCount() {
        long indexesBefore;
        try (Transaction tx = this.db.beginTx();){
            indexesBefore = Iterables.count((Iterable)tx.schema().getIndexes());
        }
        return indexesBefore;
    }

    private /* synthetic */ void lambda$concurrentPopulationAndUpdatesToAnEventuallyConsistentIndexMustEventuallyResultInCorrectIndexState$7(Set nodeIds, String newValue, Set relIds, CountDownLatch readyLatch, BinaryLatch startLatch) {
        try (Transaction tx = this.db.beginTx();){
            nodeIds.forEach(nodeId -> tx.getNodeByElementId(nodeId).setProperty("prop", (Object)newValue));
            relIds.forEach(relId -> tx.getRelationshipByElementId(relId).setProperty("prop", (Object)newValue));
            readyLatch.countDown();
            startLatch.await();
            tx.commit();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum SearchString {
        FOLDING_EXACT{

            @Override
            String searchString(Character nonAsciiCharacter, String propPrefix, String propSuffix) {
                return propPrefix + FulltextProceduresTest.toASCIIFolding(nonAsciiCharacter.charValue()) + propSuffix;
            }
        }
        ,
        FOLDING_WILDCARD{

            @Override
            String searchString(Character nonAsciiCharacter, String propPrefix, String propSuffix) {
                return "*" + FulltextProceduresTest.toASCIIFolding(nonAsciiCharacter.charValue()) + "*";
            }
        };


        abstract String searchString(Character var1, String var2, String var3);
    }
}

