/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.eclipse.collections.api.set.ImmutableSet;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.IndexingTestUtil;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.index.SetInitialStateInNativeIndex;
import org.neo4j.internal.kernel.api.IndexMonitor;
import org.neo4j.internal.schema.AllIndexProviderDescriptors;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.impl.coreapi.TransactionImpl;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.monitoring.Monitors;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.test.Barrier;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.TestLabels;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;

@Neo4jLayoutExtension
public class IndexCleanupIT {
    private static final String propertyKey = "key";
    @Inject
    private FileSystemAbstraction fs;
    @Inject
    private DatabaseLayout databaseLayout;
    private DatabaseManagementService managementService;
    private GraphDatabaseAPI db;

    @AfterEach
    void tearDown() {
        if (this.managementService != null) {
            this.managementService.shutdown();
        }
    }

    private static Stream<Arguments> indexProviders() {
        return Stream.of(Arguments.of((Object[])new Object[]{AllIndexProviderDescriptors.RANGE_DESCRIPTOR, IndexType.RANGE}), Arguments.of((Object[])new Object[]{AllIndexProviderDescriptors.POINT_DESCRIPTOR, IndexType.POINT}));
    }

    @ParameterizedTest
    @MethodSource(value={"indexProviders"})
    void mustClearIndexDirectoryOnDropWhileOnline(IndexProviderDescriptor provider, IndexType indexType) throws IOException, KernelException {
        Path[] providerDirectories;
        this.configureDb();
        IndexCleanupIT.createIndex((GraphDatabaseService)this.db, indexType, provider, true);
        for (Path providerDirectory : providerDirectories = IndexCleanupIT.providerDirectories(this.fs, this.db)) {
            Assertions.assertTrue((this.fs.listFiles(providerDirectory).length > 0 ? 1 : 0) != 0, (String)"expected there to be at least one index per existing provider map");
        }
        this.dropAllIndexes();
        this.assertNoIndexFilesExisting(providerDirectories);
    }

    @ParameterizedTest
    @MethodSource(value={"indexProviders"})
    void mustClearIndexDirectoryOnDropWhileFailed(IndexProviderDescriptor provider, IndexType indexType) throws IOException, KernelException {
        this.configureDb();
        IndexCleanupIT.createIndex((GraphDatabaseService)this.db, indexType, provider, true);
        SetInitialStateInNativeIndex setInitialStateInNativeIndex = new SetInitialStateInNativeIndex(0, provider);
        this.restartDatabase(setInitialStateInNativeIndex);
        try (Transaction tx = this.db.beginTx();){
            for (IndexDefinition index : tx.schema().getIndexes()) {
                if (index.getIndexType() == org.neo4j.graphdb.schema.IndexType.LOOKUP) continue;
                Schema.IndexState indexState = tx.schema().getIndexState(index);
                Assertions.assertEquals((Object)Schema.IndexState.FAILED, (Object)indexState, (String)("expected index state to be " + String.valueOf(Schema.IndexState.FAILED)));
            }
            tx.commit();
        }
        this.dropAllIndexes();
        this.assertNoIndexFilesExisting(IndexCleanupIT.providerDirectories(this.fs, this.db));
    }

    @ParameterizedTest
    @MethodSource(value={"indexProviders"})
    void mustClearIndexDirectoryOnDropWhilePopulating(IndexProviderDescriptor provider, IndexType indexType) throws InterruptedException, IOException, KernelException {
        Path[] providerDirectories;
        final Barrier.Control midPopulation = new Barrier.Control();
        IndexMonitor.MonitorAdapter trappingMonitor = new IndexMonitor.MonitorAdapter(){

            public void indexPopulationScanStarting(IndexDescriptor[] indexDescriptors) {
                midPopulation.reached();
            }
        };
        this.configureDb();
        this.createSomeData();
        Monitors monitors = (Monitors)this.db.getDependencyResolver().resolveDependency(Monitors.class);
        monitors.addMonitorListener((Object)trappingMonitor, new String[0]);
        IndexCleanupIT.createIndex((GraphDatabaseService)this.db, indexType, provider, false);
        midPopulation.await();
        for (Path providerDirectory : providerDirectories = IndexCleanupIT.providerDirectories(this.fs, this.db)) {
            Assertions.assertTrue((this.fs.listFiles(providerDirectory).length > 0 ? 1 : 0) != 0, (String)"expected there to be at least one index per existing provider map");
        }
        this.dropAllIndexes();
        midPopulation.release();
        this.assertNoIndexFilesExisting(providerDirectories);
    }

    private void assertNoIndexFilesExisting(Path[] providerDirectories) throws IOException {
        for (Path providerDirectory : providerDirectories) {
            Assertions.assertEquals((int)0, (int)this.fs.listFiles(providerDirectory).length, (String)"expected there to be no index files");
        }
    }

    private void dropAllIndexes() {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().getIndexes().forEach(IndexDefinition::drop);
            tx.commit();
        }
    }

    private void restartDatabase(SetInitialStateInNativeIndex action) throws IOException {
        ImmutableSet openOptions = ((StorageEngine)this.db.getDependencyResolver().resolveDependency(StorageEngine.class)).getOpenOptions();
        this.managementService.shutdown();
        action.run(this.fs, this.databaseLayout, openOptions);
        this.configureDb();
    }

    private void configureDb() {
        this.managementService = new TestDatabaseManagementServiceBuilder(this.databaseLayout).build();
        this.db = (GraphDatabaseAPI)this.managementService.database("neo4j");
    }

    private static void createIndex(GraphDatabaseService db, IndexType indexType, IndexProviderDescriptor providerDescriptor, boolean awaitOnline) throws KernelException {
        try (TransactionImpl tx = (TransactionImpl)db.beginTx();){
            IndexingTestUtil.createNodePropIndexWithSpecifiedProvider((TransactionImpl)tx, (IndexProviderDescriptor)providerDescriptor, (Label)TestLabels.LABEL_ONE, (String)propertyKey, (IndexType)indexType);
            tx.commit();
        }
        if (awaitOnline) {
            tx = db.beginTx();
            try {
                tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
                tx.commit();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
    }

    private static Path[] providerDirectories(FileSystemAbstraction fs, GraphDatabaseAPI db) throws IOException {
        DatabaseLayout databaseLayout = db.databaseLayout();
        Path dbDir = databaseLayout.databaseDirectory();
        Path schemaDir = dbDir.resolve("schema");
        Path indexDir = schemaDir.resolve("index");
        return fs.listFiles(indexDir);
    }

    private void createSomeData() {
        try (Transaction tx = this.db.beginTx();){
            tx.createNode().setProperty(propertyKey, (Object)"abc");
            tx.commit();
        }
    }
}

