/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.recovery;

import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.mutable.MutableLong;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.IndexMonitor;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.fs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.UncloseableDelegatingFileSystemAbstraction;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.monitoring.Monitors;
import org.neo4j.test.DoubleLatch;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@EphemeralTestDirectoryExtension
class IndexCreationRecoveryIT {
    @Inject
    private TestDirectory directory;
    @Inject
    private EphemeralFileSystemAbstraction fs;

    IndexCreationRecoveryIT() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldEnsurePopulateIndexRecreation() throws Exception {
        Label label = Label.label((String)"L");
        String key = "k";
        final String indexName = "mine";
        String nodeValue = "I'm here";
        MutableLong nodeId = new MutableLong();
        try (EphemeralFileSystemAbstraction fsSnapshot = this.createIndexedDataThenSnapshotFSAndShutDown(label, indexName, key, nodeValue, nodeId);){
            Monitors monitors = new Monitors();
            final CountDownLatch barrier = new CountDownLatch(1);
            monitors.addMonitorListener((Object)new IndexMonitor.MonitorAdapter(){

                public void indexPopulationJobStarting(IndexDescriptor[] indexDescriptors) {
                    if (this.containsOurIndex(indexDescriptors)) {
                        DoubleLatch.awaitLatch((CountDownLatch)barrier);
                    }
                }

                public void populationCancelled(IndexDescriptor[] indexDescriptors, boolean storeScanHadStated) {
                    if (this.containsOurIndex(indexDescriptors)) {
                        barrier.countDown();
                    }
                }

                private boolean containsOurIndex(IndexDescriptor[] indexDescriptors) {
                    return Arrays.stream(indexDescriptors).anyMatch(index -> index.getName().equals(indexName));
                }
            }, new String[0]);
            DatabaseManagementService dbms = new TestDatabaseManagementServiceBuilder(this.directory.homePath()).setFileSystem((FileSystemAbstraction)new UncloseableDelegatingFileSystemAbstraction((FileSystemAbstraction)fsSnapshot)).setMonitors(monitors).build();
            try {
                GraphDatabaseAPI db = (GraphDatabaseAPI)dbms.database("neo4j");
                IndexCreationRecoveryIT.awaitIndexPopulations((GraphDatabaseService)db);
                try (InternalTransaction tx = db.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED);){
                    KernelTransaction ktx = tx.kernelTransaction();
                    IndexDescriptor index = ktx.schemaRead().indexGetForName(indexName);
                    IndexReadSession session = ktx.dataRead().indexReadSession(index);
                    try (NodeValueIndexCursor cursor = ktx.cursors().allocateNodeValueIndexCursor(ktx.cursorContext(), ktx.memoryTracker());){
                        int keyId = ktx.tokenRead().propertyKey(key);
                        ktx.dataRead().nodeIndexSeek(ktx.queryContext(), session, cursor, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)keyId, (Object)nodeValue)});
                        Assertions.assertThat((boolean)cursor.next()).isTrue();
                        Assertions.assertThat((long)cursor.nodeReference()).isEqualTo(nodeId.longValue());
                    }
                }
            }
            finally {
                dbms.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EphemeralFileSystemAbstraction createIndexedDataThenSnapshotFSAndShutDown(Label label, String indexName, String key, Object value, MutableLong nodeId) {
        EphemeralFileSystemAbstraction fsSnapshot;
        DatabaseManagementService dbms = new TestDatabaseManagementServiceBuilder(this.directory.homePath()).setFileSystem((FileSystemAbstraction)new UncloseableDelegatingFileSystemAbstraction((FileSystemAbstraction)this.fs)).build();
        try {
            GraphDatabaseService db = dbms.database("neo4j");
            try (Transaction tx = db.beginTx();){
                tx.schema().indexFor(label).on(key).withName(indexName).create();
                tx.commit();
            }
            IndexCreationRecoveryIT.awaitIndexPopulations(db);
            tx = db.beginTx();
            try {
                Node node = tx.createNode(new Label[]{label});
                nodeId.setValue(node.getId());
                node.setProperty(key, value);
                tx.commit();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
            fsSnapshot = this.fs.snapshot();
        }
        finally {
            dbms.shutdown();
        }
        return fsSnapshot;
    }

    private static void awaitIndexPopulations(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            tx.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
        }
    }
}

