/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.time.Duration;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.neo4j.configuration.FulltextSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.pagecache.PageCacheExtension;
import org.neo4j.test.utils.TestDirectory;
import org.neo4j.util.concurrent.Futures;

@PageCacheExtension
class EventuallyConsistentFulltextIT {
    private static final String INDEX_NAME_1 = "my_ft_index_1";
    private static final String INDEX_NAME_2 = "my_ft_index_2";
    private static final Label LABEL1 = Label.label((String)"Label1");
    private static final Label LABEL2 = Label.label((String)"Label2");
    private static final String KEY = "key";
    @Inject
    private PageCache pageCache;
    @Inject
    private TestDirectory directory;
    private DatabaseManagementService dbms;
    private GraphDatabaseAPI db;

    EventuallyConsistentFulltextIT() {
    }

    private void startDbms(TestDatabaseManagementServiceBuilder builder) {
        this.dbms = builder.build();
        this.db = (GraphDatabaseAPI)this.dbms.database("neo4j");
    }

    @AfterEach
    void stop() {
        this.dbms.shutdown();
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    void shouldUpdateEventuallyConsistentFulltextIndexesInParallel(boolean asyncRefresh) throws Exception {
        TestDatabaseManagementServiceBuilder builder = new TestDatabaseManagementServiceBuilder(this.directory.homePath()).setConfig(FulltextSettings.eventually_consistent, (Object)true).setConfig(FulltextSettings.eventually_consistent_apply_parallelism, (Object)4);
        if (asyncRefresh) {
            builder = builder.setConfig(FulltextSettings.eventually_consistent_refresh_interval, (Object)Duration.ofSeconds(1L)).setConfig(FulltextSettings.eventually_consistent_refresh_parallelism, (Object)2);
        }
        this.startDbms(builder);
        this.createFulltextIndexes();
        int numNodes = this.createFulltextIndexedNodesInParallel(4, 100, 10);
        this.awaitIndexUpdatesUpToThisPoint();
        this.assertAllNodesVisibleInIndexes(numNodes);
    }

    private void awaitIndexUpdatesUpToThisPoint() {
        try (Transaction tx = this.db.beginTx();){
            tx.execute("CALL db.index.fulltext.awaitEventuallyConsistentIndexRefresh()");
        }
    }

    private void assertAllNodesVisibleInIndexes(int numNodes) throws KernelException {
        try (InternalTransaction tx = this.db.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED);
             NodeValueIndexCursor cursor = tx.kernelTransaction().cursors().allocateNodeValueIndexCursor(CursorContext.NULL_CONTEXT, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            KernelTransaction ktx = tx.kernelTransaction();
            for (String indexName : new String[]{INDEX_NAME_1, INDEX_NAME_2}) {
                IndexDescriptor index = ktx.schemaRead().indexGetForName(indexName);
                IndexReadSession session = ktx.dataRead().indexReadSession(index);
                ktx.dataRead().nodeIndexSeek(ktx.queryContext(), session, cursor, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{PropertyIndexQuery.fulltextSearch((String)"Marker")});
                int numIndexedNodes = 0;
                while (cursor.next()) {
                    ++numIndexedNodes;
                }
                Assertions.assertThat((int)numIndexedNodes).isEqualTo(numNodes);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int createFulltextIndexedNodesInParallel(int numThreads, int numTransactionsPerThread, int txSize) throws Exception {
        ArrayList<Callable<Void>> tasks = new ArrayList<Callable<Void>>();
        for (int t = 0; t < numThreads; ++t) {
            tasks.add(() -> {
                for (int r = 0; r < numTransactionsPerThread; ++r) {
                    try (Transaction tx = this.db.beginTx();){
                        for (int i = 0; i < txSize; ++i) {
                            this.createFulltextIndexedNode(tx);
                        }
                        tx.commit();
                        continue;
                    }
                }
                return null;
            });
        }
        ExecutorService executor = Executors.newFixedThreadPool(numThreads);
        try {
            Futures.getAll(executor.invokeAll(tasks));
        }
        finally {
            executor.shutdown();
        }
        return numThreads * numTransactionsPerThread * txSize;
    }

    private void createFulltextIndexedNode(Transaction tx) {
        tx.createNode(new Label[]{LABEL1, LABEL2}).setProperty(KEY, (Object)("Marker " + String.valueOf(UUID.randomUUID())));
    }

    private void createFulltextIndexes() {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().indexFor(LABEL1).on(KEY).withIndexType(IndexType.FULLTEXT).withName(INDEX_NAME_1).create();
            tx.schema().indexFor(LABEL2).on(KEY).withIndexType(IndexType.FULLTEXT).withName(INDEX_NAME_2).create();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }
}

