/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import org.neo4j.index.internal.gbptree.TreeNodeDynamicSize;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.kernel.api.impl.schema.StringLengthIndexValidationIT;
import org.neo4j.kernel.impl.index.schema.IndexEntryTestUtil;
import org.neo4j.kernel.impl.index.schema.RangeIndexProvider;
import org.neo4j.test.RandomSupport;

public class RangeIndexStringLengthIndexValidationIT
extends StringLengthIndexValidationIT {
    @Override
    protected int getSingleKeySizeLimit(int payloadSize) {
        return TreeNodeDynamicSize.keyValueSizeCapFromPageSize((int)payloadSize);
    }

    @Override
    protected String getString(RandomSupport random, int keySize) {
        return IndexEntryTestUtil.generateStringResultingInIndexEntrySize((int)keySize);
    }

    @Override
    protected IndexType getIndexType() {
        return IndexType.RANGE;
    }

    @Override
    protected IndexProviderDescriptor getIndexProvider() {
        return RangeIndexProvider.DESCRIPTOR;
    }

    @Override
    protected String expectedPopulationFailureCauseMessage(long indexId, long entityId) {
        return String.format("Property value is too large to index, please see index documentation for limitations. Index: Index( id=%d, name='coolName', type='RANGE', schema=(:LABEL_ONE {largeString}), indexProvider='range-1.0' ), entity id: %d", indexId, entityId);
    }
}

